/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.mail;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.mail.MailPacket;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MailScreen
extends Screen {
    private boolean editable = true;
    private ResourceLocation backgroundTexture;
    private final ResourceLocation sealButtonTexture = ResourceLocationHelper.of(Resources.prefix + "gui/mail/sealButton.png");
    private final ResourceLocation abandonButtonTexture = ResourceLocationHelper.of(Resources.prefix + "gui/mail/closeButton.png");
    private IndexedButton sealButton;
    private final int sealX = 60;
    private final int sealY = 185;
    private IndexedButton exitButton;
    private final int exitX = 100;
    private final int exitY = 185;
    private String bookContents = "";
    private String author = "";

    public MailScreen(ItemStack item) {
        super((Component)Component.m_237119_());
        String mailType = item.m_41778_().split("_")[1];
        this.backgroundTexture = ResourceLocationHelper.of(Resources.prefix + "gui/mail/" + mailType + "mail.png");
        if (item.m_41782_()) {
            CompoundTag nbtdata = item.m_41783_();
            this.editable = nbtdata.m_128471_("editable");
            this.author = nbtdata.m_128461_("author");
            this.bookContents = nbtdata.m_128461_("contents");
        }
    }

    private void writeLetterData(boolean shouldSeal) {
        MailPacket packetMail = new MailPacket(shouldSeal, this.bookContents);
        NetworkHelper.sendToServer(packetMail);
        Minecraft.m_91087_().m_91152_(null);
    }

    public void m_7856_() {
        int buttonID = 0;
        int xOffset = (this.f_96543_ - 252) / 2;
        int yOffset = 2;
        int n = buttonID++;
        Objects.requireNonNull(this);
        this.sealButton = new IndexedButton(n, xOffset + this.sealX, yOffset + 185, 30, 20, (Component)Component.m_237115_((String)"gui.mail.seal"), this::actionPerformed);
        Objects.requireNonNull(this);
        this.exitButton = new IndexedButton(buttonID, xOffset + this.exitX, yOffset + 185, 30, 20, (Component)Component.m_237115_((String)"gui.mail.close"), this::actionPerformed);
        if (!this.editable) {
            this.sealButton.f_93623_ = false;
        }
        this.m_142416_((GuiEventListener)this.sealButton);
        this.m_142416_((GuiEventListener)this.exitButton);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 0: {
                    this.writeLetterData(true);
                    break;
                }
                case 1: {
                    if (this.editable) {
                        this.writeLetterData(false);
                        break;
                    }
                    Minecraft.m_91087_().m_91152_(null);
                }
            }
        }
    }

    public boolean m_7933_(int keyCode, int p_231046_2_, int p_231046_3_) {
        if (keyCode == 259) {
            if (!this.bookContents.isEmpty()) {
                this.bookContents = this.bookContents.substring(0, this.bookContents.length() - 1);
                return true;
            }
        } else if (keyCode == 257 || keyCode == 335) {
            String[] strings2 = this.bookContents.split("\n");
            if (strings2.length == 14) {
                return super.m_7933_(keyCode, p_231046_2_, p_231046_3_);
            }
            this.bookContents = this.bookContents + "\n";
            return true;
        }
        return super.m_7933_(keyCode, p_231046_2_, p_231046_3_);
    }

    public boolean m_5534_(char keyChar, int keyCode) {
        if (!this.editable) {
            return super.m_5534_(keyChar, keyCode);
        }
        switch (keyChar) {
            case '\u0016': {
                for (char character : this.getMinecraft().f_91068_.m_90876_().toCharArray()) {
                    this.addNormalCharacter(character);
                }
                break;
            }
            default: {
                this.addNormalCharacter(keyChar);
            }
        }
        return super.m_5534_(keyChar, keyCode);
    }

    private void addNormalCharacter(char keyChar) {
        int widthInPixels;
        if (!SharedConstants.m_136188_((char)keyChar)) {
            return;
        }
        String[] strings = this.bookContents.split("\n");
        if (strings.length > 0 && (widthInPixels = this.f_96547_.m_92895_(strings[strings.length - 1])) >= 200) {
            if (strings.length == 14) {
                return;
            }
            this.bookContents = this.bookContents + "\n";
        }
        this.bookContents = this.bookContents + keyChar;
    }

    public void m_7861_() {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float wut) {
        int guiWidth = 252;
        int guiHeight = 188;
        int xOffset = (this.f_96543_ - 252) / 2;
        int yOffset = 2;
        graphics.m_280163_(this.backgroundTexture, xOffset, yOffset, 0.0f, 0.0f, 252, 188, 252, 188);
        int buttonWidth = 32;
        int buttonHeight = 32;
        if (this.editable) {
            Objects.requireNonNull(this);
            graphics.m_280163_(this.sealButtonTexture, xOffset + this.sealX, yOffset + 185, 0.0f, 0.0f, buttonWidth, buttonHeight, buttonWidth, buttonHeight);
        }
        Objects.requireNonNull(this);
        graphics.m_280163_(this.abandonButtonTexture, xOffset + this.exitX, yOffset + 185, 0.0f, 0.0f, buttonWidth, buttonHeight, buttonWidth, buttonHeight);
        String[] lines = this.bookContents.split("\n");
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            String string = lines[lineNumber];
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, string, xOffset + 27, yOffset + 32 + lineNumber * 9 - 9, 0);
        }
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, this.author, xOffset + 164, yOffset + 175 - 9, 0);
        this.drawButtonTooltips(graphics, mouseX, mouseY);
    }

    private void drawButtonTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.mouseOverButton(mouseX, mouseY, this.sealButton)) {
            ArrayList<MutableComponent> tooltipData = new ArrayList<MutableComponent>(1);
            tooltipData.add(Component.m_237115_((String)"gui.mail.seal"));
            graphics.m_280666_(this.f_96547_, tooltipData, mouseX, mouseY);
        } else if (this.mouseOverButton(mouseX, mouseY, this.exitButton)) {
            ArrayList<MutableComponent> tooltipData = new ArrayList<MutableComponent>(1);
            tooltipData.add(Component.m_237115_((String)"gui.mail.close"));
            graphics.m_280666_(this.f_96547_, tooltipData, mouseX, mouseY);
        }
    }

    private boolean mouseOverButton(int mouseX, int mouseY, Button button) {
        return button.f_93623_ && mouseX >= button.f_93620_ && mouseX <= button.f_93620_ + button.m_5711_() && mouseY >= button.f_93621_ && mouseY <= button.f_93621_ + button.m_5711_();
    }

    public boolean m_7043_() {
        return false;
    }
}

