/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.machines.washingmachine;

import com.pixelmonmod.pixelmon.blocks.tileentity.WashingMachineTileEntity;
import com.pixelmonmod.pixelmon.client.gui.machines.slots.SingleItemStackHandler;
import com.pixelmonmod.pixelmon.init.registry.ContainerRegistration;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WashingMachineContainer
extends AbstractContainerMenu {
    public WashingMachineTileEntity te;
    private int lastProgress = 0;

    public WashingMachineContainer(int windowId, Inventory inventory, WashingMachineTileEntity tileEntity) {
        super((MenuType)ContainerRegistration.WASHING_MACHINE.get(), windowId);
        this.te = tileEntity;
        this.addOwnSlots();
        this.addPlayerSlots(inventory);
    }

    public WashingMachineContainer(int windowId, Inventory inventoryPlayer, FriendlyByteBuf buffer) {
        this(windowId, inventoryPlayer, WashingMachineContainer.getTileEntity(inventoryPlayer, buffer));
    }

    private static WashingMachineTileEntity getTileEntity(Inventory inventoryPlayer, FriendlyByteBuf buffer) {
        BlockEntity te = inventoryPlayer.f_35978_.f_19853_.m_7702_(buffer.m_130135_());
        if (te instanceof WashingMachineTileEntity) {
            return (WashingMachineTileEntity)te;
        }
        throw new IllegalStateException("Failed to find WashingMachineTileEntity at " + inventoryPlayer.f_35978_.m_20182_());
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 9 + col * 18;
                int y = row * 18 + 85;
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 10, x - 1, y - 1));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 9 + row * 18;
            int y = 143;
            this.m_38897_(new Slot((Container)playerInventory, row, x - 1, y - 1));
        }
    }

    private void addOwnSlots() {
        ItemStackHandler cooked = this.te.getCooked();
        ItemStackHandler cooking = this.te.getCooking();
        this.m_38897_(new SingleItemStackHandler((IItemHandler)cooking, 0, 54, 33));
        this.m_38897_(new SingleItemStackHandler((IItemHandler)cooked, 1, 111, 30));
    }

    public void m_38946_() {
        super.m_38946_();
        for (int i = 0; i < this.f_38848_.size(); ++i) {
            ContainerListener crafting = (ContainerListener)this.f_38848_.get(i);
            if (this.lastProgress == this.te.getSmeltTime()) continue;
            crafting.m_142153_((AbstractContainerMenu)this, 0, this.te.getSmeltTime());
        }
        this.lastProgress = this.te.getSmeltTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7511_(int id, int data) {
        if (id == 0) {
            this.te.setSmeltTime(data);
        } else if (id == 1) {
            // empty if block
        }
    }

    @Nullable
    public ItemStack m_7648_(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }
}

