/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory.tabs.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareScreen;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareSlot;
import com.pixelmonmod.pixelmon.client.gui.inventory.tabs.impl.SimpleSurvivalTab;
import com.pixelmonmod.pixelmon.client.gui.widgets.InvisibleButtonWithTooltip;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestAllErrorsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestConditionUpdatePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DayCareTab
extends SimpleSurvivalTab {
    private static final ResourceLocation GUI_LOCATION = ResourceLocationHelper.of("pixelmon", "textures/gui/daycare/inventory.png");
    private int startSlot = 0;
    private DayCareBox box;

    public DayCareTab(int id, int column, boolean topRow, boolean alignedRight, ItemStack iconItem) {
        super(id, column, topRow, alignedRight, iconItem);
    }

    @Override
    public void init() {
        int boxId;
        PlayerPartyStorage party = ClientStorageManager.party;
        this.minecraft.f_91074_.m_108631_().m_12684_().m_12736_(RecipeBookType.CRAFTING, false);
        this.selectBox(0);
        this.addRenderableWidget(new InvisibleButtonWithTooltip(this.getGuiLeft() + this.imageWidth - 16 - 16 - 10, this.getGuiTop(), 16, 14, (Component)Component.m_237119_(), button -> this.swapPage(false), (graphics, mouseX, mouseY) -> graphics.m_280557_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.previous.page"), mouseX, mouseY)));
        this.addRenderableWidget(new InvisibleButtonWithTooltip(this.getGuiLeft() + this.imageWidth - 16 - 10, this.getGuiTop(), 16, 14, (Component)Component.m_237119_(), button -> this.swapPage(true), (graphics, mouseX, mouseY) -> graphics.m_280557_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.next.page"), mouseX, mouseY)));
        int i = (this.minecraft.f_91080_.f_96543_ - 176) / 2;
        int j = (this.minecraft.f_91080_.f_96544_ - 166) / 2;
        int j1 = i + 60;
        PlayerDayCare dayCare = ClientStorageManager.party.getDayCare();
        for (int k = 0; k < 3 && (boxId = this.startSlot + k) < party.getDayCare().getAllowedBoxes(); ++k) {
            int finalK = k;
            this.addRenderableWidget(new InvisibleButtonWithTooltip(j1, j + 14 + 19 * k, 108, 19, (Component)Component.m_237119_(), button -> this.selectBox(this.startSlot + finalK), (graphics, mouseX, mouseY) -> {
                Optional<DayCareBox> box = dayCare.getOrCreateBox(boxId);
                box.ifPresent(dayCareBox -> {
                    if (dayCareBox.canBreedingBegin() || dayCareBox.isEmpty()) {
                        graphics.m_280666_(this.minecraft.f_91062_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("pixelmon.daycare.box." + boxId))}), mouseX, mouseY);
                        return;
                    }
                    if (dayCareBox.getAllErrorMessages() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestAllErrorsPacket(dayCareBox.getBoxId()));
                        graphics.m_280666_(this.minecraft.f_91062_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("pixelmon.daycare.box." + boxId))}), mouseX, mouseY);
                        return;
                    }
                    ArrayList allErrorMessages = Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("pixelmon.daycare.box." + boxId)), Component.m_237115_((String)"pixelmon.daycare.requirements")});
                    allErrorMessages.addAll(dayCareBox.getAllErrorMessages());
                    graphics.m_280666_(this.minecraft.f_91062_, (List)allErrorMessages, mouseX, mouseY);
                });
            }));
        }
    }

    private void selectBox(int boxId) {
        PlayerPartyStorage party = ClientStorageManager.party;
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(boxId).orElse(null);
        if (dayCareBox == null || dayCareBox.isEmpty()) {
            this.box = party.getDayCare().getFirstEmptyBox();
        } else {
            this.box = dayCareBox;
            if (!dayCareBox.canBreedingBegin()) {
                NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(dayCareBox.getBoxId()));
            }
        }
    }

    private void renderToolTip(GuiGraphics graphics, double mouseX, double mouseY, Component component) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_252880_(1.0f, 1.0f, 10.0f);
        ScreenHelper.drawInUnicode(() -> {
            Font font = this.minecraft.f_91062_;
            FormattedCharSequence formattedCharSequence = component.m_7532_();
            float f = (float)mouseX - (float)this.minecraft.f_91062_.m_92852_((FormattedText)component) / 2.0f;
            float f2 = (float)mouseY;
            Objects.requireNonNull(this.minecraft.f_91062_);
            graphics.drawString(font, formattedCharSequence, f, f2 - 9.0f, 1, true);
        });
        matrix.m_85849_();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        PlayerPartyStorage party = ClientStorageManager.party;
        InventoryScreen containerScreen = (InventoryScreen)minecraft.f_91080_;
        if (this.startSlot > 0) {
            ScreenHelper.drawImageQuad(Resources.UP, graphics, containerScreen.getGuiLeft() + 176 - 16 - 16 - 10, containerScreen.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, 1.0f);
        }
        if (this.startSlot < party.getDayCare().getAllowedBoxes() - 3) {
            ScreenHelper.drawImageQuad(Resources.DOWN, graphics, containerScreen.getGuiLeft() + 176 - 16 - 10, containerScreen.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, 1.0f);
        }
        List<PokemonBase> history = party.getDayCare().getHistory();
        NonNullList slots = ((InventoryMenu)containerScreen.m_6262_()).f_38839_;
        int pos = 0;
        for (int i = 0; i < slots.size(); ++i) {
            Slot slot = (Slot)slots.get(i);
            if (slot instanceof ResultSlot || slot.m_6641_() == 1) continue;
            if (pos >= history.size()) break;
            ScreenHelper.drawImage(history.get(pos).getSprite(), graphics, (float)(this.getGuiLeft() + slot.f_40220_), (float)(this.getGuiTop() + slot.f_40221_), 16.0f, 16.0f, 1.0f);
            ++pos;
        }
        ScreenHelper.drawInUnicode(() -> {
            int i = (minecraft.f_91080_.f_96543_ - 176) / 2;
            int j = (minecraft.f_91080_.f_96544_ - 166) / 2;
            graphics.m_280218_(GUI_LOCATION, i, j, 0, 0, 176, 166);
            int j1 = i + 60;
            for (int k = 0; k < 3; ++k) {
                int boxId = this.startSlot + k;
                if (boxId >= party.getDayCare().getAllowedBoxes()) {
                    graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 0, 186, 108, 19);
                    continue;
                }
                DayCareBox box = party.getDayCare().getOrCreateBox(boxId).orElse(null);
                if (box == null) continue;
                if (!box.canBreedingBegin() && !box.isEmpty()) {
                    if (box.getErrorMessage() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(box.getBoxId()));
                        continue;
                    }
                    graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 109, 205, 109, 19);
                    graphics.m_280614_(minecraft.f_91062_, box.getErrorMessage(), j1 + 20, j + 19 + 19 * k, 1, false);
                } else if (!box.isEmpty() && box.hasBreedingBegun()) {
                    if (box.getPercentComplete() < 100.0) {
                        graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 0, 205, 109, 19);
                        graphics.m_280218_(GUI_LOCATION, j1 - 1 + 23, j + 19 + 19 * k, 19, 226, 81, 5);
                        graphics.m_280218_(GUI_LOCATION, j1 - 1 + 23, j + 19 + 19 * k, 19, 231, (int)(box.getPercentComplete() / 100.0 * 81.0), 5);
                        MutableComponent totalDuration = StringHelper.getFormattedDuration(box.getTotalDuration());
                        Font font = minecraft.f_91062_;
                        int n = j1 + 18 + 50 - this.minecraft.f_91062_.m_92852_((FormattedText)totalDuration);
                        Objects.requireNonNull(this.minecraft.f_91062_);
                        graphics.m_280614_(font, (Component)totalDuration, n, j + 33 + 19 * k - 9, 1, false);
                    } else {
                        graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 109, 186, 109, 19);
                        MutableComponent complete = Component.m_237115_((String)"pixelmon.daycare.complete");
                        graphics.m_280614_(minecraft.f_91062_, (Component)complete, j1 + 18 + 45 - minecraft.f_91062_.m_92852_((FormattedText)complete) / 2, j + 18 + 19 * k, 1, false);
                    }
                }
                if (box.isEmpty()) continue;
                ScreenHelper.drawImageQuad(box.getEgg().getSprite(), graphics, j1, j + 13 + 19 * k, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.box != null && !this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.box.getEgg().getSprite(), graphics, this.getGuiLeft() + 16, (float)this.getGuiTop() + 12.5f, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.box != null && !this.box.isEmpty()) {
                int id = 1;
                for (DayCareSlot slotData : DayCareScreen.SLOTS) {
                    ScreenHelper.drawImageQuad(this.box.getParent(id).getSprite(), graphics, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                    if (slotData.inSlot(mouseX - this.getGuiLeft(), mouseY - this.getGuiTop())) {
                        ScreenHelper.drawPokemonHoverInfo(graphics, this.box.getParent(id), mouseX, mouseY);
                    }
                    ++id;
                }
            }
            graphics.m_280614_(minecraft.f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.title"), containerScreen.getGuiLeft() + 5, containerScreen.getGuiTop() + 3, 1, false);
            graphics.m_280614_(minecraft.f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.tab.history"), containerScreen.getGuiLeft() + 5, containerScreen.getGuiTop() + 72, 1, false);
        });
        for (GuiEventListener button : this.buttons) {
            if (!button.m_5953_((double)mouseX, (double)mouseY)) continue;
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        for (GuiEventListener button : this.buttons) {
            if (!button.m_6375_(x, y, mouseButton)) continue;
            return true;
        }
        return true;
    }

    private void swapPage(boolean forward) {
        if (this.startSlot == 0 && !forward) {
            return;
        }
        if (this.startSlot == ClientStorageManager.party.getDayCare().getAllowedBoxes() - 3 && forward) {
            return;
        }
        this.startSlot += forward ? 1 : -1;
        this.buttons.clear();
        this.init();
    }
}

