/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmonBase;
import com.pixelmonmod.pixelmon.client.gui.inventory.tabs.PixelmonTabs;
import com.pixelmonmod.pixelmon.client.gui.inventory.tabs.SurvivalTab;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryPixelmonExtendedScreen
extends InventoryScreen
implements InventoryPixelmonBase {
    public static final ResourceLocation INVENTORY_LOCATION = new ResourceLocation("textures/gui/demo_background.png");
    private static final ResourceLocation[] UNSELECTED_TOP_TABS = new ResourceLocation[]{new ResourceLocation("container/creative_inventory/tab_top_unselected_1"), new ResourceLocation("container/creative_inventory/tab_top_unselected_2"), new ResourceLocation("container/creative_inventory/tab_top_unselected_3"), new ResourceLocation("container/creative_inventory/tab_top_unselected_4"), new ResourceLocation("container/creative_inventory/tab_top_unselected_5"), new ResourceLocation("container/creative_inventory/tab_top_unselected_6"), new ResourceLocation("container/creative_inventory/tab_top_unselected_7")};
    private static final ResourceLocation[] SELECTED_TOP_TABS = new ResourceLocation[]{new ResourceLocation("container/creative_inventory/tab_top_selected_1"), new ResourceLocation("container/creative_inventory/tab_top_selected_2"), new ResourceLocation("container/creative_inventory/tab_top_selected_3"), new ResourceLocation("container/creative_inventory/tab_top_selected_4"), new ResourceLocation("container/creative_inventory/tab_top_selected_5"), new ResourceLocation("container/creative_inventory/tab_top_selected_6"), new ResourceLocation("container/creative_inventory/tab_top_selected_7")};
    private static final ResourceLocation[] UNSELECTED_BOTTOM_TABS = new ResourceLocation[]{new ResourceLocation("container/creative_inventory/tab_bottom_unselected_1"), new ResourceLocation("container/creative_inventory/tab_bottom_unselected_2"), new ResourceLocation("container/creative_inventory/tab_bottom_unselected_3"), new ResourceLocation("container/creative_inventory/tab_bottom_unselected_4"), new ResourceLocation("container/creative_inventory/tab_bottom_unselected_5"), new ResourceLocation("container/creative_inventory/tab_bottom_unselected_6"), new ResourceLocation("container/creative_inventory/tab_bottom_unselected_7")};
    private static final ResourceLocation[] SELECTED_BOTTOM_TABS = new ResourceLocation[]{new ResourceLocation("container/creative_inventory/tab_bottom_selected_1"), new ResourceLocation("container/creative_inventory/tab_bottom_selected_2"), new ResourceLocation("container/creative_inventory/tab_bottom_selected_3"), new ResourceLocation("container/creative_inventory/tab_bottom_selected_4"), new ResourceLocation("container/creative_inventory/tab_bottom_selected_5"), new ResourceLocation("container/creative_inventory/tab_bottom_selected_6"), new ResourceLocation("container/creative_inventory/tab_bottom_selected_7")};
    private InventoryPixelmon inventory = new InventoryPixelmon<InventoryPixelmonExtendedScreen>(this, 42);
    private static int selectedTab = 1;

    public InventoryPixelmonExtendedScreen(Player player) {
        super(player);
    }

    public void m_7856_() {
        super.m_7856_();
        this.inventory.initGui();
        selectedTab = 1;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (selectedTab != 1) {
            this.m_280273_(graphics, mouseX, mouseY, partialTicks);
            this.renderTabs(graphics);
            this.renderSpecialBg(graphics, partialTicks, mouseX, mouseY);
        }
        SurvivalTab selectedTab = PixelmonTabs.getAll().stream().filter(survivalTab -> survivalTab.getId() == selectedTab).findFirst().orElse(null);
        if (InventoryPixelmonExtendedScreen.selectedTab == 1) {
            super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        } else {
            selectedTab.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.inventory.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTabButton(graphics, selectedTab);
        if (!this.m_5564_().m_100385_()) {
            graphics.m_280218_(Resources.pixelmonOverlayExtended2, this.f_97735_ - 80, this.f_96544_ / 2 - 83, 0, 0, 90, 166);
            this.inventory.drawGuiContainerBackgroundLayer(graphics, partialTicks, mouseX, mouseY);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void renderSpecialBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.f_97735_;
        int j = this.f_97736_;
        graphics.m_280218_(INVENTORY_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public float getZLevel() {
        return 1.0f;
    }

    @Override
    public int getGUILeft() {
        return this.f_97735_;
    }

    @Override
    public void offsetGUILeft(int offset) {
        this.f_97735_ += offset;
    }

    protected void m_7286_(GuiGraphics graphics, float par1, int par2, int par3) {
        if (selectedTab == 1) {
            this.renderTabs(graphics);
            super.m_7286_(graphics, par1, par2, par3);
        }
    }

    private void renderTabs(GuiGraphics graphics) {
        for (SurvivalTab survivalTab : PixelmonTabs.getAll()) {
            if (survivalTab.getId() == selectedTab) continue;
            this.renderTabButton(graphics, survivalTab);
        }
    }

    protected void renderTabButton(GuiGraphics graphics, SurvivalTab tab) {
        if (tab == null) {
            return;
        }
        boolean selected = tab.getId() == selectedTab;
        boolean topRow = true;
        int i = tab.getColumn();
        int j = this.f_97735_ + this.getTabX(tab);
        int k = this.f_97736_ - (topRow ? 28 : -(this.f_97727_ - 4));
        ResourceLocation[] aresourcelocation = topRow ? (selected ? SELECTED_TOP_TABS : UNSELECTED_TOP_TABS) : (selected ? SELECTED_BOTTOM_TABS : UNSELECTED_BOTTOM_TABS);
        RenderSystem.enableBlend();
        graphics.m_292816_(aresourcelocation[Mth.m_14045_((int)i, (int)0, (int)aresourcelocation.length)], j, k, 26, 32);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int n = topRow ? 1 : -1;
        ItemStack itemstack = tab.getIconItem();
        graphics.m_280480_(itemstack, j += 5, k += 8 + n);
        graphics.m_280370_(this.f_96547_, itemstack, j, k);
        graphics.m_280168_().m_85849_();
    }

    private int getTabX(SurvivalTab tab) {
        int i = tab.getColumn();
        int k = 27 * i;
        if (tab.isAlignedRight()) {
            k = this.f_97726_ - 27 * (7 - i) + 1;
        }
        return k;
    }

    @Override
    public List<Renderable> getButtonList() {
        return this.f_169369_;
    }

    @Override
    public void refreshSearchResults() {
    }

    public boolean m_6375_(double x, double y, int mouseButton) {
        SurvivalTab selectedTab;
        if (mouseButton == 0) {
            double relativeX = x - (double)this.f_97735_;
            double relativeY = y - (double)this.f_97736_;
            for (SurvivalTab tab : PixelmonTabs.getAll()) {
                if (tab == null || !this.checkTabClicked(tab, relativeX, relativeY)) continue;
                return true;
            }
        }
        if ((selectedTab = (SurvivalTab)PixelmonTabs.getAll().stream().filter(survivalTab -> survivalTab.getId() == selectedTab).findFirst().orElse(null)) != null && selectedTab.mouseClicked(x, y, mouseButton)) {
            return true;
        }
        if (this.m_5564_().m_100385_() || this.inventory.mouseClicked(x, y, mouseButton) && this.isOutsideParty((int)x, (int)y)) {
            try {
                super.m_6375_(x, y, mouseButton);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean checkTabClicked(SurvivalTab tab, double x, double y) {
        if (tab.getId() == selectedTab) {
            return false;
        }
        int i = tab.getColumn();
        int j = 28 * i;
        int k = 0;
        if (tab.isAlignedRight()) {
            j = this.f_97726_ - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = tab.isTopRow() ? (k -= 32) : (k += this.f_97727_);
        return x >= (double)j && x <= (double)(j + 28) && y >= (double)k && y <= (double)(k + 32);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (state == 0) {
            double relativeX = mouseX - (double)this.f_97735_;
            double relativeY = mouseY - (double)this.f_97736_;
            for (SurvivalTab tab : PixelmonTabs.getAll()) {
                if (tab == null || !this.checkTabClicked(tab, relativeX, relativeY)) continue;
                selectedTab = tab.getId();
                SurvivalTab selectedTab = PixelmonTabs.getAll().stream().filter(survivalTab -> survivalTab.getId() == selectedTab).findFirst().orElse(null);
                if (selectedTab != null) {
                    if (this.m_5564_().m_100385_()) {
                        this.m_5564_().m_100384_();
                        this.m_5564_().m_181404_();
                        this.f_97735_ = this.m_5564_().m_181401_(this.f_96543_, this.f_97726_);
                    }
                    selectedTab.init();
                }
                return true;
            }
        }
        if (this.isOutsideParty((int)mouseX, (int)mouseY)) {
            return super.m_6348_(mouseX, mouseY, state);
        }
        return false;
    }

    private boolean isOutsideParty(int x, int y) {
        return !this.isWithinParty(x, y) && !this.isWithinLureBox(x, y);
    }

    private boolean isWithinParty(int x, int y) {
        int centerW = this.f_96543_ / 2;
        int centerH = this.f_96544_ / 2;
        return x > centerW + -128 && x < centerW + -80 && y > centerH + -84 && y < centerH + 60;
    }

    private boolean isWithinLureBox(int x, int y) {
        int centerW = this.f_96543_ / 2;
        int centerH = this.f_96544_ / 2;
        return x > centerW + -168 && x < centerW + -128 && y > centerH + -84 && y < centerH + -42;
    }

    public void m_86600_() {
        super.m_86600_();
        this.inventory.tick();
    }
}

