/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmonBase;
import com.pixelmonmod.pixelmon.client.gui.inventory.SlotInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.widgets.PokeCheckerButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetCharmPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetHeldItemPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.ChangeLurePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ServerSwapPacket;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.LureItem;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.awt.Color;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class InventoryPixelmon<T extends EffectRenderingInventoryScreen> {
    private T gui;
    private int partyWidth;
    private SlotInventoryPixelmon[] pixelmonSlots;
    private StoragePosition selected;
    private PokeCheckerButton pokeChecker;
    private boolean drawerOut = false;
    private int drawerOffset = 0;
    private int[] lureSlot;
    private int ticksTillClick = 0;

    public InventoryPixelmon(T gui, int partyWidth) {
        this.gui = gui;
        this.pixelmonSlots = new SlotInventoryPixelmon[6];
        this.partyWidth = partyWidth;
    }

    public void initGui() {
        int slotLeft = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 34;
        int slotTop = ((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2 + 21;
        this.lureSlot = new int[]{slotLeft - 16 - (this.gui instanceof CreativeModeInventoryScreen ? 1 : 0), slotTop + 20};
        this.pokeChecker = new PokeCheckerButton((Screen)this.gui);
        ((InventoryPixelmonBase)this.gui).getButtonList().add((Renderable)this.pokeChecker);
        this.reloadSlots();
    }

    private void reloadSlots() {
        int i;
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            this.pixelmonSlots[i] = null;
        }
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            StoragePosition position = new StoragePosition(-1, i);
            Pokemon pokemon = ClientStorageManager.party.get(i);
            if (pokemon == null) continue;
            int x = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 8;
            int y = ((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2 + i * 18 - 75;
            this.pixelmonSlots[i] = new SlotInventoryPixelmon(x, y, position);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean recipeBookVisible;
        boolean bl = recipeBookVisible = this.gui instanceof InventoryScreen && ((InventoryScreen)this.gui).m_5564_().m_100385_();
        if (recipeBookVisible) {
            return;
        }
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            if ((!this.pokeChecker.f_93623_ || mouseY < this.pokeChecker.f_93621_ || mouseY > this.pokeChecker.f_93621_ + this.pokeChecker.m_93694_()) && slot.getBounds().contains(mouseX, mouseY)) {
                ScreenHelper.drawPokemonHoverInfo(graphics, pokemon, mouseX, mouseY);
                continue;
            }
            if (pokemon.isEgg() || !slot.getHeldItemBounds().contains(mouseX, mouseY) || !this.heldItemQualifies(pokemon) || this.ticksTillClick > 0 || pokemon.getHeldItem().m_41619_()) continue;
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, pokemon.getHeldItem(), mouseX, mouseY);
        }
        if (ClientStorageManager.party.getLure() != null) {
            graphics.m_280480_(ClientStorageManager.party.getLureStack(), this.lureSlot[0], this.lureSlot[1]);
            graphics.m_280370_(Minecraft.m_91087_().f_91062_, ClientStorageManager.party.getLureStack(), this.lureSlot[0], this.lureSlot[1]);
            if (mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16) {
                graphics.m_280153_(Minecraft.m_91087_().f_91062_, ClientStorageManager.party.getLureStack(), mouseX, mouseY);
            }
        }
        if (this.drawerOut && this.drawerOffset < 42) {
            this.drawerOffset += 3;
            if (this.drawerOffset > 42) {
                this.drawerOffset = 42;
            }
        } else if (!this.drawerOut && this.drawerOffset > 0) {
            this.drawerOffset -= 3;
            if (this.drawerOffset < 0) {
                this.drawerOffset = 0;
            }
        }
    }

    public void drawGuiContainerBackgroundLayer(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            slot.setX(((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 8);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, graphics, slot.x, slot.y, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), ((InventoryPixelmonBase)this.gui).getZLevel() + 1.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getSprite(), graphics, slot.x, slot.y, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
            if (!pokemon.isEgg()) {
                if (pokemon.getHeldItem() != ItemStack.f_41583_) {
                    graphics.m_280480_(pokemon.getHeldItem(), slot.heldItemX, slot.heldItemY);
                } else {
                    ScreenHelper.drawImageQuad(Resources.heldItem, graphics, slot.heldItemX + 3, slot.heldItemY + 3, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                }
            }
            if (!slot.position.equals(this.selected)) continue;
            ScreenHelper.drawImageQuadUV(Resources.pcResources, graphics, (float)slot.x + 0.5f, (float)slot.y + 0.5f, 15.0f, 15.0f, 0.0f, 29.0f, 29.0f, 29.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        if ((ClientStorageManager.party.getLure() != null || this.gui.getMinecraft().f_91074_.m_150109_().m_36056_().m_41720_() instanceof LureItem) && mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, graphics, this.lureSlot[0] - 1, this.lureSlot[1] - 1, 18.0f, 18.0f, 0.23046875f, 0.7265625f, 0.30078125f, 0.796875f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        int bX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth;
        int bY = ((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2;
        if (this.drawerOffset > 0) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, graphics, bX - 2 - this.drawerOffset, bY - 83, 7 + this.drawerOffset, 166.0f, 0.609375f, 0.0f, (163.0f + (float)this.drawerOffset) / 256.0f, 0.6484375f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
            if (this.drawerOut && mouseX >= bX - 38 && mouseX <= bX - 28 && mouseY >= bY - 18 && mouseY <= bY + 18) {
                ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, graphics, bX - 35, bY - 5, 5.0f, 10.0f, 0.01953125f, 0.671875f, 0.0390625f, 0.7109375f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
            }
            if (this.drawerOffset > 40) {
                EnumMegaItemsUnlocked megaItems;
                EnumFeatureState ovalCharm;
                EnumFeatureState shinyCharm;
                EnumFeatureState expCharm;
                EnumFeatureState catchingCharm;
                EnumFeatureState markCharm = EntityPlayerExtension.getPlayerMarkCharm((Player)this.gui.getMinecraft().f_91074_);
                if (markCharm.isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.markCharmBig, graphics, bX + 17 - this.drawerOffset, bY + 55, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!markCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY + 55, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((catchingCharm = EntityPlayerExtension.getPlayerCatchingCharm((Player)this.gui.getMinecraft().f_91074_)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.catchingCharmBig, graphics, bX + 17 - this.drawerOffset, bY + 32, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!catchingCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY + 32, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((expCharm = EntityPlayerExtension.getPlayerExpCharm((Player)this.gui.getMinecraft().f_91074_)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.expCharmBig, graphics, bX + 17 - this.drawerOffset, bY + 9, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!expCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY + 9, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((shinyCharm = EntityPlayerExtension.getPlayerShinyCharm((Player)this.gui.getMinecraft().f_91074_)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.shinyCharmBig, graphics, bX + 17 - this.drawerOffset, bY - 14, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!shinyCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY - 14, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((ovalCharm = EntityPlayerExtension.getPlayerOvalCharm((Player)this.gui.getMinecraft().f_91074_)).isAvailable()) {
                    ScreenHelper.drawImageQuad(Resources.ovalCharmBig, graphics, bX + 17 - this.drawerOffset, bY - 36, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!ovalCharm.isActive()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY - 36, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if ((megaItems = EntityPlayerExtension.getPlayerMegaItemsUnlocked((Player)this.gui.getMinecraft().f_91074_)).canMega()) {
                    ScreenHelper.drawImageQuad(Resources.keyStoneBig, graphics, bX + 17 - this.drawerOffset, bY - 59, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!EntityPlayerExtension.getPlayerMegaItem((Player)this.gui.getMinecraft().f_91074_).canMega()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY - 59, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
                if (megaItems.canDynamax()) {
                    ScreenHelper.drawImageQuad(Resources.dynamaxBandBig, graphics, bX + 17 - this.drawerOffset, bY - 81, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    if (!EntityPlayerExtension.getPlayerMegaItem((Player)this.gui.getMinecraft().f_91074_).canDynamax()) {
                        ScreenHelper.drawImageQuad(Resources.disabled, graphics, bX + 17 - this.drawerOffset, bY - 81, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
                    }
                }
            }
        } else if (mouseX >= bX - 9 && mouseX <= bX + 1 && mouseY >= bY - 18 && mouseY <= bY + 18) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, graphics, bX - 6, bY - 5, 5.0f, 10.0f, 0.0f, 0.671875f, 0.01953125f, 0.7109375f, 1.0f, 1.0f, 1.0f, 1.0f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        if (this.drawerOffset > 0) {
            ScreenHelper.drawImageQuad(Resources.pixelmonOverlayExtended2, graphics, bX, bY - 83, 5.0f, 166.0f, 0.1484375f, 0.0f, 0.16796875f, 0.6484375f, ((InventoryPixelmonBase)this.gui).getZLevel());
        }
        if (ClientData.playerMoney != null) {
            ScreenHelper.drawStringRightAligned(graphics, NumberFormat.getInstance().format(ClientData.playerMoney), ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 44, (float)((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2.0f + 66.0f, 0xF0F0F0, false, true);
        }
        this.pokeChecker.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private boolean heldItemQualifies(Pokemon pokemon) {
        ItemStack handStack = this.gui.getMinecraft().f_91074_.f_36095_.m_142621_();
        ItemStack heldStack = pokemon.getHeldItem();
        if (handStack.m_41619_() && !heldStack.m_41619_()) {
            return true;
        }
        return !handStack.m_41619_() && handStack.m_41720_() instanceof HeldItem;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseX >= (double)this.lureSlot[0] && mouseX <= (double)(this.lureSlot[0] + 16) && mouseY >= (double)this.lureSlot[1] && mouseY <= (double)(this.lureSlot[1] + 16) && this.ticksTillClick <= 0) {
            ItemStack held = this.gui.getMinecraft().f_91074_.f_36095_.m_142621_();
            ItemStack lure = ClientStorageManager.party.getLureStack();
            boolean creative = this.gui.getMinecraft().f_91074_.m_7500_();
            if (held.m_41619_() && lure.m_41619_()) {
                return false;
            }
            if (held.m_41720_() instanceof LureItem) {
                if (lure.m_41619_()) {
                    ClientStorageManager.party.setLureStack(held);
                    this.gui.getMinecraft().f_91074_.f_36095_.m_142503_(ItemStack.f_41583_);
                    NetworkHelper.sendToServer(creative ? new ChangeLurePacket(ChangeLurePacket.Change.PUT, held.m_41720_(), held.m_41773_()) : new ChangeLurePacket(ChangeLurePacket.Change.PUT));
                } else {
                    this.gui.getMinecraft().f_91074_.f_36095_.m_142503_(lure);
                    ClientStorageManager.party.setLureStack(held);
                    NetworkHelper.sendToServer(creative ? new ChangeLurePacket(ChangeLurePacket.Change.SWAP, held.m_41720_(), held.m_41773_()) : new ChangeLurePacket(ChangeLurePacket.Change.SWAP));
                }
            } else if (!lure.m_41619_() && held.m_41619_()) {
                this.gui.getMinecraft().f_91074_.f_36095_.m_142503_(lure);
                ClientStorageManager.party.setLureStack(ItemStack.f_41583_);
                NetworkHelper.sendToServer(new ChangeLurePacket(ChangeLurePacket.Change.TAKE));
            }
            this.ticksTillClick = 10;
            return false;
        }
        if (this.pokeChecker.m_5953_(mouseX, mouseY)) {
            if (mouseButton == 0) {
                this.pokeChecker.m_6375_(mouseX, mouseY, mouseButton);
            }
            return false;
        }
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            int slotY;
            int slotX;
            Pokemon pokemon;
            SlotInventoryPixelmon slot = this.pixelmonSlots[i];
            StoragePosition position = slot == null ? null : slot.position;
            Pokemon pokemon2 = pokemon = position == null ? null : ClientStorageManager.party.get(position);
            if (slot != null) {
                slotX = slot.x;
                slotY = slot.y;
            } else {
                slotX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 6;
                slotY = ((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2 + i * 18 - 75;
            }
            if (mouseX >= (double)slotX && mouseX <= (double)(slotX + 16) && mouseY >= (double)slotY && mouseY <= (double)(slotY + 16)) {
                if (mouseButton == 1) {
                    this.pokeChecker.setPokemon(ClientStorageManager.party, position, pokemon, (int)mouseX, (int)mouseY);
                } else {
                    this.pokeChecker.setPokemon(null, null, null, (int)mouseX, (int)mouseY);
                }
                if (mouseButton == 0) {
                    if (this.selected == null) {
                        this.selected = position;
                    } else {
                        NetworkHelper.sendToServer(new ServerSwapPacket(this.selected, ClientStorageManager.party.get(this.selected), new StoragePosition(-1, i), pokemon));
                        ClientStorageManager.party.swap(this.selected.order, i);
                        this.selected = null;
                        this.reloadSlots();
                    }
                }
                return false;
            }
            if (this.ticksTillClick > 0 || pokemon == null || pokemon.isEgg() || !this.heldItemQualifies(pokemon) || !slot.getHeldItemBounds().contains(mouseX, mouseY)) continue;
            SetHeldItemPacket packet = new SetHeldItemPacket(position, pokemon.getUUID());
            InventoryMenu inventory = this.gui.getMinecraft().f_91074_.f_36095_;
            ItemStack currentItem = inventory.m_142621_();
            ItemStack oldItem = pokemon.getHeldItem();
            if (this.gui.getMinecraft().f_91074_.m_7500_()) {
                if (!currentItem.m_41619_()) {
                    ItemStack singleItem = currentItem.m_41777_();
                    singleItem.m_41764_(1);
                    pokemon.setHeldItem(singleItem);
                    packet.setItem(currentItem.m_41720_());
                } else {
                    pokemon.setHeldItem(ItemStack.f_41583_);
                    packet.setItem(null);
                }
            } else {
                ItemStack playerItem;
                if (oldItem.m_41619_()) {
                    if (!currentItem.m_41619_()) {
                        ItemStack singleItem = currentItem.m_41777_();
                        singleItem.m_41764_(1);
                        pokemon.setHeldItem(singleItem);
                        if (currentItem.m_41613_() <= 1) {
                            inventory.m_142503_(ItemStack.f_41583_);
                        } else {
                            currentItem.m_41774_(1);
                        }
                        packet.setItem(singleItem.m_41720_());
                    }
                } else if (currentItem.m_41619_()) {
                    pokemon.setHeldItem(ItemStack.f_41583_);
                    inventory.m_142503_(oldItem);
                } else if (ItemStack.m_150942_((ItemStack)oldItem, (ItemStack)currentItem)) {
                    pokemon.setHeldItem(ItemStack.f_41583_);
                    currentItem.m_41769_(1);
                } else if (currentItem.m_41613_() <= 1) {
                    ItemStack singleItem = currentItem.m_41777_();
                    singleItem.m_41764_(1);
                    pokemon.setHeldItem(singleItem);
                    inventory.m_142503_(oldItem);
                } else {
                    ItemStack singleItem = currentItem.m_41777_();
                    singleItem.m_41764_(1);
                    pokemon.setHeldItem(singleItem);
                    currentItem.m_41774_(1);
                    this.gui.getMinecraft().f_91074_.m_150109_().m_36054_(oldItem);
                }
                if (!(playerItem = inventory.m_142621_()).m_41619_() && playerItem.m_41613_() > 64) {
                    playerItem.m_41764_(64);
                }
            }
            NetworkHelper.sendToServer(packet);
            this.ticksTillClick = 10;
            return false;
        }
        int bX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth;
        int bY = ((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2;
        if (this.drawerOut) {
            if (mouseX >= (double)(bX - 38) && mouseX <= (double)(bX - 28) && mouseY >= (double)(bY - 18) && mouseY <= (double)(bY + 18)) {
                this.drawerOut = false;
                return false;
            }
            if (mouseX >= (double)(bX - 25) && mouseX <= (double)(bX - 1)) {
                EnumFeatureState charm;
                if (mouseY > (double)(bY + 55) && mouseY < (double)(bY + 79)) {
                    charm = EntityPlayerExtension.getPlayerMarkCharm((Player)this.gui.getMinecraft().f_91074_);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Mark, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY + 33) && mouseY < (double)(bY + 55)) {
                    charm = EntityPlayerExtension.getPlayerCatchingCharm((Player)this.gui.getMinecraft().f_91074_);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Catching, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY + 9) && mouseY < (double)(bY + 33)) {
                    charm = EntityPlayerExtension.getPlayerExpCharm((Player)this.gui.getMinecraft().f_91074_);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Exp, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 13) && mouseY < (double)(bY + 9)) {
                    charm = EntityPlayerExtension.getPlayerShinyCharm((Player)this.gui.getMinecraft().f_91074_);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Shiny, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 35) && mouseY < (double)(bY - 13)) {
                    charm = EntityPlayerExtension.getPlayerOvalCharm((Player)this.gui.getMinecraft().f_91074_);
                    if (charm.isAvailable()) {
                        NetworkHelper.sendToServer(new SetCharmPacket(EnumCharms.Oval, charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 58) && mouseY < (double)(bY - 36)) {
                    if (EntityPlayerExtension.getPlayerMegaItemsUnlocked((Player)this.gui.getMinecraft().f_91074_).canMega()) {
                        this.gui.getMinecraft().m_91152_((Screen)new MegaItemScreen(false));
                    }
                    return false;
                }
                if (mouseY > (double)(bY - 79) && mouseY < (double)(bY - 58) && EntityPlayerExtension.getPlayerMegaItemsUnlocked((Player)this.gui.getMinecraft().f_91074_).canDynamax()) {
                    this.gui.getMinecraft().m_91152_((Screen)new MegaItemScreen(true));
                }
            }
        } else if (mouseX >= (double)(bX - 9) && mouseX <= (double)(bX + 1) && mouseY >= (double)(bY - 18) && mouseY <= (double)(bY + 18)) {
            this.drawerOut = true;
            return false;
        }
        return true;
    }

    public void tick() {
        if (this.ticksTillClick > 0) {
            --this.ticksTillClick;
        }
    }

    public int getSlotClicked(double mouseX, double mouseY) {
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            int slotY;
            int slotX;
            Pokemon pokemon;
            SlotInventoryPixelmon slot = this.pixelmonSlots[i];
            StoragePosition position = slot == null ? null : slot.position;
            Pokemon pokemon2 = pokemon = position == null ? null : ClientStorageManager.party.get(position);
            if (slot != null) {
                slotX = slot.x;
                slotY = slot.y;
            } else {
                slotX = ((InventoryPixelmonBase)this.gui).getGUILeft() - this.partyWidth + 6;
                slotY = ((EffectRenderingInventoryScreen)this.gui).f_96544_ / 2 + i * 18 - 75;
            }
            if (!(mouseX >= (double)slotX) || !(mouseX <= (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY <= (double)(slotY + 16))) continue;
            return i;
        }
        return -1;
    }

    public StoragePosition getSelected() {
        return this.selected;
    }

    public void setSelected(StoragePosition selected) {
        this.selected = selected;
    }

    public boolean isDrawerOut() {
        return this.drawerOut;
    }

    public int getDrawerOffset() {
        return this.drawerOffset;
    }

    public int getPartyWidth() {
        return this.partyWidth;
    }
}

