/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class FishingLogMenuScreen
extends Screen {
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private int currentScroll = 0;
    private int waitingScroll = 0;
    int maxScroll;
    private BiMap<Species, IndexedButton> buttons = HashBiMap.create();
    HashMap<Integer, int[]> map = new HashMap();
    HashMap<Integer, Double> percent = new HashMap();

    public FishingLogMenuScreen(int[] data) {
        super((Component)Component.m_237119_());
        int currentSpecies = -1;
        int total = -1;
        int count = 0;
        int[] arr = new int[]{};
        double seen = 0.0;
        for (int i = 1; i < data.length; ++i) {
            if (currentSpecies == -1) {
                currentSpecies = data[i];
            } else if (total == -1) {
                total = data[i];
                arr = new int[data[i]];
            } else {
                if (data[i] > 0) {
                    seen += 1.0;
                }
                arr[count] = data[i];
                ++count;
            }
            if (count != total) continue;
            this.percent.put(currentSpecies, seen * 100.0 / (double)total);
            seen = 0.0;
            this.map.put(currentSpecies, arr);
            currentSpecies = -1;
            total = -1;
            count = 0;
        }
        this.maxScroll = 240 * (this.map.values().size() / 3);
    }

    public void m_7856_() {
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        this.map.forEach((id, data) -> {
            Species species = PixelmonSpecies.fromNationalDex(id);
            this.buttons.put((Object)species, (Object)((IndexedButton)this.m_142416_((GuiEventListener)new IndexedButton(species.getDex(), 0, 0, 60, 46, (Component)Component.m_237113_((String)species.toString()), this::actionPerformed))));
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics, mouseX, mouseY, partialTicks);
        this.processScroll();
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        float sf = (float)this.f_96541_.m_91268_().m_85449_();
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * sf;
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * sf;
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 5.0f) * sf;
        float y2 = ((float)this.centerY + this.guiHeight / 2.0f - 5.0f) * sf;
        this.drawScreenForeground(graphics, mouseX, mouseY);
        matrix.m_85849_();
        int height = 15;
        float width = (float)height * 6.168067f;
        ScreenHelper.drawImageQuad(Resources.fishingLogTitle, graphics, (float)this.centerX - width / 2.0f, this.centerY - 117, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawScaledCenteredString(graphics, I18n.m_118938_((String)"gui.fishinglog.menu.title", (Object[])new Object[0]), this.centerX, (float)this.centerY - 112.5f, -7781367, 14.0f);
    }

    private void drawScreenForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        float x = (float)this.centerX - this.guiWidth / 2.0f + 14.5f;
        AtomicInteger top = new AtomicInteger((int)((float)(this.currentScroll + this.centerY) - this.guiHeight / 2.0f + 20.0f));
        DecimalFormat format = new DecimalFormat("###.#");
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int i = 0;
        for (IndexedButton button : this.buttons.values()) {
            boolean noSilhouette = true;
            Species form = (Species)this.buttons.inverse().get((Object)button);
            float height = 45.6f;
            float xPos = x + 63.5f * (float)(i % 2);
            ScreenHelper.drawImageQuad(Resources.fishingMenuContainer, graphics, xPos, top.get(), 60.0f, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            button.f_93620_ = (int)xPos;
            button.f_93621_ = top.get();
            if (this.percent.get(form.getDex()) == 0.0) {
                noSilhouette = false;
            }
            ScreenHelper.drawImageQuad(form.getFirstPaletteProperties().getSprite(), graphics, xPos + 10.0f, top.get() - 1, 39.0f, 39.0f, 0.0f, 0.0f, 1.0f, 1.0f, (float)noSilhouette, (float)noSilhouette, (float)noSilhouette, 1.0f, 0.0f);
            ScreenHelper.drawScaledString(graphics, format.format(this.percent.get(form.getDex())) + "%", xPos + 3.0f, top.get() + 3, -1, 8.0f);
            ScreenHelper.drawScaledCenteredSplitString(graphics, this.percent.get(form.getDex()) == 0.0 ? "???" : form.getLocalizedName(), xPos + 30.0f, (float)top.get() + height + 4.0f, -7845363, 10.0f, 50, false);
            if (++i % 2 != 0) continue;
            top.addAndGet(65);
        }
    }

    public void m_280273_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.fishingLogBackground, graphics, (float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    public void processScroll() {
        int mustard = 6;
        if (this.waitingScroll != 0) {
            if (Math.abs(this.waitingScroll) >= mustard) {
                if (this.waitingScroll < 0) {
                    this.waitingScroll += mustard;
                    this.currentScroll -= mustard;
                } else {
                    this.waitingScroll -= mustard;
                    this.currentScroll += mustard;
                }
            } else if (this.waitingScroll < 0) {
                ++this.waitingScroll;
                --this.currentScroll;
            } else {
                --this.waitingScroll;
                ++this.currentScroll;
            }
        }
    }

    public boolean m_6050_(double p_231043_1_, double p_231043_3_, double iX, double iY) {
        int speed = 20;
        if (iY < 0.0) {
            this.waitingScroll += speed;
            if (this.currentScroll + this.waitingScroll > this.maxScroll - 240) {
                this.waitingScroll = this.maxScroll - 240 - this.currentScroll;
            }
        } else if (iY > 0.0) {
            this.waitingScroll -= speed;
            if (this.currentScroll + this.waitingScroll < 0) {
                this.waitingScroll = -this.currentScroll;
            }
        }
        return super.m_6050_(p_231043_1_, p_231043_3_, iX, iY);
    }

    public void actionPerformed(Button button) {
        Species form;
        if (button instanceof IndexedButton && this.map.get((form = (Species)this.buttons.inverse().get((Object)button)).getDex()).length != 0) {
            Minecraft.m_91087_().m_91152_((Screen)new FishingLogScreen(form.getDex(), this.map.get(form.getDex())));
        }
    }
}

