/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.BubbleObject;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogScreen;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.lwjgl.opengl.GL11;

public class FishingLogInformationScreen
extends Screen {
    private Pokemon pokemon;
    private int[] encountered;
    private int category;
    private double scalar = 10900.0;
    private PixelmonEntity displayedPokemon;
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private Button okButton;
    private List<BubbleObject> bubbles = Lists.newArrayList();

    public FishingLogInformationScreen(int dex, int category, int form, int ... data) {
        super((Component)Component.m_237119_());
        this.category = category;
        Species species = PixelmonSpecies.fromNationalDex(dex);
        PokemonSpecification spec = FormLogRegistry.getFormFromId(species, form);
        this.pokemon = PokemonFactory.create(species);
        spec.apply(this.pokemon);
        this.encountered = Arrays.copyOfRange(data, 3, data.length);
    }

    public FishingLogInformationScreen(int dex, int category, PokemonSpecification form, int[] data) {
        super((Component)Component.m_237119_());
        this.category = category;
        Species species = PixelmonSpecies.fromNationalDex(dex);
        this.pokemon = PokemonFactory.create(species);
        form.apply(this.pokemon);
        this.encountered = data;
    }

    public void m_7856_() {
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        int height = 20;
        int width = (int)((double)height * 5.338235294117647);
        this.okButton = (Button)this.m_142416_((GuiEventListener)new Button(this.centerX - width / 2, this.centerY + 70, width, height, (Component)Component.m_237119_(), this::actionPerformed, a -> Component.m_237119_()));
        this.bubbles = Lists.newArrayList();
        this.setupDisplayedPokemon();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.getFont("pixelmon:textures/gui/pokemonfont.png", true);
        if (this.bubbles.size() < 8 && RandomHelper.getRandomChance(0.05)) {
            int size = RandomHelper.getRandomNumberBetween(5, 10);
            this.bubbles.add(new BubbleObject(this.centerX + RandomHelper.getRandomNumberBetween(-65, 65 - size), this.centerY, size));
        }
        this.m_280273_(graphics, mouseX, mouseY, partialTicks);
        this.drawScreenForeground(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_280273_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrix = graphics.m_280168_();
        float borderWidth = 1.0f;
        float width = this.guiWidth - borderWidth * 2.0f;
        ScreenHelper.drawImageQuad(Resources.fishingLogWater, graphics, (float)this.centerX - this.guiWidth / 2.0f + borderWidth, (float)this.centerY - this.guiHeight / 2.0f + borderWidth, width, width * 0.73f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        matrix.m_85836_();
        float sf = (float)this.f_96541_.m_91268_().m_85449_();
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * sf;
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * sf;
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 1.0f) * sf;
        float y2 = (float)this.centerY * sf;
        GL11.glScissor((int)((int)x1), (int)((int)((float)this.f_96541_.m_91268_().m_85444_() - y2)), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
        GL11.glEnable((int)3089);
        for (int i = 0; i < this.bubbles.size(); ++i) {
            BubbleObject bubble = this.bubbles.get(i);
            bubble.render(graphics);
            if (!(bubble.getY() < (float)this.centerY - this.guiHeight / 2.0f - 20.0f)) continue;
            this.bubbles.remove(i--);
        }
        GL11.glDisable((int)3089);
        matrix.m_85849_();
        ScreenHelper.drawImageQuad(Resources.fishingLogInformationBackground, graphics, (float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    public void drawScreenForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.fishingLogConfirmButton, graphics, this.okButton.f_93620_, this.okButton.f_93621_, this.okButton.m_5711_(), this.okButton.m_93694_(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawCenteredString(graphics, "Ok", (float)this.centerX, (float)(this.okButton.f_93621_ + 6), this.okButton.m_5953_((double)mouseX, (double)mouseY) ? -12687348 : -1);
        if (this.pokemon.getForm().isForm(PixelmonForms.NONE) && this.pokemon.getPalette().is("none")) {
            ScreenHelper.drawScaledCenteredString(graphics, I18n.m_118938_((String)"pixelmon.generic.form.base", (Object[])new Object[0]), this.centerX, this.centerY + 1, -7781367, 14.0f);
            ScreenHelper.drawScaledCenteredSplitString(graphics, I18n.m_118938_((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".palette." + this.pokemon.getPalette().getName() + ".description"), (Object[])new Object[0]), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        } else if (!this.pokemon.getForm().isForm(PixelmonForms.NONE) && this.pokemon.getPalette().is("none")) {
            ScreenHelper.drawScaledCenteredString(graphics, I18n.m_118938_((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".form." + this.pokemon.getForm().getName()), (Object[])new Object[0]), this.centerX, this.centerY + 1, -7781367, 14.0f);
            ScreenHelper.drawScaledCenteredSplitString(graphics, I18n.m_118938_((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".form." + this.pokemon.getForm().getName() + ".description"), (Object[])new Object[0]), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        } else if (!this.pokemon.getPalette().is("none")) {
            ScreenHelper.drawScaledCenteredString(graphics, I18n.m_118938_((String)("pixelmon.palette." + this.pokemon.getPalette().getName()), (Object[])new Object[0]), this.centerX, this.centerY + 1, -7781367, 14.0f);
            ScreenHelper.drawScaledCenteredSplitString(graphics, I18n.m_118938_((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".palette." + this.pokemon.getPalette().getName() + ".description"), (Object[])new Object[0]), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        }
        this.drawEntityToScreen(graphics, this.centerX, this.centerY - 30, 70, this.displayedPokemon, mouseX, partialTicks);
    }

    protected void actionPerformed(Button button) {
        if (button != null) {
            Minecraft.m_91087_().m_91152_((Screen)new FishingLogScreen(this.pokemon.getSpecies().getDex(), this.encountered));
        }
    }

    private void setupDisplayedPokemon() {
        if (this.f_96541_ == null) {
            return;
        }
        this.displayedPokemon = new PixelmonEntity((Level)this.f_96541_.f_91073_, this.pokemon);
        this.displayedPokemon.m_6034_(this.f_96541_.f_91074_.m_20185_(), this.f_96541_.f_91074_.m_20186_(), this.f_96541_.f_91074_.m_20189_());
        this.displayedPokemon.getPokemon().setGrowth(EnumGrowth.Ordinary);
        this.displayedPokemon.setDisableNametag(true);
        this.displayedPokemon.checkAnimation();
        this.displayedPokemon.setAnimation(AnimationType.SWIM);
        this.displayedPokemon.initAnimation();
        double referenceW = 50.0;
        double referenceH = 50.0;
        double dh = (double)this.displayedPokemon.m_20206_() - referenceH;
        double dw = (double)this.displayedPokemon.m_20205_() - referenceW;
        this.scalar = dh > dw ? referenceH / (double)this.displayedPokemon.m_20206_() : referenceW / (double)this.displayedPokemon.m_20205_();
    }

    public void m_86600_() {
        if (this.displayedPokemon != null && this.displayedPokemon.getAnimationVariables() != null) {
            this.displayedPokemon.getAnimationVariables().tick();
        }
    }

    private void drawEntityToScreen(GuiGraphics graphics, int x, int y, int l, PixelmonEntity entity, int mouseX, float partialTicks) {
        PoseStack matrix = graphics.m_280168_();
        graphics.m_280168_().m_85836_();
        RenderSystem.enableDepthTest();
        matrix.m_252880_((float)x, (float)y, 100.0f);
        matrix.m_85841_((float)this.scalar, (float)this.scalar, (float)this.scalar);
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler((float)(x - mouseX) / 2.0f, 0.0f, 1.0f, 0.0f));
        PixelmonRendering.renderEntity(graphics, entity, true, partialTicks);
        matrix.m_252781_(QuaternionHelper.fromEuler(360.0f - (float)(x - mouseX) / 2.0f, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.m_85841_(1.0f / (float)this.scalar, 1.0f / (float)this.scalar, 1.0f / (float)this.scalar);
        matrix.m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!super.m_6050_(mouseX, mouseY, deltaX, deltaY)) {
            this.scalar += deltaY;
        }
        return true;
    }
}

