/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.egg;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.ChatVisiblity;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Quaternionf;
import org.joml.Vector2f;

public class EggHatchingScreen
extends Screen {
    private static final Component ANIMATION_COMPLETE = Component.m_237115_((String)"animation.complete");
    private static final Component STEP_ONE = Component.m_237115_((String)"pixelmon.egg.step1");
    private static final Component STEP_TWO = Component.m_237115_((String)"pixelmon.egg.step2");
    private static final Component STEP_THREE = Component.m_237115_((String)"pixelmon.egg.step3");
    protected final int slot;
    protected float lastAngleX;
    protected float lastAngleZ;
    protected float lastScale;
    protected int ticks;
    protected boolean complete = false;
    protected SimpleSoundInstance sound = null;
    protected SimpleSoundInstance firstSound = null;
    protected SimpleSoundInstance pokemonSound = null;
    protected Button button;
    protected List<MutablePair<Vector2f, Vector2f>> particles = Lists.newArrayList();

    public EggHatchingScreen(int slot) {
        super((Component)Component.m_237119_());
        this.slot = slot;
    }

    protected void m_7856_() {
        this.ticks = 0;
        this.lastAngleX = 0.0f;
        this.lastAngleZ = 0.0f;
        this.lastScale = 1.0f;
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        if (Minecraft.m_91087_().m_293199_().m_294516_()) {
            Minecraft.m_91087_().m_293199_().m_293034_();
        }
        Minecraft.m_91087_().f_91066_.f_92119_.m_231514_((Object)ChatVisiblity.HIDDEN);
        this.button = new Button(this.f_96543_ / 2 - 40, this.f_96544_ - 20, 80, 20, (Component)Component.m_237115_((String)(this.complete ? "animation.complete" : "animation.skip")), button -> this.m_7379_(), a -> Component.m_237119_());
        this.m_142416_((GuiEventListener)this.button);
        this.particles.clear();
    }

    public void m_86600_() {
        ++this.ticks;
        for (MutablePair<Vector2f, Vector2f> particle : this.particles) {
            particle.setLeft((Object)new Vector2f(((Vector2f)particle.getLeft()).x + ((Vector2f)particle.getRight()).x, ((Vector2f)particle.getLeft()).y + ((Vector2f)particle.getRight()).y));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        SoundEvent cry;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_252781_(QuaternionHelper.fromEuler(partialTicks > 50.0f ? 20.0f : -20.0f, 0.0f, 0.0f, 0.0f));
        int loop = this.ticks % 301;
        Pokemon pokemon = ClientStorageManager.party.get(this.slot);
        ResourceLocation egg = Resources.getEggSprite(pokemon.getSpecies(), 11);
        if (this.firstSound == null) {
            this.firstSound = SimpleSoundInstance.m_119745_((SoundEvent)((SoundEvent)SoundRegistration.EGG_HYPE.get()));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.firstSound);
        }
        if (loop < 5) {
            this.lastScale = 1.0f;
            this.lastAngleZ = 0.0f;
            this.lastAngleX -= 1.0f;
        } else if (loop < 10) {
            this.lastAngleX += 1.0f;
        } else if (loop < 15) {
            this.lastAngleX -= 2.0f;
        } else if (loop < 20) {
            this.lastAngleX += 2.0f;
        } else if (loop < 25) {
            this.lastAngleX -= 1.0f;
        } else if (loop < 30) {
            this.lastAngleX += 1.0f;
        } else if (loop < 35) {
            this.lastAngleX = 0.0f;
            this.lastAngleZ += 1.125f;
        } else if (loop < 45) {
            this.lastAngleZ -= 1.125f;
        } else if (loop < 55) {
            this.lastAngleZ += 1.125f;
        } else if (loop < 65) {
            this.lastAngleZ -= 1.125f;
        } else if (loop < 75) {
            this.lastAngleZ += 1.125f;
        } else if (loop < 85) {
            this.lastAngleZ -= 1.125f;
        } else if (loop < 90) {
            this.lastAngleZ += 1.125f;
        } else if (loop >= 120) {
            if (loop < 122) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 126) {
                this.lastAngleZ -= 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 128) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 150) {
                egg = Resources.getEggSprite(pokemon.getSpecies(), 6);
            } else if (loop < 152) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 156) {
                this.lastAngleZ -= 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 158) {
                this.lastAngleZ += 2.25f;
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 170) {
                egg = Resources.getEggSprite(pokemon.getSpecies(), 1);
            } else if (loop < 301) {
                this.lastAngleZ = 0.0f;
                this.lastAngleX = 0.0f;
                this.complete = true;
                this.button.m_93666_(ANIMATION_COMPLETE);
                egg = ClientStorageManager.party.get(this.slot).getSprite();
            }
        }
        if (loop > 160 && loop < 295 && this.sound == null) {
            this.sound = SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundRegistration.EGG_REVEAL.get()), (float)1.0f);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
        }
        if (loop > 190 && loop < 295 && this.pokemonSound == null && (cry = pokemon.getPalette().getSound()) != null) {
            this.pokemonSound = SimpleSoundInstance.m_119752_((SoundEvent)cry, (float)1.0f);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.pokemonSound);
        }
        if (loop > 170) {
            if (loop % 5 == 0) {
                double angle = Math.random() * 2.0 * Math.PI;
                Vector2f vector2f = new Vector2f((float)Math.cos(angle) * 3.0f, (float)Math.sin(angle) * 3.0f);
                this.particles.add((MutablePair<Vector2f, Vector2f>)new MutablePair((Object)new Vector2f((float)this.f_96543_ / 2.0f, 0.75f * (float)this.f_96544_), (Object)vector2f));
            }
            if (loop < 175) {
                this.lastScale = (float)((double)this.lastScale + 0.01);
            } else if (loop < 180) {
                this.lastScale = (float)((double)this.lastScale - 0.01);
            } else if (loop < 185) {
                this.lastScale = (float)((double)this.lastScale + 0.01);
            } else if (loop < 190) {
                this.lastScale = (float)((double)this.lastScale - 0.01);
            }
        }
        Object component = loop < 30 ? STEP_ONE : (loop < 120 ? STEP_TWO : (loop < 170 ? STEP_THREE : Component.m_237110_((String)"pixelmon.egg.step4", (Object[])new Object[]{pokemon.getDisplayName()})));
        boolean shinyStar = pokemon.isLegendary() || pokemon.isShiny() || pokemon.isUltraBeast();
        for (MutablePair<Vector2f, Vector2f> particle : this.particles) {
            ScreenHelper.drawImage(graphics, Resources.shiny, ((Vector2f)particle.left).x, ((Vector2f)particle.left).y, 16.0f, 16.0f, shinyStar ? 1.0f : 0.5f, shinyStar ? 1.0f : 0.5f, shinyStar ? 1.0f : 0.5f, shinyStar ? 1.0f : 0.5f, 2.0f);
        }
        ScreenHelper.drawImage(graphics, ResourceLocationHelper.of("pixelmon", "textures/gui/egg/egg_shadow.png"), (float)this.f_96543_ / 2.0f - 48.0f, (float)this.f_96544_ * 0.77f - 48.0f, 96.0f, 96.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawImage(graphics, ResourceLocationHelper.of("pixelmon", "textures/gui/egg/background.png"), (float)this.f_96543_ / 2.0f - 128.0f, (float)this.f_96544_ * 0.15f - 12.0f, 256.0f, 32.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        graphics.drawString(this.f_96541_.f_91062_, component.m_7532_(), (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)component) / 2.0f, (float)this.f_96544_ * 0.15f, 2, false);
        matrix.m_85836_();
        Quaternionf quaternion = Axis.f_252403_.m_252977_(this.lastAngleZ);
        matrix.m_85837_((double)this.f_96543_ / 2.0, (double)(0.75f * (float)this.f_96544_ + this.lastAngleX), 0.0);
        matrix.m_252781_(quaternion);
        matrix.m_85841_(this.lastScale, this.lastScale, 0.0f);
        ScreenHelper.drawImageQuad(egg, graphics, -64.0f, -96.0f, 128.0f, 128.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
        matrix.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        if (Minecraft.m_91087_().m_293199_().m_294516_()) {
            Minecraft.m_91087_().m_293199_().m_293034_();
        }
        Minecraft.m_91087_().f_91066_.f_92119_.m_231514_((Object)ChatVisiblity.FULL);
        this.endActiveSound(this.sound);
        this.endActiveSound(this.firstSound);
        this.endActiveSound(this.pokemonSound);
        super.m_7379_();
    }

    public void endActiveSound(SimpleSoundInstance playing) {
        if (Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)playing)) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)playing);
        }
    }
}

