/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.daycare;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareContainer;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareSlot;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmonBase;
import com.pixelmonmod.pixelmon.client.gui.widgets.InvisibleButtonWithTooltip;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.AddToDayCarePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.CancelDayCareBoxPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.CompleteDayCareRequirementPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareHourglassUsedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestAllErrorsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestConditionUpdatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.RequestDayCareChildPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.WithdrawDayCareBoxPacket;
import com.pixelmonmod.pixelmon.items.IsiHourglassItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ItemStack;

public class DayCareScreen
extends EffectRenderingInventoryScreen<DayCareContainer>
implements InventoryPixelmonBase {
    private static final ResourceLocation GUI_LOCATION = ResourceLocationHelper.of("pixelmon", "textures/gui/daycare/inventory.png");
    private static final ResourceLocation OVAL_CHARM_ITEM = ResourceLocationHelper.of("pixelmon", "textures/item/keyitems/oval_charm.png");
    public static final DayCareSlot[] SLOTS = new DayCareSlot[]{new DayCareSlot(15.0, 46.5, 16.0, 16.0), new DayCareSlot(35.0, 46.5, 16.0, 16.0)};
    private InventoryPixelmon<?> inventory;
    private PlayerPartyStorage party;
    private DayCareBox box;
    private int[] slots = new int[]{-1, -1};
    private int selectedSlot = -1;
    private Pokemon child;
    private Pokemon displayedChild;
    private int startSlot = 0;

    public DayCareScreen(DayCareContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.party = ClientStorageManager.party;
        this.inventory = new InventoryPixelmon<DayCareScreen>(this, 42);
        this.selectBox(0, false);
    }

    public void m_7856_() {
        int boxId;
        super.m_7856_();
        this.inventory.initGui();
        this.m_142416_((GuiEventListener)new InvisibleButtonWithTooltip(this.getGuiLeft() + 13, this.getGuiTop() + 45 + 16 + 5, 16, 16, (Component)Component.m_237119_(), this::clickCancel, (graphics, mouseX, mouseY) -> graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.cancel"), mouseX, mouseY), i -> this.box != null && !this.box.isEmpty(), 0));
        this.m_142416_((GuiEventListener)new InvisibleButtonWithTooltip(this.getGuiLeft() + 13 + 16 + 3, this.getGuiTop() + 45 + 16 + 3, 19, 19, (Component)Component.m_237119_(), this::clickConfirm, (graphics, mouseX, mouseY) -> graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.confirm"), mouseX, mouseY), i -> this.box != null && this.child != null && this.box.isEmpty() || this.box != null && !this.box.hasBreedingBegun() && this.box.canConsume(), 0));
        Predicate<Integer> previousPredicate = i -> i > 0;
        this.m_142416_((GuiEventListener)new InvisibleButtonWithTooltip(this.getGuiLeft() + this.f_97726_ - 16 - 16 - 10, this.getGuiTop(), 16, 14, (Component)Component.m_237119_(), button -> this.swapPage(false), (graphics, mouseX, mouseY) -> graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.previous.page"), mouseX, mouseY), previousPredicate, this.startSlot));
        Predicate<Integer> nextPredicate = i -> i < this.party.getDayCare().getAllowedBoxes();
        this.m_142416_((GuiEventListener)new InvisibleButtonWithTooltip(this.getGuiLeft() + this.f_97726_ - 16 - 10, this.getGuiTop(), 16, 14, (Component)Component.m_237119_(), button -> this.swapPage(true), (graphics, mouseX, mouseY) -> graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.next.page"), mouseX, mouseY), nextPredicate, this.startSlot + 3));
        int i2 = (this.f_96543_ - 176) / 2;
        int j = (this.f_96544_ - 166) / 2;
        int j1 = i2 + 60;
        PlayerDayCare dayCare = ClientStorageManager.party.getDayCare();
        for (int k = 0; k < 3 && (boxId = this.startSlot + k) < this.party.getDayCare().getAllowedBoxes(); ++k) {
            int finalK = k;
            this.m_142416_((GuiEventListener)new InvisibleButtonWithTooltip(j1, j + 14 + 19 * k, 108, 19, (Component)Component.m_237119_(), button -> this.selectBox(this.startSlot + finalK, true), (graphics, mouseX, mouseY) -> {
                Optional<DayCareBox> box = dayCare.getOrCreateBox(boxId);
                box.ifPresent(dayCareBox -> {
                    if (dayCareBox.canBreedingBegin() || dayCareBox.isEmpty()) {
                        graphics.m_280666_(this.f_96541_.f_91062_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("pixelmon.daycare.box." + boxId))}), mouseX, mouseY);
                        return;
                    }
                    if (dayCareBox.getAllErrorMessages() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestAllErrorsPacket(dayCareBox.getBoxId()));
                        graphics.m_280666_(this.f_96541_.f_91062_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("pixelmon.daycare.box." + boxId))}), mouseX, mouseY);
                        return;
                    }
                    ArrayList allErrorMessages = Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("pixelmon.daycare.box." + boxId)), Component.m_237115_((String)"pixelmon.daycare.requirements")});
                    allErrorMessages.addAll(dayCareBox.getAllErrorMessages());
                    graphics.m_280666_(this.f_96541_.f_91062_, (List)allErrorMessages, mouseX, mouseY);
                });
            }));
        }
    }

    private void clickConfirm(Button button) {
        if (this.box == null || this.box.hasBreedingBegun() && this.box.getPercentComplete() < 100.0) {
            return;
        }
        if (!this.box.isEmpty() && this.box.hasBreedingBegun() && this.box.getPercentComplete() >= 100.0) {
            NetworkHelper.sendToServer(new WithdrawDayCareBoxPacket(this.box.getBoxId()));
            ScreenHelper.closeScreen();
            return;
        }
        if (!this.box.isEmpty() && !this.box.canBreedingBegin() && this.box.canConsume()) {
            NetworkHelper.sendToServer(new CompleteDayCareRequirementPacket(this.box.getBoxId()));
            return;
        }
        if (this.child == null) {
            return;
        }
        NetworkHelper.sendToServer(new AddToDayCarePacket(this.box.getBoxId(), this.slots[0], this.slots[1]));
    }

    private void clickCancel(Button button) {
        if (this.box == null) {
            return;
        }
        if (!this.box.isEmpty() && this.box.hasBreedingBegun() && this.box.getPercentComplete() >= 100.0) {
            NetworkHelper.sendToServer(new WithdrawDayCareBoxPacket(this.box.getBoxId()));
            ScreenHelper.closeScreen();
            return;
        }
        NetworkHelper.sendToServer(new CancelDayCareBoxPacket(this.box.getBoxId()));
        ScreenHelper.closeScreen();
    }

    private void selectBox(int boxId, boolean checkHeld) {
        if (checkHeld && this.f_96541_ != null && !(this.f_96541_.f_91074_.f_36096_.m_142621_().m_41720_() instanceof AirItem)) {
            ItemStack carried = this.f_96541_.f_91074_.f_36096_.m_142621_();
            if (!(carried.m_41720_() instanceof IsiHourglassItem)) {
                return;
            }
            NetworkHelper.sendToServer(new DayCareHourglassUsedPacket(boxId - this.startSlot, this.startSlot, this.startSlot + 1, this.startSlot + 2));
            return;
        }
        DayCareBox dayCareBox = this.party.getDayCare().getOrCreateBox(boxId).orElse(null);
        if (dayCareBox == null || dayCareBox.isEmpty()) {
            this.setBox(this.party.getDayCare().getFirstEmptyBox());
        } else {
            this.setBox(dayCareBox);
            if (!dayCareBox.canBreedingBegin()) {
                NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(dayCareBox.getBoxId()));
            }
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrix = graphics.m_280168_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        matrix.m_85836_();
        graphics.m_280218_(Resources.pixelmonOverlayExtended2, this.f_97735_ - 80, this.f_96544_ / 2 - 83, 0, 0, 90, 166);
        this.inventory.drawGuiContainerBackgroundLayer(graphics, partialTicks, mouseX, mouseY);
        this.inventory.render(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        ScreenHelper.drawInUnicode(() -> {
            this.renderSlots(graphics, mouseX, mouseY);
            if (this.child != null && this.box != null && this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.displayedChild.getSprite(), graphics, this.getGuiLeft() + 16, (float)this.getGuiTop() + 12.5f, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
            if (this.box != null && !this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.box.getEgg().getSprite(), graphics, this.getGuiLeft() + 16, (float)this.getGuiTop() + 12.5f, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
            if (this.startSlot > 0) {
                ScreenHelper.drawImageQuad(Resources.UP, graphics, this.getGuiLeft() + this.f_97726_ - 16 - 16 - 10, this.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, this.getZLevel());
            }
            if (this.startSlot < this.party.getDayCare().getAllowedBoxes() - 3) {
                ScreenHelper.drawImageQuad(Resources.DOWN, graphics, this.getGuiLeft() + this.f_97726_ - 16 - 10, this.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, this.getZLevel());
            }
            graphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237115_((String)"pixelmon.daycare.title"), this.getGuiLeft() + 5, this.getGuiTop() + 3, 1, false);
        });
        matrix.m_85849_();
    }

    private void renderSlots(GuiGraphics graphics, double mouseX, double mouseY) {
        int id = 0;
        boolean full = ClientStorageManager.party.getDayCare().isFull();
        for (int slot : this.slots) {
            DayCareSlot slotData = SLOTS[id];
            if (full && this.box == null) {
                ScreenHelper.drawImageQuad(Resources.NO_ENTRY, graphics, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, this.getZLevel());
                ++id;
                continue;
            }
            if (!this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.box.getParent(id + 1).getSprite(), graphics, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
                if (slotData.inSlot(mouseX - (double)this.getGUILeft(), mouseY - (double)this.getGuiTop())) {
                    ScreenHelper.drawPokemonHoverInfo(graphics, this.box.getParent(id + 1), (int)mouseX, (int)mouseY);
                }
                ++id;
                continue;
            }
            if (slot == -1) {
                ++id;
                continue;
            }
            Pokemon pokemon = ClientStorageManager.party.get(slot);
            if (pokemon == null || pokemon.isUnbreedable()) {
                this.slots[id] = -1;
                ++id;
                continue;
            }
            if (this.selectedSlot == id) {
                ScreenHelper.drawImageQuadUV(Resources.pcResources, graphics, (float)this.getGuiLeft() + (float)slotData.getStartX() - 0.25f, (float)this.getGuiTop() + (float)slotData.getStartY() + 0.25f, (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 29.0f, 29.0f, 29.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
            if (slotData.inSlot(mouseX - (double)this.getGUILeft(), mouseY - (double)this.getGuiTop())) {
                ScreenHelper.drawPokemonHoverInfo(graphics, pokemon, (int)mouseX, (int)mouseY);
            }
            ScreenHelper.drawImageQuad(pokemon.getSprite(), graphics, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            ++id;
        }
    }

    public boolean m_6375_(double x, double y, int mouseButton) {
        if (this.inventory.mouseClicked(x, y, mouseButton) && this.isOutsideParty(x, y)) {
            if (this.party.getDayCare().isFull() || !this.box.isEmpty()) {
                return super.m_6375_(x, y, mouseButton);
            }
            double mouseX = x - (double)this.getGUILeft();
            double mouseY = y - (double)this.getGuiTop();
            if (this.inventory.getSelected() == null) {
                if (this.selectedSlot == -1) {
                    for (int i = 0; i < this.slots.length; ++i) {
                        if (!SLOTS[i].inSlot(mouseX, mouseY)) continue;
                        this.selectedSlot = i;
                        this.inventory.setSelected(null);
                        return true;
                    }
                } else {
                    for (int i = 0; i < this.slots.length; ++i) {
                        if (this.selectedSlot == i && SLOTS[i].inSlot(mouseX, mouseY)) {
                            this.selectedSlot = -1;
                            continue;
                        }
                        if (!SLOTS[i].inSlot(mouseX, mouseY) || this.selectedSlot == -1) continue;
                        int swapSlotValue = this.slots[this.selectedSlot];
                        this.slots[this.selectedSlot] = this.slots[i];
                        this.slots[i] = swapSlotValue;
                        this.selectedSlot = -1;
                    }
                }
            } else {
                if (ClientStorageManager.party.countPokemon() <= 2) {
                    return true;
                }
                Pokemon pokemon = ClientStorageManager.party.get(this.inventory.getSelected().order);
                if (pokemon == null || pokemon.isEgg() || pokemon.isFainted() || pokemon.isUnbreedable()) {
                    return true;
                }
                for (int i = 0; i < this.slots.length; ++i) {
                    if (!SLOTS[i].inSlot(mouseX, mouseY)) continue;
                    this.setSlot(i);
                }
            }
            this.checkAndGetChild();
            return super.m_6375_(x, y, mouseButton);
        }
        if (ClientStorageManager.party.countPokemon() <= 2) {
            return true;
        }
        if (this.inventory.getSelected() == null) {
            this.checkAndGetChild();
            return true;
        }
        Pokemon pokemon = ClientStorageManager.party.get(this.inventory.getSelected().order);
        if (pokemon == null || pokemon.isEgg() || pokemon.isFainted() || pokemon.isUnbreedable()) {
            return true;
        }
        if (this.inventory.getSelected() != null && this.selectedSlot != -1) {
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.selectedSlot != i) continue;
                this.setSlot(i);
            }
        }
        return true;
    }

    private void setSlot(int slotId) {
        Pokemon pokemon = ClientStorageManager.party.get(this.inventory.getSelected().order);
        if (pokemon.isUnbreedable()) {
            this.inventory.setSelected(null);
            return;
        }
        if (this.getOtherSlot(slotId) == this.inventory.getSelected().order) {
            this.inventory.setSelected(null);
            return;
        }
        this.selectedSlot = -1;
        this.slots[slotId] = this.inventory.getSelected().order;
        this.inventory.setSelected(null);
        this.checkAndGetChild();
    }

    private int getOtherSlot(int slotId) {
        return this.slots[(slotId + 1) % this.slots.length];
    }

    private void checkAndGetChild() {
        if (this.isASlotUnset()) {
            return;
        }
        if (this.clearFaintedSlots()) {
            return;
        }
        NetworkHelper.sendToServer(new RequestDayCareChildPacket(this.slots[0], this.slots[1]));
    }

    private boolean isASlotUnset() {
        for (int slot : this.slots) {
            if (slot != -1) continue;
            return true;
        }
        return false;
    }

    private boolean clearFaintedSlots() {
        for (int partySlot : this.slots) {
            if (this.party.get(partySlot) == null || !this.party.get(partySlot).isFainted()) continue;
            this.setBox(this.box);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isOutsideParty(mouseX, mouseY)) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        this.inventory.tick();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawInUnicode(() -> {
            int i = (this.f_96543_ - 176) / 2;
            int j = (this.f_96544_ - 166) / 2;
            graphics.m_280218_(GUI_LOCATION, i, j, 0, 0, 176, 166);
            int j1 = i + 60;
            if (this.child != null && this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(Resources.TICK, graphics, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 64, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.getZLevel());
            }
            if (this.box != null && !this.box.isEmpty()) {
                if (!this.box.hasBreedingBegun()) {
                    if (!this.box.canConsume()) {
                        ScreenHelper.drawImageQuad(Resources.NO_ENTRY, graphics, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 65, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, this.getZLevel());
                    } else {
                        ScreenHelper.drawImageQuad(Resources.TICK, graphics, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 65, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.getZLevel());
                    }
                }
                if (this.box.getPercentComplete() < 100.0) {
                    ScreenHelper.drawImageQuad(Resources.CROSS, graphics, this.getGuiLeft() + 13 + 2, this.getGuiTop() + 65, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, this.getZLevel());
                }
            }
            for (int k = 0; k < 3; ++k) {
                int boxId = this.startSlot + k;
                if (boxId >= this.party.getDayCare().getAllowedBoxes()) {
                    graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 0, 186, 108, 19);
                    continue;
                }
                DayCareBox box = this.party.getDayCare().getOrCreateBox(boxId).orElse(null);
                if (box == null) continue;
                if (!box.canBreedingBegin() && !box.isEmpty()) {
                    if (box.getErrorMessage() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(box.getBoxId()));
                        continue;
                    }
                    graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 109, 205, 109, 19);
                    graphics.m_280614_(this.f_96541_.f_91062_, box.getErrorMessage(), j1 + 20, j + 19 + 19 * k, 1, false);
                } else if (!box.isEmpty() && box.hasBreedingBegun()) {
                    if (box.getPercentComplete() < 100.0) {
                        graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 0, 205, 109, 19);
                        graphics.m_280218_(GUI_LOCATION, j1 - 1 + 23, j + 19 + 19 * k, 19, 226, 81, 5);
                        graphics.m_280218_(GUI_LOCATION, j1 - 1 + 23, j + 19 + 19 * k, 19, 231, (int)(box.getPercentComplete() / 100.0 * 81.0), 5);
                        MutableComponent totalDuration = StringHelper.getFormattedDuration(box.getTotalDuration());
                        if (box.getOvalCharmActive()) {
                            Font font = this.f_96541_.f_91062_;
                            FormattedCharSequence formattedCharSequence = totalDuration.m_7532_();
                            int n = (int)((float)(j1 + 18 + 50) - (float)this.f_96541_.f_91062_.m_92852_((FormattedText)totalDuration) * 1.5f);
                            Objects.requireNonNull(this.f_96541_.f_91062_);
                            graphics.m_280649_(font, formattedCharSequence, n, j + 33 + 19 * k - 9, 1, false);
                            float f = j1 + 18 + 50 - 4;
                            Objects.requireNonNull(this.f_96541_.f_91062_);
                            ScreenHelper.drawImageQuad(OVAL_CHARM_ITEM, graphics, f, j + 33 + 19 * k - 9, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
                        } else {
                            Font font = this.f_96541_.f_91062_;
                            int n = j1 + 18 + 50 - this.f_96541_.f_91062_.m_92852_((FormattedText)totalDuration);
                            Objects.requireNonNull(this.f_96541_.f_91062_);
                            graphics.m_280614_(font, (Component)totalDuration, n, j + 33 + 19 * k - 9, 1, false);
                        }
                    } else {
                        ScreenHelper.drawImageQuad(Resources.TICK, graphics, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 64, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.getZLevel());
                        graphics.m_280218_(GUI_LOCATION, j1 - 1, j + 14 + 19 * k, 109, 186, 109, 19);
                        MutableComponent complete = Component.m_237115_((String)"pixelmon.daycare.complete");
                        graphics.m_280614_(this.f_96541_.f_91062_, (Component)complete, j1 + 18 + 45 - this.f_96541_.f_91062_.m_92852_((FormattedText)complete) / 2, j + 18 + 19 * k, 1, false);
                    }
                }
                if (box.isEmpty()) continue;
                ScreenHelper.drawImageQuad(box.getEgg().getSprite(), graphics, j1, j + 13 + 19 * k, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
        });
    }

    private void swapPage(boolean forward) {
        if (this.startSlot == 0 && !forward) {
            return;
        }
        if (this.startSlot == this.party.getDayCare().getAllowedBoxes() - 3 && forward) {
            return;
        }
        this.startSlot += forward ? 1 : -1;
        this.m_169413_();
        this.m_7856_();
    }

    public void setChild(Pokemon child, boolean showPotentialShiny) {
        boolean isShiny;
        this.child = child;
        this.displayedChild = child == null ? null : PokemonFactory.copy(child);
        boolean bl = isShiny = child != null && child.isShiny();
        if (!showPotentialShiny && isShiny) {
            this.displayedChild.setShiny(false);
        }
    }

    protected void m_280003_(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public float getZLevel() {
        return 1.0f;
    }

    @Override
    public int getGUILeft() {
        return (this.f_96543_ - 176) / 2;
    }

    @Override
    public void offsetGUILeft(int offset) {
        this.f_97735_ += offset;
    }

    @Override
    public List<Renderable> getButtonList() {
        return this.f_169369_;
    }

    @Override
    public void refreshSearchResults() {
    }

    private boolean isOutsideParty(double x, double y) {
        return !this.isWithinParty(x, y) && !this.isWithinLoreBox(x, y);
    }

    private boolean isWithinParty(double x, double y) {
        int centerW = this.f_96543_ / 2;
        int centerH = this.f_96544_ / 2;
        return x > (double)(centerW + -128) && x < (double)(centerW + -80) && y > (double)(centerH + -84) && y < (double)(centerH + 60);
    }

    private boolean isWithinLoreBox(double x, double y) {
        int centerW = this.f_96543_ / 2;
        int centerH = this.f_96544_ / 2;
        return x > (double)(centerW + -168) && x < (double)(centerW + -128) && y > (double)(centerH + -84) && y < (double)(centerH + -42);
    }

    public void setAndSelectBox(DayCareBox box) {
        this.box = box;
        this.slots = new int[]{-1, -1};
        this.child = null;
        this.displayedChild = null;
        this.selectBox(box.getBoxId(), false);
    }

    public void setBox(DayCareBox box) {
        this.box = box;
        this.slots = new int[]{-1, -1};
        this.child = null;
        this.displayedChild = null;
    }
}

