/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.custom.selection;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.custom.selection.elements.SelectionPokemonUI;
import com.pixelmonmod.pixelmon.comm.packetHandlers.selection.SelectionResponsePacket;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class SelectionScreen
extends Screen {
    private final Component title;
    private final Component text;
    private final int selections;
    private final Pokemon[] options;
    private final Set<Integer> selected;
    private final boolean allowExit;
    private List<SelectionPokemonUI> pokemonInUI = Lists.newArrayList();
    private int centerW;
    private int centerH;
    private int buttonOffset = 30;
    private boolean closing = false;

    public SelectionScreen(Component title, Component text, int selections, boolean allowExit) {
        super(title);
        this.title = title;
        this.text = text;
        this.selections = selections;
        this.allowExit = allowExit;
        this.options = new Pokemon[6];
        this.selected = Sets.newHashSet();
        if (this.allowExit) {
            this.closing = true;
        }
    }

    public SelectionScreen(Component title, Component text, int selections, Pokemon[] options, Set<Integer> selected, boolean allowExit) {
        super(title);
        this.title = title;
        this.text = text;
        this.selections = selections;
        this.options = options;
        this.selected = selected;
        this.allowExit = allowExit;
        if (this.allowExit) {
            this.closing = true;
        }
    }

    public void setPokemon(int slot, Pokemon pokemon) {
        this.options[slot] = pokemon;
    }

    public void m_7856_() {
        this.centerW = this.f_96543_ / 2;
        this.centerH = this.f_96544_ / 2;
        this.pokemonInUI.clear();
        for (int i = 0; i < this.options.length; ++i) {
            SelectionPokemonUI selection = new SelectionPokemonUI(0, 0, this.options[i]);
            selection.setSelected(this.selected.contains(i));
            this.pokemonInUI.add(selection);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.allowExit && this.selections != this.selected.size()) {
            NetworkHelper.sendToServer(new SelectionResponsePacket(null));
        } else {
            NetworkHelper.sendToServer(new SelectionResponsePacket(Lists.newArrayList(this.selected)));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawDialogueBox(graphics, (Screen)this, this.title, this.text, 0.0f);
        for (int i = 0; i < this.pokemonInUI.size(); ++i) {
            SelectionPokemonUI pokemon = this.pokemonInUI.get(i);
            boolean highlight = pokemon.isMouseOver(i < 3 ? this.centerW - 110 : this.centerW + 5, this.f_96544_ / 4 + 20 + this.buttonOffset * (i % 3 + 1), mouseX, mouseY) || pokemon.isSelected();
            pokemon.drawPokemon(graphics, pokemon.getPokemon(), i < 3 ? this.centerW - 110 : this.centerW + 5, this.f_96544_ / 4 + 20 + this.buttonOffset * (i % 3 + 1), mouseX, mouseY, 0.0f, highlight);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.pokemonInUI.size(); ++i) {
            SelectionPokemonUI pokemonUI = this.pokemonInUI.get(i);
            if (!pokemonUI.isMouseOver(i < 3 ? this.centerW - 110 : this.centerW + 5, this.f_96544_ / 4 + 20 + this.buttonOffset * (i % 3 + 1), mouseX, mouseY)) continue;
            if (pokemonUI.isSelected()) {
                this.selected.remove(i);
                this.m_7856_();
                this.closing = this.allowExit;
                continue;
            }
            if (this.selected.size() >= this.selections) continue;
            this.selected.add(i);
            this.m_7856_();
            if (this.allowExit) continue;
            this.closing = this.selected.size() == this.selections;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

