/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.custom.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.overlay.notice.EnumOverlayLayout;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.OverlayGraphicType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CustomNoticeOverlay {
    private static boolean enabled = false;
    private static Collection<Component> lines;
    private static OverlayGraphicType type;
    private static EnumOverlayLayout layout;
    private static int squareSize;
    private static Pokemon pokemon;
    private static PixelmonEntity entity;
    private static float scale;
    private static ItemStack itemStack;

    public static void resetNotice() {
        enabled = false;
        lines = null;
        type = null;
        layout = null;
        pokemon = null;
        entity = null;
        itemStack = null;
    }

    public static void draw(GuiGraphics graphics) {
        Minecraft mc = Minecraft.m_91087_();
        Optional<int[]> coordsOptional = ScreenHelper.renderTooltip(graphics, mc.m_91268_().m_85445_() / 2, 15, lines, -16776961, -1, 100, true, true, 0.0f);
        if (coordsOptional.isPresent()) {
            int[] coords = coordsOptional.get();
            if (type != null) {
                switch (type) {
                    case PokemonSprite: {
                        CustomNoticeOverlay.drawPokemonSprites(graphics, coords);
                        break;
                    }
                    case Pokemon3D: {
                        CustomNoticeOverlay.drawPokemon3Ds(graphics, coords);
                        break;
                    }
                    case ItemStack: {
                        CustomNoticeOverlay.drawItemStacks(graphics, coords);
                    }
                }
            }
        }
    }

    public static void setEnabled(boolean enabled) {
        CustomNoticeOverlay.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void populate(List<Component> lines) {
        CustomNoticeOverlay.lines = lines;
    }

    public static void setPokemonSprite(PokemonSpecification spec, EnumOverlayLayout layout) {
        CustomNoticeOverlay.layout = layout;
        type = OverlayGraphicType.PokemonSprite;
        pokemon = spec.create();
        if (pokemon == null) {
            throw new IllegalArgumentException(String.format("The spec '%s' is not valid.", spec.toString()));
        }
    }

    public static void setPokemon3D(PokemonSpecification spec, EnumOverlayLayout layout) {
        CustomNoticeOverlay.layout = layout;
        type = OverlayGraphicType.Pokemon3D;
        entity = spec.create((Level)Minecraft.m_91087_().f_91073_);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("The spec '%s' is not valid.", spec.toString()));
        }
        scale = 15.0f / entity.m_20206_();
    }

    public static void setItemStack(ItemStack itemStack, EnumOverlayLayout layout) {
        CustomNoticeOverlay.layout = layout;
        type = OverlayGraphicType.ItemStack;
        CustomNoticeOverlay.itemStack = itemStack;
    }

    private static void drawPokemonSprites(GuiGraphics graphics, int[] coords) {
        ResourceLocation rl = pokemon.getSprite();
        switch (layout) {
            case LEFT: {
                ScreenHelper.drawImageQuad(rl, graphics, coords[0] - squareSize, 0.0f, squareSize, squareSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                break;
            }
            case RIGHT: {
                ScreenHelper.drawImageQuad(rl, graphics, coords[2], 0.0f, squareSize, squareSize, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                break;
            }
            case LEFT_AND_RIGHT: {
                ScreenHelper.drawImageQuad(rl, graphics, coords[0] - squareSize, 0.0f, squareSize, squareSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuad(rl, graphics, coords[2], 0.0f, squareSize, squareSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    private static void drawPokemon3Ds(GuiGraphics graphics, int[] coords) {
        switch (layout) {
            case LEFT: {
                ScreenHelper.drawEntity(graphics, (LivingEntity)entity, coords[0] - 15, squareSize - 5, scale, -60.0f, 0.0f);
                break;
            }
            case RIGHT: {
                ScreenHelper.drawEntity(graphics, (LivingEntity)entity, coords[2] + 15, squareSize - 5, scale, 60.0f, 0.0f);
                break;
            }
            case LEFT_AND_RIGHT: {
                ScreenHelper.drawEntity(graphics, (LivingEntity)entity, coords[0] - 15, squareSize - 5, scale, -60.0f, 0.0f);
                ScreenHelper.drawEntity(graphics, (LivingEntity)entity, coords[2] + 15, squareSize - 5, scale, 60.0f, 0.0f);
            }
        }
    }

    private static void drawItemStacks(GuiGraphics graphics, int[] coords) {
        switch (layout) {
            case LEFT: {
                graphics.m_280480_(itemStack, coords[0] - 20, 15);
                break;
            }
            case RIGHT: {
                graphics.m_280480_(itemStack, coords[2] + 5, 15);
                break;
            }
            case LEFT_AND_RIGHT: {
                graphics.m_280480_(itemStack, coords[0] - 20, 15);
                graphics.m_280480_(itemStack, coords[2] + 5, 15);
            }
        }
        RenderSystem.disableDepthTest();
    }

    static {
        squareSize = 40;
        scale = 1.0f;
    }
}

