/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.VersusScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectPokemonIcon;
import com.pixelmonmod.pixelmon.client.gui.widgets.RoundButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.CloseTeamSelectScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.ConfirmTeamSelectPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.ShowTeamSelectPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.UnconfirmTeamSelectPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class TeamSelectScreen
extends VersusScreen {
    public static ShowTeamSelectPacket teamSelectPacket;
    private NPCTrainer trainer;
    private RoundButton confirmButton;
    private boolean confirmed;
    private boolean timeExpired;
    private ClientBattleManager bm;
    private List<TeamSelectPokemonIcon> icons = new ArrayList<TeamSelectPokemonIcon>();
    private int numSelected;
    public String rejectClause = "";
    private static final String SELECT_TEAM = "gui.battlerules.selectteam";

    public TeamSelectScreen() {
        Optional<NPCTrainer> entityNPCOptional;
        this.confirmButton = new RoundButton(85, 152, I18n.m_118938_((String)SELECT_TEAM, (Object[])new Object[0]));
        this.bm = ClientProxy.battleManager;
        this.bm.setTeamSelectTime();
        if (TeamSelectScreen.teamSelectPacket.npcID != -1 && (entityNPCOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, TeamSelectScreen.teamSelectPacket.npcID, NPCTrainer.class)).isPresent()) {
            this.trainer = entityNPCOptional.get();
            this.isNPC = true;
        }
    }

    @Override
    public void m_7856_() {
        int i;
        super.m_7856_();
        if (this.icons.isEmpty()) {
            i = 0;
            for (Pokemon data : ClientStorageManager.party.getAll()) {
                this.icons.add(new TeamSelectPokemonIcon(data, TeamSelectScreen.teamSelectPacket.disabled[i]));
                ++i;
            }
            if (TeamSelectScreen.teamSelectPacket.showOpponentTeam && TeamSelectScreen.teamSelectPacket.opponentTeam != null) {
                for (PokemonBase pokemon : TeamSelectScreen.teamSelectPacket.opponentTeam) {
                    this.icons.add(new TeamSelectPokemonIcon(pokemon.toPokemon(), "n"));
                }
            }
        }
        i = 0;
        for (TeamSelectPokemonIcon icon : this.icons) {
            if (i < 6) {
                icon.setPosition(this.playerPartyX + i * 12, this.playerPartyY);
            } else {
                icon.setPosition(this.opponentPartyX + (i - 6) * 12, this.opponentPartyY);
            }
            ++i;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (TeamSelectScreen.teamSelectPacket.closeable) {
                NetworkHelper.sendToServer(new CloseTeamSelectScreenPacket(TeamSelectScreen.teamSelectPacket.teamSelectID));
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char key, int keyCode) {
        return false;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.ticks == 0) {
            boolean canHighlight = this.numSelected > 0;
            int currentX = canHighlight ? mouseX : 0;
            int currentY = canHighlight ? mouseY : 0;
            this.confirmButton.drawButton(graphics, this.leftX, this.topY, currentX, currentY, 1.0f, this.confirmed);
        }
        if (this.bm.afkOn) {
            ScreenHelper.drawBattleTimer(graphics, this, this.bm.afkTime);
            if (this.bm.afkTime <= 0 && !this.timeExpired) {
                this.confirmed = true;
                this.timeExpired = true;
                NetworkHelper.sendToServer(new ConfirmTeamSelectPacket(TeamSelectScreen.teamSelectPacket.teamSelectID, this.getSelectionOrder(), true));
            }
        }
        Object centerMessage = "";
        if (!this.rejectClause.isEmpty()) {
            centerMessage = I18n.m_118938_((String)"gui.battlerules.teamviolated", (Object[])new Object[0]) + " " + BattleClause.getLocalizedName(this.rejectClause);
            this.confirmed = false;
        } else if (this.confirmed) {
            centerMessage = I18n.m_118938_((String)"gui.battlerules.waitselect", (Object[])new Object[0]);
        }
        if (!((String)centerMessage).isEmpty()) {
            ScreenHelper.renderTooltip(graphics, this.leftX + 140, this.topY + 60, Color.BLUE.getRGB(), Color.BLACK.getRGB(), 200, true, true, ScreenHelper.trimStringToWidth(this.f_96541_.f_91062_, (String)centerMessage, 100));
        }
        int i = 0;
        for (TeamSelectPokemonIcon icon : this.icons) {
            icon.setTickOffset(i++ < 6 ? this.offset1 : this.offset2);
            icon.drawIcon(graphics, mouseX, mouseY, 1.0f, this.isFullSelect());
        }
        if (!TeamSelectScreen.teamSelectPacket.showOpponentTeam) {
            this.drawOpponentPokeBalls(graphics, TeamSelectScreen.teamSelectPacket.opponentSize);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.timeExpired) {
            return false;
        }
        if (!this.confirmed) {
            for (TeamSelectPokemonIcon icon : this.icons) {
                if (!icon.isMouseOver(mouseX, mouseY) || icon.isDisabled()) continue;
                if (icon.selectIndex == -1) {
                    if (this.isFullSelect()) break;
                    icon.selectIndex = this.numSelected++;
                    if (this.numSelected == 1) {
                        this.confirmButton.setText(I18n.m_118938_((String)"gui.battlerules.confirm", (Object[])new Object[0]));
                    }
                } else {
                    for (TeamSelectPokemonIcon icon2 : this.icons) {
                        if (icon2.selectIndex <= icon.selectIndex) continue;
                        --icon2.selectIndex;
                    }
                    icon.selectIndex = -1;
                    if (--this.numSelected == 0) {
                        this.confirmButton.setText(I18n.m_118938_((String)SELECT_TEAM, (Object[])new Object[0]));
                    }
                }
                this.rejectClause = "";
                break;
            }
        }
        if (this.numSelected > 0 && this.confirmButton.isMouseOver(this.leftX, this.topY, mouseX, mouseY)) {
            boolean bl = this.confirmed = !this.confirmed;
            if (this.confirmed) {
                Pixelmon.network.send((Object)new ConfirmTeamSelectPacket(TeamSelectScreen.teamSelectPacket.teamSelectID, this.getSelectionOrder(), false), PacketDistributor.SERVER.noArg());
            } else {
                NetworkHelper.sendToServer(new UnconfirmTeamSelectPacket(TeamSelectScreen.teamSelectPacket.teamSelectID));
            }
        }
        return true;
    }

    private boolean isFullSelect() {
        return this.numSelected >= this.bm.rules.getOrDefault(BattleRuleRegistry.NUM_POKEMON);
    }

    @Override
    protected LivingEntity getOpponent() {
        if (TeamSelectScreen.teamSelectPacket.opponentUUID == null) {
            return this.trainer;
        }
        return this.f_96541_.f_91073_.m_46003_(TeamSelectScreen.teamSelectPacket.opponentUUID);
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    private int[] getSelectionOrder() {
        int[] selection = new int[6];
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = this.icons.get((int)i).selectIndex;
        }
        return selection;
    }

    public boolean m_6913_() {
        return false;
    }
}

