/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class TeamSelectPokemonIcon {
    private Pokemon pokemon;
    private String disabled;
    private int x;
    private int y;
    private int tickOffset;
    public int selectIndex = -1;
    private static final int SIZE = 16;

    public TeamSelectPokemonIcon() {
    }

    public TeamSelectPokemonIcon(Pokemon pokemon, String disabled) {
        this.pokemon = pokemon;
        this.disabled = disabled;
    }

    public TeamSelectPokemonIcon setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public void setTickOffset(int tickOffset) {
        this.tickOffset = tickOffset;
    }

    public void drawIcon(GuiGraphics graphics, double mouseX, double mouseY, float zLevel, boolean fullSelected) {
        if (this.pokemon == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int currentX = this.x + this.tickOffset;
        int currentY = this.y;
        boolean allowed = this.disabled.isEmpty();
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        boolean isOpponent = "n".equals(this.disabled);
        boolean unselected = this.selectIndex == -1;
        ResourceLocation circle = null;
        if (!allowed) {
            if (!isOpponent) {
                circle = Resources.fainted;
            }
        } else if (mouseOver) {
            circle = Resources.selected;
        } else if (!unselected) {
            circle = Resources.released;
        }
        if (circle != null) {
            int circleDiff = 4;
            int circleSize = 16 + circleDiff;
            ScreenHelper.drawImageQuad(circle, graphics, (float)currentX - (float)circleDiff / 2.0f, (float)this.y - (float)circleDiff / 2.0f, circleSize, circleSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        }
        float us = isOpponent ? 0.0f : 1.0f;
        float ue = isOpponent ? 1.0f : 0.0f;
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), graphics, currentX, currentY, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        if (!unselected) {
            graphics.drawString(Minecraft.m_91087_().f_91062_, Integer.toString(this.selectIndex + 1), (float)currentX + 8.0f - 3.0f, (float)(this.y + 16 + 1), 0, true);
        }
        if (mouseOver && !isOpponent) {
            ScreenHelper.drawPokemonHoverInfo(graphics, this.pokemon, (int)mouseX, (int)mouseY);
        }
        if (mouseOver && (!allowed || unselected && fullSelected)) {
            Object reason = "";
            if (isOpponent) {
                reason = this.pokemon.getLocalizedName();
            } else if (this.disabled.equals("e")) {
                reason = I18n.m_118938_((String)"gui.battlerules.egg", (Object[])new Object[0]);
            } else if (this.disabled.equals("f")) {
                reason = I18n.m_118938_((String)"gui.battlerules.fainted", (Object[])new Object[0]);
            } else if (!this.disabled.isEmpty() && !this.disabled.equals("n")) {
                reason = I18n.m_118938_((String)"gui.battlerules.clauseviolated", (Object[])new Object[0]) + " " + BattleClause.getLocalizedName(this.disabled);
            } else if (fullSelected) {
                reason = I18n.m_118938_((String)"gui.battlerules.fullselect", (Object[])new Object[0]);
            }
            if (!((String)reason).isEmpty()) {
                ScreenHelper.renderTooltip(graphics, (int)mouseX + 10, (int)mouseY + 30, Color.BLUE.getRGB(), Color.BLACK.getRGB(), 100, false, false, ScreenHelper.trimStringToWidth(Minecraft.m_91087_().f_91062_, (String)reason, 100));
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.tickOffset != 0 || this.pokemon == null) {
            return false;
        }
        int selectOffset = 2;
        return mouseX >= (double)(this.x + selectOffset + 1) && mouseX <= (double)(this.x + 12 + selectOffset) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 16);
    }

    public boolean isDisabled() {
        return !this.disabled.isEmpty();
    }
}

