/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.AcceptDenyScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.BattleRulesBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.EnumRulesGuiState;
import com.pixelmonmod.pixelmon.client.gui.widgets.ChatExtensionScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.AcceptDeclineBattlePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnumBattleQueryResponse;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.ProposeBattleRulesPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class BattleRulesPlayerScreen
extends BattleRulesBaseScreen {
    private ChatExtensionScreen chat;
    private String opponentName = "";
    private int battleQueryID;
    private EnumRulesGuiState state;
    private Button proposeButton;
    private Button acceptButton;
    private Button changeButton;
    private Button declineButton;
    private int flashCounter;
    private static final int FLASH_DURATION = 30;

    public BattleRulesPlayerScreen(int battleQueryID, boolean isProposing) {
        Player opponentEntity;
        this.battleQueryID = battleQueryID;
        this.state = isProposing ? EnumRulesGuiState.Propose : EnumRulesGuiState.WaitPropose;
        this.chat = new ChatExtensionScreen(this, 20);
        if (AcceptDenyScreen.opponent != null && (opponentEntity = this.f_96541_.f_91073_.m_46003_(AcceptDenyScreen.opponent.opponentUUID)) != null) {
            this.opponentName = opponentEntity.m_5446_().getString();
        }
        this.yChange = -15;
        this.clauseListHeight = 50;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.chat.m_7856_();
        int buttonWidth = 60;
        int id = 0;
        this.proposeButton = new IndexedButton(id++, this.centerX - buttonWidth / 2, this.centerY + 60, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.battlerules.propose"), this::actionPerformed);
        this.acceptButton = new IndexedButton(id++, this.centerX - buttonWidth, this.centerY + 60, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.acceptdeny.accept"), this::actionPerformed);
        this.changeButton = new IndexedButton(id++, this.centerX, this.centerY + 60, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.battlerules.change"), this::actionPerformed);
        this.declineButton = new IndexedButton(id++, this.centerX + 200 - buttonWidth, this.centerY + 60, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.acceptdeny.deny"), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.declineButton);
        this.changeState(this.state);
    }

    public void changeState(EnumRulesGuiState state) {
        this.state = state;
        switch (state) {
            case Propose: {
                this.f_96540_.remove(this.acceptButton);
                this.f_96540_.remove(this.changeButton);
                this.enableButton(this.proposeButton);
                this.editingEnabled = true;
                break;
            }
            case WaitPropose: 
            case WaitChange: 
            case WaitAccept: {
                this.f_96540_.remove(this.proposeButton);
                this.f_96540_.remove(this.acceptButton);
                this.f_96540_.remove(this.changeButton);
                this.editingEnabled = false;
                break;
            }
            case Accept: {
                this.f_96540_.remove(this.proposeButton);
                this.enableButton(this.acceptButton);
                this.enableButton(this.changeButton);
                this.editingEnabled = false;
            }
        }
    }

    private void enableButton(Button button) {
        if (!this.f_96540_.contains(button)) {
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_86600_() {
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(graphics, partialTicks, mouseX, mouseY);
        if (this.state != EnumRulesGuiState.Propose) {
            boolean isWaiting;
            this.dimScreen(graphics);
            String langKey = "";
            int textColor = 0;
            switch (this.state) {
                case WaitAccept: {
                    langKey = "gui.battlerules.waitaccept";
                    break;
                }
                case WaitPropose: {
                    langKey = "gui.battlerules.waitpropose";
                    break;
                }
                case WaitChange: {
                    langKey = "gui.battlerules.waitchange";
                    break;
                }
            }
            int n = this.flashCounter++;
            if ((double)n >= 45.0) {
                this.flashCounter = 0;
            }
            if (!(isWaiting = this.state.isWaiting())) {
                this.highlightButtons(graphics, 80, 35);
            }
            if (this.flashCounter < 30 || !isWaiting) {
                ScreenHelper.drawCenteredString(graphics, I18n.m_118938_((String)langKey, (Object[])new Object[]{this.opponentName}), (float)this.centerX, (float)(this.rectBottom - 30), textColor);
            }
        }
    }

    @Override
    protected int getBackgroundHeight() {
        return 200;
    }

    public void m_280039_(GuiGraphics p_282281_) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        return this.chat.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.m_6050_(mouseX, mouseY, deltaX, deltaY);
        return this.chat.m_6050_(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        super.mouseClickedUnderMenus(x, y, mouseButton);
        this.chat.m_6375_(x, y, mouseButton);
        return true;
    }

    @Override
    protected void actionPerformed(Button button) {
        super.actionPerformed(button);
        if (!button.f_93623_) {
            return;
        }
        if (button == this.proposeButton) {
            this.registerRules();
            NetworkHelper.sendToServer(new ProposeBattleRulesPacket(this.battleQueryID, this.rules));
        } else if (button == this.acceptButton) {
            NetworkHelper.sendToServer(new AcceptDeclineBattlePacket(this.battleQueryID, EnumBattleQueryResponse.Accept));
        } else if (button == this.changeButton) {
            NetworkHelper.sendToServer(new AcceptDeclineBattlePacket(this.battleQueryID, EnumBattleQueryResponse.Change));
        } else if (button == this.declineButton) {
            NetworkHelper.sendToServer(new AcceptDeclineBattlePacket(this.battleQueryID, EnumBattleQueryResponse.Decline));
            ScreenHelper.closeScreen();
        }
    }

    @Override
    public void m_7861_() {
        super.m_7861_();
        this.chat.m_7379_();
    }

    @Override
    public boolean m_7043_() {
        return false;
    }
}

