/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.rules;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleTierRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers.Tier;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.ClauseListScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DescriptiveText;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.OnOffButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TextAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public abstract class BattleRulesBaseScreen
extends DropDownScreen
implements IImportableContainer {
    protected BattleRules rules = new BattleRules();
    private String titleText;
    protected List<EditBox> textFields = new ArrayList<EditBox>();
    private EditBox levelCapField;
    private EditBox numPokemonField;
    private EditBox turnTimeField;
    private EditBox teamSelectTimeField;
    protected boolean editingEnabled = true;
    protected Button importExportButton;
    protected OnOffButton raiseToCapButton;
    protected Button battleTypeButton;
    protected OnOffButton fullHealButton;
    protected OnOffButton teamPreviewButton;
    protected Button[] editButtons;
    protected List<DescriptiveText> ruleLabels;
    protected List<BattleClause> selectedClauses = new ArrayList<BattleClause>();
    private ClauseListScreen allClauseList;
    private ClauseListScreen selectedClauseList;
    protected int centerX;
    protected int centerY;
    protected int rectBottom;
    protected int yChange;
    protected int clauseListHeight = 70;
    protected DropDown<Tier> tierMenu;

    public BattleRulesBaseScreen() {
        super((Component)Component.m_237115_((String)"gui.battlerules.title"));
        this.f_96541_ = Minecraft.m_91087_();
        this.titleText = I18n.m_118938_((String)"gui.battlerules.title", (Object[])new Object[0]);
    }

    @Override
    public void m_7856_() {
        if (!this.textFields.isEmpty()) {
            this.registerRules();
        }
        this.textFields.clear();
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.rectBottom = this.centerY - 120 + this.getBackgroundHeight();
        int textHeight = 20;
        int leftFieldX = this.centerX - 130;
        int centerFieldX = this.centerX - 20;
        int rightFieldX = this.centerX + 120;
        int topY = this.centerY - 76 + this.yChange;
        int yOffset = 25;
        int centerY = topY + yOffset;
        int bottomY = topY + yOffset * 2;
        int numberFieldWidth = 30;
        this.levelCapField = this.createRuleField(leftFieldX, topY, numberFieldWidth, textHeight);
        this.numPokemonField = this.createRuleField(centerFieldX, centerY, numberFieldWidth, textHeight);
        this.turnTimeField = this.createRuleField(rightFieldX, topY, numberFieldWidth, textHeight);
        this.teamSelectTimeField = this.createRuleField(rightFieldX, centerY, numberFieldWidth, textHeight);
        this.textFields.addAll(Arrays.asList(this.levelCapField, this.numPokemonField, this.turnTimeField, this.teamSelectTimeField));
        for (EditBox textField : this.textFields) {
            this.m_142416_((GuiEventListener)textField);
        }
        int onOffButtonWidth = 30;
        int buttonHeight = 20;
        int leftButton = leftFieldX - 1;
        int id = 0;
        this.importExportButton = new IndexedButton(id++, this.centerX + 90, this.centerY - 120, 100, buttonHeight, (Component)Component.m_237115_((String)"gui.pokemoneditor.importexport"), this::actionPerformed);
        this.raiseToCapButton = new OnOffButton(id++, leftButton, centerY, onOffButtonWidth, buttonHeight, this.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.raiseToCapButton);
        this.fullHealButton = new OnOffButton(id++, leftButton, bottomY, onOffButtonWidth, buttonHeight, this.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.fullHealButton);
        this.teamPreviewButton = new OnOffButton(id++, rightFieldX - 1, bottomY, onOffButtonWidth, buttonHeight, this.rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.teamPreviewButton);
        this.battleTypeButton = new IndexedButton(id++, centerFieldX - 1, topY, 40, buttonHeight, (Component)Component.m_237113_((String)this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getLocalizedName()), this::actionPerformed);
        for (Button editButton : this.editButtons = new Button[]{this.importExportButton, this.battleTypeButton, this.raiseToCapButton, this.fullHealButton, this.teamPreviewButton}) {
            this.m_142416_((GuiEventListener)editButton);
        }
        this.ruleLabels = new ArrayList<DescriptiveText>();
        int textOffset = 5;
        int leftTextX = leftFieldX - textOffset;
        int centerTextX = centerFieldX - textOffset;
        int rightTextX = rightFieldX - textOffset;
        int topTextY = topY + textOffset;
        int centerTextY = topTextY + yOffset;
        int bottomTextY = topTextY + yOffset * 2;
        int tierTextX = this.centerX - 62;
        this.ruleLabels.add(this.createRuleLabel("levelcap", leftTextX, topTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("raisetocap", leftTextX, centerTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("fullheal", leftTextX, bottomTextY, TextAlignment.Right));
        this.ruleLabels.add(new DescriptiveText(I18n.m_118938_((String)"gui.trainereditor.battletype", (Object[])new Object[0]), I18n.m_118938_((String)"gui.battlerules.description.battletype", (Object[])new Object[0]), centerTextX, topTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("numpokemon", centerTextX, centerTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("tier", tierTextX, bottomTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("turntime", rightTextX, topTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("teamselecttime", rightTextX, centerTextY, TextAlignment.Right));
        this.ruleLabels.add(this.createRuleLabel("teampreview", rightTextX, bottomTextY, TextAlignment.Right));
        int clauseListWidth = 120;
        int clauseListY = topTextY + yOffset * 2 + 30;
        int clauseListX = centerTextX - clauseListWidth / 2 + 10;
        this.allClauseList = new ClauseListScreen(this, BattleClauseRegistry.getClauseList(), clauseListY, clauseListX, clauseListWidth, this.clauseListHeight);
        this.selectedClauseList = new ClauseListScreen(this, this.selectedClauses, clauseListY, clauseListX + clauseListWidth + 10, clauseListWidth, this.clauseListHeight);
        this.m_142416_((GuiEventListener)this.allClauseList);
        this.m_142416_((GuiEventListener)this.selectedClauseList);
        ArrayList tiers = Lists.newArrayList(BattleTierRegistry.getAllTiers());
        this.tierMenu = new DropDown<Tier>(tiers, this.rules.getOrDefault(BattleRuleRegistry.TIER), tierTextX + 10, bottomTextY, 70, 100);
        this.addDropDown(this.tierMenu);
        this.setRules(this.rules);
    }

    private EditBox createRuleField(int x, int y, int width, int height) {
        return new EditBox(this.getMinecraft().f_91062_, x, y, width, height, (Component)Component.m_237119_());
    }

    private DescriptiveText createRuleLabel(String langKey, int x, int y, TextAlignment align) {
        return new DescriptiveText(I18n.m_118938_((String)("gui.battlerules." + langKey), (Object[])new Object[0]), I18n.m_118938_((String)("gui.battlerules.description." + langKey), (Object[])new Object[0]), x, y, align);
    }

    public void setRules(BattleRules rules) {
        this.rules = rules;
        this.setText(this.levelCapField, this.rules.getOrDefault(BattleRuleRegistry.LEVEL_CAP));
        this.setText(this.numPokemonField, this.rules.getOrDefault(BattleRuleRegistry.NUM_POKEMON));
        this.setBlankableText(this.turnTimeField, this.rules.getOrDefault(BattleRuleRegistry.TURN_TIME));
        this.setBlankableText(this.teamSelectTimeField, this.rules.getOrDefault(BattleRuleRegistry.TEAM_SELECT));
        this.raiseToCapButton.setOn(this.rules.getOrDefault(BattleRuleRegistry.RAISE_TO_CAP));
        this.fullHealButton.setOn(this.rules.getOrDefault(BattleRuleRegistry.FULL_HEAL));
        this.teamPreviewButton.setOn(this.rules.getOrDefault(BattleRuleRegistry.TEAM_PREVIEW));
        this.battleTypeButton.m_93666_((Component)Component.m_237113_((String)this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getLocalizedName()));
        this.selectedClauses.clear();
        this.selectedClauses.addAll(this.rules.getClauseList());
        this.tierMenu.setSelected(this.rules.getOrDefault(BattleRuleRegistry.TIER));
    }

    private void setText(EditBox field, int number) {
        field.m_94144_(Integer.toString(number));
    }

    private void setBlankableText(EditBox field, int number) {
        String fieldText = "";
        if (number > 0) {
            fieldText = Integer.toString(number);
        }
        field.m_94144_(fieldText);
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int textColor = 0;
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, this.centerX - 200, this.centerY - 120, 400.0f, this.getBackgroundHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        for (Button button : this.editButtons) {
            button.f_93623_ = this.editingEnabled;
        }
        this.importExportButton.f_93624_ = this.editingEnabled;
        ScreenHelper.drawCenteredString(graphics, this.titleText, (float)this.centerX, (float)(this.centerY - 90 + this.yChange), textColor);
        if (this.editingEnabled) {
            ScreenHelper.drawCenteredString(graphics, I18n.m_118938_((String)"gui.battlerules.clauses", (Object[])new Object[0]), (float)this.allClauseList.getCenterX(), (float)(this.centerY + this.yChange), textColor);
        }
        ScreenHelper.drawCenteredString(graphics, I18n.m_118938_((String)"gui.battlerules.selectedclauses", (Object[])new Object[0]), (float)this.selectedClauseList.getCenterX(), (float)(this.centerY + this.yChange), textColor);
        String description = "";
        for (DescriptiveText text : this.ruleLabels) {
            text.draw(graphics);
            if (!text.isHovering(mouseX, mouseY)) continue;
            description = text.getDescription();
        }
        ClauseListScreen[] renderLists = this.editingEnabled ? new ClauseListScreen[]{this.allClauseList, this.selectedClauseList} : new ClauseListScreen[]{this.selectedClauseList};
        for (ClauseListScreen list : renderLists) {
            int hoverIndex;
            if (!description.isEmpty() || (hoverIndex = list.getMouseOverIndex(mouseX, mouseY)) <= -1) continue;
            description = list.getElement(hoverIndex).getDescription();
        }
        if (!description.isEmpty()) {
            int descX = this.centerX - 190;
            int descY = this.centerY + 10 + this.yChange;
            int textWidth = 100;
            int boxOffset = 5;
            ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, descX - boxOffset, descY - boxOffset, textWidth + boxOffset * 2, 70.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.65f, 0.65f, 0.65f, 1.0f, 1.0f);
            String finalDescription = description;
            ScreenHelper.drawInUnicode(() -> ScreenHelper.drawSplitString(graphics, finalDescription, descX, descY, textWidth, textColor));
        }
    }

    protected int getBackgroundHeight() {
        return 240;
    }

    public boolean m_5534_(char key, int keyCode) {
        if (this.editingEnabled) {
            for (EditBox textField : this.textFields) {
                textField.m_5534_(key, keyCode);
            }
            ScreenHelper.switchFocus(keyCode, this.textFields);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        if (this.editingEnabled) {
            for (EditBox textField : this.textFields) {
                textField.m_6375_(x, y, mouseButton);
            }
            return true;
        }
        return false;
    }

    protected void actionPerformed(Button button) {
        if (button == this.importExportButton) {
            this.registerRules();
            this.f_96541_.m_91152_((Screen)new ImportExportScreen(this, this.titleText));
        } else if (button == this.battleTypeButton) {
            this.rules.set(BattleRuleRegistry.BATTLE_TYPE, (Object)this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).next());
            this.battleTypeButton.m_93666_((Component)Component.m_237113_((String)this.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getLocalizedName()));
        } else if (button instanceof OnOffButton) {
            ((OnOffButton)button).toggle();
        }
    }

    protected void registerRules() {
        this.rules.set(BattleRuleRegistry.LEVEL_CAP, this.levelCapField.m_94155_()).set(BattleRuleRegistry.RAISE_TO_CAP, this.raiseToCapButton.isOn()).set(BattleRuleRegistry.NUM_POKEMON, this.numPokemonField.m_94155_()).set(BattleRuleRegistry.TURN_TIME, this.turnTimeField.m_94155_()).set(BattleRuleRegistry.TEAM_SELECT, this.teamSelectTimeField.m_94155_()).set(BattleRuleRegistry.FULL_HEAL, this.fullHealButton.isOn()).set(BattleRuleRegistry.TEAM_PREVIEW, this.teamPreviewButton.isOn());
        this.rules.setNewClauses(this.selectedClauses);
        this.rules.set(BattleRuleRegistry.TIER, this.tierMenu.getSelected());
        this.setRules(this.rules);
    }

    private int parseBlankableText(String text) {
        if (text.trim().isEmpty()) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    @Override
    public String getExportText() {
        return this.rules.exportText();
    }

    @Override
    public String importText(String importText) {
        String result = this.rules.importText(importText);
        this.setRules(this.rules);
        return result;
    }

    public void m_7861_() {
        super.m_7861_();
    }

    void clauseListSelected(List<BattleClause> clauses, int index) {
        if (!this.editingEnabled) {
            return;
        }
        BattleClause clause = clauses.get(index);
        if (this.selectedClauses.contains(clause)) {
            this.selectedClauses.remove(clause);
        } else {
            this.selectedClauses.add(clause);
            Collections.sort(this.selectedClauses);
        }
    }

    boolean isClauseSelected(List<BattleClause> clauses, int index) {
        if (clauses == this.selectedClauses) {
            return false;
        }
        return this.selectedClauses.contains(clauses.get(index));
    }

    protected void dimScreen(GuiGraphics graphics) {
        graphics.m_280509_(this.centerX - 200, this.centerY - 120, this.centerX + 200, this.rectBottom, 0x5F000000);
    }

    protected void highlightButtons(GuiGraphics graphics, int highlightOffsetX, int bottomOffset) {
        graphics.m_280509_(this.centerX - highlightOffsetX, this.rectBottom - bottomOffset, this.centerX + highlightOffsetX, this.rectBottom - bottomOffset + 35, -1);
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    protected boolean disableMenus() {
        return !this.editingEnabled;
    }
}

