/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OpponentElement;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class RaidElement
extends OpponentElement {
    private static final ResourceLocation OPPONENT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/opponent.png");
    private static final ResourceLocation HEALTHY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_healthy.png");
    private static final ResourceLocation CAUTION = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_caution.png");
    private static final ResourceLocation WARNING = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_warning.png");
    private static final ResourceLocation SHINY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/shiny.png");
    private static final ResourceLocation STAR = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/star.png");
    private static final ResourceLocation CAUGHT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/caught.png");
    private static final ResourceLocation TARGET = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/target_up.png");
    private static final ResourceLocation RAID = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/raid.png");
    private static final ResourceLocation BARRIER = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/barrier.png");
    private final Screen parent;
    private final PixelmonClientData enemy;
    private final ScreenParticleEngine particleEngine;

    public RaidElement(PixelmonClientData enemy, Screen parent, ScreenParticleEngine particleEngine) {
        super(enemy, parent, particleEngine);
        this.parent = parent;
        this.enemy = enemy;
        this.particleEngine = particleEngine;
    }

    @Override
    public PixelmonClientData getEnemy() {
        return this.enemy;
    }

    @Override
    public void drawSelected(GuiGraphics graphics, int x, int y, int width, int height, float scale) {
        PoseStack matrix = graphics.m_280168_();
        this.setPosition(x, y, width, height);
        matrix.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.m_85841_(scale, scale, scale);
        ScreenHelper.drawImage(graphics, TARGET, (float)(x + 105), (float)(y + 75), 40.0f, 16.5f, this.zLevel);
        matrix.m_85849_();
        this.setPosition((int)((float)x * scale), (int)((float)y * scale), (int)((float)width * scale), (int)((float)height * scale));
    }

    @Override
    public void drawElement(GuiGraphics graphics, float scale) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        ScreenHelper.drawImage(graphics, RAID, (float)this.x, (float)(this.y - 3), 250.0f, 70.0f, this.zLevel);
        float healthPercent = (float)(this.enemy.health.get() / (double)this.enemy.maxHealth);
        ScreenHelper.drawBar(graphics, this.x + 6, this.y + 45, 244.0, 11.5, healthPercent, this.enemy.getHealthColor());
        if (this.enemy.status != -1 && StatusType.getEffect(this.enemy.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos(StatusType.getEffect(this.enemy.status));
            ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, this.x + 222, this.y + 12, 20.0f, 20.0f, texturePair2[0] / 768.0f, texturePair2[1] / 768.0f, (texturePair2[0] + 240.0f) / 768.0f, (texturePair2[1] + 240.0f) / 768.0f, this.zLevel);
        }
        float offset = 0.0f;
        if (this.enemy.shields > 0) {
            offset = 6.0f;
            for (int i = 0; i < this.enemy.maxShields; ++i) {
                float r;
                float g;
                float b;
                if (this.enemy.shields <= i) {
                    b = 0.4f;
                    g = 0.4f;
                    r = 0.4f;
                    if (this.enemy.lostShield) {
                        this.enemy.lostShield = false;
                        float diffScale = 1.0f - scale;
                        float oX = 22.0f * diffScale * 0.5f;
                        float oY = 7.0f * diffScale * 0.5f;
                        SoundHelper.playSound(SoundEvents.f_12346_, 0.25f, 0.8f + RandomHelper.getRandom().nextFloat() * 0.4f);
                        this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle("", BARRIER, ((float)(this.x + 128 + 18 * i) - (float)(18 * this.enemy.maxShields) / 2.0f - 2.0f) * scale - oX, ((double)this.y + 30.5) * (double)scale - (double)oY, 2.0, 0.0, 0.0, 0.0, 0.843f, 0.0314f, 0.478f, 0.0f, 22.0f, 7.0f, 40, (particle, PoseStack2) -> {
                            particle.a = 1.0f - (float)particle.age / (float)particle.maxAge;
                            float growth = 0.5f * scale;
                            float yMult = 0.5f;
                            particle.x -= (double)growth;
                            particle.w += growth * 2.0f;
                            particle.y -= (double)(growth * yMult);
                            particle.h += growth * 2.0f * yMult;
                        }));
                    }
                } else {
                    r = 0.843f;
                    g = 0.0314f;
                    b = 0.478f;
                }
                ScreenHelper.drawImage(graphics, BARRIER, (float)(this.x + 128 + 18 * i) - (float)(18 * this.enemy.maxShields) / 2.0f - 2.0f, (float)this.y + 30.5f, 22.0f, 7.0f, r, g, b, 1.0f, 1.0f);
            }
        } else if (this.enemy.lostShield) {
            this.enemy.lostShield = false;
            SoundHelper.playSound(SoundEvents.f_12347_, 0.8f, 0.8f + RandomHelper.getRandom().nextFloat() * 0.4f);
        }
        if (this.enemy.getGender() != Gender.NONE) {
            ScreenHelper.drawImage(graphics, this.enemy.getGender() == Gender.MALE ? Resources.male : Resources.female, (float)(this.x + 8), (float)(this.y + 13), 10.0f, 16.0f, this.zLevel);
        }
        ScreenHelper.drawScaledCenteredString(graphics, this.enemy.getDisplayName(), this.x + 128, (float)this.y + 14.0f - offset, this.enemy.palette.equalsIgnoreCase("shiny") ? -7545 : -986896, 34.0f);
        if (PixelmonConfigProxy.getGraphics().isAdvancedBattleInformation()) {
            DecimalFormat df = new DecimalFormat(".#");
            String percentage = df.format((double)healthPercent * 100.0).replace(".0", "");
            if (percentage.isEmpty()) {
                percentage = "0";
            }
            ScreenHelper.drawScaledCenteredString(graphics, percentage + "%", this.x + 128, (float)this.y + 46.0f, -986896, 20.0f);
        }
        if (this.enemy.palette.equalsIgnoreCase("shiny") && RandomHelper.getRandom().nextInt(80) == 0) {
            int size = 7 + RandomHelper.getRandom().nextInt(7);
            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle("", SHINY, (float)this.parent.f_96543_ / 2.0f + (float)RandomHelper.getRandom().nextInt(80) - 40.0f, (double)this.parent.f_96544_ * 0.04 + (double)RandomHelper.getRandom().nextInt(16) - 10.0, 1.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, (particle, PoseStack2) -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
    }
}

