/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.AllyElement;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OpponentElement;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayBase;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.RaidElement;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class OverlayNew
extends OverlayBase {
    private static final ResourceLocation ACTIVE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_active.png");
    private final List<OpponentElement> opponents = Lists.newLinkedList();
    private final List<AllyElement> allies = Lists.newLinkedList();
    private final List<AllyElement> our = Lists.newLinkedList();
    private PixelmonClientData current = this.bm.getCurrentPokemon();

    public OverlayNew(BattleScreen parent) {
        super(parent);
    }

    @Override
    public void render(GuiGraphics graphics, int width, int height, int guiWidth, int guiHeight) {
        try {
            this.bm.processBattleTasks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.bm.displayedOurPokemon == null || this.bm.displayedOurPokemon.length == 0) {
            return;
        }
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableBlend();
        this.generateElements();
        if (this.bm.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID && this.opponents.size() == 1) {
            float scaleOpponents = 1.0f;
            if ((float)this.parent.f_96543_ < 700.0f) {
                scaleOpponents = 1.0f / new BigDecimal(700.0f / (float)this.parent.f_96543_).setScale(2, RoundingMode.HALF_UP).floatValue();
            }
            OpponentElement opponent = this.opponents.get(0);
            int yPos = opponent.getEnemy().xPos;
            float center = (float)this.parent.f_96543_ / 2.0f;
            float offset = 125.0f * scaleOpponents;
            if (this.parent.showTargeting() && this.parent.isTargeted(opponent.getEnemy().pokemonUUID)) {
                opponent.drawSelected(graphics, (int)((center - offset) * (1.0f / scaleOpponents)), yPos, 250, 70, scaleOpponents);
            }
            opponent.drawElementScaled(graphics, (int)((center - offset) * (1.0f / scaleOpponents)), yPos, 250, 70, scaleOpponents, 0, this, this.particleEngine);
        } else {
            float wo = this.parent.f_96543_;
            float scaleOpponents = 1.0f;
            if (wo < (float)(180 * this.bm.displayedEnemyPokemon.length)) {
                scaleOpponents = 1.0f / new BigDecimal(180.0f * (float)this.bm.displayedEnemyPokemon.length / wo).setScale(2, RoundingMode.HALF_UP).floatValue();
            }
            for (int i = 0; i < this.opponents.size(); ++i) {
                OpponentElement opponent = this.opponents.get(i);
                int yPos = opponent.getEnemy().xPos;
                if (this.parent.showTargeting() && this.parent.isTargeted(opponent.getEnemy().pokemonUUID)) {
                    opponent.drawSelected(graphics, 180 * i, yPos, 160, 50, scaleOpponents);
                }
                opponent.drawElementScaled(graphics, 180 * i, yPos, 160, 50, scaleOpponents, i, this, this.particleEngine);
            }
        }
        PixelmonClientData pig = this.current;
        if (pig == null) {
            if (this.bm.isSpectating) {
                pig = this.bm.displayedOurPokemon[0];
            } else {
                return;
            }
        }
        float wa = this.parent.f_96543_;
        float scaleAllies = 1.0f;
        if (wa < (float)(190 * this.our.size())) {
            scaleAllies = 1.0f / new BigDecimal(190.0f * (float)this.our.size() / wa).setScale(2, RoundingMode.HALF_UP).floatValue();
        }
        for (int i = 0; i < this.our.size(); ++i) {
            AllyElement our = this.our.get(i);
            int yPos = our.getAlly().xPos;
            if (this.parent.showTargeting() && this.parent.isTargeted(our.getAlly().pokemonUUID)) {
                our.drawSelected(graphics, this.parent.f_96543_ + 25 - 190 * (i + 1), this.parent.f_96544_ - 6 - yPos, 160, 40, scaleAllies);
            }
            our.drawElementScaled(graphics, this.parent.f_96543_ + 25 - 190 * (i + 1), this.parent.f_96544_ - 6 - yPos, 160, 40, scaleAllies, i, this, this.particleEngine);
        }
        this.particleEngine.draw(graphics, "");
    }

    @Override
    public int mouseOverEnemyPokemon(int guiWidth, int guiHeight, double mouseX, double mouseY) {
        for (int i = 0; i < this.opponents.size(); ++i) {
            OpponentElement opponent = this.opponents.get(i);
            if (!opponent.isMouseOver(mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int mouseOverUserPokemon(int width, int height, int guiWidth, int guiHeight, double mouseX, double mouseY) {
        int i = 0;
        for (AllyElement ally : this.allies) {
            if (ally.isMouseOver(mouseX, mouseY)) {
                return Lists.newArrayList((Object[])this.bm.teamPokemon).indexOf(ally.getAlly().pokemonUUID);
            }
            ++i;
        }
        i = 0;
        for (AllyElement ally : this.our) {
            if (ally.isMouseOver(mouseX, mouseY)) {
                return Lists.newArrayList((Object[])this.bm.teamPokemon).indexOf(ally.getAlly().pokemonUUID);
            }
            ++i;
        }
        return -1;
    }

    private void generateElements() {
        PixelmonClientData ally;
        if (this.bm.getCurrentPokemon() != null) {
            this.current = this.bm.getCurrentPokemon();
        }
        this.opponents.clear();
        if (this.bm.displayedEnemyPokemon != null) {
            for (int i = 0; i < this.bm.displayedEnemyPokemon.length; ++i) {
                PixelmonClientData enemy = this.bm.displayedEnemyPokemon[i];
                if (this.bm.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.RAID) {
                    this.opponents.add(new RaidElement(enemy, this, this.particleEngine));
                    continue;
                }
                this.opponents.add(new OpponentElement(enemy, this, this.particleEngine));
            }
        }
        this.our.clear();
        this.allies.clear();
        HashSet<UUID> added = new HashSet<UUID>();
        if (this.bm.displayedOurPokemon != null) {
            for (int i = 0; i < this.bm.displayedOurPokemon.length; ++i) {
                ally = this.bm.displayedOurPokemon[i];
                if (added.contains(ally.pokemonUUID)) continue;
                this.our.add(new AllyElement(ally, this, this.particleEngine));
                added.add(ally.pokemonUUID);
            }
        }
        if (this.bm.displayedAllyPokemon != null) {
            for (int i = 0; i < this.bm.displayedAllyPokemon.length; ++i) {
                ally = this.bm.displayedAllyPokemon[i];
                if (added.contains(ally.pokemonUUID)) continue;
                this.our.add(new AllyElement(ally, this, this.particleEngine));
                added.add(ally.pokemonUUID);
            }
        }
        this.our.sort(Comparator.comparingInt(a -> -a.getAlly().position));
    }
}

