/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.widgets.PixelmonWidget;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class OpponentElement
extends PixelmonWidget {
    private static final ResourceLocation OPPONENT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/opponent.png");
    private static final ResourceLocation HEALTHY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_healthy.png");
    private static final ResourceLocation CAUTION = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_caution.png");
    private static final ResourceLocation WARNING = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_warning.png");
    private static final ResourceLocation SHINY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/shiny.png");
    private static final ResourceLocation CAUGHT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/caught.png");
    private static final ResourceLocation TARGET = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/target_up.png");
    private final Screen parent;
    private final PixelmonClientData enemy;
    private final ScreenParticleEngine particleEngine;

    public OpponentElement(PixelmonClientData enemy, Screen parent, ScreenParticleEngine particleEngine) {
        this.parent = parent;
        this.enemy = enemy;
        this.particleEngine = particleEngine;
    }

    public PixelmonClientData getEnemy() {
        return this.enemy;
    }

    public void drawSelected(GuiGraphics graphics, int x, int y, int width, int height, float scale) {
        this.setPosition(x, y, width, height);
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.m_85841_(scale, scale, scale);
        ScreenHelper.drawImage(graphics, TARGET, (float)x + 6.5f, (float)(y + 45), 26.666666f, 11.0f, this.zLevel);
        matrix.m_85849_();
        this.setPosition((int)((float)x * scale), (int)((float)y * scale), (int)((float)width * scale), (int)((float)height * scale));
    }

    @Override
    public void drawElement(GuiGraphics graphics, float scale) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        ScreenHelper.drawImage(graphics, OPPONENT, (float)this.x, (float)(this.y - 3), 160.0f, 50.0f, this.zLevel);
        float healthPercent = (float)(this.enemy.health.get() / (double)this.enemy.maxHealth);
        ScreenHelper.drawBar(graphics, this.x + 44, this.y + 20, 109.0, 10.0, healthPercent, this.enemy.getHealthColor());
        ScreenHelper.drawImage(healthPercent <= 0.5f ? (healthPercent <= 0.25f ? WARNING : CAUTION) : HEALTHY, graphics, (float)(this.x - 10), (float)(this.y - 18), 60.0f, 60.0f, this.zLevel);
        ScreenHelper.drawImage(ScreenHelper.getPokemonSprite(this.enemy, this.parent.getMinecraft()), graphics, (float)(this.x + 1), (float)(this.y - 3), 40.0f, 40.0f, this.zLevel);
        this.particleEngine.drawAtOffset(graphics, this.enemy.pokemonUUID.toString(), this.x + 5, this.y + 1, RandomHelper.getRandom().nextInt(26), RandomHelper.getRandom().nextInt(26));
        float offset = 0.0f;
        if (ClientStorageManager.pokedex.hasCaught(this.enemy.species)) {
            ScreenHelper.drawImage(graphics, CAUGHT, (float)(this.x + 52), (float)(this.y + 5), 8.0f, 8.0f, this.zLevel);
            offset += 9.0f;
        }
        if (this.enemy.getGender() != Gender.NONE) {
            ScreenHelper.drawImage(this.enemy.getGender() == Gender.MALE ? Resources.male : Resources.female, graphics, (float)(this.x + 52) + offset, (float)(this.y + 5), 5.0f, 8.0f, this.zLevel);
            offset += 7.0f;
        }
        ScreenHelper.drawScaledString(graphics, this.enemy.getDisplayName(), (float)(this.x + 52) + offset, (float)this.y + 5.75f, this.enemy.palette.equalsIgnoreCase("shiny") ? -7545 : -986896, 16.0f);
        ScreenHelper.drawScaledStringRightAligned(graphics, "Lv." + this.enemy.level, this.x + 149, (float)this.y + 7.0f, -986896, false, 12.0f);
        if (PixelmonConfigProxy.getGraphics().isAdvancedBattleInformation()) {
            DecimalFormat df = new DecimalFormat(".#");
            String percentage = df.format((double)healthPercent * 100.0).replace(".0", "");
            if (percentage.isEmpty()) {
                percentage = "0";
            }
            ScreenHelper.drawScaledStringRightAligned(graphics, percentage + "%", this.x + 145, (float)this.y + 22.0f, -986896, false, 14.0f);
        }
        if (this.enemy.status != -1 && StatusType.getEffect(this.enemy.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos(StatusType.getEffect(this.enemy.status));
            ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)(this.x + 54 + ScreenHelper.getStringWidth(this.enemy.getDisplayName())) + offset, this.y + 4, 10.5f, 10.5f, texturePair2[0] / 768.0f, texturePair2[1] / 768.0f, (texturePair2[0] + 240.0f) / 768.0f, (texturePair2[1] + 240.0f) / 768.0f, this.zLevel);
        }
        if (ClientProxy.battleManager.catchCombo != 0) {
            ScreenHelper.drawScaledString(graphics, I18n.m_118938_((String)"gui.battle.catch_combo", (Object[])new Object[]{ClientProxy.battleManager.catchCombo}), (float)(this.x + 22) + offset, (float)this.y + 38.75f, -986896, 12.0f);
        }
        if (this.enemy.palette.equalsIgnoreCase("shiny") && RandomHelper.getRandom().nextInt(80) == 0) {
            int size = 7 + RandomHelper.getRandom().nextInt(7);
            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(this.enemy.pokemonUUID.toString(), SHINY, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, (particle, PoseStack2) -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
    }
}

