/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.widgets.PixelmonWidget;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class AllyElement
extends PixelmonWidget {
    private static final ResourceLocation ALLY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/ally.png");
    private static final ResourceLocation RAID = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/raid.png");
    private static final ResourceLocation BARRIER = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/barrier.png");
    private static final ResourceLocation SHINY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/shiny.png");
    private static final ResourceLocation HEALTHY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_healthy.png");
    private static final ResourceLocation CAUTION = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_caution.png");
    private static final ResourceLocation WARNING = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_warning.png");
    private static final ResourceLocation TARGET = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/target_down.png");
    private final PixelmonClientData ally;
    private final Screen parent;
    private final ScreenParticleEngine particleEngine;

    public AllyElement(PixelmonClientData ally, Screen parent, ScreenParticleEngine particleEngine) {
        this.ally = ally;
        this.parent = parent;
        this.particleEngine = particleEngine;
    }

    public PixelmonClientData getAlly() {
        return this.ally;
    }

    public void drawSelected(GuiGraphics graphics, int x, int y, int width, int height, float scale) {
        PoseStack matrix = graphics.m_280168_();
        this.setPosition(x, y, width, height);
        matrix.m_85836_();
        double tX = this.parent.f_96543_;
        double tY = (float)(y + height) + 2.0f / scale;
        matrix.m_85837_(tX, tY, 0.0);
        matrix.m_85841_(scale, scale, scale);
        matrix.m_85837_(-tX, -tY, 0.0);
        ScreenHelper.drawImage(graphics, TARGET, (float)x + 131.5f, (float)(y - 16), 26.666666f, 11.0f, this.zLevel);
        matrix.m_85849_();
        this.setPosition((int)((float)x * scale), (int)((float)y * scale), (int)((float)width * scale), (int)((float)height * scale));
    }

    @Override
    public void drawElement(GuiGraphics graphics, float scale) {
        PoseStack matrix = graphics.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        ScreenHelper.drawImage(graphics, ALLY, (float)this.x, (float)(this.y + 5), 160.0f, 50.0f, this.zLevel);
        float healthPercent = (float)(this.ally.health.get() / (double)this.ally.maxHealth);
        ScreenHelper.drawBar(graphics, this.x + 13, this.y + 28, 109.0, 7.0, healthPercent, this.ally.getHealthColor(), true);
        float barWidth = this.ally.level < PixelmonServerConfig.maxLevel ? this.ally.expFraction : 1.0f;
        ScreenHelper.drawBar(graphics, this.x + 13, this.y + 36, 111.0, 2.0, barWidth, new Color(69, 215, 255), true);
        ScreenHelper.drawImage(graphics, healthPercent <= 0.5f ? (healthPercent <= 0.25f ? WARNING : CAUTION) : HEALTHY, (float)(this.x + 115), (float)(this.y - 2), 60.0f, 60.0f, this.zLevel);
        ScreenHelper.drawImage(graphics, ScreenHelper.getPokemonSprite(this.ally, Minecraft.m_91087_()), (float)(this.x + 125), (float)(this.y + 2), 40.0f, 40.0f, this.zLevel);
        this.particleEngine.drawAtOffset(graphics, this.ally.pokemonUUID.toString(), this.x + 130, this.y + 7, RandomHelper.getRandom().nextInt(26), RandomHelper.getRandom().nextInt(26));
        float offset = 0.0f;
        if (this.ally.getGender() != Gender.NONE) {
            ScreenHelper.drawImage(graphics, this.ally.getGender() == Gender.MALE ? Resources.male : Resources.female, (float)(this.x + 12), (float)this.y + 13.5f, 5.0f, 8.0f, this.zLevel);
            offset += 7.0f;
        }
        ScreenHelper.drawScaledString(graphics, this.ally.getDisplayName(), (float)(this.x + 12) + offset, (float)this.y + 14.0f, this.ally.palette.equalsIgnoreCase("shiny") ? -7545 : -986896, 16.0f);
        ScreenHelper.drawScaledStringRightAligned(graphics, "Lv." + this.ally.level, this.x + 114, (float)this.y + 15.0f, -986896, false, 12.0f);
        if (PixelmonConfigProxy.getGraphics().isAdvancedBattleInformation()) {
            ScreenHelper.drawScaledString(graphics, (int)this.ally.health.get() + "/" + this.ally.maxHealth, this.x + 15, (float)this.y + 29.0f, -986896, 11.0f);
        }
        if (this.ally.status != -1 && StatusType.getEffect(this.ally.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos(StatusType.getEffect(this.ally.status));
            ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)(this.x + 12 + ScreenHelper.getStringWidth(this.ally.getDisplayName())) + offset + 2.0f, (float)this.y + 12.5f, 10.5f, 10.5f, texturePair2[0] / 768.0f, texturePair2[1] / 768.0f, (texturePair2[0] + 240.0f) / 768.0f, (texturePair2[1] + 240.0f) / 768.0f, this.zLevel);
        }
        if (this.ally.palette.equalsIgnoreCase("shiny") && RandomHelper.getRandom().nextInt(80) == 0) {
            int size = 7 + RandomHelper.getRandom().nextInt(7);
            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(this.ally.pokemonUUID.toString(), SHINY, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, (particle, PoseStack2) -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
    }
}

