/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoDialogue;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class YesNoReplaceMove
extends YesNoDialogue {
    public YesNoReplaceMove(BattleScreen parent) {
        super(parent, BattleMode.YES_NO_REPLACE_MOVE);
    }

    @Override
    protected void drawConfirmText(GuiGraphics graphics, int width, int height) {
        Attack newAttack;
        if (this.bm.newAttackList.isEmpty()) {
            this.parent.restoreSettingsAndClose();
            this.bm.setMode(this.bm.getOldMode());
            return;
        }
        Pokemon pokemonToLearnAttack = ClientStorageManager.party.find(this.bm.newAttackList.get((int)0).pokemonUUID);
        try {
            newAttack = this.bm.newAttackList.get((int)0).attack;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.warn("User is clicking too fast.");
            Pixelmon.LOGGER.warn("New attack list is " + e.getMessage());
            this.bm.setMode(this.bm.getOldMode());
            return;
        }
        float textAreaWidth = 170.0f;
        if (this.bm.selectedAttack == -1) {
            String attackName = newAttack.getActualMove().getLocalizedName();
            String text = I18n.m_118938_((String)"gui.yesno.yousure", (Object[])new Object[]{attackName});
            float textWidth = this.f_96541_.f_91062_.m_92895_(text);
            int numLines = (int)(textWidth / textAreaWidth) + 1;
            ScreenHelper.drawSplitString(graphics, text, width / 2 - 109, height / 2 + 1 - numLines * 10 / 2, (int)textAreaWidth, 0);
            ScreenHelper.drawSplitString(graphics, text, width / 2 - 110, height / 2 - numLines * 10 / 2, (int)textAreaWidth, 0xFFFFFF);
        } else {
            if (pokemonToLearnAttack == null) {
                return;
            }
            String text = I18n.m_118938_((String)"gui.yesno.replace", (Object[])new Object[]{pokemonToLearnAttack.getMoveset().get(this.bm.selectedAttack).getMove().getLocalizedName(), newAttack.getMove().getLocalizedName()});
            float textWidth = this.f_96541_.f_91062_.m_92895_(text);
            int numLines = (int)(textWidth / textAreaWidth) + 1;
            ScreenHelper.drawSplitString(graphics, text, width / 2 - 109, height / 2 + 1 - numLines * 10 / 2, (int)textAreaWidth, 0);
            ScreenHelper.drawSplitString(graphics, text, width / 2 - 110, height / 2 - numLines * 10 / 2, (int)textAreaWidth, 0xFFFFFF);
        }
    }

    @Override
    protected void confirm() {
        if (this.bm.newAttackList.isEmpty()) {
            this.closeBattleScreen();
            return;
        }
        this.bm.newAttackList.remove(0);
        if (this.bm.sendPacket != null) {
            NetworkHelper.sendToServer(this.bm.sendPacket);
        }
        if (this.bm.battleControllerIndex != -1) {
            if (this.bm.hasNewAttacks() || this.bm.hasLevelUps()) {
                this.bm.setMode(this.bm.yesNoOrigin);
            } else {
                if (this.bm.battleEnded) {
                    this.closeBattleScreen();
                    return;
                }
                this.bm.setMode(BattleMode.MAIN_MENU);
                this.bm.checkClearedMessages();
            }
        } else if (this.bm.hasNewAttacks() || this.bm.hasLevelUps()) {
            this.bm.setMode(this.bm.yesNoOrigin);
        } else {
            this.closeBattleScreen();
            return;
        }
    }

    private void closeBattleScreen() {
        this.parent.restoreSettingsAndClose();
        this.bm.setMode(this.bm.getOldMode());
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, int vOffset) {
    }
}

