/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleMenuElement;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.PokemonMenuButton;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ItemMenuButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BagPacket;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class ApplyToPokemon
extends BattleScreen {
    private BattleMenuElement<ItemMenuButton> bagMenu;
    private BattleMenuElement<PokemonMenuButton> pokeMenu;

    public ApplyToPokemon(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void render(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, float partialTicks) {
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        PoseStack matrix = graphics.m_280168_();
        this.renderBackground(graphics, width, height, mouseX, mouseY, 0);
        this.drawButtons(graphics, mouseX, mouseY, partialTicks);
        this.parent.battleLog.drawElement(graphics, 40, height - 80, Math.min(this.f_96543_ - 80, 260), 80, false);
        AtomicInteger index = new AtomicInteger();
        List<ItemData> bag = this.bm.getBagItems(this.bm.bagSection);
        List items = bag.stream().map(it -> new ItemMenuButton(index.getAndIncrement(), it.getItemStack(), this)).collect(Collectors.toList());
        this.bagMenu = new BattleMenuElement(this, (Component)Component.m_237113_((String)this.bm.bagSection.getLocalizedName()), items);
        this.bagMenu.setPosition(0, this.f_96544_ - 240, 180, 240);
        this.bagMenu.drawElement(graphics, 1.0f);
        ScreenHelper.drawGradientRect(graphics, 0, 0, 0.0f, this.f_96543_, this.f_96544_, 0x70000000, 0x70000000);
        index.set(0);
        List pigs = this.bm.fullOurPokemon.stream().map(it -> new PokemonMenuButton(index.getAndIncrement(), (PixelmonClientData)it, this)).collect(Collectors.toList());
        this.pokeMenu = new BattleMenuElement(this, (Component)Component.m_237115_((String)"gui.choosepokemon.select"), pigs);
        this.pokeMenu.setPosition(180, this.f_96544_ - 240, 180, 240);
        this.pokeMenu.drawElement(graphics, 1.0f);
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.bm.isHealing) {
            return;
        }
        if (this.pokeMenu.isMouseOver(mouseX, mouseY)) {
            if (this.pokeMenu.isOverReturnButton(mouseX, mouseY)) {
                this.bm.setMode(BattleMode.CHOOSE_BAG);
            } else if (!this.pokeMenu.handleClickPageTurn(mouseX, mouseY)) {
                List<PokemonMenuButton> buttons = this.pokeMenu.getPageButtons();
                for (PokemonMenuButton button : buttons) {
                    if (!button.m_6375_(mouseX, mouseY, 0)) continue;
                    PixelmonClientData pokemonToApplyTo = null;
                    PixelmonClientData chosenPokemon = button.getPig();
                    Item item = this.bm.itemToUse.getItemStack().m_41720_();
                    if (chosenPokemon != null) {
                        if (item == PixelmonItems.revive.m_5456_() || item == PixelmonItems.max_revive.m_5456_() || item == PixelmonItems.revival_herb.m_5456_()) {
                            if (chosenPokemon.health.get() <= 0.0) {
                                pokemonToApplyTo = chosenPokemon;
                            }
                        } else if (chosenPokemon.health.get() > 0.0) {
                            pokemonToApplyTo = chosenPokemon;
                        }
                    }
                    if (pokemonToApplyTo == null) continue;
                    if (item == PixelmonItems.ether || item == PixelmonItems.max_ether || item == PixelmonItems.leppa_berry) {
                        this.bm.setMode(BattleMode.CHOOSE_ETHER);
                        continue;
                    }
                    this.bm.selectedActions.add(new BagPacket(this.bm.getCurrentPokemon().pokemonUUID, pokemonToApplyTo.pokemonUUID, this.bm.itemToUse.getItemStack(), this.bm.battleControllerIndex));
                    this.bm.selectedMove();
                }
            }
        }
    }
}

