/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUpPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class LevelUpScreen
extends BattleScreen {
    private EnumLevelStage drawLevelStage = EnumLevelStage.First;

    public LevelUpScreen(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.drawLevelStage = EnumLevelStage.First;
    }

    @Override
    public void render(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, float partialTicks) {
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        if (this.bm.battleType == BattleType.RAID) {
            try {
                this.bm.processBattleTasks();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.bm.battleControllerIndex != -1) {
            this.renderBackground(graphics, width, height, mouseX, mouseY, 0);
            this.drawButtons(graphics, mouseX, mouseY, partialTicks);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (ClientProxy.camera != null) {
            this.parent.bm.setCameraToPlayer();
        }
        ScreenHelper.drawImageQuad(Resources.levelUpPopup, graphics, (float)width / 2.0f - 52.0f, (float)height / 2.0f - 66.0f, 104.0f, 113.0f, 0.0f, 0.0f, 0.40625f, 0.44140625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        if (!this.bm.levelUpList.isEmpty()) {
            graphics.m_280488_(mc.f_91062_, I18n.m_118938_((String)"nbt.hp2", (Object[])new Object[0]), width / 2 - 43, height / 2 - 54, 0xFFFFFF);
            graphics.m_280488_(mc.f_91062_, I18n.m_118938_((String)"nbt.attack2", (Object[])new Object[0]), width / 2 - 43, height / 2 - 38, 0xFFFFFF);
            graphics.m_280488_(mc.f_91062_, I18n.m_118938_((String)"nbt.defense2", (Object[])new Object[0]), width / 2 - 43, height / 2 - 22, 0xFFFFFF);
            graphics.m_280488_(mc.f_91062_, I18n.m_118938_((String)"nbt.spattack2", (Object[])new Object[0]), width / 2 - 43, height / 2 - 6, 0xFFFFFF);
            graphics.m_280488_(mc.f_91062_, I18n.m_118938_((String)"nbt.spdefense2", (Object[])new Object[0]), width / 2 - 43, height / 2 + 10, 0xFFFFFF);
            graphics.m_280488_(mc.f_91062_, I18n.m_118938_((String)"nbt.speed2", (Object[])new Object[0]), width / 2 - 43, height / 2 + 26, 0xFFFFFF);
            LevelUpPacket levelUp = this.bm.levelUpList.get(0);
            if (this.drawLevelStage == EnumLevelStage.First) {
                graphics.m_280488_(mc.f_91062_, "+" + (levelUp.statsLevel2.HP - levelUp.statsLevel1.HP), width / 2 + 25, height / 2 - 54, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "+" + (levelUp.statsLevel2.Attack - levelUp.statsLevel1.Attack), width / 2 + 25, height / 2 - 38, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "+" + (levelUp.statsLevel2.Defense - levelUp.statsLevel1.Defense), width / 2 + 25, height / 2 - 22, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "+" + (levelUp.statsLevel2.SpecialAttack - levelUp.statsLevel1.SpecialAttack), width / 2 + 25, height / 2 - 6, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "+" + (levelUp.statsLevel2.SpecialDefense - levelUp.statsLevel1.SpecialDefense), width / 2 + 25, height / 2 + 10, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "+" + (levelUp.statsLevel2.Speed - levelUp.statsLevel1.Speed), width / 2 + 25, height / 2 + 26, 0xFFFFFF);
            } else if (this.drawLevelStage == EnumLevelStage.Second) {
                PixelmonStatsData stats = levelUp.statsLevel2;
                graphics.m_280488_(mc.f_91062_, "" + stats.HP, stats.HP < 100 ? width / 2 + 28 : width / 2 + 22, height / 2 - 54, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "" + stats.Attack, stats.Attack < 100 ? width / 2 + 28 : width / 2 + 22, height / 2 - 38, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "" + stats.Defense, stats.Defense < 100 ? width / 2 + 28 : width / 2 + 22, height / 2 - 22, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "" + stats.SpecialAttack, stats.SpecialAttack < 100 ? width / 2 + 28 : width / 2 + 22, height / 2 - 6, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "" + stats.SpecialDefense, stats.SpecialDefense < 100 ? width / 2 + 28 : width / 2 + 22, height / 2 + 10, 0xFFFFFF);
                graphics.m_280488_(mc.f_91062_, "" + stats.Speed, stats.Speed < 100 ? width / 2 + 28 : width / 2 + 22, height / 2 + 26, 0xFFFFFF);
            }
            UUID uuid = levelUp.pokemonUUID;
            if (this.bm != null) {
                PixelmonClientData pig = this.bm.getPokemon(uuid);
                if (pig != null) {
                    String name = pig.getDisplayName();
                    if (this.bm.battleControllerIndex != -1) {
                        this.parent.battleLog.setActiveMessage(I18n.m_118938_((String)"gui.levelupscreen.lvlup", (Object[])new Object[]{name, levelUp.level}));
                        try {
                            this.parent.battleLog.drawElement(graphics, 40, height - 80, Math.min(this.f_96543_ - 80, 260), 80, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.parent.restoreSettingsAndClose();
                }
            } else {
                this.parent.restoreSettingsAndClose();
            }
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, int vOffset) {
    }

    public void m_86600_() {
        this.parent.battleLog.m_7673_();
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.parent.battleLog.processUpDown(mouseX, mouseY)) {
            return;
        }
        if (this.parent.battleLog.withinBounds(mouseX, mouseY) && this.parent.bm.hasMoreMessages()) {
            this.parent.battleLog.acknowledge();
        } else if (this.drawLevelStage == EnumLevelStage.First) {
            this.drawLevelStage = EnumLevelStage.Second;
        } else {
            try {
                LevelUpPacket levelUp = this.bm.levelUpList.remove(0);
                String name = this.bm.getPokemon(levelUp.pokemonUUID).getDisplayName();
                this.parent.battleLog.forceAddMessage(I18n.m_118938_((String)"gui.levelupscreen.lvlup", (Object[])new Object[]{name, levelUp.level}));
            }
            catch (Exception e) {
                this.bm.setMode(this.bm.getOldMode());
                this.bm.checkClearedMessages();
                return;
            }
            if (this.bm.hasLevelUps()) {
                this.drawLevelStage = EnumLevelStage.First;
            } else if (this.bm.battleControllerIndex == -1 && !this.bm.hasNewAttacks()) {
                this.parent.restoreSettingsAndClose();
            } else {
                this.bm.setMode(this.bm.getOldMode());
                this.bm.checkClearedMessages();
            }
        }
    }

    @Override
    public boolean isScreen() {
        return super.isScreen() && this.bm.hasLevelUps();
    }

    public static enum EnumLevelStage {
        First,
        Second,
        Third;

    }
}

