/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.old_gui.choosePokemon;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleBaseScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemonPacket;
import com.pixelmonmod.pixelmon.items.ReviveItem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.Item;

public class ChoosePokemon
extends BattleBaseScreen {
    PixelmonClientData selected = null;
    protected PixelmonClientData[] inBattle = new PixelmonClientData[6];
    protected PixelmonClientData[] inParty = new PixelmonClientData[6];
    protected String backText = "";

    public ChoosePokemon(BattleScreen parent) {
        super(parent, BattleMode.CHOOSE_POKEMON);
    }

    public ChoosePokemon(BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void render(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, float partialTicks) {
        Item item;
        this.fillParty();
        ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 128.0f, height - 203, 256.0f, 203.0f, 0.0f, 0.0f, 1.0f, 0.79296875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        if (this.bm.getMode() == BattleMode.APPLY_TO_POKEMON) {
            ScreenHelper.drawCenteredString(graphics, this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.choosepokemon.select", (Object[])new Object[0]), (float)(width / 2 - 40), (float)(height - 23), 0xFFFFFF);
        } else if (this.bm.getMode() == BattleMode.CHOOSE_RELEARN_MOVE || this.bm.getMode() == BattleMode.CHOOSE_TUTOR) {
            ScreenHelper.drawCenteredString(graphics, this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.selectpokemon.message", (Object[])new Object[0]), (float)(width / 2 - 40), (float)(height - 23), 0xFFFFFF);
        } else {
            ScreenHelper.drawCenteredString(graphics, this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.choosepokemon.sendout", (Object[])new Object[0]), (float)(width / 2 - 40), (float)(height - 23), 0xFFFFFF);
        }
        this.backText = this.getBackText();
        if (!"".equals(this.backText)) {
            if (mouseX > width / 2 + 63 && mouseX < width / 2 + 63 + 48 && mouseY > height - 27 && mouseY < height - 27 + 17 && !this.bm.isHealing) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 63.0f, height - 27, 48.0f, 17.0f, 0.7734375f, 0.8203125f, 0.9609375f, 0.88671875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            ScreenHelper.drawCenteredString(graphics, this.f_96541_.f_91062_, I18n.m_118938_((String)this.backText, (Object[])new Object[0]), (float)(width / 2 + 87), (float)(height - 22), 0xFFFFFF);
        }
        PixelmonClientData p = this.inBattle[0] != null ? this.inBattle[0] : this.inParty[0];
        Item item2 = item = this.bm.itemToUse != null ? this.bm.itemToUse.getItemStack().m_41720_() : null;
        if (p != null) {
            ScreenHelper.drawImageQuad(ScreenHelper.getPokemonSprite(p, this.f_96541_), graphics, (float)width / 2.0f - 121.0f, height - 179, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            BattleScreen.drawHealthBar(graphics, width / 2 - 85, height - 135, 56, 9, (float)p.health.get(), p.maxHealth);
            ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 95.0f, height - 135, 61.0f, 9.0f, 0.3359375f, 0.9375f, 0.57421875f, 0.97265625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawCenteredString(graphics, this.f_96541_.f_91062_, (int)p.health.get() + "/" + p.maxHealth, (float)(width / 2 - 59), (float)(height - 123), 0xFFFFFF);
            String name = p.getDisplayName();
            ScreenHelper.drawString(graphics, this.f_96541_.f_91062_, name, (float)(width / 2 - 90), (float)(height - 161), 0xFFFFFF);
            ScreenHelper.drawString(graphics, this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + p.level, (float)(width / 2 - 90), (float)(height - 148), 0xFFFFFF);
            float[] texturePair = p.getStatusTexturePos();
            if (texturePair[0] != -1.0f) {
                ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)width / 2.0f - 117.0f, height - 145, 20.0f, 20.0f, texturePair[0] / 768.0f, texturePair[1] / 768.0f, (texturePair[0] + 240.0f) / 768.0f, (texturePair[1] + 240.0f) / 768.0f, 0.0f);
            }
            if (p.getGender() == Gender.MALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 90.0f + (float)this.f_96541_.f_91062_.m_92895_(name), height - 161, 6.0f, 9.0f, 0.125f, 0.8125f, 0.1484375f, 0.84765625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else if (p.getGender() == Gender.FEMALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 90.0f + (float)this.f_96541_.f_91062_.m_92895_(name), height - 161, 6.0f, 9.0f, 0.125f, 0.8515625f, 0.1484375f, 0.88671875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (this.bm.getMode() == BattleMode.APPLY_TO_POKEMON && !this.bm.isHealing && mouseX > width / 2 - 120 && mouseX < width / 2 - 21 && mouseY > height - 165 && mouseY < height - 113) {
                boolean valid = false;
                if (item instanceof ReviveItem) {
                    if (p.health.get() <= 0.0) {
                        valid = true;
                    }
                } else if (p.health.get() > 0.0) {
                    valid = true;
                }
                if (valid) {
                    ScreenHelper.drawImageQuad(Resources.selectCurrentPokemon, graphics, (float)width / 2.0f - 120.0f, height - 165, 89.0f, 52.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
        }
        int inBattleIndex = 1;
        int inPartyIndex = this.inBattle[0] == null ? 1 : 0;
        for (int i = 0; i < 5; ++i) {
            PixelmonClientData pData = this.inBattle[inBattleIndex] != null ? this.inBattle[inBattleIndex++] : this.inParty[inPartyIndex++];
            int pos = i;
            if (pData == null) continue;
            ScreenHelper.drawImageQuad(ScreenHelper.getPokemonSprite(pData, this.f_96541_), graphics, (float)width / 2.0f - 23.0f, height - 192 + pos * 30, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            BattleScreen.drawHealthBar(graphics, width / 2 + 65, height - 192 + pos * 30, 56, 9, (float)pData.health.get(), pData.maxHealth);
            ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 55.0f, height - 192 + pos * 30, 61.0f, 9.0f, 0.3359375f, 0.9375f, 0.57421875f, 0.97265625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawString(graphics, this.f_96541_.f_91062_, (int)pData.health.get() + "/" + pData.maxHealth, (float)(width / 2 + 75), (float)(height - 180 + pos * 30), 0xFFFFFF);
            ScreenHelper.drawString(graphics, this.f_96541_.f_91062_, pData.getDisplayName(), (float)(width / 2 + 5), (float)(height - 190 + pos * 30), 0xFFFFFF);
            ScreenHelper.drawString(graphics, this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + pData.level, (float)(width / 2 + 5), (float)(height - 176 + pos * 30), 0xFFFFFF);
            float[] texturePair = pData.getStatusTexturePos();
            if (texturePair[0] != -1.0f) {
                ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)width / 2.0f + 50.0f, height - 177 + pos * 26, 14.0f, 14.0f, texturePair[0] / 768.0f, texturePair[1] / 768.0f, (texturePair[0] + 240.0f) / 768.0f, (texturePair[1] + 240.0f) / 768.0f, 0.0f);
            }
            if (pData.getGender() == Gender.MALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 40.0f, height - 176 + pos * 30, 6.0f, 9.0f, 0.125f, 0.8125f, 0.1484375f, 0.84765625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else if (pData.getGender() == Gender.FEMALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 40.0f, height - 176 + pos * 30, 6.0f, 9.0f, 0.125f, 0.8515625f, 0.1484375f, 0.88671875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            int xPos = width / 2 - 30;
            int yPos = height - 195 + pos * 30;
            boolean isCurrent = false;
            if (Arrays.asList(this.inBattle).contains(pData)) {
                isCurrent = true;
            }
            if ((!isCurrent || this.bm.getMode() != BattleMode.APPLY_TO_POKEMON) && isCurrent || mouseX <= xPos || mouseX >= xPos + 150 || mouseY <= yPos + 1 || mouseY >= yPos + 31 || this.bm.isHealing) continue;
            boolean valid = false;
            if (this.bm.getMode() == BattleMode.APPLY_TO_POKEMON && item instanceof ReviveItem) {
                if (pData.health.get() <= 0.0) {
                    valid = true;
                }
            } else if (pData.health.get() > 0.0 && pData != this.selected) {
                valid = true;
            }
            if (!valid) continue;
            ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, xPos, yPos, 150.0f, 32.0f, 0.16796875f, 0.80078125f, 0.7578125f, 0.92578125f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, int vOffset) {
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (mouseX > (double)((float)width / 2.0f + 63.0f) && mouseX < (double)((float)width / 2.0f + 63.0f + 48.0f) && mouseY > (double)(height - 27) && mouseY < (double)(height - 27 + 17)) {
            this.clickBackButton();
        }
        if (this.bm.getMode() == BattleMode.MAIN_MENU) {
            return;
        }
        int inBattleIndex = 1;
        int inPartyIndex = 0;
        for (int i = 0; i < 5; ++i) {
            PixelmonClientData pData;
            if (this.inBattle[inBattleIndex] != null) {
                pData = this.inBattle[inBattleIndex++];
            } else if (this.inParty[inPartyIndex] != null) {
                pData = this.inParty[inPartyIndex++];
            } else {
                return;
            }
            if (pData == null) continue;
            int xpos = width / 2 - 30;
            int ypos = height - 195 + i * 30;
            if (!(mouseX > (double)xpos) || !(mouseX < (double)(xpos + 150)) || !(mouseY > (double)(ypos + 1)) || !(mouseY < (double)(ypos + 31))) continue;
            boolean canSelect = true;
            if (Arrays.asList(this.inBattle).contains(pData)) {
                canSelect = false;
            }
            if (pData == this.selected) {
                if (this.bm.selectedActions.isEmpty()) {
                    this.selected = null;
                } else {
                    canSelect = false;
                }
            }
            if (!canSelect) continue;
            this.selected = pData;
            if (!(pData.health.get() > 0.0)) continue;
            this.addSwitch(pData.pokemonUUID);
            this.selectedMove();
            return;
        }
    }

    protected void selectedMove() {
        this.bm.selectedMove();
    }

    public PixelmonClientData choosePokemonSlot(int width, int height, double mouseX, double mouseY) {
        if (mouseX > (double)((float)width / 2.0f + 63.0f) && mouseX < (double)((float)width / 2.0f + 63.0f + 48.0f) && mouseY > (double)(height - 27) && mouseY < (double)(height - 27 + 17)) {
            Minecraft.m_91087_().f_91074_.m_6915_();
            return null;
        }
        PixelmonClientData[] party = this.getParty();
        if (mouseX > (double)((float)width / 2.0f - 120.0f) && mouseX < (double)((float)width / 2.0f - 21.0f) && mouseY > (double)(height - 165) && mouseY < (double)(height - 113)) {
            if (party[0] != null) {
                return party[0];
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                PixelmonClientData pokemon = party[i + 1];
                if (pokemon == null) continue;
                int xpos = width / 2 - 30;
                int ypos = height - 195 + i * 30;
                if (!(mouseX > (double)xpos) || !(mouseX < (double)(xpos + 150)) || !(mouseY > (double)(ypos + 1)) || !(mouseY < (double)(ypos + 31))) continue;
                return pokemon;
            }
        }
        return null;
    }

    protected PixelmonClientData[] getParty() {
        PixelmonClientData[] party = new PixelmonClientData[6];
        int arrayIndex = 0;
        for (PixelmonClientData data : this.inBattle) {
            if (data == null) break;
            if (arrayIndex >= 6) continue;
            party[arrayIndex++] = data;
        }
        for (PixelmonClientData data : this.inParty) {
            if (arrayIndex >= 6) continue;
            party[arrayIndex++] = data;
        }
        return party;
    }

    protected void fillParty() {
        this.inBattle = new PixelmonClientData[6];
        this.inParty = new PixelmonClientData[6];
        if (this.bm.teamPokemon != null) {
            int i = 0;
            for (UUID uuid : this.bm.teamPokemon) {
                Optional<PixelmonClientData> pixelmon = this.bm.fullOurPokemon.stream().filter(p -> p.pokemonUUID.equals(uuid)).findFirst();
                if (!pixelmon.isPresent()) continue;
                this.inBattle[i++] = pixelmon.get();
            }
        }
        List<PixelmonClientData> inBattleList = Arrays.asList(this.inBattle);
        int i = 0;
        for (PixelmonClientData d : this.bm.fullOurPokemon) {
            if (inBattleList.contains(d)) continue;
            this.inParty[i++] = d;
        }
    }

    protected String getBackText() {
        return "gui.battle.back";
    }

    protected void clickBackButton() {
        this.bm.setMode(BattleMode.MAIN_MENU);
    }

    protected void addSwitch(UUID newPokemonUUID) {
        this.bm.selectedActions.add(new SwitchPokemonPacket(newPokemonUUID, this.bm.battleControllerIndex, this.bm.getCurrentPokemon().pokemonUUID, false));
    }
}

