/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ChooseAttackPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetStrugglePacket;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class ChooseAttack
extends BattleScreen {
    private static boolean evoButtonHovered = false;
    private EvoButton evoButton;

    public ChooseAttack(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.evoButton = new EvoButton(99);
        this.m_142416_((GuiEventListener)new MoveButton(this, 0));
        this.m_142416_((GuiEventListener)new MoveButton(this, 1));
        this.m_142416_((GuiEventListener)new MoveButton(this, 2));
        this.m_142416_((GuiEventListener)new MoveButton(this, 3));
        this.m_142416_((GuiEventListener)this.evoButton);
    }

    @Override
    public void render(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, float partialTicks) {
        PixelmonClientData data = this.bm.getCurrentPokemon();
        if (data != null && data.health.get() <= 0.0) {
            this.bm.selectedMove();
            return;
        }
        int areaForMoves = this.f_96543_ - 40 - 80 - 8;
        int bwidth = Math.min(areaForMoves - 10, 300) / 2;
        boolean hovering = false;
        PixelmonClientData pixelmon = this.bm.getCurrentPokemon();
        for (Renderable button2 : this.f_169369_) {
            Button move;
            if (button2 instanceof MoveButton) {
                move = (MoveButton)button2;
                if (pixelmon == null) {
                    ((MoveButton)button2).f_93624_ = false;
                    continue;
                }
                Moveset moveset = pixelmon.moveset;
                if (moveset.stream().noneMatch(attack -> attack != null && (!attack.getDisabled() || this.bm.dynamaxing || this.bm.dynamaxTurnsLeft > 0) && attack.pp > 0)) {
                    if (move.id == 0) {
                        ((MoveButton)button2).f_93624_ = true;
                        ((MoveButton)button2).struggle();
                        this.parent.setTargeting(pixelmon, move.getAttack(), -1, -1);
                    } else {
                        ((MoveButton)button2).f_93624_ = false;
                    }
                } else if (moveset.size() >= move.id + 1) {
                    move.setupAttack(this.bm, pixelmon);
                    move.f_93624_ = true;
                    if (move.m_5953_((double)mouseX, (double)mouseY)) {
                        this.drawAttackInfo(move.attack);
                        if (move.f_93624_ && move.f_93623_ && move.attack != null) {
                            this.parent.setTargeting(pixelmon, move.getAttack(), -1, -1);
                            hovering = true;
                        }
                    }
                } else {
                    move.f_93624_ = false;
                }
                move.f_93620_ = move.id % 2 == 0 ? this.detailsStart - bwidth * 2 - 8 : this.detailsStart - bwidth - 4;
                move.f_93621_ = move.id < 2 ? this.f_96544_ - 70 - 6 : this.f_96544_ - 35 - 3;
                move.m_93674_(bwidth);
                move.m_293384_(34);
            }
            if (!(button2 instanceof EvoButton)) continue;
            move = (EvoButton)button2;
            int badgeWidth = 40;
            move.f_93620_ = this.detailsStart - bwidth - 6 - badgeWidth / 2;
            move.f_93621_ = this.f_96544_ - 35 - 3 - badgeWidth / 2;
            if (move.m_5953_((double)mouseX, (double)mouseY) && move.f_93624_ && move.f_93623_ && move.pressable) {
                hovering = true;
                continue;
            }
            if (!move.m_5953_((double)mouseX, (double)mouseY) || !move.f_93624_ || !move.f_93623_) continue;
            hovering = true;
        }
        if (pixelmon != null && this.f_96540_.stream().filter(it -> it instanceof MoveButton).noneMatch(button -> button.m_5953_((double)mouseX, (double)mouseY))) {
            this.parent.setTargeting(pixelmon, pixelmon.moveset.stream().filter(Objects::nonNull).findFirst().get(), -1, -1);
        }
        ScreenHelper.drawBattleCursor(hovering, mouseX, mouseY, 3.0f);
        this.renderBackground(graphics, width, height, mouseX, mouseY, 0);
        this.drawButtons(graphics, mouseX, mouseY, partialTicks);
        this.chatArea = this.f_96543_ - 40 - 80 - bwidth * 2 - 10;
        if (this.chatArea > 160) {
            try {
                if (data != null) {
                    this.parent.battleLog.setActiveMessage(I18n.m_118938_((String)"gui.mainmenu.whatdo", (Object[])new Object[]{data.nickname}));
                }
                this.parent.battleLog.drawElement(graphics, 50, height - 80, Math.min(this.chatArea, 260), 80, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, int vOffset) {
        super.renderBackground(graphics, width, height, mouseX, mouseY, vOffset);
    }

    private void drawAttackInfo(Attack attack) {
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.handleButtonClick(mouseX, mouseY)) {
            return;
        }
        if (this.parent.battleLog.processUpDown(mouseX, mouseY)) {
            return;
        }
        PixelmonClientData pixelmon = this.bm.getCurrentPokemon();
        if (this.evoButton.m_6375_(mouseX, mouseY, 0)) {
            if (this.bm.megaEvolving || this.bm.dynamaxing) {
                this.bm.dynamaxing = false;
                this.bm.megaEvolving = false;
            } else {
                if (this.bm.oldGen.isYes()) {
                    if (this.bm.canMegaEvolve(pixelmon)) {
                        this.bm.megaEvolving = true;
                        SoundHelper.playSound(SoundEvents.f_11874_);
                    } else if (this.bm.canUltraBurst(pixelmon)) {
                        this.bm.megaEvolving = true;
                        SoundHelper.playSound(SoundEvents.f_11874_);
                    } else if (this.bm.canUseZMove(pixelmon)) {
                        boolean bl = this.bm.showZMoves = !this.bm.showZMoves;
                        if (this.bm.showZMoves) {
                            SoundHelper.playSound(SoundEvents.f_11942_);
                        }
                    }
                }
                if (this.bm.oldGen.isNo() && this.bm.canDynamax(pixelmon)) {
                    this.bm.dynamaxing = true;
                    SoundHelper.playSound(SoundEvents.f_11669_);
                }
            }
            return;
        }
        for (Renderable b : this.f_169369_) {
            if (pixelmon == null) {
                return;
            }
            if (!(b instanceof MoveButton)) continue;
            MoveButton button = (MoveButton)b;
            if (button.getAttack() == null) {
                return;
            }
            if (!button.m_6375_(mouseX, mouseY, 0)) continue;
            if (button.id == 0 && button.getAttack().isAttack(AttackRegistry.STRUGGLE) && pixelmon.moveset.stream().noneMatch(attack -> attack != null && (!attack.getDisabled() || (button.willDynamax || button.isDynamaxed) && !button.holdingAssaultVest) && attack.pp > 0)) {
                this.bm.selectedActions.add(new SetStrugglePacket(this.bm.getCurrentPokemon().pokemonUUID, this.bm.targetted, this.bm.battleControllerIndex));
                this.bm.selectedMove();
                return;
            }
            if (this.bm.showZMoves && button.getAttack().getMove().getZMove(pixelmon, false) == null) continue;
            if (this.parent.canSelectTarget(button.getAttack())) {
                this.bm.selectedAttack = button.id;
                this.bm.setMode(BattleMode.CHOOSE_TARGETS);
            } else {
                this.parent.setTargeting(pixelmon, button.getAttack(), -1, -1);
                this.bm.selectedAttack = button.id + (this.bm.showZMoves ? 4 : 0);
                this.bm.selectedActions.add(new ChooseAttackPacket(pixelmon.pokemonUUID, this.bm.targetted, this.bm.selectedAttack, this.bm.battleControllerIndex, this.bm.megaEvolving, this.bm.dynamaxing));
                this.bm.selectedMove();
            }
            return;
        }
    }

    public static class EvoButton
    extends Button {
        public static final ResourceLocation MAIN_BADGE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge.png");
        public static final ResourceLocation BLANK_BADGE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_blank_badge.png");
        public static final ResourceLocation MEGA_BADGE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge_mega_hollow.png");
        public static final ResourceLocation DYNA_BADGE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge_dynamax_hollow.png");
        public static final ResourceLocation ZMOVE_BADGE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge_zmove_hollow.png");
        public static final ResourceLocation MEGA_BADGE_GREYSCALE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge_mega_grey.png");
        public static final ResourceLocation DYNA_BADGE_GREYSCALE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge_dynamax_grey.png");
        public static final ResourceLocation ZMOVE_BADGE_GREYSCALE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_badge_zmove_grey.png");
        public boolean hovered = false;
        private boolean isPressed;
        private int hoverTimer = 0;
        private int timer = 0;
        private final ClientBattleManager bm = ClientProxy.battleManager;
        public boolean pressable = false;

        public EvoButton(int index) {
            super(0, 0, 40, 40, (Component)Component.m_237119_(), action -> {}, p_253695_ -> Component.m_237119_());
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            PoseStack matrix = graphics.m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            int r = this.f_93618_;
            int centerX = this.f_93620_ + this.f_93618_ / 2;
            int centerY = this.f_93621_ + this.f_93619_ / 2;
            evoButtonHovered = this.hovered = Math.sqrt((mouseX - centerX) * (mouseX - centerX) + (mouseY - centerY) * (mouseY - centerY)) < (double)((float)r / 2.0f);
            int range = 250;
            if (this.f_93624_) {
                ResourceLocation texture;
                PixelmonClientData pixelmon = this.bm.getCurrentPokemon();
                if (pixelmon == null) {
                    return;
                }
                boolean canPokemonMegaEvolve = this.bm.canMegaEvolve(pixelmon);
                boolean canPokemonUltraBurst = this.bm.canUltraBurst(pixelmon);
                boolean canPokemonZMove = this.bm.canUseZMove(pixelmon);
                boolean canPokemonDynamax = this.bm.canDynamax(pixelmon);
                boolean canMegaEvolve = this.bm.oldGen.isYes() && canPokemonMegaEvolve;
                boolean canUltraBurst = this.bm.oldGen.isYes() && canPokemonUltraBurst;
                boolean canZMove = this.bm.oldGen.isYes() && canPokemonZMove;
                boolean canDynamax = this.bm.oldGen.isNo() && canPokemonDynamax;
                boolean isMegaEvolving = canMegaEvolve && this.bm.megaEvolving;
                boolean isUltraBursting = canUltraBurst && this.bm.megaEvolving;
                boolean isUsingZMove = canZMove && this.bm.showZMoves;
                boolean isDynamaxing = canDynamax && this.bm.dynamaxing;
                int mode = 0;
                boolean disabled = false;
                if (canPokemonMegaEvolve) {
                    if (canMegaEvolve) {
                        texture = MEGA_BADGE;
                        if (isMegaEvolving) {
                            mode = 2;
                        } else if (this.hoverTimer > 0) {
                            mode = 1;
                        }
                        this.pressable = this.hovered;
                    } else {
                        disabled = true;
                        texture = MEGA_BADGE_GREYSCALE;
                    }
                } else if (canPokemonUltraBurst) {
                    if (canUltraBurst) {
                        texture = MEGA_BADGE;
                        if (isUltraBursting) {
                            mode = 2;
                        } else if (this.hoverTimer > 0) {
                            mode = 1;
                        }
                        this.pressable = this.hovered;
                    } else {
                        disabled = true;
                        texture = MEGA_BADGE_GREYSCALE;
                    }
                } else if (canPokemonZMove) {
                    if (canZMove) {
                        texture = ZMOVE_BADGE;
                        if (isUsingZMove) {
                            mode = 2;
                        } else if (this.hoverTimer > 0) {
                            mode = 1;
                        }
                        this.pressable = this.hovered;
                    } else {
                        disabled = true;
                        texture = ZMOVE_BADGE_GREYSCALE;
                    }
                } else if (canPokemonDynamax) {
                    if (canDynamax) {
                        texture = DYNA_BADGE;
                        if (isDynamaxing) {
                            mode = 2;
                        } else if (this.hoverTimer > 0) {
                            mode = 1;
                        }
                        this.pressable = this.hovered;
                    } else {
                        disabled = true;
                        texture = DYNA_BADGE_GREYSCALE;
                    }
                } else {
                    texture = MAIN_BADGE;
                }
                if (disabled && this.hovered && mc.f_91080_ != null) {
                    int mod = this.hoverTimer % range;
                    int value = mod >= range / 2 ? range - 1 - mod : mod;
                    float dif = Math.min(1.0f, (float)value * 0.005f + 0.3f);
                    graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.mainmenu.disabled"), this.f_93620_ + this.f_93618_ / 2, this.f_93621_ - 40, new Color(1.0f, 1.0f - dif, 1.0f - dif, 1.0f).getRGB());
                } else {
                    float[] rgb = new float[]{1.0f, 1.0f, 1.0f};
                    if (mode == 1) {
                        int mod = this.hoverTimer % range;
                        int value = mod >= range / 2 ? range - 1 - mod : mod;
                        float dif = (float)value * 0.0025f;
                        rgb[0] = 1.0f - dif;
                        rgb[1] = 1.0f - dif;
                        rgb[2] = 1.0f - dif;
                    } else if (mode != 0) {
                        this.hoverTimer = 0;
                        Color color = new Color(Color.HSBtoRGB((float)(this.timer % 400) / 400.0f, 0.8f, 0.9f));
                        rgb[0] = (float)color.getRed() / 255.0f;
                        rgb[1] = (float)color.getGreen() / 255.0f;
                        rgb[2] = (float)color.getBlue() / 255.0f;
                    }
                    ScreenHelper.drawImage(graphics, BLANK_BADGE, (float)this.f_93620_, (float)this.f_93621_, (float)this.f_93618_, (float)this.f_93619_, rgb[0], rgb[1], rgb[2], 1.0f, 0.0f);
                }
                ScreenHelper.drawImage(graphics, texture, (float)this.f_93620_, (float)this.f_93621_, (float)this.f_93618_, (float)this.f_93619_, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else {
                ScreenHelper.drawImage(graphics, MAIN_BADGE, (float)this.f_93620_, (float)this.f_93621_, (float)this.f_93618_, (float)this.f_93619_, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            this.hoverTimer = this.hovered ? ++this.hoverTimer : (this.hoverTimer % range != 0 ? ++this.hoverTimer : 0);
            ++this.timer;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.isPressed = super.m_6375_(mouseX, mouseY, button);
            return this.isPressed;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isPressed = false;
            return true;
        }
    }

    public static class MoveButton
    extends Button {
        private static final ResourceLocation MOVE_LEFT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_left.png");
        private static final ResourceLocation MOVE_RIGHT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/moveselection_right.png");
        private static final Color COLOR = new Color(13, 143, 214);
        private static final Color DARKCOLOR = new Color(7, 68, 101);
        private Attack attack;
        private String moveName;
        private int displayedPower;
        private boolean isPressed;
        private int hoverTimer = 0;
        private int timer = 0;
        private boolean willDynamax = false;
        private boolean isDynamaxed = false;
        private boolean holdingAssaultVest = false;
        public boolean hovered = false;
        public int id;
        private ChooseAttack parent;

        public MoveButton(ChooseAttack parent, int index) {
            super(0, 0, 0, 0, (Component)Component.m_237119_(), action -> {}, button -> Component.m_237119_());
            this.id = index;
            this.parent = parent;
            this.f_93624_ = false;
        }

        public Attack getAttack() {
            return this.attack;
        }

        public void struggle() {
            this.attack = new Attack(AttackRegistry.STRUGGLE);
            this.moveName = this.attack.getMove().getLocalizedName();
        }

        public void setupAttack(ClientBattleManager bm, PixelmonClientData pig) {
            Moveset moveset = pig.moveset;
            this.attack = moveset.get(this.id);
            this.setWillDynamax(bm);
            this.setIsDynamaxed(bm);
            this.setHoldingAssaultVest(pig);
            boolean isAlreadyDynamaxed = pig.pokemonUUID.equals(bm.dynamax);
            if (bm.showZMoves) {
                ZMove zMove = this.attack.getMove().getZMove(pig, false);
                this.moveName = zMove != null ? zMove.getLocalizedName() : this.attack.getMove().getLocalizedName();
            } else if (bm.dynamaxing || isAlreadyDynamaxed) {
                Attack maxMove = pig.gmaxFactor ? (isAlreadyDynamaxed ? MaxMoveConverter.getGMaxMoveFromAttack(this.attack, null, pig.species, pig.species.getForm(pig.prevForm)) : MaxMoveConverter.getGMaxMoveFromAttack(this.attack, null, pig.species, pig.species.getForm(pig.form))) : MaxMoveConverter.getMaxMoveFromAttack(this.attack, null);
                this.moveName = maxMove.getMove().getLocalizedName();
                this.displayedPower = maxMove.overridePower;
            } else {
                this.moveName = this.attack.getMove().getLocalizedName();
                this.displayedPower = this.attack.getMove().getBasePower();
            }
        }

        public void setWillDynamax(ClientBattleManager bm) {
            this.willDynamax = bm.dynamaxing;
        }

        public void setIsDynamaxed(ClientBattleManager bm) {
            this.isDynamaxed = bm.dynamaxTurnsLeft > 0;
        }

        public void setHoldingAssaultVest(PixelmonClientData pig) {
            this.holdingAssaultVest = pig.heldItem.getHeldItemType() == EnumHeldItems.assaultVest;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            PoseStack matrix = graphics.m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            this.hovered = !evoButtonHovered && mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            int range = 180;
            if (this.f_93624_ && this.attack != null) {
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.enableBlend();
                boolean struggle = this.attack.isAttack(AttackRegistry.STRUGGLE);
                boolean zMove = this.attack.getMove().getZMove(this.parent.bm.getCurrentPokemon(), false) != null;
                float[] rgb = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                if (!(this.attack.pp > 0 && (!this.attack.getDisabled() || (this.willDynamax || this.isDynamaxed) && !this.holdingAssaultVest || zMove && this.parent.bm.showZMoves || struggle))) {
                    rgb = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
                } else if (this.hoverTimer > 0) {
                    int mod = this.hoverTimer % range;
                    int value = range - (mod >= range / 2 ? range - 1 - mod : mod);
                    float dif = Math.min(1.0f, (float)value / (float)range);
                    rgb = new float[]{0.5f + 0.5f * dif, 0.8f + 0.2f * dif, 0.5f + 0.5f * dif, 1.0f};
                }
                boolean isLeft = this.id % 2 == 0;
                ScreenHelper.drawImage(isLeft ? MOVE_LEFT : MOVE_RIGHT, graphics, (float)this.f_93620_, (float)this.f_93621_, (float)this.f_93618_, (float)this.f_93619_, rgb[0], rgb[1], rgb[2], rgb[3], 0.0f);
                ScreenHelper.drawScaledCenteredSplitString(graphics, this.moveName, (float)this.f_93620_ + (float)this.f_93618_ / 2.0f, this.f_93621_ + 9, 0, 16.0f, this.f_93618_ - 4, false);
                if (!struggle) {
                    ScreenHelper.drawBar(graphics, this.f_93620_, this.f_93621_ + 26, this.f_93618_ + 6, 8.0, (float)this.attack.pp / (float)this.attack.getMaxPP(), this.attack.pp > 0 && (!this.attack.getDisabled() || (this.willDynamax || this.isDynamaxed) && !this.holdingAssaultVest) || zMove && this.parent.bm.showZMoves ? COLOR : DARKCOLOR);
                    ScreenHelper.drawScaledCenteredString(graphics, this.attack.pp + "/" + this.attack.getMaxPP(), (float)this.f_93620_ + (float)this.f_93618_ / 2.0f, (float)this.f_93621_ + 27.5f, this.attack.pp > 0 && (!this.attack.getDisabled() || (this.willDynamax || this.isDynamaxed) && !this.holdingAssaultVest) || zMove && this.parent.bm.showZMoves ? 0xF0F0F0 : 0xC0C0C0, 12.0f);
                    Element type = this.moveName.equalsIgnoreCase("Max Guard") ? Element.NORMAL : this.attack.getType();
                    float x = type.textureX;
                    float y = type.textureY;
                    ScreenHelper.drawImageQuadUV(Resources.types, graphics, isLeft ? (float)(this.f_93620_ + 6) : (float)(this.f_93620_ + this.f_93618_ - 22), (float)this.f_93621_ + (float)this.f_93619_ / 2.0f - 12.0f, 16.0f, 16.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                } else {
                    ScreenHelper.drawBar(graphics, this.f_93620_, this.f_93621_ + 26, this.f_93618_ + 6, 8.0, 1.0f, COLOR);
                    ScreenHelper.drawImageQuad(Resources.infinity, graphics, (float)this.f_93620_ + (float)this.f_93618_ / 2.0f - 6.0f, (float)this.f_93621_ + 23.75f, 12.0f, 12.0f, 0.0f, 0.0f, 1.0f, 1.0f, rgb[0], rgb[1], rgb[2], rgb[3], 0.0f);
                }
                boolean showGlobalInfo = false;
                boolean showAttackInfo = false;
                if (mc.f_91080_ != null && this.id == 0) {
                    showGlobalInfo = true;
                    for (Renderable button : this.parent.f_169369_) {
                        if (!(button instanceof MoveButton)) continue;
                        MoveButton mb = (MoveButton)button;
                        if (!mb.hovered) continue;
                        showGlobalInfo = false;
                        break;
                    }
                    this.parent.parent.showGlobalInfo = showGlobalInfo;
                }
                if (this.hovered) {
                    ++this.hoverTimer;
                    showAttackInfo = true;
                    showGlobalInfo = false;
                } else {
                    this.hoverTimer = this.hoverTimer % range != 0 ? ++this.hoverTimer : 0;
                }
                if (mc.f_91080_ != null && showAttackInfo) {
                    int w = mc.f_91080_.f_96543_;
                    int h = mc.f_91080_.f_96544_;
                    int accuracy = this.attack.getMove().getAccuracy();
                    if (accuracy < 0) {
                        accuracy = 100;
                    }
                    ScreenHelper.drawCenteredSquashedString(graphics, this.moveName, false, 75.0, w - 40, h - 76, 0xFFFFFF, false);
                    ScreenHelper.drawScaledCenteredSplitString(graphics, this.attack.getAttackCategory().getLocalizedName(), w - 40, h - 35, 0xFFFFFF, 16.0f, 100, false);
                    ScreenHelper.drawScaledCenteredSplitString(graphics, I18n.m_118938_((String)"gui.battle.powerval", (Object[])new Object[]{this.displayedPower}), w - 40, h - 24, 0xFFFFFF, 16.0f, 100, false);
                    ScreenHelper.drawScaledCenteredSplitString(graphics, I18n.m_118938_((String)"gui.battle.accuracyval", (Object[])new Object[]{accuracy}), w - 40, h - 13, 0xFFFFFF, 16.0f, 100, false);
                    TargetingInfo ti = this.attack.getMove().getTargetingInfo();
                    matrix.m_85836_();
                    matrix.m_252880_(0.0f, -1.0f, 0.0f);
                    graphics.m_280509_(w - 50, h - 62, w - 30, h - 52, -14475232);
                    graphics.m_280509_(w - 50, h - 50, w - 30, h - 40, -14475232);
                    graphics.m_280509_(w - 72, h - 62, w - 52, h - 52, -14475232);
                    graphics.m_280509_(w - 72, h - 50, w - 52, h - 40, -14475232);
                    graphics.m_280509_(w - 28, h - 62, w - 8, h - 52, -14475232);
                    graphics.m_280509_(w - 28, h - 50, w - 8, h - 40, -14475232);
                    graphics.m_280509_(w - 50 + 1, h - 62 + 1, w - 30 - 1, h - 52 - 1, ti.hitsAdjacentFoe ? -15888426 : -6249825);
                    graphics.m_280509_(w - 50 + 1, h - 50 + 1, w - 30 - 1, h - 40 - 1, ti.hitsAdjacentAlly ? -15888426 : -6249825);
                    graphics.m_280509_(w - 72 + 1, h - 62 + 1, w - 52 - 1, h - 52 - 1, ti.hitsOppositeFoe ? -15888426 : -6249825);
                    graphics.m_280509_(w - 72 + 1, h - 50 + 1, w - 52 - 1, h - 40 - 1, ti.hitsSelf ? -15888426 : -6249825);
                    graphics.m_280509_(w - 28 + 1, h - 62 + 1, w - 8 - 1, h - 52 - 1, ti.hitsExtendedFoe ? -15888426 : -6249825);
                    graphics.m_280509_(w - 28 + 1, h - 50 + 1, w - 8 - 1, h - 40 - 1, ti.hitsExtendedAlly ? -15888426 : -6249825);
                    matrix.m_85849_();
                }
                ++this.timer;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Attack attack = this.getAttack();
            boolean zMove = attack.getMove().getZMove(this.parent.bm.getCurrentPokemon(), false) != null;
            return attack == null || (this.attack.pp > 0 && (!this.attack.getDisabled() || (this.willDynamax || this.isDynamaxed) && !this.holdingAssaultVest || zMove && this.parent.bm.showZMoves) || attack.isAttack(AttackRegistry.STRUGGLE)) && (this.isPressed = super.m_6375_(mouseX, mouseY, button));
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isPressed = false;
            return true;
        }
    }
}

