/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleBaseScreen;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class BattleScreen
extends BattleBaseScreen {
    public static final ResourceLocation BACKGROUND = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/background.png");
    public static final ResourceLocation DETAILS = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/pokemon_details.png");
    public static final ResourceLocation MENU_BAG = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_bag.png");
    public static final ResourceLocation MENU_BAG_DISABLED = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_bag_disabled.png");
    public static final ResourceLocation MENU_BAG_ICON = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_bag_icon.png");
    public static final ResourceLocation MENU_POKE = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_poke.png");
    public static final ResourceLocation MENU_POKE_DISABLED = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_poke_disabled.png");
    public static final ResourceLocation MENU_POKE_ICON = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_poke_icon.png");
    public static final ResourceLocation MENU_RUN = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_run.png");
    public static final ResourceLocation MENU_RUN_DISABLED = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_run_disabled.png");
    public static final ResourceLocation MENU_RUN_ICON = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_run_icon.png");
    int chatArea;
    int detailsStart;

    public BattleScreen(com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    public void m_7856_() {
        this.f_96540_.clear();
        this.m_142416_((GuiEventListener)new ActionButton(EnumBattleButton.BAG, this));
        this.m_142416_((GuiEventListener)new ActionButton(EnumBattleButton.POKE, this));
        this.m_142416_((GuiEventListener)new ActionButton(EnumBattleButton.RUN, this));
        if (ClientProxy.battleManager.rules.hasClause(BattleClauseRegistry.BAG_CLAUSE)) {
            ((Button)this.f_169369_.get((int)0)).f_93623_ = false;
        }
        if (!this.bm.canSwitch) {
            ((Button)this.f_169369_.get((int)1)).f_93623_ = false;
        }
        if (!this.bm.canFlee || ClientProxy.battleManager.rules.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE)) {
            ((Button)this.f_169369_.get((int)2)).f_93623_ = false;
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int width, int height, int mouseX, int mouseY, int vOffset) {
        this.chatArea = width - 40 - 80;
        ScreenHelper.drawImage(BACKGROUND, graphics, 0.0f, (float)height - 82.1f, (float)width, 83.1f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.detailsStart = this.f_96543_ - 80;
        ScreenHelper.drawImage(DETAILS, graphics, (float)this.detailsStart, (float)(height - 80), 80.0f, 80.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    public void drawButtons(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ((Button)this.f_169369_.get((int)1)).f_93623_ = this.bm.canSwitch;
        ((Button)this.f_169369_.get((int)2)).f_93623_ = this.bm.canFlee && !ClientProxy.battleManager.rules.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE);
        for (Renderable button : this.f_169369_) {
            button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean handleButtonClick(double mouseX, double mouseY) {
        for (GuiEventListener button : this.f_96540_) {
            if (!(button instanceof ActionButton) || !button.m_6375_(mouseX, mouseY, 0)) continue;
            this.bm.dynamaxing = false;
            this.bm.megaEvolving = false;
            this.bm.showZMoves = false;
            ActionButton action = (ActionButton)button;
            if (action.button == EnumBattleButton.RUN) {
                this.bm.selectRunAction(this.bm.getCurrentPokemon().pokemonUUID);
            } else {
                ClientProxy.battleManager.setMode(action.button.getBattleMode());
            }
            return true;
        }
        return false;
    }

    public static class ActionButton
    extends Button {
        public final EnumBattleButton button;
        public final BattleScreen parent;
        public boolean hovered;
        private int hoveredFrames = 0;
        private boolean isPressed;

        public ActionButton(EnumBattleButton button, BattleScreen parent) {
            super(0, 0, button == EnumBattleButton.POKE ? 41 : 40, button == EnumBattleButton.POKE ? 26 : 24, (Component)Component.m_237119_(), action -> {}, p_253695_ -> Component.m_237119_());
            this.button = button;
            this.f_93621_ = button.getY();
            this.parent = parent;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            PoseStack matrix = graphics.m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            this.hovered = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            this.hoveredFrames = this.hovered ? Math.min(3, this.hoveredFrames + 1) : Math.max(0, this.hoveredFrames - 1);
            matrix.m_85836_();
            if ((this.parent.mode == BattleMode.MAIN_MENU || this.parent.mode == BattleMode.CHOOSE_ATTACK) && this.hoveredFrames > 0 && this.f_93623_ && this.f_93624_) {
                matrix.m_252880_((float)(-this.hoveredFrames), 0.0f, 0.0f);
            }
            this.button.drawButton(graphics, mc.f_91080_, this.f_93623_);
            matrix.m_85849_();
            this.button.drawIcon(graphics, mc.f_91080_);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.isPressed = super.m_6375_(mouseX, mouseY, button);
            return this.isPressed;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isPressed = false;
            return true;
        }
    }

    public static enum EnumBattleButton {
        BAG,
        POKE,
        RUN;


        @Nonnull
        public BattleMode getBattleMode() {
            switch (this) {
                case BAG: {
                    return BattleMode.CHOOSE_BAG;
                }
                case POKE: {
                    return BattleMode.CHOOSE_POKEMON;
                }
                case RUN: {
                    return BattleMode.YES_NO_FORFEIT;
                }
            }
            return null;
        }

        @Nonnull
        public ResourceLocation getTexture(boolean disabled) {
            switch (this) {
                case BAG: {
                    return disabled ? MENU_BAG_DISABLED : MENU_BAG;
                }
                case POKE: {
                    return disabled ? MENU_POKE_DISABLED : MENU_POKE;
                }
                case RUN: {
                    return disabled ? MENU_RUN_DISABLED : MENU_RUN;
                }
            }
            return null;
        }

        @Nonnull
        public void drawButton(GuiGraphics graphics, Screen screen, boolean active) {
            switch (this) {
                case BAG: {
                    ScreenHelper.drawImage(this.getTexture(!active), graphics, -1.0f, (float)this.getY(), 40.0f, 24.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case RUN: {
                    ScreenHelper.drawImage(this.getTexture(!active), graphics, 0.0f, (float)this.getY(), 40.0f, 24.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case POKE: {
                    ScreenHelper.drawImage(this.getTexture(!active), graphics, 0.0f, (float)this.getY(), 41.0f, 26.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
        }

        public int getY() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null) {
                return 0;
            }
            switch (this) {
                case BAG: {
                    return screen.f_96544_ - 72 - 8;
                }
                case POKE: {
                    return screen.f_96544_ - 48 - 5;
                }
                case RUN: {
                    return screen.f_96544_ - 24;
                }
            }
            return 0;
        }

        @Nonnull
        public ResourceLocation getIcon() {
            switch (this) {
                case BAG: {
                    return MENU_BAG_ICON;
                }
                case POKE: {
                    return MENU_POKE_ICON;
                }
                case RUN: {
                    return MENU_RUN_ICON;
                }
            }
            return null;
        }

        @Nonnull
        public void drawIcon(GuiGraphics graphics, Screen screen) {
            if (screen == null) {
                return;
            }
            switch (this) {
                case BAG: {
                    ScreenHelper.drawImage(this.getIcon(), graphics, 8.0f, (float)(screen.f_96544_ - 72 - 3), 16.0f, 14.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case POKE: {
                    ScreenHelper.drawImage(this.getIcon(), graphics, 8.0f, (float)(screen.f_96544_ - 48), 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    break;
                }
                case RUN: {
                    ScreenHelper.drawImage(this.getIcon(), graphics, 8.0f, (float)(screen.f_96544_ - 24 + 5), 20.0f, 14.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
        }
    }
}

