/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MenuReuseElement;
import com.pixelmonmod.pixelmon.client.gui.widgets.PixelmonWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BattleMenuElement<B extends MenuListButton>
extends PixelmonWidget {
    protected static final ResourceLocation MENU_BACKGROUND = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_background.png");
    protected static final ResourceLocation MENU_LIST_ITEM = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_list_item.png");
    protected static final ResourceLocation MENU_LIST_LEFT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_left.png");
    protected static final ResourceLocation MENU_LIST_RIGHT = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/menu_right.png");
    private int page = 1;
    private final Screen parent;
    private Component title;
    private List<B> buttons;
    private MenuReuseElement reuseElement = null;

    public BattleMenuElement(Screen parent) {
        this.parent = parent;
        this.setTitle((Component)Component.m_237119_());
        this.setButtons(Collections.emptyList());
    }

    public BattleMenuElement(Screen parent, Component title, List<B> buttons) {
        this.parent = parent;
        this.setTitle(title);
        this.setButtons(buttons);
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public List<B> getAllButtons() {
        return this.buttons;
    }

    public void setButtons(List<B> buttons) {
        this.buttons = buttons;
    }

    public List<B> getPageButtons() {
        ArrayList list = Lists.newArrayList();
        int maxPages = this.buttons.size() < 6 ? 1 : this.buttons.size() / 6 + (this.buttons.size() % 6 > 0 ? 1 : 0);
        int page = Math.min(this.page, maxPages);
        for (int i = 0; i < 6; ++i) {
            if (i + 6 * (page - 1) >= this.buttons.size()) continue;
            list.add((MenuListButton)((Object)this.buttons.get(i + 6 * (page - 1))));
        }
        return list;
    }

    public void setReuseMessage(String key, @Nullable ItemStack stack) {
        this.reuseElement = key != null && !key.isEmpty() ? new MenuReuseElement(key, stack) : null;
    }

    @Override
    public void drawElement(GuiGraphics graphics, float scale) {
        ScreenHelper.drawImage(graphics, MENU_BACKGROUND, (float)this.x, (float)this.y, 180.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawScaledCenteredString(graphics, this.getTitle().getString(), (float)this.x + 85.0f, this.y + 6, -986896, 14.0f);
        if (this.reuseElement != null) {
            this.reuseElement.drawElement(graphics, scale);
        }
        Minecraft mc = Minecraft.m_91087_();
        int mouseX = (int)(mc.f_91067_.m_91589_() * (double)this.width / (double)this.parent.f_96543_);
        int mouseZ = (int)((double)this.height - mc.f_91067_.m_91589_() * (double)this.height / (double)this.parent.f_96544_ - 1.0);
        this.drawMenuButtons(graphics, mouseX, mouseZ);
    }

    @Override
    public <T extends PixelmonWidget> T setPosition(int x, int y, int width, int height) {
        Object t = super.setPosition(x, y, width, height);
        if (this.reuseElement != null) {
            this.reuseElement.setPosition(x + 45, y + height - 22, 110, 18);
        }
        for (MenuListButton button : this.getAllButtons()) {
            button.setPosition(x, y, width, height);
        }
        return t;
    }

    public void drawMenuButtons(GuiGraphics graphics, int mouseX, int mouseY) {
        int maxPages = this.buttons.size() < 6 ? 1 : this.buttons.size() / 6 + (this.buttons.size() % 6 > 0 ? 1 : 0);
        this.page = Math.min(this.page, maxPages);
        for (int i = 0; i < 6; ++i) {
            if (i + 6 * (this.page - 1) >= this.buttons.size()) continue;
            ((MenuListButton)((Object)this.buttons.get(i + 6 * (this.page - 1)))).m_87963_(graphics, mouseX, mouseY, 0.0f);
        }
        if (maxPages > 1) {
            ScreenHelper.drawScaledCenteredString(graphics, this.page + "/" + maxPages, 85.0f, this.y + this.height - 38, -986896, 14.0f);
            if (this.page < maxPages) {
                ScreenHelper.drawImage(graphics, MENU_LIST_RIGHT, 100.0f, (float)(this.y + this.height - 39), 8.0f, 8.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (this.page > 1) {
                ScreenHelper.drawImage(graphics, MENU_LIST_LEFT, 62.0f, (float)(this.y + this.height - 39), 8.0f, 8.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    public boolean isOverReturnButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + 30) && mouseY >= (double)(this.y + this.height - 30) && mouseY < (double)(this.y + this.height);
    }

    public boolean isOverReuseButton(double mouseX, double mouseY) {
        return this.reuseElement != null && this.reuseElement.isMouseOver(mouseX, mouseY);
    }

    public boolean handleClickPageTurn(double mouseX, double mouseY) {
        int maxPages;
        int n = this.buttons.size() < 6 ? 1 : (maxPages = this.buttons.size() / 6 + (this.buttons.size() % 6 > 0 ? 1 : 0));
        if (maxPages > 1) {
            if (this.page > 1 && mouseX >= 62.0 && mouseY >= (double)(this.y + this.height - 39) && mouseX < 70.0 && mouseY < (double)(this.y + this.height - 39 + 8)) {
                --this.page;
                return true;
            }
            if (this.page < maxPages && mouseX >= 100.0 && mouseY >= (double)(this.y + this.height - 39) && mouseX < 108.0 && mouseY < (double)(this.y + this.height - 39 + 8)) {
                ++this.page;
                return true;
            }
        }
        return false;
    }

    public static class MenuListButton
    extends Button {
        public int id;
        public boolean isPressed = false;

        public MenuListButton(int id, Screen parent) {
            super(0, 0, parent.f_96543_, parent.f_96544_, (Component)Component.m_237119_(), action -> {}, p_253695_ -> Component.m_237119_());
            this.id = id;
            this.setPosition(0, 0, parent.f_96543_, parent.f_96544_);
        }

        public <T extends MenuListButton> T setPosition(int x, int y, int width, int height) {
            this.f_93620_ = x + 5;
            this.f_93621_ = y + 20 + this.id % 6 * 30;
            this.f_93618_ = 155;
            this.f_93619_ = 26;
            return (T)((Object)this);
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                ScreenHelper.drawImage(graphics, MENU_LIST_ITEM, (float)this.f_93620_, (float)this.f_93621_, (float)this.f_93618_, (float)this.f_93619_, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.isPressed = super.m_6375_(mouseX, mouseY, button);
            return this.isPressed;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isPressed = false;
            return true;
        }
    }
}

