/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectScreen;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public abstract class VersusScreen
extends Screen {
    private static final ResourceLocation TOP_LEFT = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent1.png");
    private static final ResourceLocation MIDDLE = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent2.png");
    private static final ResourceLocation BOTTOM_RIGHT = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent3.png");
    private static final ResourceLocation VS = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/opponent8.png");
    private static final ResourceLocation PLAYER_1_FRAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player1frame.png");
    private static final ResourceLocation PLAYER_2_FRAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player2frame.png");
    private static final ResourceLocation PLAYER_1_NAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player1name.png");
    private static final ResourceLocation PLAYER_2_NAME = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/player2name.png");
    private static final ResourceLocation POKE_BALL_HOLDER = ResourceLocationHelper.of("pixelmon:textures/gui/acceptdeny/pokeballholder.png");
    protected int leftX;
    protected int topY;
    protected int ticks = 5;
    protected int offset1;
    protected int offset2;
    protected int playerPartyX;
    protected int playerPartyY;
    protected int opponentPartyX;
    protected int opponentPartyY;
    protected boolean isNPC;
    private ResourceLocation npcSkin;
    protected static final int GUI_WIDTH = 280;
    protected static final int GUI_HEIGHT = 182;
    public static final int PARTY_SEPARATOR = 12;

    protected VersusScreen() {
        super((Component)Component.m_237119_());
        this.f_96541_ = Minecraft.m_91087_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.updateAnchors();
    }

    public void m_280273_(GuiGraphics p_283688_, int mouseX, int mouseY, float partialTicks) {
    }

    public void m_280039_(GuiGraphics p_282281_) {
    }

    public void m_86600_() {
        try {
            super.m_86600_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.ticks > 0) {
            --this.ticks;
        }
    }

    private void updateAnchors() {
        this.leftX = (this.f_96543_ - 280) / 2;
        this.topY = (this.f_96544_ - 182) / 2;
        this.offset1 = -this.ticks * 50;
        this.offset2 = -this.offset1;
        this.playerPartyX = this.leftX + 84;
        this.playerPartyY = this.topY + 27;
        this.opponentPartyX = this.leftX + 120;
        this.opponentPartyY = this.topY + 121;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float f) {
        this.updateAnchors();
        this.drawRectangle(graphics);
        this.drawEntity(graphics, PLAYER_1_NAME, PLAYER_1_FRAME, (LivingEntity)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_5446_().getString(), this.offset1, 76, 9, 19, 11, 16, 9, 82, 27, 92, 15, false);
        LivingEntity opponent = this.getOpponent();
        if (opponent == null) {
            return;
        }
        String opponentName = this.isNPC ? TeamSelectScreen.teamSelectPacket.npcName : opponent.m_5446_().getString();
        this.drawEntity(graphics, PLAYER_2_NAME, PLAYER_2_FRAME, opponent, opponentName, this.offset2, 56, 103, 202, 76, 199, 74, 118, 121, 188 - this.f_96541_.f_91062_.m_92895_(opponentName), 108, this.isNPC);
    }

    public boolean m_7043_() {
        return false;
    }

    protected abstract LivingEntity getOpponent();

    private void drawRectangle(GuiGraphics graphics) {
        ScreenHelper.drawImageQuad(TOP_LEFT, graphics, this.leftX + this.offset1, this.topY, 280.0f, 182.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(MIDDLE, graphics, this.leftX + this.offset2, this.topY, 280.0f, 182.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(BOTTOM_RIGHT, graphics, this.leftX, this.topY, 280.0f, 182.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.ticks == 0) {
            ScreenHelper.drawImageQuad(VS, graphics, this.leftX, this.topY + 2, 280.0f, 226.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void drawEntity(GuiGraphics graphics, ResourceLocation name, ResourceLocation frame, LivingEntity entity, String entityName, int tickOffset, int nameBoxX, int nameBoxY, int headX, int headY, int frameX, int frameY, int holderX, int holderY, int nameX, int nameY, boolean isCurrentNPC) {
        ScreenHelper.drawImageQuad(name, graphics, this.leftX + nameBoxX + tickOffset, this.topY + nameBoxY, 145.0f, 17.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.drawEntity(graphics, entity, this.leftX + headX + tickOffset, this.topY + headY, isCurrentNPC);
        ScreenHelper.drawImageQuad(frame, graphics, this.leftX + frameX + tickOffset, this.topY + frameY, 65.0f, 65.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(POKE_BALL_HOLDER, graphics, this.leftX + holderX + tickOffset, this.topY + holderY, 80.0f, 17.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, entityName, this.leftX + nameX + tickOffset, this.topY + nameY, 0xFFFFFF);
    }

    protected void drawPokeBalls(GuiGraphics graphics, String[] pokeBalls, int startX, int startY, int tickOffset) {
        int pos = 0;
        for (String pid : pokeBalls) {
            if (!pid.isEmpty()) {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                if (pid.startsWith("!")) {
                    pid = pid.replace("!", "");
                    graphics.m_280246_(0.4f, 0.4f, 0.4f, 1.0f);
                }
                ItemStack pball = PokeBallRegistry.getPokeBall(pid).getValueUnsafe().getBallItem();
                graphics.m_280480_(pball, startX + pos * 12 + tickOffset, startY);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            ++pos;
        }
    }

    protected void drawOpponentPokeBalls(GuiGraphics graphics, int numPokeBalls) {
        Object[] opponentPokeBalls = new String[numPokeBalls];
        Arrays.fill(opponentPokeBalls, "poke_ball");
        this.drawPokeBalls(graphics, (String[])opponentPokeBalls, this.opponentPartyX, this.opponentPartyY, this.offset2);
    }

    protected void drawEntity(GuiGraphics graphics, LivingEntity entity, int x, int y, boolean isCurrentNPC) {
        ResourceLocation skin;
        if (isCurrentNPC && entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            if (!npc.bindTexture() && this.npcSkin == null) {
                this.npcSkin = ResourceLocationHelper.of(npc.getTexture());
            }
            skin = this.npcSkin;
        } else {
            skin = ((AbstractClientPlayer)entity).m_294544_().f_290339_();
        }
        if (skin != null) {
            ScreenHelper.simpleDrawImageQuad(skin, graphics, x, y, 60.0f, 60.0f, 0.125f, 0.125f, 0.25f, 0.25f, 1.0f);
        }
    }
}

