/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.google.common.util.concurrent.AtomicDouble;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Illusion;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PixelmonClientData {
    public UUID pokemonUUID;
    public Species species;
    public String form = "default";
    public String prevForm = "default";
    public short gender;
    public AtomicDouble health = new AtomicDouble(0.0);
    public int maxHealth;
    public int dynamax = 0;
    public boolean mega = false;
    public String nickname;
    public int status = -1;
    public int level;
    public BossTier bossTier;
    public String palette;
    public boolean gmaxFactor;
    public int position = 0;
    public Moveset moveset = null;
    public HeldItem heldItem = null;
    public float expFraction = 0.0f;
    public int xPos = 0;
    public boolean isSwitchingOut;
    public boolean isSwitchingIn;
    public boolean blockCapture = false;
    public boolean inIllusion = false;
    public int maxShields = 0;
    public int shields = 0;
    public boolean lostShield = false;

    public PixelmonClientData() {
        this.nickname = "";
        this.species = null;
    }

    public PixelmonClientData(Pokemon poke) {
        this.set(poke);
    }

    public PixelmonClientData(PixelmonWrapper pixelmon) {
        Transformed transformedStatus;
        this.pokemonUUID = pixelmon.getPokemonUUID();
        this.health.set((double)pixelmon.getHealth());
        this.maxHealth = pixelmon.getMaxHealth();
        this.dynamax = pixelmon.isDynamax;
        this.mega = pixelmon.isMega;
        this.palette = pixelmon.getInnerLink().getPalette().getName();
        Ability ability = pixelmon.getBattleAbility();
        if (ability instanceof Illusion) {
            Illusion illusion = (Illusion)ability;
            if (illusion.disguisedGender != null) {
                this.nickname = illusion.disguisedNickname;
                this.species = illusion.disguisedPokemon;
                this.gender = (short)illusion.disguisedGender.ordinal();
                this.form = illusion.disguisedForm;
                this.palette = illusion.disguisedPalette;
                this.inIllusion = true;
            }
        }
        if (pixelmon.hasStatus(StatusType.Transformed) && (transformedStatus = (Transformed)pixelmon.getStatus(StatusType.Transformed)) != null) {
            this.nickname = pixelmon.getRealNickname();
            this.species = transformedStatus.transformedPokemon;
            this.gender = (short)transformedStatus.transformedGender.ordinal();
            this.form = transformedStatus.transformedForm;
            this.palette = transformedStatus.transformedPalette;
        }
        if (!this.inIllusion && !pixelmon.hasStatus(StatusType.Transformed)) {
            this.nickname = pixelmon.getRealNickname();
            this.species = pixelmon.getSpecies();
            this.gender = (short)pixelmon.getGender().ordinal();
            this.form = pixelmon.getForm().getName();
            this.palette = pixelmon.getInnerLink().getPalette().getName();
            this.mega = pixelmon.isMega;
            this.dynamax = pixelmon.isDynamax;
        }
        this.level = pixelmon.getPokemonLevelNum();
        this.bossTier = pixelmon.entity != null ? pixelmon.entity.getBossTier() : BossTierRegistry.NOT_BOSS;
        this.gmaxFactor = pixelmon.getInnerLink().hasGigantamaxFactor();
        StatusPersist primaryStatus = pixelmon.getPrimaryStatus();
        this.status = primaryStatus != NoStatus.noStatus ? primaryStatus.type.ordinal() : -1;
        this.moveset = pixelmon.getMoveset();
        this.heldItem = pixelmon.getHeldItem();
        this.expFraction = pixelmon.pokemon.getExperienceFraction();
        this.blockCapture = pixelmon.pokemon.isUncatchable();
        this.position = pixelmon.battlePosition;
        this.shields = pixelmon.shields;
        this.maxShields = pixelmon.maxShields;
    }

    public void set(Pokemon poke) {
        this.pokemonUUID = poke.getUUID();
        this.health.set((double)poke.getHealth());
        this.maxHealth = poke.getMaxHealth();
        this.nickname = poke.getDisplayName();
        this.species = poke.getSpecies();
        this.status = poke.getStatus() == null || poke.getStatus().type == StatusType.None ? -1 : poke.getStatus().type.ordinal();
        this.level = poke.getPokemonLevel();
        this.gender = (short)poke.getGender().ordinal();
        this.palette = poke.getPalette().getName();
        this.gmaxFactor = poke.hasGigantamaxFactor();
        this.expFraction = poke.getExperienceFraction();
        this.form = poke.getForm().getName();
        this.mega = poke.isMega();
        this.dynamax = poke.getDynamaxLevel();
        this.moveset = poke.getMoveset();
        this.heldItem = poke.getHeldItemAsItemHeld();
        this.blockCapture = poke.isUncatchable();
    }

    public static PixelmonClientData[] convertToGUI(List<PixelmonWrapper> pokemon) {
        PixelmonClientData[] data = new PixelmonClientData[pokemon.size()];
        for (int i = 0; i < pokemon.size(); ++i) {
            PixelmonWrapper wrapper = pokemon.get(i);
            data[i] = new PixelmonClientData(wrapper);
            data[i].position = wrapper.battlePosition;
        }
        return data;
    }

    public void decodeFrom(FriendlyByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.species = PixelmonSpecies.fromNationalDex(Integer.valueOf(buffer.readShort()));
        this.form = buffer.m_130277_();
        this.health.set(buffer.readDouble());
        this.maxHealth = buffer.readInt();
        this.dynamax = buffer.readInt();
        this.mega = buffer.readBoolean();
        this.nickname = buffer.m_130277_();
        this.level = buffer.readInt();
        this.bossTier = BossTierRegistry.getBossTierOrNotBoss(buffer.m_130277_());
        this.gender = buffer.readShort();
        this.palette = buffer.m_130277_();
        this.gmaxFactor = buffer.readBoolean();
        this.status = buffer.readInt();
        this.expFraction = buffer.readFloat();
        this.blockCapture = buffer.readBoolean();
        this.moveset = new Moveset();
        this.moveset.fromBytes(buffer);
        boolean noItem = buffer.readBoolean();
        this.heldItem = noItem ? PixelmonItems.no_item : HeldItem.getItemHeld(buffer.m_130267_());
        this.position = buffer.readInt();
        this.inIllusion = buffer.readBoolean();
        this.shields = buffer.readInt();
        this.maxShields = buffer.readInt();
    }

    public void encodeInto(FriendlyByteBuf buffer) {
        if (this.nickname == null) {
            this.nickname = this.species.getName();
        }
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits()).writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.writeShort(this.species.getDex());
        buffer.m_130070_(this.form);
        buffer.writeDouble(this.health.get());
        buffer.writeInt(this.maxHealth);
        buffer.writeInt(this.dynamax);
        buffer.writeBoolean(this.mega);
        buffer.m_130070_(this.nickname);
        buffer.writeInt(this.level);
        buffer.m_130070_(this.bossTier == null ? BossTierRegistry.NOT_BOSS.getID() : this.bossTier.getID());
        buffer.writeShort((int)this.gender);
        buffer.m_130070_(this.palette);
        buffer.writeBoolean(this.gmaxFactor);
        buffer.writeInt(this.status);
        buffer.writeFloat(this.expFraction);
        buffer.writeBoolean(this.blockCapture);
        this.moveset.toBytes(buffer);
        boolean noItem = this.heldItem == PixelmonItems.no_item || this.heldItem == null;
        buffer.writeBoolean(noItem);
        if (!noItem) {
            buffer.m_130055_(new ItemStack((ItemLike)this.heldItem));
        }
        buffer.writeInt(this.position);
        buffer.writeBoolean(this.inIllusion);
        buffer.writeInt(this.shields);
        buffer.writeInt(this.maxShields);
    }

    public String getDisplayName() {
        String localizedName = this.species.getLocalizedName();
        if (this.nickname == null || this.nickname.isEmpty() || this.nickname.equals(this.species.getName())) {
            return localizedName;
        }
        return this.nickname;
    }

    public int getDexNumber() {
        return this.species.getDex();
    }

    public Stats getBaseStats() {
        return this.species.getForm(this.form);
    }

    public Gender getGender() {
        return Gender.getGender(this.gender);
    }

    public float[] getStatusTexturePos() {
        return StatusType.getTexturePos(this.status == -1 ? StatusType.None : StatusType.getEffect(this.status));
    }

    public Color getHealthColor() {
        Color color = new Color(51, 204, 51);
        if (this.health.get() <= (double)((float)this.maxHealth / 5.0f)) {
            color = new Color(204, 0, 0);
        } else if (this.health.get() <= (double)((float)this.maxHealth / 2.0f)) {
            color = new Color(255, 255, 102);
        }
        return color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelmonClientData that = (PixelmonClientData)o;
        return Objects.equals(this.pokemonUUID, that.pokemonUUID);
    }

    public int hashCode() {
        return Objects.hash(this.pokemonUUID);
    }
}

