/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.badgecase;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.BadgeCaseActionPacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BadgeCaseScreen
extends Screen {
    private static final int[] X_VALUE = new int[]{50, 92, 133, 174};
    private ResourceLocation upTexture;
    private ResourceLocation downTexture;
    private ResourceLocation registerTexture;
    private ResourceLocation badgeCaseTexture;
    private Button buttonUp;
    private Button buttonRegister;
    private Button buttonDown;
    private final Button[] badgeButtons = new Button[8];
    private int page = 0;
    private int selectedBadge = -1;
    private String owner;
    boolean allowChanges;
    EnumBadgeCase color;
    List<ItemStack> badges;
    public Pokemon[] party = new Pokemon[6];
    private boolean custom;
    private static final int SPRITE_HEIGHT = 40;
    private static final int SPRITE_WIDTH = 40;
    private static final int POKEBALL_HEIGHT = 43;
    private static final int POKEBALL_WIDTH = 44;

    public BadgeCaseScreen(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, Pokemon[] party) {
        super((Component)Component.m_237119_());
        this.updateBadgeCase(owner, allowChanges, custom, color, badges, party);
    }

    public void m_7856_() {
        int buttonID = 0;
        int xOffset = (this.f_96543_ - 252) / 2;
        int yOffset = 2;
        this.buttonUp = new IndexedButton(buttonID++, xOffset + 37, yOffset + 208, 42, 20, (Component)Component.m_237119_(), p_onPress_1_ -> {});
        this.buttonDown = new IndexedButton(buttonID++, xOffset + 79, yOffset + 208, 42, 20, (Component)Component.m_237119_(), button -> {});
        this.buttonRegister = new IndexedButton(buttonID++, xOffset + 37, yOffset + 7, 80, 20, (Component)Component.m_237119_(), button -> {});
        for (int i = 0; i < 4; ++i) {
            this.badgeButtons[i] = new IndexedButton(buttonID, xOffset + X_VALUE[i], yOffset + 135, 33, 23, (Component)Component.m_237119_(), button -> {});
            this.badgeButtons[i + 4] = new IndexedButton(buttonID + 4, xOffset + X_VALUE[i], yOffset + 168, 33, 23, (Component)Component.m_237119_(), button -> {});
        }
        this.m_142416_((GuiEventListener)this.buttonUp);
        this.m_142416_((GuiEventListener)this.buttonDown);
        this.m_142416_((GuiEventListener)this.buttonRegister);
        for (Button badgeButton : this.badgeButtons) {
            this.m_142416_((GuiEventListener)badgeButton);
        }
        if (!this.allowChanges) {
            this.buttonRegister.f_93623_ = false;
            Arrays.stream(this.badgeButtons).forEach(badge -> {
                badge.f_93623_ = false;
            });
        }
        if (this.owner != null && !this.owner.isEmpty()) {
            this.buttonRegister.f_93623_ = false;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        if (this.f_96541_ == null) {
            return;
        }
        int guiWidth = 210;
        int guiHeight = 235;
        int xOffset = (this.f_96543_ - 205) / 2;
        int yOffset = 2;
        graphics.m_280163_(this.badgeCaseTexture, xOffset, yOffset, 0.0f, 0.0f, 210, 235, 210, 235);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280163_(this.upTexture, xOffset + 17, yOffset + 208, 0.0f, 0.0f, 40, 14, 40, 14);
        graphics.m_280163_(this.downTexture, xOffset + 59, yOffset + 208, 0.0f, 0.0f, 40, 14, 40, 14);
        if (this.buttonRegister.f_93623_) {
            graphics.m_280163_(this.registerTexture, xOffset + 16, yOffset + 10, 0.0f, 0.0f, 80, 14, 80, 14);
        }
        int textColor = switch (this.color) {
            case EnumBadgeCase.Black -> 0x919191;
            case EnumBadgeCase.Blue -> {
                if (this.buttonRegister.f_93623_) {
                    yield 0x1919FF;
                }
                yield 35020;
            }
            case EnumBadgeCase.Green -> 13064;
            case EnumBadgeCase.Pink -> {
                if (!this.buttonRegister.f_93623_) {
                    yield 0xFF99FF;
                }
                yield 0xE600E6;
            }
            case EnumBadgeCase.Red -> {
                if (this.buttonRegister.f_93623_) {
                    yield 0xB30000;
                }
                yield 0xFF4D4D;
            }
            case EnumBadgeCase.White, EnumBadgeCase.Yellow -> 0;
            default -> 1048575;
        };
        if (this.buttonRegister.f_93623_) {
            graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.badgecase.register", (Object[])new Object[0]), xOffset + 55, yOffset + 13, textColor);
        } else {
            graphics.m_280137_(this.f_96541_.f_91062_, this.owner, xOffset + 55, yOffset + 13, textColor);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int firstRowHeight = 32;
        int secondRowHeight = 64;
        int collum = 17;
        int offset = 27;
        this.drawPokemon(graphics, this.party[0], xOffset, yOffset, collum, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(graphics, this.party[3], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        this.drawPokemon(graphics, this.party[1], xOffset, yOffset, collum += offset, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(graphics, this.party[4], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        this.drawPokemon(graphics, this.party[2], xOffset, yOffset, collum += offset, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(graphics, this.party[5], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        int count = 0;
        for (Button button : this.badgeButtons) {
            if (this.selectedBadge == this.page * 8 + count) {
                ScreenHelper.drawGradientRect(graphics, button.f_93620_, button.f_93621_, 1.0f, button.f_93620_ + button.m_5711_(), button.f_93621_ + button.m_93694_(), 0x46FFFFFF, 0x46FFFFFF);
            }
            if (this.page * 8 + count < this.badges.size() && button.m_5953_((double)mouseX, (double)mouseY)) {
                graphics.m_280509_(button.f_93620_, button.f_93621_, button.f_93620_ + button.m_5711_(), button.f_93621_ + button.m_93694_(), 0x32FFFFFF);
            }
            ++count;
        }
        for (i = 0; i < 8 && this.page * 8 + i != this.badges.size(); ++i) {
            int rowX = 34;
            int rowY = i < 4 ? 137 : 170;
            int rowOffset = 42;
            graphics.m_280480_(this.badges.get(this.page * 8 + i), xOffset + rowX + (i + 1 <= 4 ? i * rowOffset : (i - 4) * rowOffset), yOffset + rowY);
        }
        for (i = 0; i < 8; ++i) {
            ListTag loreList;
            if (this.page * 8 + i >= this.badges.size() || !this.badgeButtons[i].m_5953_((double)mouseX, (double)mouseY)) continue;
            ItemStack badge = this.badges.get(this.page * 8 + i);
            ArrayList lore = Lists.newArrayList();
            if (badge.m_41788_()) {
                lore.add(badge.m_41786_());
            }
            if (badge.m_41737_("display") != null && badge.m_41737_("display").m_128425_("Lore", 9) && !(loreList = badge.m_41737_("display").m_128437_("Lore", 8)).isEmpty()) {
                for (int l1 = 0; l1 < loreList.size(); ++l1) {
                    lore.add(Component.Serializer.m_130701_((String)loreList.m_128778_(l1)));
                }
            }
            if (lore.isEmpty()) continue;
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, (List)lore, mouseX, mouseY);
        }
    }

    protected void actionPerformed(Button button, int mouseButton) {
        if (button == this.buttonUp) {
            this.pageUp();
            return;
        }
        if (button == this.buttonDown) {
            this.pageDown();
            return;
        }
        if (!this.allowChanges) {
            return;
        }
        if (button == this.buttonRegister) {
            if (this.buttonRegister.f_93623_) {
                NetworkHelper.sendToServer(new BadgeCaseActionPacket(BadgeCaseActionPacket.Action.REGISTER, this.custom));
                this.buttonRegister.f_93623_ = false;
            }
        } else {
            for (int i = 0; i < this.badgeButtons.length; ++i) {
                if (button != this.badgeButtons[i] || this.badges.size() < this.page * 8 + 1) continue;
                if (mouseButton == 0) {
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + i;
                        continue;
                    }
                    NetworkHelper.sendToServer(new BadgeCaseActionPacket(this.selectedBadge, this.page * 8 + i, this.custom));
                    this.selectedBadge = -1;
                    continue;
                }
                if (mouseButton != 1) continue;
                NetworkHelper.sendToServer(new BadgeCaseActionPacket(this.page * 8 + i, this.custom));
                this.selectedBadge = -1;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (GuiEventListener widget : this.f_96540_) {
            if (!(widget instanceof Button) || !widget.m_5953_(mouseX, mouseY)) continue;
            Button button = (Button)widget;
            ScreenEvent.MouseButtonPressed.Pre event = new ScreenEvent.MouseButtonPressed.Pre((Screen)this, mouseX, mouseY, mouseButton);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            ((Button)widget).m_7435_(this.f_96541_.m_91106_());
            this.actionPerformed(button, mouseButton);
            if (((Object)((Object)this)).equals(this.f_96541_.f_91080_)) {
                MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.MouseButtonPressed.Post((Screen)this, mouseX, mouseY, mouseButton, true));
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            mc.m_91152_(null);
            if (mc.f_91080_ == null) {
                mc.m_7440_(true);
                return true;
            }
        } else {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    private void pageDown() {
        if ((this.page + 1) * 8 >= this.badges.size()) {
            return;
        }
        ++this.page;
    }

    private void pageUp() {
        if (this.page == 0) {
            return;
        }
        --this.page;
    }

    private void drawPokemon(GuiGraphics graphics, Pokemon pokemon, int xOffset, int yOffset, int ballX, int ballY, int pokeX, int pokeY) {
        if (pokemon != null) {
            graphics.m_280411_(pokemon.getBall().getGUISprite(), xOffset + ballX, yOffset + ballY, 0, 0, 44.0f, 43.0f, 36, 36, 44, 43);
            graphics.m_280411_(pokemon.getSprite(), xOffset + pokeX, yOffset + pokeY - 3, 0, 0, 40.0f, 40.0f, 36, 36, 40, 40);
        }
    }

    public void updateBadgeCase(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, Pokemon[] party) {
        this.owner = owner;
        this.allowChanges = allowChanges;
        this.custom = custom;
        this.color = color;
        this.badges = badges;
        if (party.length == 6) {
            this.party = party;
        }
        this.badgeCaseTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/badgecase_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
        this.upTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/up_button_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
        this.downTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/down_button_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
        this.registerTexture = ResourceLocationHelper.of(Resources.prefix + "gui/badgecases/register_" + color.toString().toLowerCase(Locale.ROOT) + ".png");
    }
}

