/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.ClientTradingManager;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.ServerTradesPacket;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TradingScreen
extends Screen {
    public boolean ready = false;
    private int selected = -1;
    private BlockPos tradeMachine;

    public TradingScreen(int x, int y, int z) {
        super((Component)Component.m_237119_());
        this.tradeMachine = new BlockPos(x, y, z);
    }

    public void m_7861_() {
        NetworkHelper.sendToServer(ServerTradesPacket.getDeRegisterPacket(this.tradeMachine));
        ClientTradingManager.reset();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280218_(Resources.tradeGui, (this.f_96543_ - 256) / 2, (this.f_96544_ - 206) / 2, 0, 0, 256, 204);
        int i = -1;
        Pokemon[] party = ClientStorageManager.party.getAll();
        graphics.m_280168_().m_85836_();
        for (Pokemon p : party) {
            ++i;
            if (p == null) continue;
            ScreenHelper.drawImageQuad(p.getSprite(), graphics, (float)this.f_96543_ / 2.0f - 93.0f + (float)(25 * i), (float)this.f_96544_ / 2.0f + 68.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!p.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, graphics, (float)this.f_96543_ / 2.0f - 97.0f + (float)(25 * i) + 18.0f, (float)this.f_96544_ / 2.0f + 68.0f + 18.0f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (!ClientStorageManager.party.inTemporaryMode()) continue;
            Color color = ClientStorageManager.party.getTempPartyColor();
            ScreenHelper.drawImageQuad(Resources.padlock, graphics, (float)this.f_96543_ / 2.0f - 93.0f + (float)(25 * i), (float)this.f_96544_ / 2.0f + 68.0f, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
        }
        graphics.m_280168_().m_85849_();
        this.drawPlayer(graphics, (Player)this.f_96541_.f_91074_, 0, 0);
        this.drawPlayer(graphics, ClientTradingManager.tradePartner, 270, 90);
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.0f);
        Pokemon playerPokemon = null;
        if (this.selected != -1) {
            playerPokemon = party[this.selected];
        }
        this.drawStats(graphics, ClientTradingManager.selectedStats, playerPokemon, 0);
        this.drawStats(graphics, ClientTradingManager.tradeTargetStats, ClientTradingManager.tradeTarget, 270);
        matrix.m_85849_();
        graphics.m_280168_().m_85836_();
        this.drawPokemonDetails(graphics, playerPokemon, -117, -212, -180, -75);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        this.drawPokemonDetails(graphics, ClientTradingManager.tradeTarget, 18, 58, 90, 15);
        graphics.m_280168_().m_85849_();
        graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.ready").getString(), (this.f_96543_ + 130) / 2, (this.f_96544_ + 157) / 2, 0xFFFFFF);
        this.drawButtonReady(graphics, mouseX, mouseY);
        if (!this.hasOtherHatchedPokemon(this.selected) || playerPokemon != null && playerPokemon.isEgg() && !ClientTradingManager.targetPartyIsMoreThanOnePokemon) {
            graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.invalid").getString(), (this.f_96543_ - 30) / 2, (this.f_96544_ + 38) / 2, 16213760);
        } else if (ClientTradingManager.player1Ready && ClientTradingManager.player2Ready) {
            graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.trade").getString(), (this.f_96543_ - 30) / 2, (this.f_96544_ + 38) / 2, 0xFFFFFF);
            this.drawButtonTrade(graphics, mouseX, mouseY);
        } else {
            graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.notready").getString(), (this.f_96543_ - 45) / 2, (this.f_96544_ + 38) / 2, 0xFFFFFF);
        }
        this.drawPokemonSelection(graphics, mouseX, mouseY);
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.0f);
        graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237110_((String)"gui.trading.want", (Object[])new Object[]{Component.m_237115_((String)this.f_96541_.f_91074_.m_5446_().getString()).getString()}).getString(), this.f_96543_ - 235, this.f_96544_ - 178, 0xFFFFFF);
        if (ClientTradingManager.tradePartner != null) {
            graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237110_((String)"gui.trading.want", (Object[])new Object[]{Component.m_237115_((String)ClientTradingManager.tradePartner.m_7755_().getString()).getString()}).getString(), this.f_96543_ + 35, this.f_96544_ - 178, 0xFFFFFF);
        } else {
            graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.nuf").getString(), this.f_96543_ + 35, this.f_96544_ - 178, 0xFFFFFF);
        }
        matrix.m_85849_();
        matrix.m_85836_();
        if (ClientTradingManager.tradePartner != null && !ClientTradingManager.player2Ready) {
            graphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ + 45) / 2, (this.f_96544_ + 85) / 2, 61, 242, 90, 14);
        } else if (!ClientTradingManager.player2Ready) {
            graphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ + 65) / 2, (this.f_96544_ + 85) / 2, 153, 242, 72, 14);
        } else if (ClientTradingManager.player2Ready) {
            graphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ + 75) / 2, (this.f_96544_ + 85) / 2, 1, 242, 58, 14);
        }
        if (!ClientTradingManager.player1Ready) {
            graphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ - 225) / 2, (this.f_96544_ + 85) / 2, 61, 242, 90, 14);
        } else if (ClientTradingManager.player1Ready) {
            graphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ - 195) / 2, (this.f_96544_ + 85) / 2, 1, 242, 58, 14);
        }
        matrix.m_85849_();
        if (this.selected != -1) {
            matrix.m_85836_();
            graphics.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ - 190 + this.selected * 50) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
            matrix.m_85849_();
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.isOverCloseButton(mouseX, mouseY);
        if (this.isOverCloseButton(mouseX, mouseY)) {
            graphics.m_280218_(Resources.tradeGui, (this.f_96543_ + 214) / 2, (this.f_96544_ + 170) / 2, 67, 225, 17, 15);
        }
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.0f);
        ScreenHelper.drawSplitString(graphics, Component.m_237115_((String)"gui.trading.select").getString(), (this.f_96543_ / 2 - 118) * 2, (this.f_96544_ / 2 + 77) * 2, 50, 0xFFFFFF);
        matrix.m_85849_();
    }

    private void drawPlayer(GuiGraphics graphics, Player player, int playerOffset, int questionOffset) {
        if (player != null) {
            ScreenHelper.drawEntity(graphics, (LivingEntity)player, (this.f_96543_ - 210 + playerOffset) / 2, (this.f_96544_ - 82) / 2, 20.0f, 360.0f, 0.0f);
        } else {
            PoseStack matrix = graphics.m_280168_();
            matrix.m_85836_();
            matrix.m_85841_(1.5f, 1.5f, 0.0f);
            graphics.m_280218_(Resources.tradeGui, this.f_96543_ - 75 + questionOffset, this.f_96544_ - 265, 227, 242, 10, 14);
            matrix.m_85849_();
        }
    }

    private void drawStats(GuiGraphics graphics, PixelmonStatsData stats, Pokemon pokemon, int xOffset) {
        boolean isEgg;
        String[] statNames = new String[]{"hp", "attack", "defense", "spattack", "spdefense", "speed"};
        int[] statHeights = new int[6];
        int textPosition = this.f_96543_ - 183 + xOffset;
        for (int i = 0; i < statNames.length; ++i) {
            int statHeight;
            String statLang = "nbt." + statNames[i];
            statHeights[i] = statHeight = this.f_96544_ - 156 + 16 * i;
            graphics.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)statLang).getString(), textPosition, statHeight, 0xFFFFFF);
        }
        int statPosition = this.f_96543_ - 54 + xOffset;
        boolean bl = isEgg = pokemon == null ? false : pokemon.isEgg();
        if (isEgg || stats == null) {
            String questionMarks = "???";
            for (int statHeight : statHeights) {
                graphics.m_280488_(this.f_96541_.f_91062_, questionMarks, statPosition, statHeight, 0xFFFFFF);
            }
        } else {
            int[] statValues = pokemon == null || pokemon.getStats() == null ? new int[]{stats.HP, stats.Attack, stats.Defense, stats.SpecialAttack, stats.SpecialDefense, stats.Speed} : pokemon.getStats().toArray();
            for (int i = 0; i < statValues.length; ++i) {
                graphics.m_280488_(this.f_96541_.f_91062_, String.valueOf(statValues[i]), statPosition, statHeights[i], 0xFFFFFF);
            }
        }
    }

    private void drawPokemonDetails(GuiGraphics graphics, Pokemon p, int spriteOffset, int textOffset, int descriptionOffset, int emptyOffset) {
        if (p != null) {
            Object descriptionLang;
            String nameText;
            Object levelText;
            ScreenHelper.drawImageQuad(p.getSprite(), graphics, (float)this.f_96543_ / 2.0f + (float)spriteOffset, (float)this.f_96544_ / 2.0f - 33.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!p.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, graphics, (float)this.f_96543_ / 2.0f + (float)spriteOffset + 18.0f, (float)this.f_96544_ / 2.0f - 33.0f + 18.0f, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (p.isShiny() && !p.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.shiny, graphics, (float)this.f_96543_ / 2.0f + (float)spriteOffset - 3.0f, (float)this.f_96544_ / 2.0f - 16.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            PoseStack matrix = graphics.m_280168_();
            matrix.m_85836_();
            matrix.m_85841_(0.5f, 0.5f, 0.0f);
            if (p.isEgg()) {
                levelText = "???";
                nameText = Component.m_237115_((String)"pixelmon.egg").getString();
                descriptionLang = "gui.trader.eggDescription";
            } else {
                levelText = " " + p.getPokemonLevel();
                nameText = p.getNickname();
                descriptionLang = "pixelmon." + p.getSpecies().getName().toLowerCase(Locale.ROOT) + ".description";
            }
            graphics.m_280137_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.screenpokechecker.lvl").getString() + (String)levelText, this.f_96543_ + textOffset, this.f_96544_ - 62, 0xFFFFFF);
            graphics.m_280137_(this.f_96541_.f_91062_, nameText, this.f_96543_ + textOffset, this.f_96544_ - 10, 0xFFFFFF);
            ScreenHelper.drawSplitString(graphics, Component.m_237115_((String)descriptionLang).getString(), this.f_96543_ + descriptionOffset, this.f_96544_ - 55, 150, 0xFFFFFF);
        } else {
            PoseStack matrix = graphics.m_280168_();
            matrix.m_85836_();
            matrix.m_85841_(1.5f, 1.5f, 0.0f);
            graphics.m_280218_(Resources.tradeGui, this.f_96543_ / 3 + emptyOffset, this.f_96544_ / 3 - 20, 227, 242, 10, 14);
            matrix.m_85849_();
        }
    }

    public int hoveredPokemonSelectionIndex(double mouseX, double mouseY) {
        int index = -1;
        if (mouseX >= (double)((float)(this.f_96543_ - 190) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ - 140) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 140) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 190) / 2.0f) && ClientStorageManager.party.get(0) != null && !ClientStorageManager.party.get(0).hasFlag("untradeable")) {
            index = 0;
        }
        if (mouseX >= (double)((float)(this.f_96543_ - 140) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ - 90) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 140) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 190) / 2.0f) && ClientStorageManager.party.get(1) != null && !ClientStorageManager.party.get(1).hasFlag("untradeable")) {
            index = 1;
        }
        if (mouseX >= (double)((float)(this.f_96543_ - 90) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ - 40) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 140) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 190) / 2.0f) && ClientStorageManager.party.get(2) != null && !ClientStorageManager.party.get(2).hasFlag("untradeable")) {
            index = 2;
        }
        if (mouseX >= (double)((float)(this.f_96543_ - 40) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ + 10) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 140) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 190) / 2.0f) && ClientStorageManager.party.get(3) != null && !ClientStorageManager.party.get(3).hasFlag("untradeable")) {
            index = 3;
        }
        if (mouseX >= (double)((float)(this.f_96543_ + 10) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ + 60) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 140) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 190) / 2.0f) && ClientStorageManager.party.get(4) != null && !ClientStorageManager.party.get(4).hasFlag("untradeable")) {
            index = 4;
        }
        if (mouseX >= (double)((float)(this.f_96543_ + 60) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ + 110) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 140) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 190) / 2.0f) && ClientStorageManager.party.get(5) != null && !ClientStorageManager.party.get(5).hasFlag("untradeable")) {
            index = 5;
        }
        return index;
    }

    public void drawPokemonSelection(GuiGraphics matrix, double mouseX, double mouseY) {
        if (matrix != null) {
            switch (this.hoveredPokemonSelectionIndex(mouseX, mouseY)) {
                case 0: {
                    matrix.m_280218_(Resources.tradeGui, (this.f_96543_ - 190) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
                    break;
                }
                case 1: {
                    matrix.m_280218_(Resources.tradeGui, (this.f_96543_ - 140) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
                    break;
                }
                case 2: {
                    matrix.m_280218_(Resources.tradeGui, (this.f_96543_ - 90) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
                    break;
                }
                case 3: {
                    matrix.m_280218_(Resources.tradeGui, (this.f_96543_ - 40) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
                    break;
                }
                case 4: {
                    matrix.m_280218_(Resources.tradeGui, (this.f_96543_ + 10) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
                    break;
                }
                case 5: {
                    matrix.m_280218_(Resources.tradeGui, (this.f_96543_ + 60) / 2, (this.f_96544_ + 140) / 2, 1, 206, 26, 24);
                }
            }
        }
    }

    private boolean hasOtherHatchedPokemon(int except) {
        for (int slot = 0; slot < 6; ++slot) {
            Pokemon pokemon;
            if (slot == except || (pokemon = ClientStorageManager.party.get(slot)) == null || pokemon.isEgg()) continue;
            return true;
        }
        return ClientTradingManager.tradeTarget == null || !ClientTradingManager.tradeTarget.isEgg();
    }

    public boolean hoveredButtonTrade(double mouseX, double mouseY) {
        return mouseX >= (double)((float)(this.f_96543_ - 72) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ + 70) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 26) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 62) / 2.0f);
    }

    public boolean drawButtonTrade(GuiGraphics matrix, double mouseX, double mouseY) {
        if (this.hoveredButtonTrade(mouseX, mouseY)) {
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            matrix.m_280218_(Resources.tradeGui, (this.f_96543_ - 72) / 2, (this.f_96544_ + 26) / 2, 28, 205, 72, 19);
            matrix.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.trade").getString(), (this.f_96543_ - 30) / 2, (this.f_96544_ + 38) / 2, 0xFFFFA0);
            matrix.m_280168_().m_85849_();
            return true;
        }
        return false;
    }

    public boolean isOverCloseButton(double mouseX, double mouseY) {
        return mouseX >= (double)((float)(this.f_96543_ + 213) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ + 248) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 199) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 170) / 2.0f);
    }

    public boolean hoveredButtonReady(double mouseX, double mouseY) {
        return mouseX >= (double)((float)(this.f_96543_ + 123) / 2.0f) && mouseX <= (double)((float)(this.f_96543_ + 197) / 2.0f) && mouseY <= (double)((float)(this.f_96544_ + 179) / 2.0f) && mouseY >= (double)((float)(this.f_96544_ + 148) / 2.0f);
    }

    public boolean drawButtonReady(GuiGraphics matrix, double mouseX, double mouseY) {
        if (this.hoveredButtonReady(mouseX, mouseY)) {
            matrix.m_280218_(Resources.tradeGui, (this.f_96543_ + 122) / 2, (this.f_96544_ + 148) / 2, 28, 225, 38, 16);
            matrix.m_280488_(this.f_96541_.f_91062_, Component.m_237115_((String)"gui.trading.ready").getString(), (this.f_96543_ + 130) / 2, (this.f_96544_ + 157) / 2, 0xFFFFA0);
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        if (this.isOverCloseButton(mouseX, mouseY)) {
            this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), SoundEvents.f_12088_, SoundSource.AMBIENT, 0.7f, 1.0f);
            this.f_96541_.f_91074_.m_6915_();
            if (!ClientProxy.battleManager.evolveList.isEmpty()) {
                this.f_96541_.m_91152_((Screen)new EvolveScreen());
            }
        }
        if (ClientStorageManager.party.inTemporaryMode()) {
            return true;
        }
        if (this.hoveredButtonReady(mouseX, mouseY) && this.selected >= 0 && ClientTradingManager.tradeTarget != null) {
            this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), SoundEvents.f_12088_, SoundSource.AMBIENT, 0.7f, 1.0f);
            ClientTradingManager.player1Ready = !ClientTradingManager.player1Ready;
            NetworkHelper.sendToServer(new ServerTradesPacket(ClientTradingManager.player1Ready, this.tradeMachine));
        }
        if (this.hoveredButtonTrade(mouseX, mouseY) && ClientTradingManager.player1Ready && ClientTradingManager.player2Ready) {
            Pokemon[] party = ClientStorageManager.party.getAll();
            if (this.selected >= 0 && this.selected >= 0 && party[this.selected] != null && (!party[this.selected].isEgg() || ClientTradingManager.targetPartyIsMoreThanOnePokemon) && this.hasOtherHatchedPokemon(this.selected)) {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), SoundEvents.f_12088_, SoundSource.AMBIENT, 0.7f, 1.0f);
                NetworkHelper.sendToServer(ServerTradesPacket.getTradePacket(this.tradeMachine));
            }
        }
        if (this.hoveredPokemonSelectionIndex(mouseX, mouseY) != -1) {
            this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), SoundEvents.f_12088_, SoundSource.AMBIENT, 0.7f, 1.0f);
            this.selected = this.hoveredPokemonSelectionIndex(mouseX, mouseY);
            NetworkHelper.sendToServer(new ServerTradesPacket(this.selected, this.tradeMachine));
            ClientTradingManager.player1Ready = false;
            ClientTradingManager.player2Ready = false;
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }
}

