/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.EggRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.ScoreboardJustification;
import com.pixelmonmod.pixelmon.client.render.OverlayToggles;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class ScreenHelper {
    public static Font getFont(String font, boolean extendedColours) {
        return Minecraft.m_91087_().f_91062_;
    }

    public static void drawString(GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawString(graphics, Minecraft.m_91087_().f_91062_, text, x, y, color, dropShadow, false);
    }

    public static void drawString(GuiGraphics graphics, Font font, String text, float x, float y, int color) {
        ScreenHelper.drawString(graphics, font, text, x, y, color, false, false);
    }

    public static void drawString(GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        ScreenHelper.drawString(graphics, Minecraft.m_91087_().f_91062_, text, x, y, color, dropShadow, unicode);
    }

    public static void drawString(GuiGraphics graphics, Font fr, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawString(graphics, fr, text, x, y, color, dropShadow, false);
    }

    public static void drawString(GuiGraphics graphics, Font fr, String text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        boolean force = Minecraft.m_91087_().m_91390_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        graphics.drawString(fr, text, x, y, color, dropShadow);
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
    }

    public static void drawString(GuiGraphics graphics, Font fr, Component text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        boolean force = Minecraft.m_91087_().m_91390_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        graphics.drawString(fr, text.m_7532_(), x, y, color, dropShadow);
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
    }

    public static void drawString(GuiGraphics graphics, Font fr, String text, float x, float y, int color, boolean dropShadow, boolean unicode, boolean centered) {
        boolean force = Minecraft.m_91087_().m_91390_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        if (centered) {
            ScreenHelper.drawCenteredString(graphics, fr, text, x, y, color, dropShadow);
        } else {
            graphics.drawString(fr, text, x, y, color, dropShadow);
        }
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
    }

    public static void drawInUnicode(Runnable runnable) {
        boolean force = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        runnable.run();
        Minecraft.m_91087_().m_91336_(force);
    }

    public static void drawStringRightAligned(GuiGraphics graphics, String text, float x, float y, int color) {
        ScreenHelper.drawStringRightAligned(graphics, text, x, y, color, false);
    }

    public static void drawStringRightAligned(GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawStringRightAligned(graphics, text, x, y, color, dropShadow, false);
    }

    public static void drawStringRightAligned(GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, boolean unicode) {
        boolean force = Minecraft.m_91087_().m_91390_();
        PoseStack matrix = graphics.m_280168_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        ScreenHelper.drawString(graphics, fontRenderer, text, x -= (float)fontRenderer.m_92895_(text), y, color, dropShadow, unicode);
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
    }

    public static void drawScaledString(GuiGraphics graphics, String text, float x, float y, int color, float fontSize) {
        float scalar = fontSize / 16.0f;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(scalar, scalar, 1.0f);
        ScreenHelper.drawString(graphics, text, x / scalar, y / scalar, color);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
    }

    public static void drawScaledCenteredString(GuiGraphics graphics, String text, float x, float y, int color, float fontSize) {
        float scalar = fontSize / 16.0f;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(scalar, scalar, 1.0f);
        ScreenHelper.drawCenteredString(graphics, text, x / scalar, y / scalar, color);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
    }

    public static void drawScaledStringWithOutline(GuiGraphics graphics, String text, float x, float y, int color, int outlineColor, float fontSize, float outline) {
        int i = 0;
        while (i < text.length()) {
            String character = text.substring(i, i + 1);
            ScreenHelper.drawScaledCenteredString(graphics, character, x, y - outline / 4.0f, outlineColor, fontSize);
            ScreenHelper.drawScaledCenteredString(graphics, character, x, y, color, fontSize - outline);
            if (i == 0) {
                x -= (float)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(text.charAt(i))) / 2.0f;
            }
            x += (float)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(text.charAt(i++)));
        }
    }

    public static void drawScaledStringRightAligned(GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, float fontSize) {
        float scalar = fontSize / 16.0f;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_85841_(scalar, scalar, 1.0f);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        x = (float)((double)x - (double)((float)fontRenderer.m_92895_(text) * fontSize) / 16.0);
        ScreenHelper.drawString(graphics, fontRenderer, text, x / scalar, y / scalar, color, dropShadow, false);
        matrix.m_85849_();
    }

    public static String splitStringToFit(String s, int font, int width) {
        int i = 0;
        block0: while (i < ((String)s).length()) {
            int j = 0;
            while (j < width) {
                if (++i >= ((String)s).length()) {
                    return s;
                }
                j = (int)((double)j + (double)Minecraft.m_91087_().f_91062_.m_92895_(String.valueOf(((String)s).charAt(i))) * ((double)font / 16.0));
            }
            if (((String)s).substring(0, i).contains(" ")) {
                for (j = i; j > 0; --j) {
                    if (((String)s).charAt(j) != ' ') continue;
                    s = ((String)s).substring(0, j).trim() + "\n" + ((String)s).substring(j).trim();
                    continue block0;
                }
                continue;
            }
            s = ((String)s).substring(0, i).trim() + "\n" + ((String)s).substring(i).trim();
        }
        return s;
    }

    public static void simpleDrawImageQuad(ResourceLocation texture, GuiGraphics graphics, float x, float y, float w, float h, float us, float vs, float ue, float ve, float zLevel) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, x, y + h, zLevel).m_7421_(us, ve).m_5752_();
        buffer.m_252986_(matrix, x + w, y + h, zLevel).m_7421_(ue, ve).m_5752_();
        buffer.m_252986_(matrix, x + w, y, zLevel).m_7421_(ue, vs).m_5752_();
        buffer.m_252986_(matrix, x, y, zLevel).m_7421_(us, vs).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void drawImageQuad(ResourceLocation texture, GuiGraphics graphics, float x, float y, float w, float h, float us, float vs, float ue, float ve, float zLevel) {
        ScreenHelper.drawImageQuad(texture, graphics, x, y, w, h, us, vs, ue, ve, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
    }

    public static void drawImageQuad(ResourceLocation texture, GuiGraphics graphics, float x, float y, float w, float h, float us, float vs, float ue, float ve, float a, float zLevel) {
        ScreenHelper.drawImageQuad(texture, graphics, x, y, w, h, us, vs, ue, ve, 1.0f, 1.0f, 1.0f, a, zLevel);
    }

    public static void drawImageQuad(ResourceLocation texture, GuiGraphics graphics, float x, float y, float w, float h, float us, float vs, float ue, float ve, float r, float g, float b, float a, float zLevel) {
        PoseStack matrix = graphics.m_280168_();
        Minecraft.m_91087_().m_91097_().m_174784_(texture);
        int texW = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int texH = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        float u = ue - us;
        float v = ve - vs;
        matrix.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280246_(r, g, b, a);
        int ix = (int)x;
        int iy = (int)y;
        matrix.m_252880_(x - (float)ix, y - (float)iy, zLevel);
        graphics.m_280163_(texture, ix, iy, us * (float)texW, vs * (float)texH, (int)w, (int)h, u == 1.0f ? (int)w : texW, v == 1.0f ? (int)h : texH);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
    }

    public static void drawImageQuadUV(ResourceLocation texture, GuiGraphics graphics, float x, float y, float w, float h, float us, float vs, float u, float v, float r, float g, float b, float a, float zLevel) {
        PoseStack matrix = graphics.m_280168_();
        Minecraft.m_91087_().m_91097_().m_174784_(texture);
        int texW = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int texH = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        graphics.m_280246_(r, g, b, a);
        matrix.m_85836_();
        matrix.m_252880_(x, y, zLevel);
        graphics.m_280411_(texture, 0, 0, (int)w, (int)h, us, vs, (int)u, (int)v, texW, texH);
        matrix.m_85849_();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void drawImage(ResourceLocation texture, GuiGraphics graphics, float x, float y, float width, float height, float zLevel) {
        ScreenHelper.drawImageQuad(texture, graphics, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
    }

    public static void drawImage(GuiGraphics graphics, ResourceLocation texture, float x, float y, float width, float height, float zLevel) {
        ScreenHelper.drawImageQuad(texture, graphics, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
    }

    public static void drawImage(ResourceLocation texture, GuiGraphics graphics, float x, float y, float width, float height, float r, float g, float b, float a, float zLevel) {
        ScreenHelper.drawImageQuad(texture, graphics, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, zLevel);
    }

    public static void drawImage(GuiGraphics graphics, ResourceLocation texture, float x, float y, float width, float height, float r, float g, float b, float a, float zLevel) {
        ScreenHelper.drawImageQuad(texture, graphics, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, zLevel);
    }

    public static void drawScaledImage(GuiGraphics graphics, ResourceLocation texture, float scale, float x, float y, float width, float height, float r, float g, float b, float a, float zLevel) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_252880_(x, y, 0.0f);
        matrix.m_85841_(scale, scale, 1.0f);
        ScreenHelper.drawImageQuad(texture, graphics, 0.0f, 0.0f, width, height, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, zLevel);
        matrix.m_85849_();
    }

    public static void drawSquashedString(GuiGraphics graphics, Font fr, String text, boolean unicode, float widthFactor, float x, float y, int color, boolean shadow) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        Minecraft.m_91087_().m_91336_(unicode);
        float nameSize = fr.m_92895_(text);
        boolean offset = false;
        nameSize -= (float)offset;
        if (nameSize > widthFactor) {
            float scaleFactor = widthFactor / nameSize;
            matrix.m_252880_(x, 0.0f, 0.0f);
            matrix.m_85841_(scaleFactor, 1.0f, 1.0f);
            matrix.m_252880_(-x, 0.0f, 0.0f);
        }
        graphics.drawString(fr, text, x, y, color, shadow);
        matrix.m_85849_();
        Minecraft.m_91087_().m_91336_(false);
    }

    public static void drawSquashedString(GuiGraphics graphics, Font fr, Component text, boolean unicode, float widthFactor, float x, float y, int color, boolean shadow) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        Minecraft.m_91087_().m_91336_(unicode);
        float nameSize = fr.m_92852_((FormattedText)text);
        boolean offset = false;
        nameSize -= (float)offset;
        if (nameSize > widthFactor) {
            float scaleFactor = widthFactor / nameSize;
            matrix.m_252880_(x, 0.0f, 0.0f);
            matrix.m_85841_(scaleFactor, 1.0f, 1.0f);
            matrix.m_252880_(-x, 0.0f, 0.0f);
        }
        graphics.drawString(fr, text.m_7532_(), x, y, color, shadow);
        matrix.m_85849_();
        Minecraft.m_91087_().m_91336_(false);
    }

    public static void drawCenteredSquashedString(GuiGraphics graphics, String text, boolean unicode, double widthFactor, int x, int y, int color, boolean shadow) {
        ScreenHelper.drawCenteredSquashedString(graphics, Minecraft.m_91087_().f_91062_, text, unicode, widthFactor, x, y, color, shadow);
    }

    public static void drawCenteredSquashedString(GuiGraphics graphics, Font fr, String text, boolean unicode, double widthFactor, int x, int y, int color, boolean shadow) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        double nameSize = fr.m_92895_(text);
        boolean offset = false;
        nameSize -= (double)offset;
        if (nameSize > widthFactor) {
            float scaleFactor = (float)(widthFactor / nameSize);
            matrix.m_252880_((float)x, 0.0f, 0.0f);
            matrix.m_85841_(scaleFactor, 1.0f, 1.0f);
            matrix.m_252880_((float)(-x), 0.0f, 0.0f);
        }
        matrix.m_85837_(-nameSize / 2.0, 0.0, 0.0);
        ScreenHelper.drawString(graphics, text, x, (float)y, color, shadow, unicode);
        matrix.m_85849_();
    }

    public static void bindPokemonSprite(Pokemon pokemon, Minecraft mc) {
        ScreenHelper.bindTexture(pokemon.getSprite());
    }

    public static ResourceLocation getPokemonSprite(PixelmonClientData pokemon, Minecraft mc) {
        if (pokemon == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        Stats form = pokemon.species.getForm(pokemon.form);
        if (form == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        GenderProperties genderProperties = form.getGenderProperties(pokemon.getGender());
        if (genderProperties == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        PaletteProperties currentPalette = genderProperties.getPalette(pokemon.palette);
        PaletteProperties palette = pokemon.mega || pokemon.dynamax == 2 ? (currentPalette != null ? currentPalette : genderProperties.getDefaultPalette()) : currentPalette;
        if (palette == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        ResourceLocation sprite = palette.getSprite();
        if (sprite == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        return sprite;
    }

    public static ResourceLocation getPokemonSprite(Species species, String form, Gender gender, String palette, int eggCycles, Minecraft mc) {
        if (eggCycles > 0) {
            return Resources.getEggSprite(species, eggCycles);
        }
        return species.getForm(form).getGenderProperties(gender).getPalette(palette).getSprite();
    }

    public static ResourceLocation getPokemonSprite(PokemonSpecification spec, Minecraft mc) {
        PaletteProperties foundPalette;
        GenderProperties genderProperties;
        Species species = spec.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe();
        if (species == null) {
            return Resources.egg;
        }
        String form = spec.getValue(FormRequirement.class).orElse(species.getDefaultForm().getName());
        if (spec.getValue(EggRequirement.class).orElse(false).booleanValue()) {
            return Resources.getEggSprite(species, species.getForm(form).getEggCycles());
        }
        Gender gender = spec.getValue(GenderRequirement.class).orElse(Gender.MALE);
        String palette = spec.getValue(PaletteRequirement.class).orElse("none");
        Stats foundForm = species.getForm(form);
        if (foundForm == null) {
            foundForm = species.getDefaultForm();
        }
        if ((genderProperties = foundForm.getGenderProperties(gender)) == null) {
            genderProperties = foundForm.getDefaultGenderProperties();
        }
        if ((foundPalette = genderProperties.getPalette(palette)) == null) {
            foundPalette = genderProperties.getDefaultPalette();
        }
        return foundPalette.getSprite();
    }

    public static void drawScoreboard(GuiGraphics graphics, int top, ScoreboardJustification justification, int x, int alpha, String title, Collection<String> lines, Collection<String> scores) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        PoseStack matrix = graphics.m_280168_();
        int tempWidth = ScreenHelper.getLongestStringWidth(lines);
        if (scores != null) {
            tempWidth += ScreenHelper.getLongestStringWidth(scores) + 20;
        }
        if (fontRenderer.m_92895_(title) > tempWidth) {
            tempWidth = fontRenderer.m_92895_(title);
        }
        int justifiedWidth = justification == ScoreboardJustification.RIGHT ? tempWidth : (justification == ScoreboardJustification.CENTER ? tempWidth / 2 : 0);
        int left = x - justifiedWidth - 3;
        int boxHeight = (lines.size() + 1) * 10;
        graphics.m_280509_(left, top, left + tempWidth, top + boxHeight, alpha);
        ScreenHelper.drawCenteredString(graphics, title, (float)left + (float)tempWidth / 2.0f, (float)top, -1);
        int y = top;
        for (String line : lines) {
            graphics.m_280488_(fontRenderer, line, left + 3, y += 10, -1);
        }
        y = top;
        if (scores != null) {
            for (String line : scores) {
                graphics.m_280488_(fontRenderer, line, left + tempWidth - 3 - fontRenderer.m_92895_(line), y += 10, -1);
            }
        }
    }

    public static int getLongestStringWidth(Collection<String> lines) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int longestStringWidth = 0;
        for (String line : lines) {
            int currentStringWidth = fontRenderer.m_92895_(line);
            if (currentStringWidth <= longestStringWidth) continue;
            longestStringWidth = currentStringWidth;
        }
        return longestStringWidth;
    }

    public static int getLongestWidth(Collection<Component> lines) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int longestStringWidth = 0;
        for (Component line : lines) {
            int currentStringWidth = fontRenderer.m_92852_((FormattedText)line);
            if (currentStringWidth <= longestStringWidth) continue;
            longestStringWidth = currentStringWidth;
        }
        return longestStringWidth;
    }

    public static String[] trimStringToWidth(Font fr, String string, int width) {
        ArrayList<String> strings = new ArrayList<String>();
        while (!string.isEmpty()) {
            String line = fr.m_92834_(string, width);
            strings.add(line);
            string = string.substring(line.length());
        }
        return strings.toArray(new String[0]);
    }

    public static Optional<int[]> renderTooltip(GuiGraphics graphics, int x, int y, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, String ... tooltipData) {
        Collection tooltipCollection = Arrays.stream(tooltipData).map(TextHelper::colour).collect(Collectors.toList());
        return ScreenHelper.renderTooltip(graphics, x, y, tooltipCollection, gradient1, background, alpha, centerBox, centerText);
    }

    public static Optional<int[]> renderTooltip(GuiGraphics graphics, int x, int y, Collection<Component> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, float zLevel) {
        if (tooltipData.isEmpty()) {
            return Optional.empty();
        }
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            // empty if block
        }
        PoseStack matrix = graphics.m_280168_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int longestStringWidth = ScreenHelper.getLongestWidth(tooltipData);
        int left = x;
        int top = y;
        if (centerBox) {
            left -= longestStringWidth / 2;
        }
        int boxHeight = 8;
        if (tooltipData.size() > 1) {
            boxHeight += (tooltipData.size() - 1) * 10;
        }
        matrix.m_85836_();
        matrix.m_252880_(0.0f, 0.0f, 1.0f);
        background = background & 0xFFFFFF | alpha << 24;
        graphics.m_280509_(left - 3, top - 4, left + longestStringWidth + 3, top - 3, background);
        graphics.m_280509_(left - 3, top + boxHeight + 3, left + longestStringWidth + 3, top + boxHeight + 4, background);
        graphics.m_280509_(left - 3, top - 3, left + longestStringWidth + 3, top + boxHeight + 3, background);
        graphics.m_280509_(left - 4, top - 3, left - 3, top + boxHeight + 3, background);
        graphics.m_280509_(left + longestStringWidth + 3, top - 3, left + longestStringWidth + 4, top + boxHeight + 3, background);
        int gradient2 = (gradient1 & 0xFFFFFF) >> 1 | gradient1 & 0xFF000000;
        ScreenHelper.drawGradientRect(graphics, left - 3, top - 3 + 1, zLevel, left - 3 + 1, top + boxHeight + 3 - 1, gradient1, gradient2);
        ScreenHelper.drawGradientRect(graphics, left + longestStringWidth + 2, top - 3 + 1, zLevel, left + longestStringWidth + 3, top + boxHeight + 3 - 1, gradient1, gradient2);
        ScreenHelper.drawGradientRect(graphics, left - 3, top - 3, zLevel, left + longestStringWidth + 3, top - 3 + 1, gradient1, gradient1);
        ScreenHelper.drawGradientRect(graphics, left - 3, top + boxHeight + 2, zLevel, left + longestStringWidth + 3, top + boxHeight + 3, gradient2, gradient2);
        for (Component line : tooltipData) {
            if (!centerText) {
                graphics.m_280430_(fontRenderer, line, left, top, -1);
            } else {
                ScreenHelper.drawCentered(graphics, line, (float)left + (float)longestStringWidth / 2.0f, top, -1, false);
            }
            top += 10;
        }
        matrix.m_85849_();
        if (!lighting) {
            // empty if block
        }
        return Optional.of(new int[]{left - 4, top - 4, left + longestStringWidth + 4, top + boxHeight + 4});
    }

    public static Optional<int[]> renderTooltip(GuiGraphics graphics, int x, int y, Collection<Component> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText) {
        return ScreenHelper.renderTooltip(graphics, x, y, tooltipData, gradient1, background, alpha, centerBox, centerText, 300.0f);
    }

    public static void drawString(GuiGraphics graphics, String text, float x, float y, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        graphics.drawString(fontRenderer, text, x, y, color, false);
        graphics.m_280091_().m_173043_();
    }

    public static int getStringWidth(String text) {
        return ScreenHelper.getStringWidth(text, false);
    }

    public static int getStringWidth(String text, boolean unicode) {
        boolean force = Minecraft.m_91087_().m_91390_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int width = fontRenderer.m_92895_(text);
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
        return width;
    }

    public static int getStringWidth(Component text, boolean unicode) {
        boolean force = Minecraft.m_91087_().m_91390_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int width = fontRenderer.m_92852_((FormattedText)text);
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
        return width;
    }

    public static void drawCenteredString(GuiGraphics graphics, String text, float x, float y, int color) {
        ScreenHelper.drawCenteredString(graphics, Minecraft.m_91087_().f_91062_, text, x, y, color, false);
    }

    public static void drawCenteredString(GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawCenteredString(graphics, Minecraft.m_91087_().f_91062_, text, x, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics graphics, Font fontRenderer, String text, float x, float y, int color) {
        ScreenHelper.drawCenteredString(graphics, fontRenderer, text, x, y, color, false);
    }

    public static void drawCenteredString(GuiGraphics graphics, Component text, float x, float y, int color, boolean dropShadow) {
        ScreenHelper.drawCenteredString(graphics, Minecraft.m_91087_().f_91062_, text, x, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics graphics, Font fontRenderer, String text, float x, float y, int color, boolean dropShadow) {
        graphics.drawString(fontRenderer, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, color, dropShadow);
    }

    public static void drawCenteredString(GuiGraphics graphics, Component text, float x, float y, int color) {
        ScreenHelper.drawCentered(graphics, text, x, y, color, false);
    }

    public static void drawCenteredString(GuiGraphics graphics, Font fontRenderer, Component text, float x, float y, int color, boolean dropShadow) {
        graphics.drawString(fontRenderer, text.m_7532_(), x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, color, dropShadow);
    }

    public static void drawCentered(GuiGraphics matrix, Component text, float x, float y, int color, boolean dropShadow) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        ScreenHelper.drawCentered(matrix, fontRenderer, text, x, y, color, dropShadow);
    }

    public static void drawCentered(GuiGraphics graphics, Font fontRenderer, Component text, float x, float y, int color, boolean dropShadow) {
        if (dropShadow) {
            graphics.drawString(fontRenderer, text.m_7532_(), x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, color, dropShadow);
        } else {
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, text, (int)x, (int)y, color);
        }
    }

    public static void drawCenteredSplitString(GuiGraphics matrix, String text, float x, float y, int maxLength, int color) {
        ScreenHelper.drawCenteredSplitString(matrix, text, x, y, maxLength, color, true);
    }

    public static void drawCenteredSplitString(GuiGraphics graphics, String text, float x, float y, int maxLength, int color, boolean dropShadow) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int textWidth = fontRenderer.m_92895_(text);
        int numLines = Math.max(1, (int)Math.ceil((float)textWidth / (float)maxLength));
        int lineWidth = text.length() / numLines;
        ArrayList<String> splitStrings = new ArrayList<String>(numLines);
        int lastIndex = 0;
        for (int i = 0; i < numLines - 1; ++i) {
            int spaceIndex = text.indexOf(" ", lastIndex + lineWidth);
            if (spaceIndex <= -1) continue;
            splitStrings.add(text.substring(lastIndex, spaceIndex + 1));
            lastIndex = spaceIndex + 1;
        }
        if (lastIndex < text.length()) {
            splitStrings.add(text.substring(lastIndex));
        }
        numLines = splitStrings.size();
        int currentY = (int)y - 6 * (numLines - 1);
        for (int i = 0; i < numLines; ++i) {
            ScreenHelper.drawCenteredString(graphics, fontRenderer, (String)splitStrings.get(i), x, (float)currentY, color, dropShadow);
            currentY += 12;
        }
    }

    public static String getLimitedString(String text, int maxLength) {
        String ellipses = "...";
        if (maxLength <= 3) {
            return ellipses;
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int textLength = text.length();
        Object drawText = text;
        if (textLength >= 4) {
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fontRenderer.m_92895_(String.valueOf(text.charAt(i)))) <= maxLength) continue;
                drawText = text.substring(0, i - 3) + ellipses;
                break;
            }
        }
        return drawText;
    }

    public static List<String> splitString(String text, int maxLength) {
        return ScreenHelper.splitString(text, maxLength, false);
    }

    public static List<String> splitString(String text, int maxLength, boolean unicode) {
        boolean force = Minecraft.m_91087_().m_91390_();
        if (unicode) {
            Minecraft.m_91087_().m_91336_(true);
        }
        ArrayList<String> splitString = new ArrayList<String>();
        if (text.isEmpty()) {
            splitString.add("");
        } else {
            String[] lines;
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            for (String line : lines = text.split("\n")) {
                String s = fontRenderer.m_92837_(line, maxLength, false);
                while (ScreenHelper.getStringWidth(line) > maxLength) {
                    splitString.add(s);
                    line = line.substring(s.length());
                    s = fontRenderer.m_92837_(line, maxLength, false);
                }
                splitString.add(s);
            }
        }
        if (unicode) {
            Minecraft.m_91087_().m_91336_(force);
        }
        return splitString;
    }

    public static String removeNewLine(String string) {
        int length = string.length();
        if (length > 0 && string.charAt(length - 1) == '\n') {
            return string.substring(0, length - 1);
        }
        return string;
    }

    public static void drawGradientRect(GuiGraphics graphics, int left, int top, float zLevel, int right, int bottom, int startColour, int endColour) {
        ScreenHelper.drawGradientRect(graphics, left, top, zLevel, right, bottom, startColour, endColour, false);
    }

    public static void drawGradientRect(GuiGraphics graphics, int left, int top, float zLevel, int right, int bottom, int startColour, int endColour, boolean horizontal) {
        float startAlpha = (float)(startColour >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColour >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColour >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColour & 0xFF) / 255.0f;
        float endAlpha = (float)(endColour >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColour >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColour >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColour & 0xFF) / 255.0f;
        ScreenHelper.drawGradientRect(graphics, left, top, zLevel, right, bottom, new Vector4f(startRed, startGreen, startBlue, startAlpha), new Vector4f(endRed, endGreen, endBlue, endAlpha), horizontal);
    }

    public static void drawGradientRect(GuiGraphics graphics, int left, int top, float zLevel, int right, int bottom, Vector4f startColour, Vector4f endColour, boolean horizontal) {
        PoseStack matrix = graphics.m_280168_();
        float startAlpha = startColour.w();
        float startRed = startColour.x();
        float startGreen = startColour.y();
        float startBlue = startColour.z();
        float endAlpha = endColour.w();
        float endRed = endColour.x();
        float endGreen = endColour.y();
        float endBlue = endColour.z();
        matrix.m_85836_();
        Matrix4f mat = matrix.m_85850_().m_252922_();
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        buffer.m_252986_(mat, (float)left, (float)top, zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        if (horizontal) {
            buffer.m_252986_(mat, (float)left, (float)bottom, zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        } else {
            buffer.m_252986_(mat, (float)left, (float)bottom, zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        }
        buffer.m_252986_(mat, (float)right, (float)bottom, zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        if (horizontal) {
            buffer.m_252986_(mat, (float)right, (float)top, zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        } else {
            buffer.m_252986_(mat, (float)right, (float)top, zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        }
        graphics.m_280091_().m_109912_(RenderType.m_285907_());
        matrix.m_85849_();
    }

    public static void drawBar(GuiGraphics graphics, double x, double y, double width, double height, float percent, Color color) {
        ScreenHelper.drawBar(graphics, x, y, width, height, percent, color, false);
    }

    public static void drawBar(GuiGraphics graphics, double x, double y, double width, double height, float percent, Color color, boolean flip) {
        ScreenHelper.drawBar(graphics, x, y, width, height, percent, color, Color.GRAY, flip);
    }

    public static void drawBar(GuiGraphics graphics, double x, double y, double width, double height, float percent, Color color, Color incomplete, boolean flip) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        Matrix4f mat = matrix.m_85850_().m_252922_();
        double barWidth = width - 6.0;
        buffer.m_252986_(mat, (float)x, (float)y, 0.0f).m_6122_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_252986_(mat, (float)x, (float)(y + height), 0.0f).m_6122_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_252986_(mat, (float)(x + barWidth), (float)(y + height), 0.0f).m_6122_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).m_5752_();
        buffer.m_252986_(mat, (float)(x + barWidth), (float)y, 0.0f).m_6122_(incomplete.getRed(), incomplete.getGreen(), incomplete.getBlue(), color.getAlpha()).m_5752_();
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        float curWidth = (float)((double)percent * barWidth);
        if (flip) {
            buffer.m_252986_(mat, (float)(x + (barWidth - (double)curWidth)), (float)y, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)(x + (barWidth - (double)curWidth)), (float)(y + height), 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)(x + barWidth), (float)(y + height), 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)(x + barWidth), (float)y, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        } else {
            buffer.m_252986_(mat, (float)x, (float)y, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)x, (float)(y + height), 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)(x + (double)curWidth), (float)(y + height), 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)(x + (double)curWidth), (float)y, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        }
        graphics.m_280091_().m_109911_();
        matrix.m_85849_();
    }

    public static void drawRectWithSemicircleEnds(GuiGraphics graphics, double x, double y, double z, double w, double h, int segments, Color color) {
        ScreenHelper.prepareSmoothDrawing(graphics.m_280168_());
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        double segment = Math.PI / (double)segments;
        double rad = h / 2.0;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85837_(x, y, z);
        Matrix4f mat = matrix.m_85850_().m_252922_();
        for (int pass = 1; pass <= 2; ++pass) {
            double dy;
            double dx;
            int i;
            if (pass == 2 && color == Color.WHITE) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((int)770, (int)771);
            }
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.triangleFan());
            for (i = segments; i >= 0; --i) {
                dx = -Math.sin(segment * (double)i) * rad;
                dy = Math.cos(segment * (double)i) * rad;
                buffer.m_252986_(mat, (float)dx, (float)(dy + rad), 0.0f).m_85950_(r, g, b, a).m_5752_();
            }
            buffer = graphics.m_280091_().m_6299_(PixelmonRendering.triangleFan());
            for (i = 0; i <= segments; ++i) {
                dx = Math.sin(segment * (double)i) * rad;
                dy = Math.cos(segment * (double)i) * rad;
                buffer.m_252986_(mat, (float)(w + dx), (float)(dy + rad), 0.0f).m_85950_(r, g, b, a).m_5752_();
            }
            buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
            buffer.m_252986_(mat, 0.0f, (float)h, 0.0f).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, (float)w, (float)h, 0.0f).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, (float)w, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        ScreenHelper.endSmoothDrawing(matrix);
    }

    public static void drawCircle(GuiGraphics matrix, double x, double y, double z, double d, int segments, Color color) {
        ScreenHelper.drawEllipse(matrix, x, y, z, d, d, segments, color);
    }

    public static void drawEllipse(GuiGraphics graphics, double x, double y, double z, double w, double h, int segments, Color color) {
        ScreenHelper.prepareSmoothDrawing(graphics.m_280168_());
        PoseStack matrix = graphics.m_280168_();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        double segment = Math.PI * 2 / (double)segments;
        double wr = w / 2.0;
        double hr = h / 2.0;
        matrix.m_85837_(x, y, z);
        Matrix4f mat = matrix.m_85850_().m_252922_();
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2 && color == Color.WHITE) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((int)770, (int)771);
            }
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.triangleFan());
            for (int i = 0; i <= segments; ++i) {
                double dx = Math.sin(segment * (double)i) * wr;
                double dy = Math.cos(segment * (double)i) * hr;
                buffer.m_252986_(mat, (float)(dx + wr), (float)(dy + hr), 0.0f).m_85950_(r, g, b, a).m_5752_();
            }
            graphics.m_280091_().m_109912_(PixelmonRendering.triangleFan());
        }
        ScreenHelper.endSmoothDrawing(matrix);
    }

    public static void drawQuad(GuiGraphics graphics, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2 && color == Color.WHITE) {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                RenderSystem.blendFunc((int)770, (int)771);
            }
            VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
            buffer.m_252986_(mat, x1, y1, z1).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, x2, y2, z2).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, x3, y3, z3).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(mat, x4, y4, z4).m_85950_(r, g, b, a).m_5752_();
            graphics.m_280091_().m_109911_();
        }
    }

    public static void prepareSmoothDrawing(PoseStack matrix) {
        matrix.m_85836_();
        GL11.glEnable((int)2881);
        GL11.glHint((int)3155, (int)4354);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }

    public static void endSmoothDrawing(PoseStack matrix) {
        GL11.glDisable((int)2881);
        matrix.m_85849_();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void drawEntity(GuiGraphics graphics, LivingEntity ent, int x, int y, float scale, float rotationYaw, float rotationPitch) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_252880_((float)x, (float)y, 50.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = QuaternionHelper.fromEuler(-(rotationPitch / 40.0f) * 20.0f, 1.0f, 0.0f, 0.0f);
        quaternionf.mul((Quaternionfc)quaternionf1);
        matrix.m_252781_(quaternionf);
        matrix.m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        float f2 = ent.f_20883_;
        float f3 = ent.f_19857_;
        float f4 = ent.f_19858_;
        float f5 = ent.f_20886_;
        float f6 = ent.f_20885_;
        ent.f_20883_ = rotationYaw / 40.0f * 20.0f;
        ent.f_19857_ = rotationYaw / 40.0f * 20.0f;
        ent.f_19858_ = -(rotationPitch / 40.0f) * 20.0f;
        ent.f_20885_ = ent.f_19857_;
        ent.f_20886_ = ent.f_19857_;
        matrix.m_252880_(0.0f, ent.m_6049_((Entity)ent), 0.0f);
        MultiBufferSource.BufferSource bufferSource = graphics.m_280091_();
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        if (renderManager.f_114358_ != null) {
            renderManager.f_114358_.setAnglesInternal(180.0f, 0.0f);
        }
        if (quaternionf1 != null) {
            quaternionf1.conjugate();
            renderManager.m_252923_(quaternionf1);
        }
        renderManager.m_114468_(false);
        Lighting.m_166384_();
        RenderSystem.runAsFancy(() -> renderManager.m_114384_((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (MultiBufferSource)bufferSource, 0xF000F0));
        renderManager.m_114468_(true);
        ent.f_20883_ = f2;
        ent.f_19857_ = f3;
        ent.f_19858_ = f4;
        ent.f_20886_ = f5;
        ent.f_20885_ = f6;
        matrix.m_85849_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
        Lighting.m_84931_();
    }

    public static void drawPokemonInfoChooseMove(GuiGraphics graphics, PixelmonClientData pokemon, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.m_91087_();
        ScreenHelper.drawImageQuad(ScreenHelper.getPokemonSprite(pokemon, mc), graphics, (float)width / 2.0f - 114.0f, (float)height / 2.0f - 76.0f, 64.0f, 64.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        ScreenHelper.drawCenteredString(graphics, pokemon.getDisplayName(), (float)width / 2.0f - 82.0f, (float)height / 2.0f + 8.0f, 0xFFFFFF);
        Element type1 = pokemon.getBaseStats().getTypes().get(0);
        Element type2 = pokemon.getBaseStats().getTypes().size() > 1 ? pokemon.getBaseStats().getTypes().get(1) : null;
        float x = type1.textureX;
        float y = type1.textureY;
        float x1 = 0.0f;
        float y1 = 0.0f;
        if (pokemon.getBaseStats().getTypes().size() > 1) {
            x1 = type2.textureX;
            y1 = type2.textureY;
        }
        if (type2 != null && type2 != Element.MYSTERY) {
            ScreenHelper.drawImageQuadUV(Resources.types, graphics, (float)width / 2.0f - 83.0f, (float)height / 2.0f - 84.0f, 21.0f, 21.0f, x1, y1, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
            ScreenHelper.drawImageQuadUV(Resources.types, graphics, (float)width / 2.0f - 107.0f, (float)height / 2.0f - 84.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        } else {
            ScreenHelper.drawImageQuadUV(Resources.types, graphics, (float)width / 2.0f - 93.0f, (float)height / 2.0f - 84.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        }
        graphics.drawString(mc.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.level, (float)width / 2.0f - 80.0f, (float)height / 2.0f - 94.0f, 0xFFFFFF, true);
        graphics.drawString(mc.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + pokemon.getDexNumber(), (float)width / 2.0f - 122.0f, (float)height / 2.0f - 94.0f, 0xFFFFFF, true);
    }

    public static void closeScreen() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_6915_();
        }
    }

    public static void switchFocus(int keyInt, List<EditBox> textFields) {
        EditBox[] textFieldArray = new EditBox[textFields.size()];
        ScreenHelper.switchFocus(keyInt, textFields.toArray(textFieldArray));
    }

    public static void switchFocus(int keyInt, EditBox ... textFields) {
        if (keyInt == 258) {
            for (int i = 0; i < textFields.length; ++i) {
                EditBox textField = textFields[i];
                if (!textField.m_93696_()) continue;
                textField.m_93692_(false);
                textFields[(i + 1) % textFields.length].m_93692_(true);
                return;
            }
            textFields[0].m_93692_(true);
        }
    }

    public static void drawAttackInfoBox(GuiGraphics graphics, float zLevel, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, (float)width / 2.0f + 100.0f, (float)height / 2.0f - 90.0f, 100.0f, 140.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.75f, zLevel);
        String text = I18n.m_118938_((String)"gui.choosemoveset.attackdetails", (Object[])new Object[0]);
        graphics.drawString(mc.f_91062_, text, (float)(width + 150) - (float)mc.f_91062_.m_92895_(text) / 2.0f, (float)(height - 92), 0, true);
    }

    public static void drawAttackInfoList(GuiGraphics graphics, Attack a, int width, int height) {
        PoseStack matrix = graphics.m_280168_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int y = height / 2 - 85;
        int x = width / 2 + 105;
        String powerString = I18n.m_118938_((String)"gui.choosemoveset.power", (Object[])new Object[0]) + ": ";
        powerString = a.getMove().getBasePower() > 0 ? powerString + a.getMove().getBasePower() : powerString + "--";
        graphics.m_280056_(fontRenderer, powerString, x, y + 3, 0, false);
        String accuracyString = I18n.m_118938_((String)"gui.battle.accuracy", (Object[])new Object[0]) + ": ";
        accuracyString = a.getMove().getAccuracy() > 0 ? accuracyString + a.getMove().getAccuracy() : accuracyString + "--";
        graphics.m_280056_(fontRenderer, accuracyString, x, y + 13, 0, false);
        graphics.m_280056_(fontRenderer, I18n.m_118938_((String)"nbt.pp", (Object[])new Object[0]) + " " + a.pp + "/" + a.getMaxPP(), x, y + 23, 0, false);
        String typeString = I18n.m_118938_((String)"gui.battle.type", (Object[])new Object[0]) + " ";
        graphics.m_280056_(fontRenderer, typeString, x, y + 33, 0, false);
        graphics.m_280056_(fontRenderer, a.getMove().getAttackType().getLocalizedName(), x + fontRenderer.m_92895_(typeString), y + 33, a.getMove().getAttackType().getColor(), false);
        String category = a.getMove().getAttackCategory().getLocalizedName();
        graphics.m_280056_(fontRenderer, category, x, y + 43, 0, false);
        ScreenHelper.drawSplitString(graphics, I18n.m_118938_((String)("attack." + a.getMove().getAttackName().replace(" ", "_").toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), x, y + 58, 95, 0);
    }

    public static void drawSplitString(GuiGraphics graphics, String text, int x, int y, int maxLength, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        for (FormattedCharSequence ireorderingprocessor : fontRenderer.m_92923_((FormattedText)Component.m_237113_((String)text), maxLength)) {
            graphics.drawString(fontRenderer, ireorderingprocessor, (float)x, (float)y, color, false);
            y += 9;
        }
    }

    public static void drawSplitString(GuiGraphics graphics, Component text, int x, int y, int maxLength, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        for (FormattedCharSequence ireorderingprocessor : fontRenderer.m_92923_((FormattedText)text, maxLength)) {
            graphics.drawString(fontRenderer, ireorderingprocessor, (float)x, (float)y, color, false);
            y += 9;
        }
    }

    public static void drawAttackInfoMoveset(GuiGraphics graphics, Attack attack, int y, int width, int height) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        graphics.drawString(fontRenderer, I18n.m_118938_((String)"gui.replaceattack.power", (Object[])new Object[0]), (float)width / 2.0f - 120.0f, (float)height / 2.0f + 60.0f, 0xFFFFFF, true);
        graphics.drawString(fontRenderer, I18n.m_118938_((String)"gui.replaceattack.accuracy", (Object[])new Object[0]), (float)width / 2.0f - 120.0f, (float)height / 2.0f + 70.0f, 0xFFFFFF, true);
        int bpextra = 0;
        int acextra = 0;
        if (attack.getMove().getBasePower() >= 100) {
            bpextra = fontRenderer.m_92895_("0");
        }
        if (attack.getMove().getAccuracy() >= 100) {
            acextra = fontRenderer.m_92895_("0");
        }
        String powerString = attack.getMove().getBasePower() > 0 ? "" + attack.getMove().getBasePower() : "--";
        graphics.drawString(fontRenderer, powerString, (float)width / 2.0f - 60.0f - (float)bpextra, (float)height / 2.0f + 60.0f, 0xFFFFFF, true);
        String accuracyString = attack.getMove().getAccuracy() > 0 ? "" + attack.getMove().getAccuracy() : "--";
        graphics.drawString(fontRenderer, accuracyString, (float)width / 2.0f - 60.0f - (float)acextra, (float)height / 2.0f + 70.0f, 0xFFFFFF, true);
        graphics.drawString(fontRenderer, attack.getMove().getAttackCategory() == null ? "" : attack.getMove().getAttackCategory().getLocalizedName(), (float)width / 2.0f - 120.0f, (float)height / 2.0f + 80.0f, 0xFFFFFF, true);
        ScreenHelper.drawSplitString(graphics, I18n.m_118938_((String)("attack." + attack.getMove().getAttackName().toLowerCase(Locale.ROOT).replace(" ", "_") + ".description"), (Object[])new Object[0]), width / 2 - 20, y, 135, 0xFFFFFF);
    }

    public static void drawMoveset(GuiGraphics graphics, Moveset moveset, int width, int height, float zLevel) {
        for (int i = 0; i < moveset.size(); ++i) {
            Attack move = moveset.get(i);
            graphics.drawString(Minecraft.m_91087_().f_91062_, move.getMove().getLocalizedName(), (float)width / 2.0f + 11.0f, (float)height / 2.0f - 85.0f + (float)(22 * i), 0xFFFFFF, true);
            graphics.drawString(Minecraft.m_91087_().f_91062_, move.pp + "/" + move.getMaxPP(), (float)width / 2.0f + 90.0f, (float)height / 2.0f - 83.0f + (float)(22 * i), 0xFFFFFF, false);
            float x = move.getMove().getAttackType().textureX;
            float y = move.getMove().getAttackType().textureY;
            ScreenHelper.drawImageQuadUV(Resources.types, graphics, (float)width / 2.0f - 23.0f, (float)height / 2.0f - 92.0f + (float)(22 * i), 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        }
    }

    public static int toColourValue(float red, float green, float blue, float alpha) {
        int r = (int)(red * 255.0f) & 0xFF;
        int g = (int)(green * 255.0f) & 0xFF;
        int b = (int)(blue * 255.0f) & 0xFF;
        int a = (int)(alpha * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (b << 8) + g;
    }

    public static PixelmonEntity getEntity(UUID pokemonUUID) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            for (Entity e : mc.f_91073_.m_104735_()) {
                PixelmonEntity pokemon;
                if (!(e instanceof PixelmonEntity) || !(pokemon = (PixelmonEntity)e).getPokemon().getUUID().equals(pokemonUUID)) continue;
                return pokemon;
            }
        }
        return null;
    }

    public static void drawDialogueBox(GuiGraphics graphics, Screen screen, String name, List<String> chatText, float zLevel) {
        ScreenHelper.drawDialogueBox(graphics, screen, name, String.join((CharSequence)"\n", chatText), zLevel);
    }

    public static void drawDialogueBox(GuiGraphics graphics, Screen screen, Component name, Component chatText, float zLevel) {
        ScreenHelper.drawDialogueBox(graphics, screen, name.getString(), chatText.getString(), zLevel);
    }

    public static void drawDialogueBox(GuiGraphics graphics, Screen screen, String name, String chatText, float zLevel) {
        Minecraft mc = Minecraft.m_91087_();
        ScreenHelper.drawImageQuad(Resources.evo, graphics, (float)screen.f_96543_ / 2.0f - 120.0f, (float)screen.f_96544_ / 4.0f - 40.0f, 240.0f, 80.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        graphics.drawString(mc.f_91062_, ChatFormatting.BOLD + name, (float)screen.f_96543_ / 2.0f - 107.0f, (float)screen.f_96544_ / 4.0f - 32.0f, 0xFFFFFF, true);
        ScreenHelper.drawCenteredSplitString(graphics, chatText, (float)screen.f_96543_ / 2.0f, (float)screen.f_96544_ / 4.0f - 2.0f, 200, 0xFFFFFF, false);
    }

    public static void drawBattleTimer(GuiGraphics graphics, Screen gui, int time) {
        Minecraft mc = Minecraft.m_91087_();
        time = Math.max(time, 0);
        String timerString = I18n.m_118938_((String)"battlecontroller.afktimer", (Object[])new Object[0]) + time;
        int color = time <= 5 ? 0xFF0000 : 0xFFFFFF;
        graphics.m_280488_(mc.f_91062_, timerString, gui.f_96543_ - mc.f_91062_.m_92895_(timerString) - 5, 5, color);
    }

    public static void drawPokemonHoverInfo(GuiGraphics graphics, Pokemon pokemon, int x, int y) {
        if (pokemon == null) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 5.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (x - 104 < 0) {
            x = 104;
        }
        int addition = 0;
        if (!pokemon.isEgg()) {
            if (pokemon.getForm() != null && !pokemon.getForm().isForm(PixelmonForms.NONE)) {
                addition += 10;
            }
            if (!pokemon.isDefaultPalette()) {
                addition += 10;
            }
        }
        graphics.m_280509_(x - 104, y - 2, x + 2, y + 20 + addition, -1437248170);
        String name = pokemon.getDisplayName();
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, name, x - 102, y, 0xFFFFFF);
        ScreenHelper.bindTexture(Resources.pixelmonOverlay);
        if (!pokemon.isEgg()) {
            if (pokemon.getGender() != Gender.NONE) {
                ResourceLocation rl = null;
                if (pokemon.getGender() == Gender.MALE) {
                    rl = Resources.male;
                } else if (pokemon.getGender() == Gender.FEMALE) {
                    rl = Resources.female;
                }
                if (rl != null) {
                    ScreenHelper.drawImageQuad(rl, graphics, mc.f_91062_.m_92895_(name) + x - 101, y, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
            int y2 = y;
            if (!pokemon.getForm().isForm(PixelmonForms.NONE)) {
                Font font = Minecraft.m_91087_().f_91062_;
                String string = I18n.m_118938_((String)"gui.screenpokechecker.form", (Object[])new Object[]{I18n.m_118938_((String)pokemon.getForm().getTranslationKey(), (Object[])new Object[0])});
                Objects.requireNonNull(mc.f_91062_);
                graphics.m_280488_(font, string, x - 102, y2 + 9, 0xFFFFFF);
                Objects.requireNonNull(mc.f_91062_);
                y2 += 9;
            }
            if (!pokemon.isDefaultPalette() && pokemon.getPalette() != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                String string = I18n.m_118938_((String)"gui.screenpokechecker.palette", (Object[])new Object[]{pokemon.getPalette().getTranslatedName().getString()});
                Objects.requireNonNull(mc.f_91062_);
                graphics.m_280488_(font, string, x - 102, y2 + 9, 0xFFFFFF);
                Objects.requireNonNull(mc.f_91062_);
                y2 += 9;
            }
            String level = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(mc.f_91062_);
            graphics.m_280488_(font, level, x - 101, y2 + 9 + 1, 0xFFFFFF);
            String health = pokemon.getHealth() > 0 ? I18n.m_118938_((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth() : I18n.m_118938_((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
            Font font2 = Minecraft.m_91087_().f_91062_;
            int n = x - 97 + mc.f_91062_.m_92895_(level);
            Objects.requireNonNull(mc.f_91062_);
            graphics.m_280488_(font2, health, n, y2 + 9 + 1, 0xFFFFFF);
            if (!pokemon.getHeldItem().m_41619_()) {
                graphics.m_280480_(pokemon.getHeldItem(), x - 16, y - 1);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    public static void drawScaledCenteredSplitString(GuiGraphics graphics, String text, float x, float y, int color, float fontSize, int maxLength, boolean dropShadow) {
        float scalar = fontSize / 16.0f;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85841_(scalar, scalar, 1.0f);
        ScreenHelper.drawCenteredSplitString(graphics, text, x / scalar, y / scalar, maxLength, color, dropShadow);
        matrix.m_85841_(1.0f / scalar, 1.0f / scalar, 1.0f);
    }

    public static void drawScaledSquashedString(GuiGraphics graphics, String text, float x, float y, int color, float fontSize, double widthFactor) {
        ScreenHelper.drawScaledSquashedString(graphics, text, x, y, color, fontSize, widthFactor, false);
    }

    public static void drawScaledSquashedString(GuiGraphics graphics, String text, float x, float y, int color, float fontSize, double widthFactor, boolean unicode) {
        float scalar = fontSize / 16.0f;
        PoseStack matrix = graphics.m_280168_();
        Font fr = Minecraft.m_91087_().f_91062_;
        Minecraft.m_91087_().m_91336_(unicode);
        double nameSize = fr.m_92895_(text);
        boolean offset = false;
        nameSize -= (double)offset;
        matrix.m_85836_();
        if (nameSize > widthFactor) {
            float scaleFactor = (float)(widthFactor / nameSize);
            matrix.m_252880_(x, 0.0f, 0.0f);
            matrix.m_85841_(scaleFactor, 1.0f, 1.0f);
            matrix.m_252880_(-x, 0.0f, 0.0f);
        }
        matrix.m_85841_(scalar, scalar, 1.0f);
        graphics.m_280056_(fr, text, (int)(x / scalar), (int)(y / scalar), color, false);
        Minecraft.m_91087_().m_91336_(false);
        matrix.m_85849_();
        RenderSystem.lineWidth((float)2.0f);
    }

    public static void drawScaledCenteredSplitString(GuiGraphics graphics, String text, float x, float y, int color, float fontSize, int maxLength) {
        ScreenHelper.drawScaledCenteredSplitString(graphics, text, x, y, color, fontSize, maxLength, true);
    }

    public static Screen getCurrentScreen() {
        return Minecraft.m_91087_().f_91080_;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.setShader(GameRenderer::m_172817_);
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
    }

    public static void drawBattleCursor(boolean draw, float x, float y, float z) {
        if (draw) {
            CursorHelper.setCursor(CursorHelper.BATTLE_CURSOR);
        } else {
            CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        }
    }

    public static void drawStar(GuiGraphics graphics, double x, double y, double z, double r1, double r2, int points, boolean outline, float r, float g, float b, float a) {
        PoseStack matrix = graphics.m_280168_();
        RenderSystem.lineWidth((float)1.0f);
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        Matrix4f mat = matrix.m_85850_().m_252922_();
        float change = (float)(Math.PI * 2 / (double)(points * 2));
        float angle = -change / 2.0f;
        if (outline) {
            GL11.glEnable((int)2848);
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.lineStrip());
            for (int i = 0; i <= points * 2; ++i) {
                double radius = i % 2 == 0 ? r1 : r2;
                double dx = Math.cos(angle) * radius;
                double dy = Math.sin(angle) * radius;
                buffer.m_252986_(mat, (float)dx, (float)dy, 0.0f).m_85950_(r, g, b, a).m_5752_();
                angle += change;
            }
        } else {
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.triangleFan());
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            for (int i = 0; i <= points * 2; ++i) {
                double radius = i % 2 == 0 ? r1 : r2;
                double dx = Math.cos(angle) * radius;
                double dy = Math.sin(angle) * radius;
                buffer.m_252986_(mat, (float)dx, (float)dy, 0.0f).m_85950_(r, g, b, a).m_5752_();
                angle -= change;
            }
        }
        matrix.m_85849_();
    }

    public static void disableMinecraftUI() {
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        OverlayToggles.disableOverlays(VanillaGuiOverlay.HOTBAR, VanillaGuiOverlay.SCOREBOARD, VanillaGuiOverlay.PLAYER_HEALTH, VanillaGuiOverlay.ARMOR_LEVEL, VanillaGuiOverlay.PLAYER_LIST, VanillaGuiOverlay.AIR_LEVEL, VanillaGuiOverlay.EXPERIENCE_BAR, VanillaGuiOverlay.MOUNT_HEALTH, VanillaGuiOverlay.FOOD_LEVEL, VanillaGuiOverlay.JUMP_BAR);
    }

    public static void enableMinecraftUI() {
        Minecraft.m_91087_().f_91066_.f_92062_ = false;
        OverlayToggles.resetOverlays();
    }

    public static void drawItem(GuiGraphics graphics, ItemStack stack, float x, float y, int srcFactor, int destFactor) {
        ScreenHelper.drawItem(graphics, stack, x, y, srcFactor, destFactor, false);
    }

    public static void drawItem(GuiGraphics graphics, ItemStack stack, float x, float y, int srcFactor, int destFactor, boolean darken) {
        graphics.m_280405_((LivingEntity)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.f_19853_, stack, (int)x, (int)y, srcFactor, destFactor);
    }
}

