/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.screens.OverlayScreenState;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.CameraOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.KeybindIcon;
import com.pixelmonmod.pixelmon.client.listener.SendoutListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.quests.client.ui.GuiKeybindIconQuest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class PixelmonOverlayScreen {
    public static final int SIDE_BAR_HEIGHT = 200;
    protected static final KeybindIcon POKEDEX_ICON = new KeybindIcon(ClientProxy.pokedexKeyBind, Resources.pokedexItemIcon);
    protected static final KeybindIcon WIKI_ICON = new KeybindIcon(ClientProxy.wikiKeyBind, Resources.wikiItemIcon);
    protected static final KeybindIcon TRAINER_CARD_ICON = new KeybindIcon(ClientProxy.trainerCardKeyBind, Resources.trainerCardItemIcon);
    protected static final KeybindIcon QUEST_ICON = new GuiKeybindIconQuest((KeyMapping)ClientProxy.questJournalKeyBind, ClientProxy.questCycleKeyBind);
    public static final List<KeybindIcon> ICONS = Lists.newArrayList();
    public static OverlayScreenState guiState = OverlayScreenState.ALL;
    public static String selectedMoveSkill;
    public static int targetId;
    public static boolean isVisible;
    private static String messageName;
    private static String oldMessageName;
    private static UUID uuid;
    private static UUID lastUuid;
    private static int fadeInTicks;
    private static int fadeOutTicks;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGuiEvent.Post event) {
        PoseStack matrix = event.getGuiGraphics().m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && !(mc.f_91080_ instanceof ChatScreen) && !isVisible) {
            return;
        }
        if (mc.f_91080_ instanceof InventoryScreen || mc.f_91066_.f_92062_ || mc.f_91080_ instanceof ItemDropsScreen) {
            return;
        }
        if (ClientStorageManager.party == null) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        matrix.m_85836_();
        CameraOverlayScreen.checkCameraOn();
        Window var5 = mc.m_91268_();
        int screenWidth = var5.m_85445_();
        int screenHeight = var5.m_85446_();
        if (CameraOverlayScreen.isCameraGuiOn) {
            CameraOverlayScreen.renderCamera(event.getGuiGraphics(), screenWidth, screenHeight, mc);
        } else {
            PixelmonOverlayScreen.checkSelection();
            PlayerPartyStorage party = ClientStorageManager.party;
            if (party != null && party.getAll() != null && party.getAll().length != 0 && party.getSelectedPokemon() != null) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                guiState.renderParty(event.getGuiGraphics(), Minecraft.m_91087_(), party.getSelectedSlot(), party.getAll());
            }
            Window eventResolution = event.getWindow();
            int scaledWidth = eventResolution.m_85445_();
            Pokemon pokemon = party.getSelectedPokemon();
            if (pokemon != null) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                int potionsOffset = player.m_21220_().size() * 12;
                boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (Level)mc.f_91073_);
                if (PixelmonConfigProxy.getGraphics().isShowCurrentAttackTarget() && isSentOut) {
                    ScreenHelper.drawImageQuad(Resources.targetArea, graphics, scaledWidth - 76 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ScreenHelper.drawString(graphics, StringUtils.capitalize((String)ClientProxy.actionKeyBind.getKey().m_84875_().getString()), scaledWidth - 50 - potionsOffset, 0.0f, 0xFFFFFF, false, true);
                    if (targetId != -1) {
                        LivingEntity entity = (LivingEntity)mc.f_91073_.m_6815_(targetId);
                        if (entity instanceof PixelmonEntity) {
                            Pokemon target = ((PixelmonEntity)entity).getPokemon();
                            ScreenHelper.drawImageQuad(target.getSprite(), graphics, scaledWidth - 75 - potionsOffset, 3.0f, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        } else if (entity instanceof Player) {
                            ScreenHelper.drawImageQuad(((AbstractClientPlayer)entity).m_294544_().f_290339_(), graphics, scaledWidth - 73 - potionsOffset, 5.0f, 18.0f, 18.0f, 0.125f, 0.125f, 0.25f, 0.25f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        } else if (entity instanceof NPCTrainer) {
                            ScreenHelper.drawImageQuad(DefaultPlayerSkin.m_293779_(), graphics, scaledWidth - 73 - potionsOffset, 5.0f, 18.0f, 18.0f, 0.125f, 0.125f, 0.25f, 0.25f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        }
                    } else {
                        ScreenHelper.drawImageQuad(Resources.notarget, graphics, scaledWidth - 76 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    }
                    ScreenHelper.drawImageQuad(Resources.targetAreaOver, graphics, scaledWidth - 76 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                } else {
                    targetId = -1;
                }
                if (isSentOut && PixelmonServerConfig.allowExternalMoves) {
                    MoveSkill selected;
                    ArrayList<MoveSkill> moveSkills = ClientProxy.getMoveSkills(ClientStorageManager.party.getSelectedPokemon());
                    MoveSkill moveSkill = selected = selectedMoveSkill == null ? null : CollectionHelper.find(moveSkills, ms -> ms.id.equals(selectedMoveSkill));
                    if (selected == null && !moveSkills.isEmpty()) {
                        selected = moveSkills.get(0);
                        selectedMoveSkill = selected.id;
                    }
                    if (selected != null) {
                        ScreenHelper.drawImageQuad(selected.sprite, graphics, scaledWidth - 42 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        double cooldownRatio = pokemon.getMoveSkillCooldownRatio(selected);
                        if (cooldownRatio != 1.0) {
                            int pixels = (int)((1.0 - cooldownRatio) * 24.0);
                            ScreenHelper.simpleDrawImageQuad(Resources.cooldown, graphics, scaledWidth - 43 - potionsOffset, 25 - pixels, 26.0f, pixels + 2, 0.0f, 1.0f - (float)pixels / 24.0f, 1.0f, 1.0f, 0.0f);
                        }
                        MoveSkill finalSelected = selected;
                        graphics.m_286007_(() -> PixelmonOverlayScreen.lambda$onRenderGameOverlay$1(graphics, scaledWidth, (Player)player, finalSelected, potionsOffset));
                    }
                }
            }
            this.renderSpectateMessage(graphics, screenWidth, screenHeight);
        }
        matrix.m_85849_();
    }

    public static void selectNextPixelmon() {
        if (ClientStorageManager.party.countAll() == 0 || ClientStorageManager.party.countPokemon() == 0) {
            return;
        }
        int selectedSlot = ClientStorageManager.party.getSelectedSlot();
        if (++selectedSlot >= 6) {
            selectedSlot = 0;
        }
        while (ClientStorageManager.party.get(selectedSlot) == null || ClientStorageManager.party.get(selectedSlot).isEgg()) {
            if (++selectedSlot < 6) continue;
            selectedSlot = 0;
        }
        ClientStorageManager.party.setSelectedSlot(selectedSlot, false);
        ClientStorageManager.party.sendClientUpdatePacket();
    }

    public static void selectPreviousPixelmon() {
        if (ClientStorageManager.party.countAll() == 0 || ClientStorageManager.party.countPokemon() == 0) {
            return;
        }
        int selectedSlot = ClientStorageManager.party.getSelectedSlot();
        if (--selectedSlot < 0) {
            selectedSlot = 5;
        }
        while (ClientStorageManager.party.get(selectedSlot) == null || ClientStorageManager.party.get(selectedSlot).isEgg()) {
            if (--selectedSlot >= 0) continue;
            selectedSlot = 5;
        }
        ClientStorageManager.party.setSelectedSlot(selectedSlot, false);
        ClientStorageManager.party.sendClientUpdatePacket();
    }

    public static void checkSelection() {
        Pokemon current = ClientStorageManager.party.getSelectedPokemon();
        if ((current == null || current.isEgg()) && !ClientProxy.battleManager.isBattling()) {
            PixelmonOverlayScreen.selectPreviousPixelmon();
        }
    }

    public static void showSpectateMessage(UUID playerUuid) {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(playerUuid);
        if (player == null) {
            return;
        }
        messageName = player.m_5446_().getString();
        uuid = playerUuid;
        fadeInTicks = 20;
    }

    public static void hideSpectateMessage(UUID playerUuid) {
        if (uuid == null) {
            fadeOutTicks = 0;
            messageName = null;
            return;
        }
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(uuid);
        if (player == null) {
            fadeOutTicks = 0;
            uuid = null;
            messageName = null;
            return;
        }
        fadeOutTicks = 15;
        oldMessageName = player.m_5446_().getString();
        lastUuid = uuid;
        if (uuid.equals(playerUuid)) {
            messageName = null;
            uuid = null;
        }
    }

    private void renderSpectateMessage(GuiGraphics graphics, int screenWidth, int screenHeight) {
        int c;
        float alpha;
        int width;
        String spectateString;
        if (messageName != null) {
            spectateString = I18n.m_118938_((String)"gui.spectate.spectateMessage", (Object[])new Object[]{I18n.m_118938_((String)ClientProxy.spectateKeyBind.m_90865_(), (Object[])new Object[0]), messageName});
            width = ScreenHelper.getStringWidth(spectateString, true);
            alpha = 1.0f - (float)fadeInTicks / 20.0f * 0.7f;
            c = ScreenHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            ScreenHelper.drawString(graphics, spectateString, (float)screenWidth / 2.0f - (float)width / 2.0f, (float)screenHeight / 2.0f + 30.0f, c, false, true);
        }
        if (oldMessageName != null && fadeOutTicks > 0) {
            spectateString = I18n.m_118938_((String)"gui.spectate.spectateMessage", (Object[])new Object[]{I18n.m_118938_((String)ClientProxy.spectateKeyBind.m_90865_(), (Object[])new Object[0]), oldMessageName});
            width = ScreenHelper.getStringWidth(spectateString, true);
            alpha = (float)fadeOutTicks / 15.0f * 0.7f;
            c = ScreenHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            ScreenHelper.drawString(graphics, spectateString, (float)screenWidth / 2.0f - (float)width / 2.0f, (float)screenHeight / 2.0f + 30.0f, c, false, true);
        }
    }

    public static void onPlayerTick() {
        if (fadeInTicks > 0) {
            --fadeInTicks;
        }
        if (fadeOutTicks > 0) {
            --fadeOutTicks;
        }
    }

    public static UUID getCurrentSpectatingUUID() {
        if (uuid != null) {
            return uuid;
        }
        if (lastUuid != null && fadeOutTicks > 0) {
            return lastUuid;
        }
        return null;
    }

    private static /* synthetic */ void lambda$onRenderGameOverlay$1(GuiGraphics graphics, int scaledWidth, Player player, MoveSkill finalSelected, int potionsOffset) {
        ScreenHelper.drawString(graphics, StringUtils.capitalize((String)ClientProxy.useMoveSkillKeyBind.getKey().m_84875_().getString()), scaledWidth - 17 - player.m_21220_().size() * 12, 0.0f, 0xFFFFFF, false, true);
        ScreenHelper.drawString(graphics, StringUtils.capitalize((String)ClientProxy.chooseMoveSkillKey.getKey().m_84875_().getString()), scaledWidth - 17 - player.m_21220_().size() * 12, 18.0f, 0xFFFFFF, false, true);
        String nameString = I18n.m_118938_((String)finalSelected.name, (Object[])new Object[0]);
        ScreenHelper.drawString(graphics, nameString, (float)(scaledWidth - 30 - potionsOffset) - (float)ScreenHelper.getStringWidth(nameString, true) / 2.0f, 26.0f, 0xFFFFFF, false, true);
    }

    static {
        targetId = -1;
        isVisible = true;
        messageName = null;
        oldMessageName = null;
        fadeInTicks = 0;
        fadeOutTicks = 0;
    }
}

