/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetMegaItemPacket;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.storage.ClientData;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector4f;

public class MegaItemScreen
extends Screen {
    private static final ResourceLocation DYNAMAX_BAND = ResourceLocationHelper.of("pixelmon", "textures/gui/megaItems/dynamax_band.png");
    private static final ResourceLocation MEGA_BRACELET_ORAS = ResourceLocationHelper.of("pixelmon", "textures/gui/megaItems/megabraceletoras.png");
    private static final ResourceLocation MEGA_NECKLESS = ResourceLocationHelper.of("pixelmon", "textures/gui/megaItems/meganeckless.png");
    private static final ResourceLocation MEGA_GLASSES = ResourceLocationHelper.of("pixelmon", "textures/gui/megaItems/mega_glasses.png");
    private static final ResourceLocation MEGA_ANCHOR = ResourceLocationHelper.of("pixelmon", "textures/gui/megaItems/mega_anchor.png");
    private static final ResourceLocation MEGA_TIARA = ResourceLocationHelper.of("pixelmon", "textures/gui/megaItems/mega_tiara.png");
    private final boolean isDynamax;

    public MegaItemScreen(boolean isDynamax) {
        super((Component)Component.m_237119_());
        this.isDynamax = isDynamax;
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawGradientRect(matrix, 0, 0, 0.0f, this.f_96543_, this.f_96544_, new Vector4f(0.0f, 0.0f, 0.0f, 0.4f), new Vector4f(0.0f, 0.0f, 0.0f, 0.4f), true);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        String s = I18n.m_118938_((String)(this.isDynamax ? "gui.dynamaxitem.message" : "gui.megaitem.message"), (Object[])new Object[0]);
        matrix.m_280137_(this.f_96541_.f_91062_, s, centerX, centerY - 75, 0xFFFFFF);
        if (this.isDynamax) {
            this.drawIcon(DYNAMAX_BAND, matrix, 50, -10, mouseX, mouseY);
            this.drawIcon(Resources.noItem, matrix, -40, -10, mouseX, mouseY);
        } else {
            this.drawIcon(MEGA_BRACELET_ORAS, matrix, -80, -10, mouseX, mouseY);
            this.drawIcon(MEGA_GLASSES, matrix, 5, -10, mouseX, mouseY);
            this.drawIcon(MEGA_ANCHOR, matrix, 90, -10, mouseX, mouseY);
            PixelExtrasData extras = PlayerExtraDataStore.get((Player)Minecraft.m_91087_().f_91074_);
            if (!extras.hasBoostedNecklace()) {
                this.drawIcon(MEGA_TIARA, matrix, -40, 70, mouseX, mouseY);
                this.drawIcon(Resources.noItem, matrix, 50, 70, mouseX, mouseY);
            } else {
                this.drawIcon(MEGA_TIARA, matrix, -80, 70, mouseX, mouseY);
                this.drawIcon(MEGA_NECKLESS, matrix, 5, 70, mouseX, mouseY);
                this.drawIcon(Resources.noItem, matrix, 90, 70, mouseX, mouseY);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.isDynamax) {
            this.checkIconClick(50, -10, mouseX, mouseY, EnumMegaItem.DynamaxBand);
            this.checkIconClick(-40, -10, mouseX, mouseY, EnumMegaItem.None);
        } else {
            this.checkIconClick(-80, -10, mouseX, mouseY, EnumMegaItem.BraceletORAS);
            this.checkIconClick(5, -10, mouseX, mouseY, EnumMegaItem.MegaGlasses);
            this.checkIconClick(90, -10, mouseX, mouseY, EnumMegaItem.MegaAnchor);
            PixelExtrasData extras = PlayerExtraDataStore.get((Player)Minecraft.m_91087_().f_91074_);
            if (!extras.hasBoostedNecklace()) {
                this.checkIconClick(-40, 70, mouseX, mouseY, EnumMegaItem.MegaTiara);
                this.checkIconClick(50, 70, mouseX, mouseY, EnumMegaItem.None);
            } else {
                this.checkIconClick(-80, 70, mouseX, mouseY, EnumMegaItem.MegaTiara);
                this.checkIconClick(5, 70, mouseX, mouseY, EnumMegaItem.BoostNecklace);
                this.checkIconClick(90, 70, mouseX, mouseY, EnumMegaItem.None);
            }
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        ClientData.openMegaItemGui = -1;
        super.m_7861_();
    }

    private void drawIcon(ResourceLocation rl, GuiGraphics matrix, int x, int y, int mouseX, int mouseY) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int buttonSize = 70;
        int buttonLeft = centerX - buttonSize / 2 + x;
        int buttonTop = centerY - buttonSize / 2 + y;
        if (mouseX >= buttonLeft && mouseX <= buttonLeft + buttonSize && mouseY >= buttonTop && mouseY <= buttonTop + buttonSize) {
            ScreenHelper.drawGradientRect(matrix, buttonLeft, buttonTop, 0.0f, buttonLeft + buttonSize, buttonTop + buttonSize, new Vector4f(0.8f, 0.8f, 0.8f, 1.0f), new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), true);
        } else {
            ScreenHelper.drawGradientRect(matrix, buttonLeft, buttonTop, 0.0f, buttonLeft + buttonSize, buttonTop + buttonSize, new Vector4f(0.2f, 0.2f, 0.2f, 1.0f), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), true);
        }
        ScreenHelper.drawImageQuad(rl, matrix, buttonLeft + 3, buttonTop + 3, buttonSize - 6, buttonSize - 6, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    private void checkIconClick(int x, int y, double mouseX, double mouseY, EnumMegaItem item) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int buttonSize = 70;
        int buttonLeft = centerX - buttonSize / 2 + x;
        int buttonTop = centerY - buttonSize / 2 + y;
        if (mouseX >= (double)buttonLeft && mouseX <= (double)(buttonLeft + buttonSize) && mouseY >= (double)buttonTop && mouseY <= (double)(buttonTop + buttonSize)) {
            PixelExtrasData extras;
            if (item == EnumMegaItem.BoostNecklace && !(extras = PlayerExtraDataStore.get((Player)Minecraft.m_91087_().f_91074_)).hasBoostedNecklace()) {
                this.f_96541_.f_91074_.m_6915_();
                return;
            }
            NetworkHelper.sendToServer(new SetMegaItemPacket(item));
            this.f_96541_.f_91074_.m_6915_();
        }
    }
}

