/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.dummy.DummyLocalPlayer;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.LabelWidget;
import com.pixelmonmod.pixelmon.client.gui.widgets.UpdatingImageButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerExtrasPacket;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public class ExtrasEditorScreen
extends DropDownScreen {
    private final PixelExtrasData client;
    private int centerW;
    private int centerH;
    private float scale;
    private float xRot;
    private float yRot;
    private DummyLocalPlayer dummyPlayer;

    public ExtrasEditorScreen() {
        super((Component)Component.m_237119_());
        this.centerW = this.f_96543_ / 2;
        this.centerH = this.f_96544_ / 2;
        this.scale = 80.0f;
        this.xRot = 0.0f;
        this.yRot = 0.0f;
        this.dummyPlayer = new DummyLocalPlayer();
        this.client = PlayerExtraDataStore.get(this.f_96541_.m_91094_().m_240411_());
    }

    @Override
    public void m_7856_() {
        ArrayList list;
        super.m_7856_();
        this.centerW = this.f_96543_ / 2;
        this.centerH = this.f_96544_ / 2;
        if (this.client.getAvailableHats().size() > 0) {
            this.m_142416_((GuiEventListener)new LabelWidget(I18n.m_118938_((String)"pixelmon.cosmetic.hat", (Object[])new Object[0]), 0, this.centerW - 140, this.centerH - 100, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.HatType[]{PixelExtrasData.HatType.NONE});
            list.addAll(this.client.getAvailableHats());
            this.addDropDown(new DropDown<PixelExtrasData.HatType>(list, this.client.getHatType(), this.centerW - 180, this.centerH - 80, 80, 100).setGetOptionString(hat -> I18n.m_118938_((String)("pixelmon.cosmetic.hat." + hat.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(hat -> {
                this.client.setHatType((PixelExtrasData.HatType)((Object)hat));
                this.client.setEnabled(PixelExtrasData.Category.HAT, true);
            }));
        }
        if (this.client.getAvailableSashs().size() > 0) {
            this.m_142416_((GuiEventListener)new LabelWidget(I18n.m_118938_((String)"pixelmon.cosmetic.sash", (Object[])new Object[0]), 0, this.centerW - 140, this.centerH - 40, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.SashType[]{PixelExtrasData.SashType.NONE});
            list.addAll(this.client.getAvailableSashs());
            this.addDropDown(new DropDown<PixelExtrasData.SashType>(list, this.client.getSashType(), this.centerW - 180, this.centerH - 20, 80, 100).setGetOptionString(sash -> I18n.m_118938_((String)("pixelmon.cosmetic.sash." + sash.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(sash -> {
                this.client.setSashType((PixelExtrasData.SashType)((Object)sash));
                this.client.setEnabled(PixelExtrasData.Category.SASH, true);
            }));
        }
        if (this.client.getAvailableRobes().size() > 0) {
            this.m_142416_((GuiEventListener)new LabelWidget(I18n.m_118938_((String)"pixelmon.cosmetic.robe", (Object[])new Object[0]), 0, this.centerW + 140, this.centerH - 100, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.RobeType[]{PixelExtrasData.RobeType.NONE});
            list.addAll(this.client.getAvailableRobes());
            this.addDropDown(new DropDown<PixelExtrasData.RobeType>(list, this.client.getRobeType(), this.centerW + 100, this.centerH - 80, 80, 100).setGetOptionString(robe -> I18n.m_118938_((String)("pixelmon.cosmetic.robe." + robe.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(robe -> {
                this.client.setRobeType((PixelExtrasData.RobeType)((Object)robe));
                this.client.setEnabled(PixelExtrasData.Category.ROBE, true);
            }));
        }
        if (this.client.getAvailableMonocles().size() > 0) {
            this.m_142416_((GuiEventListener)new LabelWidget(I18n.m_118938_((String)"pixelmon.cosmetic.monocle", (Object[])new Object[0]), 0, this.centerW + 140, this.centerH - 40, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.MonocleType[]{PixelExtrasData.MonocleType.NONE});
            list.addAll(this.client.getAvailableMonocles());
            this.addDropDown(new DropDown<PixelExtrasData.MonocleType>(list, this.client.getMonocleType(), this.centerW + 100, this.centerH - 20, 80, 100).setGetOptionString(monocle -> I18n.m_118938_((String)("pixelmon.cosmetic.monocle." + monocle.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(monocle -> {
                this.client.setMonocleType((PixelExtrasData.MonocleType)((Object)monocle));
                this.client.setEnabled(PixelExtrasData.Category.MONOCLE, true);
            }));
        }
        if (this.client.getAvailableWings().size() > 0) {
            this.m_142416_((GuiEventListener)new LabelWidget(I18n.m_118938_((String)"pixelmon.cosmetic.wings", (Object[])new Object[0]), 0, this.centerW, this.centerH - 100, 80, 30, 0xFFFFFF));
            list = Lists.newArrayList((Object[])new PixelExtrasData.WingType[]{PixelExtrasData.WingType.NONE});
            list.addAll(this.client.getAvailableWings());
            this.addDropDown(new DropDown<PixelExtrasData.WingType>(list, this.client.getWingType(), this.centerW - 40, this.centerH - 80, 80, 100).setGetOptionString(wings -> I18n.m_118938_((String)("pixelmon.cosmetic.wings." + wings.name().toLowerCase(Locale.ROOT).replace("_", "")), (Object[])new Object[0])).setOnSelected(wings -> {
                this.client.setWingType((PixelExtrasData.WingType)((Object)wings));
                this.client.setEnabled(PixelExtrasData.Category.WINGS, true);
            }));
        }
        if (this.m_7043_()) {
            int slot = 0;
            for (Pokemon pokemon : ClientStorageManager.party.getAll()) {
                if (pokemon == null) continue;
                this.m_142416_((GuiEventListener)new UpdatingImageButton(1, this.centerW - 30 * (ClientStorageManager.party.countAll() / 2 + 1) + ++slot * 30, this.f_96544_ - 35, 30, 30, () -> ClientStorageManager.party.get(pokemon.getPosition().order).getSprite(), 1.0f, 1.0f, 1.0f, onPress -> NetworkHelper.sendToServer(PlayerExtrasPacket.getSetTexturePacket(((StoragePosition)pokemon.getStorageAndPosition().m_14419_()).order + 1))));
            }
        }
        this.m_142416_((GuiEventListener)new Button(25, this.f_96544_ - 75, 50, 20, (Component)Component.m_237115_((String)"menu.discord"), onClick -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(e -> {
            if (e) {
                Util.m_137581_().m_137646_("https://discord.gg/pixelmon");
            }
            Minecraft.m_91087_().m_91152_((Screen)new ExtrasEditorScreen());
        }, "https://discord.gg/pixelmon", true)), p_253695_ -> Component.m_237119_()));
        this.m_142416_((GuiEventListener)new Button(25, this.f_96544_ - 50, 50, 20, (Component)Component.m_237115_((String)"menu.refresh"), onClick -> PlayerExtraDataStore.refreshClient(newData -> Minecraft.m_91087_().m_18707_(() -> Minecraft.m_91087_().m_91152_((Screen)new ExtrasEditorScreen()))), p_253695_ -> Component.m_237119_()));
        this.m_142416_((GuiEventListener)new Button(25, this.f_96544_ - 25, 50, 20, (Component)Component.m_237115_((String)"gui.cosmetic.back"), e -> this.m_7379_(), p_253695_ -> Component.m_237119_()));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        PoseStack matrix = graphics.m_280168_();
        if (this.f_96541_.f_91074_ != null) {
            matrix.m_85836_();
            matrix.m_252880_(0.0f, 0.0f, -30.0f);
            ScreenHelper.drawEntity(graphics, (LivingEntity)this.f_96541_.f_91074_, this.centerW, this.centerH + this.centerH / 2, this.scale, this.xRot, this.yRot);
            matrix.m_85849_();
        } else {
            matrix.m_85836_();
            ScreenHelper.drawEntity(graphics, (LivingEntity)this.dummyPlayer, this.centerW, this.centerH + this.centerH / 2, this.scale, this.xRot, this.yRot);
            matrix.m_85849_();
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(matrix, mouseX, mouseY, partialTicks);
    }

    public void m_7861_() {
        PlayerExtraDataStore.saveAndSend();
    }

    @Override
    public boolean m_7043_() {
        return Minecraft.m_91087_().f_91074_ != null;
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.m_7043_()) {
            Minecraft.m_91087_().m_91152_((Screen)new PauseScreen(true));
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!super.m_6050_(mouseX, mouseY, deltaX, deltaY)) {
            this.scale = (float)((double)this.scale + deltaY);
        }
        return true;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            this.xRot = (float)((double)this.xRot - dragX);
            this.yRot = (float)((double)this.yRot - dragY);
        }
        return true;
    }
}

