/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraScreen;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionResponsePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class EvolveScreen
extends CameraScreen {
    public static PixelmonEntity currentPokemon;
    boolean createdEntity = false;
    String newPokemon;
    String oldNickname;
    boolean cancelled = false;
    EvoInfo evoInfo = null;
    int ticks = 0;
    int fadeCount = 0;

    public EvolveScreen() {
        super(CameraMode.Evolution);
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        if (ClientProxy.battleManager.evolveList.isEmpty()) {
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        this.f_96541_.m_6937_(() -> {
            this.checkForPokemon();
            if (currentPokemon == null) {
                NetworkHelper.sendToServer(new EvolutionResponsePacket(this.evoInfo.pokemonUUID));
            }
        });
    }

    private void checkForPokemon() {
        if (ClientProxy.battleManager.evolveList.isEmpty() && this.evoInfo == null) {
            return;
        }
        if (this.evoInfo == null) {
            this.evoInfo = ClientProxy.battleManager.evolveList.get(0);
            ClientProxy.battleManager.evolveList.remove(0);
        }
        UUID pokemonUUID = this.evoInfo.pokemonUUID;
        this.newPokemon = this.evoInfo.evolveInto;
        currentPokemon = ScreenHelper.getEntity(pokemonUUID);
        Minecraft mc = Minecraft.m_91087_();
        if (currentPokemon == null) {
            return;
        }
        EvolveScreen.currentPokemon.f_21345_.m_262460_(goal -> true);
        if (ClientProxy.camera != null && PixelmonConfigProxy.getGraphics().isUseBattleCamera()) {
            ClientProxy.camera.revive();
            ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)currentPokemon));
            mc.m_91118_((Entity)ClientProxy.camera);
        } else {
            Entity renderEntity = Minecraft.m_91087_().m_91288_();
            ClientProxy.camera = new CameraEntity(EvolveScreen.currentPokemon.f_19853_);
            this.getCamera().revive();
            this.getCamera().m_6034_(renderEntity.m_20185_(), renderEntity.m_20186_() + 2.0, renderEntity.m_20189_());
            this.getCamera().f_19857_ = renderEntity.f_19857_;
            this.getCamera().f_19858_ = renderEntity.f_19858_;
            this.getCamera().f_20885_ = renderEntity.m_6080_();
            ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)currentPokemon));
            ClientProxy.camera.getMovement().generatePositions();
            this.f_96541_.f_91073_.m_104739_((Entity)ClientProxy.camera);
        }
        this.oldNickname = currentPokemon.getNickname();
        this.calcSizeDifference();
    }

    private void calcSizeDifference() {
        Stats bs = PixelmonSpecies.fromName(this.newPokemon).getValueUnsafe().getDefaultForm();
        Stats currentStats = currentPokemon.getForm();
        if (currentStats == null) {
            return;
        }
        Dimensions newData = bs.getDimensions();
        Dimensions currentData = currentPokemon.getForm().getDimensions();
        EvolveScreen.currentPokemon.heightDiff = (float)(newData.getHeight() - currentData.getHeight());
        EvolveScreen.currentPokemon.widthDiff = (float)(newData.getWidth() - currentData.getWidth());
        EvolveScreen.currentPokemon.lengthDiff = (float)(newData.getWidth() - currentData.getWidth());
    }

    @Override
    public void m_280273_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void m_280039_(GuiGraphics p_282281_) {
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
    }

    public void m_86600_() {
        super.m_86600_();
        if (currentPokemon != null && currentPokemon.getEvoStage() == EvolutionStage.Choice) {
            ++this.ticks;
            if (this.ticks >= 80) {
                NetworkHelper.sendToServer(new EvolutionResponsePacket(currentPokemon.getPokemon().getUUID(), true));
                EvolveScreen.currentPokemon.evolvingVal = 0;
                EvolveScreen.currentPokemon.evoAnimTicks = 0;
                this.ticks = 0;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int par3) {
        if (currentPokemon == null) {
            return false;
        }
        if (currentPokemon.getEvoStage() == EvolutionStage.Choice) {
            int xPos = this.f_96543_ / 2 - 30;
            int yPos = this.f_96544_ / 4 - 15;
            if (mouseX >= (double)xPos && mouseX <= (double)(xPos + 60) && mouseY >= (double)yPos && mouseY <= (double)(yPos + 17)) {
                NetworkHelper.sendToServer(new EvolutionResponsePacket(currentPokemon.getPokemon().getUUID(), false));
                currentPokemon.setEvoStage(null);
                this.cancelled = true;
            }
        } else if (!currentPokemon.isEvolving() || this.cancelled) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91074_.m_6915_();
            if (!ClientProxy.battleManager.evolveList.isEmpty()) {
                minecraft.m_91152_((Screen)new EvolveScreen());
            } else if (ServerStorageDisplay.bossDrops != null) {
                minecraft.m_91152_((Screen)new ItemDropsScreen());
            } else if (!ClientProxy.battleManager.newAttackList.isEmpty()) {
                minecraft.m_91152_((Screen)new BattleScreen());
            } else if (ClientData.openMegaItemGui >= 0) {
                minecraft.m_91152_((Screen)new MegaItemScreen(ClientData.openMegaItemGui > 0));
            } else {
                NetworkHelper.sendToServer(new BattleGuiClosedPacket());
            }
            minecraft.m_91118_((Entity)minecraft.f_91074_);
        }
        return true;
    }

    @Override
    public void m_7861_() {
        super.m_7861_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        String s;
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        if (currentPokemon == null) {
            this.checkForPokemon();
            return;
        }
        if (currentPokemon.getEvoStage() != EvolutionStage.PreAnimation && currentPokemon.getEvoStage() != EvolutionStage.PostAnimation) {
            ScreenHelper.drawImageQuad(Resources.evo, matrix, (float)this.f_96543_ / 2.0f - 120.0f, (float)this.f_96544_ / 4.0f - 40.0f, 240.0f, 40.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (currentPokemon.getEvoStage() == EvolutionStage.PreChoice) {
            s = I18n.m_118938_((String)"gui.guiEvolve.huh", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, s, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(s) / 2.0f, (float)this.f_96544_ / 4.0f - 30.0f, 0xFFFFFF, true);
        }
        if (currentPokemon.getEvoStage() == EvolutionStage.Choice) {
            this.oldNickname = currentPokemon.getEscapedNickname();
            s = I18n.m_118938_((String)"gui.guiEvolve.evolve", (Object[])new Object[]{this.oldNickname});
            matrix.drawString(this.f_96547_, s, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(s) / 2.0f, (float)this.f_96544_ / 4.0f - 30.0f, 0xFFFFFF, true);
            int xPos = this.f_96543_ / 2 - 30;
            int yPos = this.f_96544_ / 4 - 15;
            ResourceLocation rl = mouseX >= xPos && mouseX <= xPos + 60 && mouseY >= yPos && mouseY <= yPos + 17 ? Resources.buttonOver : Resources.button;
            ScreenHelper.drawImageQuad(rl, matrix, xPos, yPos, 60.0f, 17.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            s = I18n.m_118938_((String)"gui.cancel.text", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, s, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(s) / 2.0f, (float)this.f_96544_ / 4.0f - 11.0f, 0xFFFFFF, true);
        }
        if (this.cancelled) {
            s = I18n.m_118938_((String)"gui.guiEvolve.cancel", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, s, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(s) / 2.0f, (float)this.f_96544_ / 4.0f - 30.0f, 0xFFFFFF, true);
        } else if (!currentPokemon.isEvolving()) {
            s = I18n.m_118938_((String)"gui.guiEvolve.done", (Object[])new Object[]{this.oldNickname, currentPokemon.getLocalizedName()});
            matrix.drawString(this.f_96547_, s, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(s) / 2.0f, (float)this.f_96544_ / 4.0f - 30.0f, 0xFFFFFF, true);
        }
        this.m_280273_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean m_6913_() {
        return false;
    }
}

