/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera.movement;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class PositionedMovement
extends CameraMovement {
    int ticksToChange = 0;
    int currentPos = 0;
    ArrayList<BlockPos> cameraPositionList = new ArrayList();
    boolean initPokePos = false;
    boolean initDiagonals = false;

    public PositionedMovement(Level worldObj, CameraEntity camera) {
        super(worldObj, camera);
    }

    @Override
    public void onLivingUpdate() {
        if ((this.initDiagonals || this.initPokePos) && this.camera.m_6084_() && ClientProxy.battleManager.getViewEntity() != this.camera) {
            ClientProxy.battleManager.setViewEntity((Entity)this.camera);
            ClientProxy.camera = this.camera;
        }
        if (!PixelmonConfigProxy.getGraphics().isPlayerControlCamera() && this.cameraPositionList.size() > this.currentPos) {
            BlockPos cameraPosition = this.cameraPositionList.get(this.currentPos);
            if (!this.camera.m_20183_().equals((Object)cameraPosition)) {
                this.camera.m_6034_(cameraPosition.m_123341_(), cameraPosition.m_123342_(), cameraPosition.m_123343_());
            }
        }
        if (!this.initPokePos && ClientProxy.battleManager.getUserPokemon(this.camera.mode) != null) {
            this.generateCameraPositionsForPokemon();
        }
        if (!this.initDiagonals && ClientProxy.battleManager.getUserPokemon(this.camera.mode) != null) {
            this.generateCameraDiagonalsForPlayer();
        }
        --this.ticksToChange;
        int positionListSize = this.cameraPositionList.size();
        if (this.ticksToChange <= 0 && positionListSize > 0) {
            this.currentPos = RandomHelper.getRandom().nextInt(positionListSize);
            this.ticksToChange = RandomHelper.getRandom().nextInt(40) + 70;
        }
    }

    @Override
    public void generatePositions() {
        this.cameraPositionList.clear();
        this.initPokePos = false;
        this.initDiagonals = false;
        this.currentPos = 0;
        this.ticksToChange = RandomHelper.getRandom().nextInt(100) + 80;
        if (ClientProxy.battleManager.getUserPokemon(this.camera.mode) != null) {
            if (!this.initPokePos) {
                this.generateCameraPositionsForPokemon();
            }
            if (!this.initDiagonals) {
                this.generateCameraDiagonalsForPlayer();
            }
        }
    }

    private void generateCameraPositionsForPokemon() {
        this.initPokePos = true;
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (pix != null) {
            BlockPos pokemonPos = pix.m_20183_();
            Player player = ClientProxy.battleManager.getViewPlayer();
            BlockPos playerPos = player.m_20183_();
            for (int i = 0; i < 8; ++i) {
                BlockPos basePos = this.getRandomCameraPositionForPokemon(pokemonPos);
                BlockState blockState = this.world.m_8055_(basePos);
                if (!blockState.m_60795_() && !blockState.m_60713_(Blocks.f_49990_) || !this.canPosSee(basePos, playerPos)) continue;
                this.cameraPositionList.add(basePos);
            }
        }
        ClientProxy.battleManager.setViewEntity((Entity)this.camera);
    }

    private BlockPos getRandomCameraPositionForPokemon(BlockPos pokemonPos) {
        int x = pokemonPos.m_123341_() + RandomHelper.getRandom().nextInt(10) - 5;
        int y = pokemonPos.m_123342_() + RandomHelper.getRandom().nextInt(7) + 1;
        int z = pokemonPos.m_123343_() + RandomHelper.getRandom().nextInt(10) - 5;
        return new BlockPos(x, y, z);
    }

    private void generateCameraDiagonalsForPlayer() {
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (pix != null) {
            BlockPos pokemonPos = pix.m_20183_();
            Vector3f pokemonVec = new Vector3f((float)pokemonPos.m_123341_(), (float)pokemonPos.m_123342_(), (float)pokemonPos.m_123343_());
            pokemonVec.set(pokemonVec.x(), pokemonVec.y() + pix.m_20192_(), pokemonVec.z());
            if (!this.checkDiagonals(pokemonVec)) {
                return;
            }
        }
        this.initDiagonals = true;
    }

    private boolean checkDiagonals(Vector3f pokemonVec) {
        Player player = ClientProxy.battleManager.getViewPlayer();
        BlockPos playerPos = player.m_20183_();
        Vector4f playerVec = new Vector4f((float)playerPos.m_123341_(), (float)playerPos.m_123342_(), (float)playerPos.m_123343_(), 0.0f);
        playerVec.y = playerVec.y() + player.m_20192_();
        Vector4f distanceVec = new Vector4f();
        new Vector4f((Vector4fc)playerVec).sub((Vector4fc)new Vector4f(pokemonVec.x(), pokemonVec.y(), pokemonVec.z(), 0.0f), distanceVec);
        distanceVec.y = 0.0f;
        if (distanceVec.length() == 0.0f) {
            return false;
        }
        Vector4f firstDiag = new Vector4f((Vector4fc)distanceVec).normalize();
        float angle = 0.3926991f;
        Vector4f perp = new Vector4f();
        PositionedMovement.cross(firstDiag, new Vector4f(0.0f, 1.0f, 0.0f, 0.0f), perp);
        Vector4f rotated = this.rotateRoundGround(firstDiag, perp, angle);
        perp = perp.normalize();
        for (int i = 0; i < 6; ++i) {
            this.generateDiagonalPos(playerPos, playerVec, rotated, perp);
        }
        return true;
    }

    public static Vector4f cross(Vector4f left, Vector4f right, Vector4f dest) {
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    private void generateDiagonalPos(BlockPos playerPos, Vector4f playerVec, Vector4f rotated, Vector4f perp) {
        Vector4f newPos = new Vector4f();
        float scale = RandomHelper.getRandom().nextInt(2) + 3;
        Vector4f rotatedScaled = new Vector4f((Vector4fc)rotated);
        rotatedScaled.mul(scale);
        scale = RandomHelper.getRandom().nextInt(9) - 4;
        Vector4f perpScaled = new Vector4f((Vector4fc)perp);
        perpScaled.mul(scale);
        playerVec.add((Vector4fc)rotatedScaled, newPos);
        newPos.add((Vector4fc)perpScaled, newPos);
        BlockPos basePos = new BlockPos((int)newPos.x(), (int)newPos.y(), (int)newPos.z());
        BlockState mat = this.world.m_8055_(basePos);
        if ((mat.m_60795_() || mat.m_60713_(Blocks.f_49990_)) && this.canPosSee(basePos, playerPos)) {
            this.cameraPositionList.add(basePos);
        }
    }

    private Vector4f rotateRoundGround(Vector4f vector, Vector4f rotateVector, float angle) {
        Matrix4f matrix = new Matrix4f();
        matrix.m03(vector.x);
        matrix.m13(vector.y);
        matrix.m23(vector.z);
        matrix.rotate(angle, (Vector3fc)new Vector3f(rotateVector.x, rotateVector.y, rotateVector.z));
        if (matrix.m13() < 0.0f) {
            return this.rotateRoundGround(vector, rotateVector, -1.0f * angle);
        }
        return new Vector4f(matrix.m03(), matrix.m13(), matrix.m23(), 0.0f);
    }

    @Override
    public void setRandomPosition(CameraTarget t) {
        BlockPos randomPos = this.getRandomCameraPositionForPokemon(new BlockPos((int)t.getX(), (int)t.getY(), (int)t.getZ()));
        this.camera.m_6034_(randomPos.m_123341_(), randomPos.m_123342_(), randomPos.m_123343_());
    }
}

