/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera.movement;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetLocation;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;

public class PlayerControlledMovement
extends CameraMovement {
    private Vec3 centerPos;
    private Vec3 baseVec;
    private float radius = 0.0f;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private boolean spherePosChanged = false;
    private boolean initSphere = false;

    public PlayerControlledMovement(Level world, CameraEntity entityCamera) {
        super(world, entityCamera);
    }

    @Override
    public void setRandomPosition(CameraTarget t) {
        Direction direction = Minecraft.m_91087_().f_91074_.m_6350_().m_122424_();
        this.camera.m_6034_(this.camera.m_20185_() + (double)direction.m_122429_(), this.camera.m_20186_() + 2.0, this.camera.m_20189_() + (double)direction.m_122431_());
    }

    @Override
    public void onLivingUpdate() {
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (!this.initSphere) {
            this.generateSphere();
        }
        if (pix == null) {
            return;
        }
        PixelmonEntity opp = this.getOpponentPokemon();
        this.centerPos = new Vec3(pix.m_20185_(), pix.m_20186_(), pix.m_20189_());
        if (opp != null) {
            this.centerPos = new Vec3((this.centerPos.f_82479_ + opp.m_20185_()) / 2.0, (this.centerPos.f_82480_ + opp.m_20186_()) / 2.0, (this.centerPos.f_82481_ + opp.m_20189_()) / 2.0);
        }
        ClientProxy.battleManager.getPokeballEntity().ifPresent(entity -> {
            this.centerPos = entity.m_20182_();
        });
        this.camera.setTarget(new CameraTargetLocation(this.centerPos.f_82479_, this.centerPos.f_82480_, this.centerPos.f_82481_));
        this.baseVec = this.centerPos.m_82541_();
        this.updatePosition();
    }

    @Override
    public void updatePosition() {
        Matrix3f mat = this.constructYawMatrix();
        if (this.baseVec == null) {
            return;
        }
        Vec3 newPos = PlayerControlledMovement.multiply(mat, this.baseVec);
        mat = this.constructRotMatrix(newPos.m_82537_(new Vec3(0.0, 1.0, 0.0)), this.pitch);
        Vec3 rotPos = PlayerControlledMovement.multiply(mat, newPos);
        Vec3 testPos = new Vec3(this.centerPos.f_82479_ + rotPos.f_82479_ * (double)this.radius, this.centerPos.f_82480_ + rotPos.f_82480_ * (double)this.radius, this.centerPos.f_82481_ + rotPos.f_82481_ * (double)this.radius);
        this.camera.m_6034_(testPos.f_82479_, testPos.f_82480_, testPos.f_82481_);
        this.camera.updatePositionAndRotation();
    }

    private PixelmonEntity getOpponentPokemon() {
        if (this.camera.mode == CameraMode.Evolution) {
            return null;
        }
        if (ClientProxy.battleManager == null || ClientProxy.battleManager.displayedEnemyPokemon == null || ClientProxy.battleManager.displayedEnemyPokemon.length == 0) {
            return null;
        }
        UUID uuid = ClientProxy.battleManager.displayedEnemyPokemon[0].pokemonUUID;
        if (uuid != null) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null) {
                for (Entity entity : mc.f_91073_.m_104735_()) {
                    if (!entity.m_20148_().equals(uuid)) continue;
                    return (PixelmonEntity)entity;
                }
            }
        }
        return null;
    }

    private Matrix3f constructYawMatrix() {
        return this.constructRotMatrix(new Vec3(0.0, 1.0, 0.0), this.yaw);
    }

    private Matrix3f constructRotMatrix(Vec3 axis, float rot) {
        Matrix3f mat = new Matrix3f();
        mat.m00 = (float)(Math.cos(rot) + axis.f_82479_ * axis.f_82479_ * (1.0 - Math.cos(rot)));
        mat.m01 = (float)(axis.f_82479_ * axis.f_82480_ * (1.0 - Math.cos(rot)) - axis.f_82481_ * Math.sin(rot));
        mat.m02 = (float)(axis.f_82479_ * axis.f_82481_ * (1.0 - Math.cos(rot)) + axis.f_82480_ * Math.sin(rot));
        mat.m10 = (float)(axis.f_82479_ * axis.f_82480_ * (1.0 - Math.cos(rot)) + axis.f_82481_ * Math.sin(rot));
        mat.m11 = (float)(Math.cos(rot) + axis.f_82480_ * axis.f_82480_ * (1.0 - Math.cos(rot)));
        mat.m12 = (float)(axis.f_82480_ * axis.f_82481_ * (1.0 - Math.cos(rot)) - axis.f_82479_ * Math.sin(rot));
        mat.m20 = (float)(axis.f_82479_ * axis.f_82481_ * (1.0 - Math.cos(rot)) - axis.f_82480_ * Math.sin(rot));
        mat.m21 = (float)(axis.f_82480_ * axis.f_82481_ * (1.0 - Math.cos(rot)) + axis.f_82479_ * Math.sin(rot));
        mat.m22 = (float)(Math.cos(rot) + axis.f_82481_ * axis.f_82481_ * (1.0 - Math.cos(rot)));
        return mat;
    }

    public static Vec3 multiply(Matrix3f matrix, Vec3 vector) {
        double x = (double)matrix.m00 * vector.f_82479_ + (double)matrix.m01 * vector.f_82480_ + (double)matrix.m02 * vector.f_82481_;
        double y = (double)matrix.m10 * vector.f_82479_ + (double)matrix.m11 * vector.f_82480_ + (double)matrix.m12 * vector.f_82481_;
        double z = (double)matrix.m20 * vector.f_82479_ + (double)matrix.m21 * vector.f_82480_ + (double)matrix.m22 * vector.f_82481_;
        return new Vec3(x, y, z);
    }

    public void generateSphere() {
        Player player;
        this.initSphere = true;
        PixelmonEntity pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
        if (pix == null) {
            player = ClientProxy.battleManager.getViewPlayer();
            this.centerPos = player.m_20182_();
        } else {
            this.centerPos = new Vec3(pix.m_20185_(), pix.m_20186_(), pix.m_20189_());
        }
        player = ClientProxy.battleManager.getViewPlayer();
        PixelmonEntity opp = this.getOpponentPokemon();
        if (opp != null) {
            this.centerPos = new Vec3((this.centerPos.f_82479_ + opp.m_20185_()) / 2.0, (this.centerPos.f_82480_ + opp.m_20186_()) / 2.0, (this.centerPos.f_82481_ + opp.m_20189_()) / 2.0);
        }
        Vec3 playerPos = new Vec3(player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_());
        this.baseVec = this.centerPos.m_82541_();
        this.pitch = 0.7853982f;
        this.yaw = 0.0f;
        this.radius = (float)playerPos.m_82554_(this.centerPos) + 2.0f;
        this.radius = this.radius < 10.0f ? 10.0f : this.radius;
        this.spherePosChanged = true;
        ClientProxy.battleManager.setViewEntity((Entity)this.camera);
    }

    @Override
    public void generatePositions() {
    }

    @Override
    public void handleMouseMovement(double dx, double dy, int dwheel) {
        if (dx != 0.0 || dy != 0.0 || dwheel != 0) {
            this.yaw = (float)((double)this.yaw - dx * (double)0.005f);
            this.pitch = (float)((double)this.pitch - dy * (double)0.008f);
            this.radius -= (float)dwheel;
            if (this.camera.mode == CameraMode.Battle) {
                if (this.radius < 4.0f) {
                    this.radius = 4.0f;
                }
            } else if (this.radius < 2.0f) {
                this.radius = 2.0f;
            }
            if (this.radius > 50.0f) {
                this.radius = 50.0f;
            }
            this.spherePosChanged = true;
        }
    }
}

