/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTarget;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.client.camera.movement.PlayerControlledMovement;
import com.pixelmonmod.pixelmon.client.camera.movement.PositionedMovement;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CameraEntity
extends LivingEntity {
    private CameraTarget target;
    public CameraMode mode;
    private CameraMovement movement;

    public CameraEntity(Level par1World) {
        this(par1World, CameraMode.Battle);
    }

    public CameraEntity(EntityType<CameraEntity> type, Level par1World) {
        this(type, par1World, CameraMode.Battle);
    }

    public CameraEntity(Level par1World, CameraMode mode) {
        this((EntityType<CameraEntity>)((EntityType)EntityRegistration.CAMERA.get()), par1World, mode);
    }

    public CameraEntity(EntityType<CameraEntity> type, Level par1World, CameraMode mode) {
        super(type, par1World);
        this.mode = mode;
        this.movement = PixelmonConfigProxy.getGraphics().isPlayerControlCamera() ? new PlayerControlledMovement(par1World, this) : new PositionedMovement(par1World, this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_() && (this.mode == CameraMode.Battle && ClientProxy.battleManager.battleEnded || this.mode == CameraMode.Evolution && !(Minecraft.m_91087_().f_91080_ instanceof EvolveScreen))) {
            this.m_6089_();
            return;
        }
        if (this.m_6084_()) {
            this.getMovement().onLivingUpdate();
        }
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot p_184582_1_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_184201_1_, ItemStack p_184201_2_) {
    }

    public void m_7334_(Entity p_21294_) {
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
    }

    protected void m_6138_() {
    }

    public AABB m_21270_(Pose p_21271_) {
        return AABB.m_82321_((BoundingBox)new BoundingBox(0, 0, 0, 0, 0, 0));
    }

    public void setTarget(CameraTarget t) {
        this.target = t;
    }

    public void setTargetRandomPosition(CameraTarget t) {
        this.setTarget(t);
        this.getMovement().setRandomPosition(t);
    }

    public CameraTarget getCameraTarget() {
        return this.target;
    }

    public void updatePositionAndRotation() {
        if (Minecraft.m_91087_().m_91288_() == this && this.target != null && this.target.isValidTarget()) {
            this.smoothLookAt(EntityAnchorArgument.Anchor.FEET, new Vec3(this.target.getX(), this.target.getY(), this.target.getZ()));
        }
    }

    private void smoothLookAt(EntityAnchorArgument.Anchor anchor, Vec3 position) {
        Vec3 Vec32 = anchor.m_90377_((Entity)this);
        double d0 = position.f_82479_ - Vec32.f_82479_;
        double d1 = position.f_82480_ - Vec32.f_82480_;
        double d2 = position.f_82481_ - Vec32.f_82481_;
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        this.m_146926_((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875)));
        this.f_19857_ = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        this.m_5616_(this.f_19857_);
        if (this.f_19857_ > 0.0f && this.f_19859_ < 0.0f || this.f_19857_ < 0.0f && this.f_19859_ > 0.0f) {
            this.f_20886_ = this.f_19857_;
        }
    }

    public CameraMovement getMovement() {
        return this.movement;
    }
}

