/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.hash.Hashing;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.io.File;
import java.io.FileFilter;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.DownloadedPackSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.ProgressListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PixelmonDownloadingPackFinder
extends DownloadedPackSource {
    private static final Component APPLYING_PACK_TEXT = Component.m_237115_((String)"multiplayer.applyingPack");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileFilter RESOURCE_PACK_FILTER = p_accept_1_ -> {
        boolean flag = p_accept_1_.isFile() && p_accept_1_.getName().endsWith(".zip");
        boolean flag1 = p_accept_1_.isDirectory() && new File(p_accept_1_, "pack.mcmeta").isFile();
        return flag || flag1;
    };
    private static final Pattern PATTERN_SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final ResourceLocation UNKNOWN_PACK_TEXTURE = ResourceLocationHelper.of("textures/misc/unknown_pack.png");
    private final File serverPackDir;
    @Nullable
    private CompletableFuture<?> currentDownload;

    public PixelmonDownloadingPackFinder(File serverPackDirIn) {
        super(serverPackDirIn);
        this.serverPackDir = serverPackDirIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> m_246254_(URL p_249839_, String p_249218_, boolean p_251033_) {
        CompletableFuture<?> completablefuture1;
        String s = Hashing.sha1().hashString((CharSequence)p_249839_.toString(), StandardCharsets.UTF_8).toString();
        String s1 = PATTERN_SHA1.matcher(p_249218_).matches() ? p_249218_ : "";
        this.f_244572_.lock();
        try {
            CompletableFuture completablefuture;
            Minecraft minecraft = Minecraft.m_91087_();
            File file1 = new File(this.serverPackDir, s);
            if (file1.exists()) {
                completablefuture = CompletableFuture.completedFuture("");
            } else {
                ProgressScreen progressscreen = new ProgressScreen(p_251033_);
                Map map = PixelmonDownloadingPackFinder.m_245308_();
                minecraft.m_18709_(() -> minecraft.m_91152_((Screen)progressscreen));
                completablefuture = HttpUtil.m_216225_((File)file1, (URL)p_249839_, (Map)map, (int)0x4B000000, (ProgressListener)progressscreen, (Proxy)minecraft.m_91096_());
            }
            completablefuture1 = this.currentDownload = ((CompletableFuture)((CompletableFuture)completablefuture.thenCompose(p_251155_ -> {
                if (!this.m_245350_(s1, file1)) {
                    return CompletableFuture.failedFuture(new RuntimeException("Hash check failure for file " + file1 + ", see log"));
                }
                minecraft.execute(() -> {
                    if (!p_251033_) {
                        minecraft.m_91152_((Screen)new GenericDirtMessageScreen(APPLYING_PACK_TEXT));
                    }
                });
                return this.m_247526_(file1, PackSource.f_10530_);
            })).exceptionallyCompose(p_249744_ -> ((CompletableFuture)this.m_246151_().thenAcceptAsync(p_251750_ -> {
                LOGGER.warn("Pack application failed: {}, deleting file {}", (Object)p_249744_.getMessage(), (Object)file1);
                PixelmonDownloadingPackFinder.m_246169_((File)file1);
            }, (Executor)Util.m_183992_())).thenAcceptAsync(p_248937_ -> minecraft.m_91152_((Screen)new ConfirmScreen(p_249339_ -> {
                if (p_249339_) {
                    minecraft.m_91152_((Screen)null);
                } else {
                    ClientPacketListener clientpacketlistener = minecraft.m_91403_();
                    if (clientpacketlistener != null) {
                        clientpacketlistener.m_104910_().m_129507_((Component)Component.m_237115_((String)"connect.aborted"));
                    }
                }
            }, (Component)Component.m_237115_((String)"multiplayer.texturePrompt.failure.line1"), (Component)Component.m_237115_((String)"multiplayer.texturePrompt.failure.line2"), CommonComponents.f_130659_, (Component)Component.m_237115_((String)"menu.disconnect"))), (Executor)minecraft))).thenAcceptAsync(p_250279_ -> this.m_245559_(), (Executor)Util.m_183992_());
        }
        finally {
            this.f_244572_.unlock();
        }
        return completablefuture1;
    }
}

