/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.override.servers.list.ExtendedServerList;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.HttpUtil;

public class DefaultServerList {
    private static final String URL = "https://api.pixelmonmod.com/servers/116/servers.dat";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static boolean searching = false;

    public static void tryFetchDefaultServers() {
        DefaultServerList.tryFetchDefaultServers(null);
    }

    public static void tryFetchDefaultServers(@Nullable Runnable onComplete) {
        if (searching) {
            return;
        }
        ExtendedServerList serverListPre = new ExtendedServerList(Minecraft.m_91087_());
        if (serverListPre.m_105445_() == 0) {
            searching = true;
            DefaultServerList.fetchDefaultServers().whenComplete((v, t) -> {
                ExtendedServerList serverListPost = new ExtendedServerList(Minecraft.m_91087_());
                serverListPost.randomize();
                if (onComplete != null) {
                    onComplete.run();
                    searching = false;
                }
            });
        }
    }

    protected static CompletableFuture<?> fetchDefaultServers() {
        CompletableFuture future;
        LOCK.lock();
        try {
            File file = new File(".", "servers.dat");
            String url = URL.replace("%s", ExtrasContact.getVersion());
            Map<String, String> map = DefaultServerList.getDownloadRequestProperties();
            future = HttpUtil.m_216225_((File)file, (URL)new URL(url), map, (int)0x4B000000, null, (Proxy)Minecraft.m_91087_().m_91096_());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        finally {
            LOCK.unlock();
        }
        return future;
    }

    private static Map<String, String> getDownloadRequestProperties() {
        HashMap map = Maps.newHashMap();
        map.put("X-Minecraft-Username", Minecraft.m_91087_().m_91094_().m_92546_());
        map.put("X-Minecraft-UUID", Minecraft.m_91087_().m_91094_().m_240411_().toString());
        map.put("X-Minecraft-Version", SharedConstants.m_183709_().m_132493_());
        map.put("X-Minecraft-Version-ID", SharedConstants.m_183709_().m_132492_());
        map.put("X-Minecraft-Pack-Format", String.valueOf(SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES)));
        map.put("X-Pixelmon-Version", String.valueOf(Pixelmon.getVersion()));
        map.put("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        return map;
    }
}

