/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.api.helpers.FireworkHelper;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.GraphicsConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.toast.ExpandingTutorialToast;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.animations.particles.ParticleGastly;
import com.pixelmonmod.pixelmon.client.DefaultServerList;
import com.pixelmonmod.pixelmon.client.camera.CameraEntity;
import com.pixelmonmod.pixelmon.client.gui.CameraOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.CharmScreen;
import com.pixelmonmod.pixelmon.client.gui.ChatOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.DoctorScreen;
import com.pixelmonmod.pixelmon.client.gui.HealerScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.MegaItemScreen;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.SelectStatScreen;
import com.pixelmonmod.pixelmon.client.gui.TradingScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.BattleRulesFixedScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.BattleRulesPlayerScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.TeamSelectScreen;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ChooseMovesetScreen;
import com.pixelmonmod.pixelmon.client.gui.curryDex.CurryDexScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.InputScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.dialogue.DialogueScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import com.pixelmonmod.pixelmon.client.gui.egg.EggHatchingScreen;
import com.pixelmonmod.pixelmon.client.gui.faint.FaintScreen;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogInformationScreen;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogMenuScreen;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogScreen;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryDetectionTickHandler;
import com.pixelmonmod.pixelmon.client.gui.mail.MailScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ChattingNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.NPCTraderScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.QuestGiverNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.RelearnerScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.SelectPartyPokemonScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ShopkeeperScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.TutorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ChattingNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ConfirmDeleteNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.CreateNPCScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.QuestGiverNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.ShopkeeperEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TradeEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TutorEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.pc.PCScreen;
import com.pixelmonmod.pixelmon.client.gui.pokedex.PokedexScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.EditedPlayerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.client.gui.selectMove.SelectMoveScreen;
import com.pixelmonmod.pixelmon.client.gui.spawner.PixelmonSpawnerScreen;
import com.pixelmonmod.pixelmon.client.gui.starter.ChooseStarterScreen;
import com.pixelmonmod.pixelmon.client.gui.statueEditor.StatueEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.vendingmachine.VendingMachineScreen;
import com.pixelmonmod.pixelmon.client.gui.zygarde.ZygardeCubeScreen;
import com.pixelmonmod.pixelmon.client.gui.zygarde.ZygardeReassemblyUnitScreen;
import com.pixelmonmod.pixelmon.client.keybindings.ActionKey;
import com.pixelmonmod.pixelmon.client.keybindings.ChooseMoveSkillKey;
import com.pixelmonmod.pixelmon.client.keybindings.DebugKeyBindings;
import com.pixelmonmod.pixelmon.client.keybindings.DescendKey;
import com.pixelmonmod.pixelmon.client.keybindings.HoverKey;
import com.pixelmonmod.pixelmon.client.keybindings.MinimizeMaximizeOverlayKey;
import com.pixelmonmod.pixelmon.client.keybindings.NextPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.OldMovementHandler;
import com.pixelmonmod.pixelmon.client.keybindings.OptionsKey;
import com.pixelmonmod.pixelmon.client.keybindings.PokedexKey;
import com.pixelmonmod.pixelmon.client.keybindings.PreviousPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.QuestCycleKey;
import com.pixelmonmod.pixelmon.client.keybindings.QuestJournalKey;
import com.pixelmonmod.pixelmon.client.keybindings.SendPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.SpectateKey;
import com.pixelmonmod.pixelmon.client.keybindings.TrainerCardKey;
import com.pixelmonmod.pixelmon.client.keybindings.UseMoveSkillKey;
import com.pixelmonmod.pixelmon.client.keybindings.WikiKey;
import com.pixelmonmod.pixelmon.client.listener.MouseOverPlayer;
import com.pixelmonmod.pixelmon.client.listener.WallpapersListener;
import com.pixelmonmod.pixelmon.client.models.ResourceLoader;
import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.pixelmonmod.pixelmon.client.particle.ParticleEvents;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockRevealRenderer;
import com.pixelmonmod.pixelmon.client.render.custom.RenderPixelmonPainting;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.BikeRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.ChairMountRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.DenRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.HookRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.InvisibleCameraRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.NPCRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonBoatRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PokeBallRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.StatueRenderer;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.WormholeRenderer;
import com.pixelmonmod.pixelmon.client.render.layers.CustomPixelmonHeadLayer;
import com.pixelmonmod.pixelmon.client.render.layers.LayerCharms;
import com.pixelmonmod.pixelmon.client.render.layers.LayerEquippables;
import com.pixelmonmod.pixelmon.client.render.layers.LayerMegaItems;
import com.pixelmonmod.pixelmon.client.render.layers.LayerSash;
import com.pixelmonmod.pixelmon.client.render.layers.LayerWings;
import com.pixelmonmod.pixelmon.client.render.layers.PixelmonLayerHead;
import com.pixelmonmod.pixelmon.client.render.layers.PixelmonLayerRobe;
import com.pixelmonmod.pixelmon.client.render.player.RenderEvents;
import com.pixelmonmod.pixelmon.client.richpresence.PixelmonRichPresence;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.EnumBreedingParticles;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumPixelmonParticles;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.FireworkRegistration;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import com.pixelmonmod.pixelmon.items.ItemFinderItem;
import com.pixelmonmod.pixelmon.items.TechnicalMoveItem;
import com.pixelmonmod.pixelmon.listener.ClientNetworkListener;
import com.pixelmonmod.pixelmon.listener.PokemonFaintClientListener;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.rendering.QuestMarkerRenderer;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.world.dimension.client.ClientDimensionRegistration;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import com.pixelmonmod.pixelmon.world.listener.DrownedWorldClientListener;
import com.pixelmonmod.pixelmon.world.listener.UltraSpaceClientListener;
import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.FireworkShapeFactoryRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    public static final SendPokemonKey SEND_POKEMON_KEY = new SendPokemonKey();
    public static final int defaultTexUnit = 33984;
    public static final int lightmapTexUnit = 33985;
    public static ClientBattleManager battleManager = new ClientBattleManager();
    public static ArrayList<MoveSkill> moveSkills = new ArrayList();
    public static TradePair currentTradePair = null;
    public static boolean playerHasTradeRequestPokemon = false;
    public static CameraEntity camera;
    private static PixelmonRichPresence richPresence;
    private static ExpandingTutorialToast toast;
    public static ActionKey actionKeyBind;
    public static UseMoveSkillKey useMoveSkillKeyBind;
    public static ChooseMoveSkillKey chooseMoveSkillKey;
    public static PokedexKey pokedexKeyBind;
    public static TrainerCardKey trainerCardKeyBind;
    public static WikiKey wikiKeyBind;
    public static SpectateKey spectateKeyBind;
    public static QuestJournalKey questJournalKeyBind;
    public static QuestCycleKey questCycleKeyBind;
    public static KeyMapping pcSearchKeyBind;
    public static KeyMapping pcRenameKeyBind;
    public static KeyMapping pcWallpaperKeyBind;

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        DefaultServerList.tryFetchDefaultServers();
        DimensionSpecialEffects.f_108857_.put((Object)ResourceLocationHelper.of("pixelmon:ultra_space"), (Object)new UltraSpace.UltraSpaceRenderInfo());
        DimensionSpecialEffects.f_108857_.put((Object)ResourceLocationHelper.of("pixelmon:drowned_world"), (Object)new DrownedWorld.DrownedWorldRenderInfo());
        ClientDimensionRegistration.register(event);
        MinecraftForge.EVENT_BUS.register((Object)new ParticleEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ClientProxy());
        MinecraftForge.EVENT_BUS.register(CameraOverlayScreen.class);
        MinecraftForge.EVENT_BUS.register(ClientNetworkListener.class);
        MinecraftForge.EVENT_BUS.register(PokemonFaintClientListener.class);
        PlayerExtraDataStore.loadClientData();
        ResourceLocation mt = ResourceLocationHelper.of("pixelmon", "move_type");
        ItemProperties.register((Item)PixelmonItems.tm_gen1, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen2, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen3, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen4, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen5, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen6, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen7, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen8, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tr_gen8, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.tm_gen9, (ResourceLocation)mt, (ItemPropertyFunction)TechnicalMoveItem.TMPropertyGetter.INSTANCE);
        ItemProperties.register((Item)PixelmonItems.item_finder, (ResourceLocation)new ResourceLocation("pixelmon", "direction"), (ItemPropertyFunction)ItemFinderItem.PropertyGetter.INSTANCE);
        ItemRegistration.registerItemLayers();
        ClientProxy.registerRenderers();
        ClientProxy.registerTickHandlers();
        richPresence = new PixelmonRichPresence(696343075731144724L);
        HashSet registeredColors = Sets.newHashSet();
        for (BerryType berry : BerryType.values()) {
            if (registeredColors.contains(berry.color)) continue;
            registeredColors.add(berry.color);
            Sheets.f_110743_.put(berry.getWoodType(), Sheets.m_173381_((WoodType)berry.getWoodType()));
        }
        Pixelmon.LOGGER.debug("Registering firework shapes!");
        FireworkRegistration.FIREWORK_PLUS_SHAPES.forEach((key, shape) -> {
            Pixelmon.LOGGER.debug("Registering shape: " + shape.getName());
            FireworkShapeFactoryRegistry.register((FireworkRocketItem.Shape)FireworkRegistration.SHAPES.get(shape.getName()), (starter, trail, flicker, colors, fadecolors) -> FireworkHelper.createNonMirroredParticleShape(shape, starter));
        });
        event.enqueueWork(() -> {
            Sheets.f_110743_.put(PixelmonWoodType.BLUE_BERRY_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.BLUE_BERRY_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.GREEN_BERRY_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.GREEN_BERRY_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.PINK_BERRY_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.PINK_BERRY_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.PURPLE_BERRY_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.PURPLE_BERRY_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.RED_BERRY_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.RED_BERRY_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.YELLOW_BERRY_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.YELLOW_BERRY_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.ULTRA_JUNGLE_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.ULTRA_JUNGLE_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.ULTRA_ELM_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.ULTRA_ELM_WOOD));
            Sheets.f_110743_.put(PixelmonWoodType.ULTRA_GINGKO_WOOD, Sheets.m_173381_((WoodType)PixelmonWoodType.ULTRA_GINGKO_WOOD));
        });
    }

    public static void registerRenderers() {
        MinecraftForge.EVENT_BUS.register((Object)new CustomOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new PixelmonOverlayScreen());
        MinecraftForge.EVENT_BUS.register((Object)new ChatOverlayScreen(Minecraft.m_91087_()));
        MinecraftForge.EVENT_BUS.register((Object)new MouseOverPlayer());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockRevealRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new QuestMarkerRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new DrownedWorldClientListener());
        MinecraftForge.EVENT_BUS.register((Object)new UltraSpaceClientListener());
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        PlayerRenderer aDefault = (PlayerRenderer)event.getSkin(PlayerSkin.Model.WIDE);
        PlayerRenderer slim = (PlayerRenderer)event.getSkin(PlayerSkin.Model.SLIM);
        List layers = aDefault.f_115291_;
        RenderLayer head = layers.stream().filter(layer -> layer instanceof CustomHeadLayer).findFirst().get();
        layers.removeIf(layer -> layer instanceof CustomHeadLayer);
        aDefault.f_115291_.addAll(layers);
        aDefault.m_115326_(new CustomPixelmonHeadLayer(head.f_117344_, event.getContext().m_174027_(), event.getContext().m_234598_()));
        aDefault.m_115326_((RenderLayer)new PixelmonLayerHead(aDefault));
        aDefault.m_115326_((RenderLayer)new LayerSash(aDefault));
        aDefault.m_115326_((RenderLayer)new PixelmonLayerRobe(aDefault));
        aDefault.m_115326_((RenderLayer)new LayerMegaItems((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)aDefault));
        aDefault.m_115326_((RenderLayer)new LayerCharms(aDefault));
        aDefault.m_115326_((RenderLayer)new LayerEquippables(aDefault));
        aDefault.m_115326_((RenderLayer)new LayerWings(aDefault));
        layers = slim.f_115291_;
        head = layers.stream().filter(layer -> layer instanceof CustomHeadLayer).findFirst().get();
        layers.removeIf(layer -> layer instanceof CustomHeadLayer);
        slim.f_115291_.addAll(layers);
        slim.m_115326_(new CustomPixelmonHeadLayer(head.f_117344_, event.getContext().m_174027_(), event.getContext().m_234598_()));
        slim.m_115326_((RenderLayer)new PixelmonLayerHead(slim));
        slim.m_115326_((RenderLayer)new LayerSash(slim));
        slim.m_115326_((RenderLayer)new PixelmonLayerRobe(slim));
        slim.m_115326_((RenderLayer)new LayerMegaItems((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)slim));
        slim.m_115326_((RenderLayer)new LayerCharms(slim));
        slim.m_115326_((RenderLayer)new LayerEquippables(slim));
        slim.m_115326_((RenderLayer)new LayerWings(slim));
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        ItemRegistration.bakeModels(event);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register(LayerWings.WINGS_MODEL);
        event.register(LayerWings.VALENTINES_WINGS_MODEL);
        event.register(PixelmonLayerHead.WITCH_HAT_MODEL);
    }

    @SubscribeEvent
    public static void onTileEntityRendererRegister(EntityRenderersEvent.RegisterRenderers event) {
        com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration.registerTileEntityRenderers(event);
        TileEntityRegistration.registerTileEntityRenderers(event);
    }

    @SubscribeEvent
    public static void onColourBlockEvent(RegisterColorHandlersEvent.Block event) {
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_WALL.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_BUTTON.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_SLAB.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_PRESSURE_PLATE.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_STONE_STAIRS.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_SLAB.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_STAIRS.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_WALL.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_BUTTON.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.ULTRA_SPACE_COBBLESTONE_PRESSURE_PLATE.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.CHISELED_ULTRA_SPACE_STONE.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE_SLAB.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE_STAIRS.get()});
        event.register((state, reader, pos, something) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{(Block)BlockRegistration.POLISHED_ULTRA_SPACE_STONE_WALL.get()});
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)SEND_POKEMON_KEY);
        MinecraftForge.EVENT_BUS.register((Object)SEND_POKEMON_KEY);
        NextPokemonKey k2 = new NextPokemonKey();
        event.register((KeyMapping)k2);
        MinecraftForge.EVENT_BUS.register((Object)k2);
        DebugKeyBindings debugKeyBindings = new DebugKeyBindings();
        MinecraftForge.EVENT_BUS.register((Object)debugKeyBindings);
        PreviousPokemonKey k3 = new PreviousPokemonKey();
        event.register((KeyMapping)k3);
        MinecraftForge.EVENT_BUS.register((Object)k3);
        MinimizeMaximizeOverlayKey k4 = new MinimizeMaximizeOverlayKey();
        event.register((KeyMapping)k4);
        MinecraftForge.EVENT_BUS.register((Object)k4);
        DescendKey k5 = new DescendKey();
        event.register((KeyMapping)k5);
        MinecraftForge.EVENT_BUS.register((Object)k5);
        HoverKey k6 = new HoverKey();
        event.register((KeyMapping)k6);
        MinecraftForge.EVENT_BUS.register((Object)k6);
        spectateKeyBind = new SpectateKey();
        event.register((KeyMapping)spectateKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)spectateKeyBind);
        questJournalKeyBind = new QuestJournalKey();
        event.register((KeyMapping)questJournalKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)questJournalKeyBind);
        questCycleKeyBind = new QuestCycleKey();
        event.register((KeyMapping)questCycleKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)questCycleKeyBind);
        actionKeyBind = new ActionKey();
        event.register((KeyMapping)actionKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)actionKeyBind);
        useMoveSkillKeyBind = new UseMoveSkillKey();
        event.register((KeyMapping)useMoveSkillKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)useMoveSkillKeyBind);
        chooseMoveSkillKey = new ChooseMoveSkillKey();
        event.register((KeyMapping)chooseMoveSkillKey);
        MinecraftForge.EVENT_BUS.register((Object)chooseMoveSkillKey);
        pokedexKeyBind = new PokedexKey();
        event.register((KeyMapping)pokedexKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)pokedexKeyBind);
        trainerCardKeyBind = new TrainerCardKey();
        event.register((KeyMapping)trainerCardKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)trainerCardKeyBind);
        wikiKeyBind = new WikiKey();
        event.register((KeyMapping)wikiKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)wikiKeyBind);
        pcSearchKeyBind = new KeyMapping("key.pcsearch", 83, "key.categories.pixelmon");
        event.register(pcSearchKeyBind);
        pcRenameKeyBind = new KeyMapping("key.pcrename", 82, "key.categories.pixelmon");
        event.register(pcRenameKeyBind);
        pcWallpaperKeyBind = new KeyMapping("key.pcwallpaper", 87, "key.categories.pixelmon");
        event.register(pcWallpaperKeyBind);
        MinecraftForge.EVENT_BUS.register(OldMovementHandler.class);
        OptionsKey k7 = new OptionsKey();
        event.register((KeyMapping)k7);
        MinecraftForge.EVENT_BUS.register((Object)k7);
        PixelmonMusic.init(Minecraft.m_91087_());
    }

    @SubscribeEvent
    public static void addPokemonRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRendererProvider npcFactory = NPCRenderer::new;
        event.registerEntityRenderer((EntityType)EntityRegistration.EMPTY_POKEBALL.get(), PokeBallRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.OCCUPIED_POKEBALL.get(), PokeBallRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.HOOK.get(), HookRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_TRAINER.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_CHATTING.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_QUEST_GIVER.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_TRADER.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_RELEARNER.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_TUTOR.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_NURSE_JOY.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_FISHERMAN.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.NPC_SHOPKEEPER.get(), npcFactory);
        event.registerEntityRenderer((EntityType)EntityRegistration.STATUE.get(), StatueRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.PIXELMON.get(), PixelmonRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.CAMERA.get(), InvisibleCameraRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.WORMHOLE.get(), WormholeRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.BIKE.get(), BikeRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.PAINTING.get(), RenderPixelmonPainting::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.DEN.get(), DenRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.CHAIR_MOUNT.get(), ChairMountRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistration.BOAT.get(), context -> new PixelmonBoatRenderer(context, false));
    }

    public static Screen createScreen(Player player, EnumGuiScreen gui, int[] data) {
        switch (gui) {
            case Faint: {
                return new FaintScreen();
            }
            case ChooseStarter: {
                return new ChooseStarterScreen();
            }
            case Dialogue: {
                return new DialogueScreen();
            }
            case Healer: {
                return new HealerScreen();
            }
            case Pokedex: {
                return new PokedexScreen(data[0]);
            }
            case PickPokemon: {
                return new SelectPartyPokemonScreen(data[0], data[1]);
            }
            case PC: {
                return new PCScreen();
            }
            case ChooseRelearnMove: 
            case ChooseTutor: 
            case Battle: {
                return new BattleScreen();
            }
            case Trading: {
                return new TradingScreen(data[0], data[1], data[2]);
            }
            case Doctor: {
                return new DoctorScreen();
            }
            case ItemDrops: {
                return new ItemDropsScreen();
            }
            case PixelmonSpawner: {
                return new PixelmonSpawnerScreen(data[0], data[1], data[2]);
            }
            case TrainerEditor: {
                return new TrainerEditorScreen(data[0]);
            }
            case ChooseMoveset: {
                return new ChooseMovesetScreen(ClientStorageManager.party.get(data[0]));
            }
            case NPCTrade: {
                return new TradeEditorScreen(data[0]);
            }
            case NPCTraderGui: {
                return new NPCTraderScreen(data[0]);
            }
            case StatueEditor: {
                return new StatueEditorScreen(data[0]);
            }
            case InputScreen: {
                return new InputScreen();
            }
            case CreateNpc: {
                return new CreateNPCScreen(new BlockPos(data[0], data[1], data[2]));
            }
            case DeleteNpc: {
                return new ConfirmDeleteNPCScreen(data[0]);
            }
            case NPCChatEditor: {
                return new ChattingNPCEditorScreen(data[0]);
            }
            case NPCChat: {
                return new ChattingNPCScreen(data[0]);
            }
            case NPCQuestGiverEditor: {
                return new QuestGiverNPCEditorScreen(data[0]);
            }
            case NPCQuestGiver: {
                return new QuestGiverNPCScreen(data[0]);
            }
            case Relearner: {
                return new RelearnerScreen(ClientStorageManager.party.get(data[0]));
            }
            case Tutor: {
                return new TutorScreen(ClientStorageManager.party.get(data[0]), data[1]);
            }
            case TutorEditor: {
                return new TutorEditorScreen(data[0]);
            }
            case HealerNurseJoy: {
                return new HealerScreen(data[0]);
            }
            case Shopkeeper: {
                return new ShopkeeperScreen(data[0]);
            }
            case ShopkeeperEditor: {
                return new ShopkeeperEditorScreen(data[0]);
            }
            case VendingMachine: {
                return new VendingMachineScreen(new BlockPos(data[0], data[1], data[2]));
            }
            case PokemonEditor: {
                return new PokemonEditorPartyScreen();
            }
            case EditedPlayer: {
                return new EditedPlayerScreen();
            }
            case MegaItem: {
                return new MegaItemScreen(data.length != 0);
            }
            case BattleRulesPlayer: {
                return new BattleRulesPlayerScreen(data[0], data[1] == 1);
            }
            case BattleRulesFixed: {
                return new BattleRulesFixedScreen();
            }
            case TeamSelect: {
                return new TeamSelectScreen();
            }
            case Mail: {
                return new MailScreen(player.m_21120_(InteractionHand.values()[data[0]]));
            }
            case SelectMove: {
                return new SelectMoveScreen(data[0], data[1]);
            }
            case ShinyCharm: {
                return new CharmScreen(EnumCharms.Shiny);
            }
            case OvalCharm: {
                return new CharmScreen(EnumCharms.Oval);
            }
            case ExpCharm: {
                return new CharmScreen(EnumCharms.Exp);
            }
            case CatchingCharm: {
                return new CharmScreen(EnumCharms.Catching);
            }
            case MarkCharm: {
                return new CharmScreen(EnumCharms.Mark);
            }
            case BottleCap: {
                return new SelectStatScreen(data);
            }
            case CurryDex: {
                return new CurryDexScreen(data);
            }
            case FishingLog: {
                return new FishingLogScreen(data[0], Arrays.copyOfRange(data, 1, data.length));
            }
            case FishingLogMenu: {
                return new FishingLogMenuScreen(data);
            }
            case FishingLogInformation: {
                return new FishingLogInformationScreen(data[0], data[1], data[2], data);
            }
            case ZygardeAssembly: {
                return new ZygardeReassemblyUnitScreen(data[0], data[1], data[2]);
            }
            case ZygardeCube: {
                return new ZygardeCubeScreen(InteractionHand.values()[data[0]], data[1]);
            }
            case QuestEditor: {
                return new QuestEditorScreen();
            }
            case EggHatch: {
                return new EggHatchingScreen(data[0]);
            }
        }
        return null;
    }

    public static File getMinecraftDir() {
        return Minecraft.m_91087_().f_91069_;
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        if (Minecraft.m_91087_().m_91089_() == null || !ClientProxy.getRichPresence().isAcknowledgedServer()) {
            ClientProxy.getRichPresence().onJoin();
        }
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ClientProxy.battleManager.battleEnded = true;
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        Pixelmon.freeze = false;
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft instance = Minecraft.m_91087_();
        if (instance.f_91073_ == null || instance.m_91104_() || toast != null || !instance.f_91066_.f_92031_) {
            return;
        }
        GraphicsConfig graphicsConfig = PixelmonConfigProxy.getGraphics();
        if (graphicsConfig.shouldSendToasts()) {
            toast = new ExpandingTutorialToast((Component)Component.m_237115_((String)"pixelmon.tutorial.send.out"), (Component)Component.m_237110_((String)"pixelmon.tutorial.send.out.desc", (Object[])new Object[]{SEND_POKEMON_KEY.getKey().m_84875_().getString().toUpperCase(Locale.ROOT)}));
            instance.m_91301_().m_120572_((TutorialToast)toast, 600);
            graphicsConfig.setShouldSendToasts(false);
            graphicsConfig.save();
        }
    }

    public static void spawnParticle(EnumPixelmonParticles particle, ClientLevel worldObj, double posX, double posY, double posZ, boolean isShiny) {
        try {
            if (particle.particleClass != ParticleGastly.class) {
                Particle fx = particle.particleClass.getConstructor(Level.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0);
                Minecraft.m_91087_().f_91061_.m_107344_(fx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void spawnParticle(EnumBreedingParticles particle, Level worldObj, double posX, double posY, double posZ, PaletteProperties paletteProperties) {
    }

    public static void registerTickHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryDetectionTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)battleManager);
    }

    public static boolean resourceLocationExists(ResourceLocation resourceLocation) {
        return Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).isPresent();
    }

    public static ArrayList<MoveSkill> getMoveSkills(Pokemon pokemon) {
        ArrayList moveSkills = Lists.newArrayList(ClientProxy.moveSkills);
        moveSkills.removeIf(moveSkill -> !moveSkill.hasMoveSkill(pokemon));
        return moveSkills;
    }

    public static PixelmonRichPresence getRichPresence() {
        return richPresence;
    }

    public static ExpandingTutorialToast getToast() {
        return toast;
    }

    @SubscribeEvent
    public static void onClientLoaded(FMLClientSetupEvent event) {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            try (PackResources modResources = minecraft.m_91099_().m_10507_("mod_resources").m_10445_();){
                ClientProxy.setIcon(minecraft.m_91268_(), modResources, IconSet.RELEASE);
            }
        }
        catch (IOException e) {
            Pixelmon.LOGGER.error("Error setting window icon", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIcon(Window window, PackResources resources, IconSet iconSet) throws IOException {
        RenderSystem.assertInInitPhase();
        if (Minecraft.f_91002_) {
            MacosUtil.m_247671_((IoSupplier)iconSet.m_280095_(resources));
        } else {
            List<IoSupplier<InputStream>> list = ClientProxy.getStandardIcons(resources);
            ArrayList<ByteBuffer> list1 = new ArrayList<ByteBuffer>(list.size());
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                GLFWImage.Buffer buffer = GLFWImage.malloc((int)list.size(), (MemoryStack)memorystack);
                for (int i = 0; i < list.size(); ++i) {
                    try (NativeImage nativeimage = NativeImage.m_85058_((InputStream)((InputStream)list.get(i).m_247737_()));){
                        ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(nativeimage.m_84982_() * nativeimage.m_85084_() * 4));
                        list1.add(bytebuffer);
                        bytebuffer.asIntBuffer().put(nativeimage.m_266370_());
                        buffer.position(i);
                        buffer.width(nativeimage.m_84982_());
                        buffer.height(nativeimage.m_85084_());
                        buffer.pixels(bytebuffer);
                        continue;
                    }
                }
                window.m_85422_("Pixelmon 9.2.6");
                GLFW.glfwSetWindowIcon((long)window.f_85349_, (GLFWImage.Buffer)((GLFWImage.Buffer)buffer.position(0)));
            }
            finally {
                list1.forEach(MemoryUtil::memFree);
            }
        }
    }

    public static List<IoSupplier<InputStream>> getStandardIcons(PackResources resources) throws IOException {
        return List.of(ClientProxy.getFile(resources, "icon_16x16.png"), ClientProxy.getFile(resources, "icon_32x32.png"), ClientProxy.getFile(resources, "icon_48x48.png"), ClientProxy.getFile(resources, "icon_128x128.png"), ClientProxy.getFile(resources, "icon_256x256.png"));
    }

    private static IoSupplier<InputStream> getFile(PackResources resources, String iconFile) throws IOException {
        IoSupplier iosupplier = resources.m_214146_(PackType.CLIENT_RESOURCES, ResourceLocationHelper.of("pixelmon", "textures/icons/" + iconFile));
        if (iosupplier == null) {
            throw new FileNotFoundException("Icons not found");
        }
        return iosupplier;
    }

    static {
        toast = null;
        ReloadableResourceManager manager = (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
        manager.m_7217_((PreparableReloadListener)new WallpapersListener());
        manager.m_7217_((PreparableReloadListener)new ResourceLoader());
    }
}

