/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ZygardeCellTileEntity
extends BlockEntity {
    private static final int MAX_SP_AGE = 12000;
    private static final int MAX_MP_AGE = 36000;
    private int age;
    private boolean isPermanent = false;
    private ZygardeCubeItem.CoreType coreType = ZygardeCubeItem.CoreType.RANDOM;
    private final Map<UUID, Long> encounters = Maps.newHashMap();

    public ZygardeCellTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.ZYGARDE_CELL.get(), blockPos, blockState);
    }

    public ZygardeCellTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public void setPermanent(boolean permanent) {
        this.isPermanent = permanent;
        if (!this.isPermanent) {
            this.encounters.clear();
        }
    }

    public ZygardeCubeItem.CoreType getCoreType() {
        return this.coreType;
    }

    public void setCoreType(ZygardeCubeItem.CoreType coreType) {
        this.coreType = coreType;
    }

    public boolean addEncounter(UUID uuid) {
        if (this.encounters.containsKey(uuid)) {
            return false;
        }
        this.encounters.put(uuid, this.f_58857_.m_46467_());
        return true;
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ++this.age;
        if (!this.isPermanent() && this.age > (ServerLifecycleHooks.getCurrentServer().m_129792_() ? 12000 : 36000)) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Age")) {
            this.age = compound.m_128451_("Age");
        }
        if (compound.m_128441_("isPermanent")) {
            this.isPermanent = compound.m_128471_("isPermanent");
            this.encounters.clear();
            if (compound.m_128441_("Encounters")) {
                ListTag list = compound.m_128437_("Encounters", 10);
                for (Tag base : list) {
                    CompoundTag tag = (CompoundTag)base;
                    UUID uuid = tag.m_128342_("UUID");
                    long time = tag.m_128454_("time");
                    this.encounters.put(uuid, time);
                }
            }
        } else {
            this.isPermanent = false;
        }
        this.coreType = compound.m_128441_("CoreType") ? ZygardeCubeItem.CoreType.fromIndex(compound.m_128445_("CoreType")) : ZygardeCubeItem.CoreType.RANDOM;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Age", this.age);
        compound.m_128379_("isPermanent", this.isPermanent);
        if (this.isPermanent && !this.encounters.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<UUID, Long> entry : this.encounters.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("UUID", entry.getKey());
                tag.m_128356_("time", entry.getValue().longValue());
                list.add((Object)tag);
            }
            compound.m_128365_("Encounters", (Tag)list);
        }
        if (this.coreType != ZygardeCubeItem.CoreType.RANDOM) {
            compound.m_128344_("CoreType", (byte)this.coreType.ordinal());
        }
    }
}

