/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.client.gui.machines.washingmachine.WashingMachineContainer;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class WashingMachineTileEntity
extends BlockEntity
implements MenuProvider {
    private int furnaceBurnTime = 0;
    private ItemStackHandler cooking = new ItemStackHandler(1);
    private ItemStackHandler cooked = new ItemStackHandler(1);

    public WashingMachineTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.WASHING_MACHINE.get(), blockPos, blockState);
    }

    public WashingMachineTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("smeltTime", this.furnaceBurnTime);
        nbt.m_128365_("Cooking", (Tag)this.cooking.serializeNBT());
        nbt.m_128365_("Cooked", (Tag)this.cooked.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooking.deserializeNBT(nbt.m_128469_("Cooking"));
        this.cooked.deserializeNBT(nbt.m_128469_("Cooked"));
    }

    public void update() {
        if (!this.f_58857_.f_46443_) {
            ++this.furnaceBurnTime;
            if (this.furnaceBurnTime >= 75) {
                this.furnaceBurnTime = 0;
                this.smeltItem();
            }
            this.m_6596_();
        }
    }

    private boolean canSmelt() {
        if (this.cooking.getStackInSlot(0).m_41619_()) {
            return false;
        }
        ItemStack itemstack = this.cooking.getStackInSlot(0).m_41777_();
        if (itemstack.m_41619_()) {
            return false;
        }
        ItemStack itemstack1 = this.cooked.getStackInSlot(0);
        ItemStack itemstack2 = itemstack.m_41777_();
        itemstack2.m_41764_(1);
        if (itemstack1.m_41619_()) {
            return true;
        }
        if (itemstack1.m_41720_() == itemstack2.m_41720_() && itemstack1.m_41753_()) {
            return true;
        }
        if (itemstack1.m_41613_() + itemstack2.m_41613_() <= this.cooked.getSlotLimit(0) && itemstack1.m_41613_() + itemstack2.m_41613_() <= itemstack1.m_41741_()) {
            return true;
        }
        return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = this.cooking.getStackInSlot(0);
            ItemStack itemstack1 = itemstack.m_41777_();
            itemstack1.m_41764_(1);
            itemstack1.m_41721_(0);
            ItemStack itemstack2 = this.cooked.getStackInSlot(0);
            if (itemstack2.m_41619_()) {
                this.cooked.setStackInSlot(0, itemstack1);
            } else if (itemstack2.m_41753_() && itemstack1.m_41720_() == itemstack2.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            itemstack.m_41774_(1);
        }
    }

    private BlockState getState() {
        return this.f_58857_.m_8055_(this.f_58858_);
    }

    public void add(ItemStack stack) {
        this.cooked.insertItem(0, stack, false);
    }

    public boolean isRunning() {
        return this.canSmelt();
    }

    public int getSmeltTimeRemainingScaled(int i) {
        return (int)((double)i * ((double)this.furnaceBurnTime / 120.0));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ItemStackHandler getCooked() {
        return this.cooked;
    }

    public ItemStackHandler getCooking() {
        return this.cooking;
    }

    public int getSmeltTime() {
        return this.furnaceBurnTime;
    }

    public void setSmeltTime(int smeltTime) {
        this.furnaceBurnTime = smeltTime;
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player p_39956_) {
        return new WashingMachineContainer(id, inventory, this);
    }
}

