/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.primitives.Doubles;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WarpPlateTileEntity
extends BlockEntity {
    private String warpX = null;
    private String warpY = null;
    private String warpZ = null;
    private BlockPos warpPosition = null;

    public WarpPlateTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.WARP_PLATE.get(), blockPos, blockState);
    }

    public WarpPlateTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.warpX != null) {
            nbt.m_128359_("warp_x", this.warpX);
            nbt.m_128359_("warp_y", this.warpY);
            nbt.m_128359_("warp_z", this.warpZ);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("warp_x")) {
            this.warpX = nbt.m_128461_("warp_x");
            this.warpY = nbt.m_128461_("warp_y");
            this.warpZ = nbt.m_128461_("warp_z");
            this.warpPosition = this.calculatePosition(this.warpX, this.warpY, this.warpZ);
        } else if (nbt.m_128441_("warpPosition")) {
            this.warpPosition = BlockPos.m_122022_((long)nbt.m_128454_("warpPosition"));
            this.warpX = String.valueOf(this.warpPosition.m_123341_());
            this.warpY = String.valueOf(this.warpPosition.m_123342_());
            this.warpZ = String.valueOf(this.warpPosition.m_123343_());
        }
    }

    public BlockPos getWarpPosition() {
        return this.warpPosition;
    }

    public void setWarpPosition(String x, String y, String z) {
        this.warpX = x;
        this.warpY = y;
        this.warpZ = z;
        this.warpPosition = this.calculatePosition(this.warpX, this.warpY, this.warpZ);
        this.m_6596_();
    }

    public BlockPos calculatePosition(String warpX, String warpY, String warpZ) {
        String[] wPos = new String[]{warpX, warpY, warpZ};
        int[] pos = new int[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()};
        double[] nPos = new double[3];
        for (int i = 0; i < wPos.length; ++i) {
            try {
                nPos[i] = WarpPlateTileEntity.parseDouble(pos[i], wPos[i], false);
                continue;
            }
            catch (NullPointerException | NumberFormatException e) {
                return null;
            }
        }
        return new BlockPos((int)nPos[0], (int)nPos[1], (int)nPos[2]);
    }

    public static double parseDouble(double base, String input, boolean centerBlock) throws NumberFormatException {
        return WarpPlateTileEntity.parseDouble(base, input, -30000000, 30000000, centerBlock);
    }

    public static double parseDouble(double base, String input, int min, int max, boolean centerBlock) throws NumberFormatException {
        double d0;
        boolean flag = input.startsWith("~");
        if (flag && Double.isNaN(base)) {
            throw new NumberFormatException();
        }
        double d = d0 = flag ? base : 0.0;
        if (!flag || input.length() > 1) {
            boolean flag1 = input.contains(".");
            if (flag) {
                input = input.substring(1);
            }
            d0 += WarpPlateTileEntity.parseDouble(input);
            if (!flag1 && !flag && centerBlock) {
                d0 += 0.5;
            }
        }
        if (min != 0 || max != 0) {
            if (d0 < (double)min) {
                throw new NumberFormatException();
            }
            if (d0 > (double)max) {
                throw new NumberFormatException();
            }
        }
        return d0;
    }

    public static double parseDouble(String input) throws NumberFormatException {
        try {
            double d0 = Double.parseDouble(input);
            if (!Doubles.isFinite((double)d0)) {
                throw new NumberFormatException();
            }
            return d0;
        }
        catch (NumberFormatException var3) {
            throw new NumberFormatException();
        }
    }
}

