/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonTradeEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.RegisterTraderPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetSelectedStatsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetTradeTargetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.TradeReadyPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class TradeMachineTileEntity
extends BlockEntity {
    private UUID owner = null;
    public int playerCount = 0;
    public ServerPlayer player1;
    public ServerPlayer player2;
    public boolean ready1;
    public boolean ready2;
    public int pos1 = -1;
    public int pos2 = -1;
    public String user1 = "";
    public String user2 = "";
    public CompoundTag poke1;
    public CompoundTag poke2;
    private int ticks = 1;
    private boolean tradePushed = false;

    public TradeMachineTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.TRADE_MACHINE.get(), blockPos, blockState);
    }

    public TradeMachineTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.owner != null) {
            compound.m_128362_("owner", this.owner);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("owner")) {
            this.owner = compound.m_128342_("owner");
        }
    }

    public void setColour(DyeColor dyeColor) {
        this.f_58857_.m_7731_(this.m_58899_(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("pixelmon", dyeColor.name().toLowerCase(Locale.ROOT) + "_trade_machine"))).m_49966_(), 3);
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        nbt.m_128359_("user1", this.player1 == null ? "" : this.player1.m_7755_().getString());
        nbt.m_128359_("user2", this.player2 == null ? "" : this.player2.m_7755_().getString());
        nbt.m_128379_("ready1", this.ready1);
        nbt.m_128379_("ready2", this.ready2);
        if (this.poke1 != null) {
            nbt.m_128365_("poke1", (Tag)this.poke1);
        }
        if (this.poke2 != null) {
            nbt.m_128365_("poke2", (Tag)this.poke2);
        }
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        this.user1 = data.m_128461_("user1");
        this.user2 = data.m_128461_("user2");
        this.ready1 = data.m_128471_("ready1");
        this.ready2 = data.m_128471_("ready2");
        this.poke1 = data.m_128441_("poke1") ? (data.m_128469_("poke1").m_128456_() ? null : data.m_128469_("poke1")) : null;
        this.poke2 = data.m_128441_("poke2") ? (data.m_128469_("poke2").m_128456_() ? null : data.m_128469_("poke2")) : null;
    }

    public void registerPlayer(ServerPlayer player) {
        if (this.playerCount == 1 && this.player1 == player) {
            return;
        }
        ++this.playerCount;
        if (this.playerCount == 1) {
            this.player1 = player;
        } else if (this.playerCount == 2) {
            this.player2 = player;
        } else {
            return;
        }
        OpenScreenPacket.open((Player)player, EnumGuiScreen.Trading, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        if (player == this.player2) {
            NetworkHelper.sendPacket(new RegisterTraderPacket(this.player1.m_20148_(), this.hasMoreThan1HatchedPokemon(this.player1.m_20148_())), this.player2);
            NetworkHelper.sendPacket(new RegisterTraderPacket(this.player2.m_20148_(), this.hasMoreThan1HatchedPokemon(this.player2.m_20148_())), this.player1);
            if (this.pos1 != -1) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(this.player1);
                NetworkHelper.sendPacket(new SetTradeTargetPacket(party.get(this.pos1), new PixelmonStatsData(party.get(this.pos1).getStats())), this.player2);
                NetworkHelper.sendPacket(new SetSelectedStatsPacket(new PixelmonStatsData(party.get(this.pos1).getStats())), this.player1);
            }
        }
        this.sendChanges();
    }

    public boolean ready(Player player, boolean ready) {
        if (this.player1 != null && this.player2 != null) {
            if (player.m_20148_().equals(this.player1.m_20148_())) {
                this.ready1 = ready;
                NetworkHelper.sendPacket(new TradeReadyPacket(ready), this.player2);
            }
            if (player.m_20148_().equals(this.player2.m_20148_())) {
                this.ready2 = ready;
                NetworkHelper.sendPacket(new TradeReadyPacket(ready), this.player1);
            }
        }
        this.tradePushed = false;
        this.sendChanges();
        return false;
    }

    public void setPos1(int pos) {
        this.ready1 = false;
        this.ready2 = false;
        PlayerPartyStorage party = StorageProxy.getPartyNow(this.player1);
        Pokemon pokemon = party.get(pos);
        if (pokemon == null || pokemon.isUntradeable()) {
            this.pos1 = -1;
            this.poke1 = null;
            this.sendChanges();
            return;
        }
        this.pos1 = pos;
        pokemon.ifEntityExists(PixelmonEntity::unloadEntity);
        this.poke1 = new CompoundTag();
        this.poke1.m_128359_("Name", pokemon.getSpecies().getName());
        this.poke1.m_128405_("Level", pokemon.getPokemonLevel());
        this.poke1.m_128379_("isEgg", pokemon.isEgg());
        this.poke1.m_128405_("eggCycles", pokemon.getEggCycles());
        this.poke1.m_128359_("Variant", pokemon.getForm().getName());
        this.poke1.m_128359_("palette", pokemon.getPalette().getName());
        this.poke1.m_128359_("CaughtBall", pokemon.getBall().getName());
        if (pokemon.getHeldItem() != ItemStack.f_41583_) {
            this.poke1.m_128365_("HeldItemStack", (Tag)pokemon.getHeldItem().m_41739_(new CompoundTag()));
        }
        this.sendChanges();
        NetworkHelper.sendPacket(new SetSelectedStatsPacket(new PixelmonStatsData(pokemon.getStats())), this.player1);
        if (this.player2 == null) {
            return;
        }
        NetworkHelper.sendPacket(new SetTradeTargetPacket(pokemon, new PixelmonStatsData(pokemon.getStats())), this.player2);
    }

    public void setPos2(int pos) {
        this.ready1 = false;
        this.ready2 = false;
        PlayerPartyStorage party = StorageProxy.getPartyNow(this.player2);
        Pokemon pokemon = party.get(pos);
        if (pokemon == null || pokemon.isUntradeable()) {
            this.pos2 = -1;
            this.poke2 = null;
            this.sendChanges();
            return;
        }
        this.pos2 = pos;
        pokemon.ifEntityExists(PixelmonEntity::unloadEntity);
        this.poke2 = new CompoundTag();
        this.poke2.m_128359_("Name", pokemon.getSpecies().getName());
        this.poke2.m_128405_("Level", pokemon.getPokemonLevel());
        this.poke2.m_128379_("isEgg", pokemon.isEgg());
        this.poke2.m_128405_("eggCycles", pokemon.getEggCycles());
        this.poke2.m_128359_("Variant", pokemon.getForm().getName());
        this.poke2.m_128359_("palette", pokemon.getPalette().getName());
        this.poke2.m_128359_("CaughtBall", pokemon.getBall().getName());
        if (pokemon.getHeldItem() != ItemStack.f_41583_) {
            this.poke2.m_128365_("HeldItemStack", (Tag)pokemon.getHeldItem().m_41739_(new CompoundTag()));
        }
        this.sendChanges();
        NetworkHelper.sendPacket(new SetSelectedStatsPacket(new PixelmonStatsData(pokemon.getStats())), this.player2);
        if (this.player1 == null) {
            return;
        }
        NetworkHelper.sendPacket(new SetTradeTargetPacket(pokemon, new PixelmonStatsData(pokemon.getStats())), this.player1);
    }

    public void removePlayer(Player player) {
        this.ready1 = false;
        this.ready2 = false;
        if (this.player1 == player) {
            this.player1 = this.player2;
            this.player2 = null;
            this.pos1 = this.pos2;
            this.pos2 = -1;
            this.poke1 = this.poke2;
            this.poke2 = null;
            --this.playerCount;
        } else if (this.player2 == player) {
            this.player2 = null;
            this.pos2 = -1;
            this.poke2 = null;
            --this.playerCount;
        }
        if (this.playerCount < 0) {
            this.playerCount = 0;
        }
        if (this.playerCount == 1) {
            NetworkHelper.sendPacket(new RegisterTraderPacket(null, false), this.player1);
            NetworkHelper.sendPacket(new SetTradeTargetPacket(true), this.player1);
        }
        this.sendChanges();
    }

    public void trade() {
        PokedexEvent.Pre preEvent;
        if (this.tradePushed || this.playerCount < 2 || !this.ready1 || !this.ready2) {
            return;
        }
        if (this.player1 == this.player2) {
            Pixelmon.LOGGER.warn("Self-trade detected! " + this.player1.m_7755_() + " is probably using hacks!");
            this.abortTrade();
            return;
        }
        PlayerPartyStorage party1 = StorageProxy.getPartyNow(this.player1);
        PlayerPartyStorage party2 = StorageProxy.getPartyNow(this.player2);
        party1.retrieveAll("BlockInteract");
        party2.retrieveAll("BlockInteract");
        this.tradePushed = true;
        Pokemon pokemon1 = party1.get(this.pos1);
        Pokemon pokemon2 = party2.get(this.pos2);
        if (pokemon1 == null || pokemon2 == null) {
            this.abortTrade();
            return;
        }
        if (!this.hasOtherHatchedPokemon(this.pos1, party1, pokemon2.isEgg()) || !this.hasOtherHatchedPokemon(this.pos2, party2, pokemon1.isEgg())) {
            this.abortTrade();
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonTradeEvent.Pre((Player)this.player1, (Player)this.player2, pokemon1, pokemon2))) {
            this.abortTrade();
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(this.player1, pokemon2, "Trade"))) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(this.player2, pokemon1, "Trade"))) {
            return;
        }
        if (party1.playerPokedex.get(pokemon2.getSpecies().getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(this.player1.m_20148_(), pokemon2, PokedexRegistrationStatus.CAUGHT, "tradePlayer")))) {
            party1.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
            party1.playerPokedex.update();
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.player1.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        if (party2.playerPokedex.get(pokemon1.getSpecies().getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(this.player2.m_20148_(), pokemon1, PokedexRegistrationStatus.CAUGHT, "tradePlayer")))) {
            party1.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
            party2.playerPokedex.update();
            Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(this.player2.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
        }
        party1.transfer(party2, new StoragePosition(-1, this.pos2), new StoragePosition(-1, this.pos1));
        this.player1.m_6915_();
        this.player2.m_6915_();
        this.playerCount = 0;
        PixelmonEntity pixelmon1 = pokemon1.getOrSpawnPixelmon((Entity)this.player1);
        PixelmonEntity pixelmon2 = pokemon2.getOrSpawnPixelmon((Entity)this.player2);
        Species species1 = pokemon1.getSpecies();
        Species species2 = pokemon2.getSpecies();
        pokemon1.setFriendship(pokemon1.getForm().getSpawn().getBaseFriendship());
        if (!pixelmon1.testTradeEvolution(species2)) {
            pixelmon1.retrieve("Forced");
        }
        pokemon2.setFriendship(pokemon2.getForm().getSpawn().getBaseFriendship());
        if (!pixelmon2.testTradeEvolution(species1)) {
            pixelmon2.retrieve("Forced");
        }
        this.sendChanges();
        Pixelmon.EVENT_BUS.post((Event)new PixelmonTradeEvent.Post((Player)this.player1, (Player)this.player2, pokemon1, pokemon2));
    }

    public void sendChanges() {
        if (this.m_58898_()) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
            this.m_6596_();
        }
    }

    private boolean hasOtherHatchedPokemon(int except, PlayerPartyStorage party, boolean isOtherAnEgg) {
        for (int i = 0; i < 6; ++i) {
            Pokemon p;
            if (i == except || (p = party.get(i)) == null || p.isEgg()) continue;
            return true;
        }
        return !isOtherAnEgg;
    }

    private boolean hasMoreThan1HatchedPokemon(UUID player) {
        if (player == null) {
            return false;
        }
        PlayerPartyStorage party1 = StorageProxy.getPartyNow(player);
        return this.hasMoreThan1HatchedPokemon(party1);
    }

    private boolean hasMoreThan1HatchedPokemon(PlayerPartyStorage party) {
        int nonEggs = 0;
        for (int i = 0; i < 6; ++i) {
            Pokemon p = party.get(i);
            if (p != null && !p.isEgg()) {
                ++nonEggs;
            }
            if (nonEggs <= true) continue;
            return true;
        }
        return false;
    }

    private void abortTrade() {
        if (this.player1 != null) {
            this.player1.m_6915_();
        }
        if (this.player2 != null) {
            this.player2.m_6915_();
        }
        this.playerCount = 0;
        this.sendChanges();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TradeMachineTileEntity blockEntity) {
        if (blockEntity.player1 == null && blockEntity.playerCount > 0) {
            blockEntity.player1 = blockEntity.player2;
            blockEntity.player2 = null;
            --blockEntity.playerCount;
            blockEntity.pos2 = -1;
            blockEntity.poke2 = null;
        } else if (blockEntity.player2 == null && blockEntity.playerCount > 1) {
            --blockEntity.playerCount;
            blockEntity.pos2 = -1;
            blockEntity.poke2 = null;
        }
        if (blockEntity.playerCount == 1) {
            NetworkHelper.sendPacket(new RegisterTraderPacket(null, false), blockEntity.player1);
        }
        ++blockEntity.ticks;
        if (blockEntity.ticks % 20 == 0) {
            if (blockEntity.player1 != null && blockEntity.player1.m_9232_()) {
                blockEntity.abortTrade();
            }
            if (blockEntity.player2 != null && blockEntity.player2.m_9232_()) {
                blockEntity.abortTrade();
            }
            blockEntity.ticks = 0;
        }
    }
}

