/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.TimespaceEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.EncounterData;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.machines.TimespaceAltarBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RotateEntityPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.heldItems.TimespaceOrbItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Event;

public class TimespaceAltarTileEntity
extends BlockEntity {
    public EncounterData encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
    public Orb orbIn = Orb.NONE;
    public boolean chainIn = false;
    public boolean flutePlayed = false;
    private boolean spawning = false;
    public int timeSpent = 0;
    public boolean summoningShiny = false;
    public Player summoningPlayer = null;
    public BlockState summoningState = null;

    public TimespaceAltarTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.TIMESPACE_ALTAR.get(), blockPos, blockState);
    }

    public TimespaceAltarTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("EncounterData", (Tag)this.encounters.write(new CompoundTag()));
        nbt.m_128405_("OrbIn", this.orbIn.ordinal());
        nbt.m_128379_("ChainIn", this.chainIn);
        nbt.m_128379_("FlutePlayed", this.flutePlayed);
        nbt.m_128405_("TimeSpent", this.timeSpent);
        nbt.m_128379_("IsShiny", this.summoningShiny);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.orbIn = Orb.values()[nbt.m_128451_("OrbIn")];
        this.chainIn = nbt.m_128471_("ChainIn");
        this.flutePlayed = nbt.m_128471_("FlutePlayed");
        this.timeSpent = nbt.m_128451_("TimeSpent");
        this.summoningShiny = nbt.m_128471_("IsShiny");
        this.encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
        if (nbt.m_128441_("EncounterData")) {
            this.encounters.read(nbt.m_128469_("EncounterData"));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        super.m_6596_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activate(Player player, TimespaceAltarBlock block, BlockState state, ItemStack item) {
        if (!(this.orbIn == Orb.NONE && !this.chainIn || !player.m_6144_() || this.orbIn != Orb.NONE && this.chainIn)) {
            if (this.orbIn != Orb.NONE) {
                if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeOrb(player, this, item))) return;
                switch (this.orbIn) {
                    case PALKIA: {
                        player.m_36356_(new ItemStack((ItemLike)PixelmonItems.lustrous_orb));
                        break;
                    }
                    case DIALGA: {
                        player.m_36356_(new ItemStack((ItemLike)PixelmonItems.adamant_orb));
                        break;
                    }
                    case GIRATINA: {
                        player.m_36356_(new ItemStack((ItemLike)PixelmonItems.griseous_orb));
                        break;
                    }
                }
                this.orbIn = Orb.NONE;
                this.m_6596_();
                return;
            } else {
                if (!this.chainIn || Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeChain(player, this, item))) return;
                player.m_36356_(new ItemStack((ItemLike)PixelmonItems.red_chain));
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_11672_, SoundSource.BLOCKS, 1.0f, 50.0f);
                this.chainIn = false;
                this.m_6596_();
            }
            return;
        }
        if (item == null || item == ItemStack.f_41583_) return;
        if (item.m_41720_() instanceof TimespaceOrbItem || item.m_41720_() == PixelmonItems.red_chain) {
            if (player.f_19853_.f_46443_) return;
            if (this.timeSpent == 0) {
                if (item.m_41720_() instanceof TimespaceOrbItem) {
                    ItemStack stack = ItemStack.f_41583_;
                    if (this.orbIn == Orb.PALKIA) {
                        stack = new ItemStack((ItemLike)PixelmonItems.lustrous_orb, 1);
                    } else if (this.orbIn == Orb.DIALGA) {
                        stack = new ItemStack((ItemLike)PixelmonItems.adamant_orb, 1);
                    } else if (this.orbIn == Orb.GIRATINA) {
                        stack = new ItemStack((ItemLike)PixelmonItems.griseous_orb, 1);
                    }
                    if (stack != ItemStack.f_41583_) {
                        if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeOrb(player, this, stack))) return;
                        player.m_36356_(stack);
                    }
                }
                if (item.m_41720_() instanceof TimespaceOrbItem) {
                    if (!this.chainIn) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.needchain", new Object[0]);
                        return;
                    }
                    if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.PlaceOrb(player, this, item))) return;
                    if (!this.encounters.canEncounter(player)) {
                        if (this.encounters.getMode().isTimedAccess()) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                            return;
                        } else {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                        }
                        return;
                    }
                    this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_12062_, SoundSource.BLOCKS, 1.0f, 5.0f);
                    if (item.m_41720_() == PixelmonItems.lustrous_orb) {
                        this.orbIn = Orb.PALKIA;
                    } else if (item.m_41720_() == PixelmonItems.adamant_orb) {
                        this.orbIn = Orb.DIALGA;
                    } else if (item.m_41720_() == PixelmonItems.griseous_orb) {
                        this.orbIn = Orb.GIRATINA;
                    }
                    this.m_6596_();
                    if (!player.m_7500_()) {
                        item.m_41774_(1);
                    }
                } else if (item.m_41720_() == PixelmonItems.red_chain) {
                    if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.PlaceChain(player, this, item))) return;
                    if (!this.encounters.canEncounter(player)) {
                        if (this.encounters.getMode().isTimedAccess()) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                            return;
                        } else {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                        }
                        return;
                    }
                    this.chainIn = true;
                    this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_11672_, SoundSource.BLOCKS, 1.0f, 50.0f);
                    this.m_6596_();
                    if (!player.m_7500_()) {
                        item.m_41774_(1);
                    }
                }
            }
            if (this.orbIn == Orb.NONE || !this.chainIn || this.spawning || this.flutePlayed) return;
            this.summoningPlayer = player;
            this.summoningState = state;
            this.spawning = true;
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12286_, SoundSource.NEUTRAL, 1.0f, 0.1f);
            this.summoningShiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)this.f_58857_.m_46472_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)this.f_58857_.m_46472_()));
            this.m_6596_();
            return;
        } else if (this.chainIn && !this.spawning && !this.flutePlayed) {
            ItemStack chain = new ItemStack((ItemLike)PixelmonItems.red_chain);
            if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeChain(player, this, chain))) return;
            this.chainIn = false;
            player.m_36356_(chain);
            this.m_6596_();
            return;
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.notorb", new Object[0]);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TimespaceAltarTileEntity blockEntity) {
        block16: {
            block17: {
                PixelmonEntity startingPixelmon;
                float spawnRot;
                double zOffset;
                double xOffset;
                PixelmonEntity pixelmonEntity;
                block19: {
                    block18: {
                        if (!blockEntity.spawning && !blockEntity.flutePlayed || level.f_46443_) break block16;
                        ++blockEntity.timeSpent;
                        if (blockEntity.summoningPlayer == null) {
                            blockEntity.reset();
                            blockEntity.m_6596_();
                            return;
                        }
                        if (blockEntity.timeSpent <= 200) break block17;
                        if (!blockEntity.spawning) break block18;
                        switch (blockEntity.orbIn) {
                            case PALKIA: {
                                pixelmonEntity = PokemonFactory.create(PixelmonSpecies.PALKIA.getValueUnsafe()).getOrCreatePixelmon(level, 0.0, 0.0, 0.0);
                                pixelmonEntity.getPokemon().setHeldItem(new ItemStack((ItemLike)PixelmonItems.lustrous_orb));
                                break block19;
                            }
                            case DIALGA: {
                                pixelmonEntity = PokemonFactory.create(PixelmonSpecies.DIALGA.getValueUnsafe()).getOrCreatePixelmon(level, 0.0, 0.0, 0.0);
                                pixelmonEntity.getPokemon().setHeldItem(new ItemStack((ItemLike)PixelmonItems.adamant_orb));
                                break block19;
                            }
                            case GIRATINA: {
                                pixelmonEntity = PokemonFactory.create(PixelmonSpecies.GIRATINA.getValueUnsafe()).getOrCreatePixelmon(level, 0.0, 0.0, 0.0);
                                pixelmonEntity.getPokemon().setHeldItem(new ItemStack((ItemLike)PixelmonItems.griseous_core));
                                break block19;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    pixelmonEntity = PokemonFactory.create(PixelmonSpecies.ARCEUS.getValueUnsafe()).getOrCreatePixelmon(level, 0.0, 0.0, 0.0);
                    pixelmonEntity.getLvl().setLevel(80);
                }
                if (blockEntity.summoningShiny) {
                    pixelmonEntity.getPokemon().setPalette("shiny");
                }
                PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)blockEntity.summoningPlayer);
                Direction rot = (Direction)blockEntity.m_58900_().m_61143_((Property)TimespaceAltarBlock.FACING);
                if (rot == Direction.EAST) {
                    xOffset = -4.5;
                    zOffset = 0.5;
                    spawnRot = 45.0f;
                } else if (rot == Direction.WEST) {
                    xOffset = 5.5;
                    zOffset = 0.5;
                    spawnRot = 225.0f;
                } else if (rot == Direction.NORTH) {
                    xOffset = 0.5;
                    zOffset = 4.5;
                    spawnRot = 135.0f;
                } else {
                    xOffset = 0.5;
                    zOffset = -5.5;
                    spawnRot = 315.0f;
                }
                TimespaceEvent.Summon.Pre pre = new TimespaceEvent.Summon.Pre(blockEntity.summoningPlayer, blockEntity, pixelmonEntity);
                if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                    return;
                }
                if (blockEntity.spawning) {
                    blockEntity.encounters.registerEncounter(blockEntity.summoningPlayer);
                }
                if ((startingPixelmon = party.getAndSendOutFirstAblePokemon((Entity)blockEntity.summoningPlayer)) == null || BattleRegistry.getBattle(blockEntity.summoningPlayer) != null) {
                    blockEntity.spawnEntity(pre.getPixelmon(), (double)blockEntity.f_58858_.m_123341_() + xOffset, blockEntity.f_58858_.m_123342_(), (double)blockEntity.f_58858_.m_123343_() + zOffset, spawnRot);
                    Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Post(blockEntity.summoningPlayer, blockEntity, pre.getPixelmon()));
                    blockEntity.reset();
                    blockEntity.m_6596_();
                    return;
                }
                blockEntity.spawnEntity(pre.getPixelmon(), (double)blockEntity.f_58858_.m_123341_() + xOffset, blockEntity.f_58858_.m_123342_(), (double)blockEntity.f_58858_.m_123343_() + zOffset, spawnRot);
                Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Post(blockEntity.summoningPlayer, blockEntity, pre.getPixelmon()));
                PlayerParticipant playerParticipant = new PlayerParticipant((ServerPlayer)blockEntity.summoningPlayer, startingPixelmon);
                WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pre.getPixelmon());
                wildPixelmonParticipant.startedBattle = true;
                BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                blockEntity.reset();
            }
            blockEntity.m_6596_();
        }
    }

    public void reset() {
        this.orbIn = Orb.NONE;
        this.chainIn = false;
        this.spawning = false;
        this.flutePlayed = false;
        this.timeSpent = 0;
        this.summoningState = null;
        this.summoningPlayer = null;
        this.summoningShiny = false;
    }

    public void spawnEntity(PixelmonEntity pixelmonEntity, double x, double y, double z, float rotation) {
        if (this.m_58904_() instanceof ServerLevel) {
            pixelmonEntity.m_19890_(x, y, z, rotation, pixelmonEntity.m_146909_());
            ((ServerLevel)this.m_58904_()).m_8847_((Entity)pixelmonEntity);
            NetworkHelper.sendToDimension(new RotateEntityPacket(pixelmonEntity.m_19879_(), rotation, pixelmonEntity.m_146909_()), pixelmonEntity.f_19853_);
            pixelmonEntity.m_6478_(MoverType.SELF, new Vec3(0.1, 0.1, 0.1));
            pixelmonEntity.f_19859_ = rotation;
            pixelmonEntity.f_19857_ = rotation;
        }
    }

    public static enum Orb {
        NONE,
        PALKIA,
        DIALGA,
        GIRATINA;

    }
}

