/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.ScrollBlock;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ScrollItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScrollTileEntity
extends BlockEntity
implements Nameable {
    private String name;
    private ScrollBlock.Type type;
    private boolean displayOnly;
    private String imageResourceLocation;

    public ScrollTileEntity(BlockPos blockPos, BlockState blockState, ScrollBlock.Type type) {
        super((BlockEntityType)TileEntityRegistration.SCROLL.get(), blockPos, blockState);
        this.type = type;
        this.imageResourceLocation = type.getDefaultResource();
        this.displayOnly = false;
    }

    public ScrollTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, ScrollBlock.Type type) {
        super(blockEntityType, blockPos, blockState);
        this.type = type;
        this.imageResourceLocation = type.getDefaultResource();
        this.displayOnly = false;
    }

    public boolean isDisplayOnly() {
        return this.displayOnly;
    }

    public ScrollBlock.Type getScrollType() {
        return this.type;
    }

    public void setItemValues(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("BlockEntityTag");
        this.displayOnly = tag.m_128471_("DisplayOnly");
        this.imageResourceLocation = tag.m_128461_("Resource");
        this.type = ((ScrollItem)stack.m_41720_()).type;
        if (!this.displayOnly) {
            this.imageResourceLocation = this.type.getDefaultResource();
        }
    }

    public Component m_7755_() {
        return this.m_8077_() ? Component.m_237113_((String)this.name) : Component.m_237115_((String)this.type.getName());
    }

    public boolean m_8077_() {
        return this.name != null && !this.name.isEmpty();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public CompoundTag save(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.m_8077_()) {
            compound.m_128359_("CustomName", this.name);
        }
        compound.m_128379_("DisplayOnly", this.displayOnly);
        compound.m_128359_("Resource", this.imageResourceLocation == null ? "" : this.imageResourceLocation);
        compound.m_128344_("Type", (byte)this.type.ordinal());
        return compound;
    }

    public void load(BlockState state, CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("CustomName")) {
            this.name = compound.m_128461_("CustomName");
        }
        this.displayOnly = compound.m_128471_("DisplayOnly");
        this.imageResourceLocation = compound.m_128461_("Resource");
        this.type = ScrollBlock.Type.values()[compound.m_128445_("Type")];
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.load(this.m_58900_(), pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getResourceLocation() {
        if (this.imageResourceLocation != null && !this.imageResourceLocation.isEmpty()) {
            return ResourceLocationHelper.of(this.imageResourceLocation);
        }
        return ResourceLocationHelper.of(this.imageResourceLocation == null || this.imageResourceLocation.isEmpty() ? this.type.getDefaultResource() : this.imageResourceLocation);
    }

    public ItemStack getItem() {
        ItemStack itemstack = ScrollItem.makeScroll(this.type, this.displayOnly, this.imageResourceLocation);
        itemstack.m_41751_(new CompoundTag());
        if (this.m_8077_()) {
            itemstack.m_41714_(this.m_7755_());
        }
        itemstack.m_41783_().m_128365_("BlockEntityTag", (Tag)this.save(new CompoundTag()));
        return itemstack;
    }
}

