/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.ZygardeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import com.pixelmonmod.pixelmon.listener.ZygardeCellsListener;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public class ReassemblyUnitTileEntity
extends BlockEntity {
    private int ticks = 0;
    private Mode mode = Mode.INACTIVE;
    private UUID uuid = null;
    private StoragePosition position = null;
    private int cubeSlot = -999;

    public ReassemblyUnitTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.REASSEMBLY_UNIT.get(), blockPos, blockState);
    }

    public ReassemblyUnitTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void activate(ServerPlayer player, BlockState state, ItemStack hand) {
        if (ZygardeCellsListener.checkForCube((Player)player)) {
            if (!Pixelmon.EVENT_BUS.post((Event)new ZygardeEvent.Activate(player, this))) {
                OpenScreenPacket.open((Player)player, EnumGuiScreen.ZygardeAssembly, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
            }
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.reassembly_unit.nocube", new Object[0]);
        }
    }

    public void onSelection(ServerPlayer player, Mode mode, StoragePosition position, int cubeSlot) {
        ItemStack stack = player.m_150109_().m_8020_(cubeSlot);
        if (!(stack.m_41720_() instanceof ZygardeCubeItem)) {
            return;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)new ZygardeEvent.Select(player, this, mode, position, stack, cubeSlot))) {
            this.uuid = player.m_20148_();
            this.setMode(mode);
            this.position = position;
            this.cubeSlot = cubeSlot;
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.INACTIVE) {
            this.ticks = 0;
        }
        this.m_6596_();
        this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
    }

    public Mode getMode() {
        return this.mode;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        compound.m_128344_("Mode", (byte)this.mode.ordinal());
        return compound;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
        this.mode = Mode.fromOrdinal(compound.m_128445_("Mode"));
    }

    private void reset() {
        this.mode = Mode.INACTIVE;
        this.ticks = 0;
        this.uuid = null;
        this.position = null;
        this.cubeSlot = -999;
        this.m_6596_();
        this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ReassemblyUnitTileEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.mode != Mode.INACTIVE) {
            ++blockEntity.ticks;
            if (blockEntity.ticks > 30) {
                Player ep = blockEntity.m_58904_().m_46003_(blockEntity.uuid);
                if (!(ep instanceof ServerPlayer)) {
                    blockEntity.reset();
                    return;
                }
                ServerPlayer player = (ServerPlayer)ep;
                ItemStack cube = player.m_150109_().m_8020_(blockEntity.cubeSlot);
                if (!(cube.m_41720_() instanceof ZygardeCubeItem)) {
                    blockEntity.reset();
                    return;
                }
                if (blockEntity.mode == Mode.SEPARATING && blockEntity.position != null) {
                    PlayerPartyStorage storage = StorageProxy.getPartyNow(blockEntity.uuid);
                    Pokemon pokemon = storage.get(blockEntity.position);
                    if (storage.countPokemon() == 1) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.gui.zygarde_reassembly.last_pokemon", new Object[0]);
                        blockEntity.reset();
                        return;
                    }
                    if (pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE) && !(pokemon.getAbility() instanceof PowerConstruct)) {
                        ZygardeEvent.Seperate event;
                        int cells = pokemon.getForm().isForm("ten_percent") ? 10 : (pokemon.getForm().isForm("fifty_percent") ? 50 : -1);
                        int cores = 1;
                        if (cells != -1 && !Pixelmon.EVENT_BUS.post((Event)(event = new ZygardeEvent.Seperate(player, blockEntity, pokemon, blockEntity.position, cube, cells, cores)))) {
                            storage.retrieveAll("BlockInteract");
                            storage.set(blockEntity.position, null);
                            ZygardeCubeItem.setCellCount(cube, ZygardeCubeItem.getCellCount(cube) + event.cells);
                            ZygardeCubeItem.setCoreCount(cube, ZygardeCubeItem.getCoreCount(cube) + event.cores);
                        }
                    }
                } else if (blockEntity.mode == Mode.ASSEMBLING && blockEntity.position != null) {
                    int cores;
                    int count;
                    ZygardeEvent.Assemble.Merge.Start startEvent;
                    PlayerPartyStorage storage = StorageProxy.getPartyNow(blockEntity.uuid);
                    Pokemon pokemon = storage.get(blockEntity.position);
                    if (pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE) && !(pokemon.getAbility() instanceof PowerConstruct) && !Pixelmon.EVENT_BUS.post((Event)(startEvent = new ZygardeEvent.Assemble.Merge.Start(player, blockEntity, pokemon, blockEntity.position, cube, count = ZygardeCubeItem.getCellCount(cube), cores = ZygardeCubeItem.getCoreCount(cube))))) {
                        count = startEvent.cells;
                        cores = startEvent.cores;
                        int cellsExpended = 0;
                        int coresExpended = 0;
                        if (pokemon.getForm().isForm("ten_percent")) {
                            if (count >= 90 && cores >= 1) {
                                pokemon.setForm("fifty_percent");
                                pokemon.setAbility(AbilityRegistry.POWER_CONSTRUCT);
                                cellsExpended = 90;
                                coresExpended = 1;
                            } else if (count >= 40) {
                                pokemon.setForm("fifty_percent");
                                pokemon.setAbility(AbilityRegistry.AURA_BREAK);
                                cellsExpended = 40;
                            }
                        } else if (pokemon.getForm().isForm("fifty_percent") && count >= 50 && cores >= 1) {
                            pokemon.setForm("fifty_percent");
                            pokemon.setAbility(AbilityRegistry.POWER_CONSTRUCT);
                            cellsExpended = 50;
                            coresExpended = 1;
                        }
                        ZygardeEvent.Assemble.Merge.End endEvent = new ZygardeEvent.Assemble.Merge.End(player, blockEntity, pokemon, blockEntity.position, cube, cellsExpended, coresExpended);
                        Pixelmon.EVENT_BUS.post((Event)endEvent);
                        ZygardeCubeItem.setCellCount(cube, ZygardeCubeItem.getCellCount(cube) - endEvent.cells);
                        ZygardeCubeItem.setCoreCount(cube, ZygardeCubeItem.getCoreCount(cube) - endEvent.cores);
                    }
                } else if (blockEntity.mode == Mode.ASSEMBLING) {
                    ZygardeEvent.Assemble.New.Start startEvent;
                    boolean shiny;
                    int count = ZygardeCubeItem.getCellCount(cube);
                    int cores = ZygardeCubeItem.getCoreCount(cube);
                    Pokemon zygarde = PokemonFactory.create(PixelmonSpecies.ZYGARDE.getValueUnsafe());
                    zygarde.initialize(new InitializeCategory[0]);
                    boolean bl = shiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)level.m_46472_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)level.m_46472_()));
                    if (shiny) {
                        zygarde.setShiny();
                    }
                    if (!Pixelmon.EVENT_BUS.post((Event)(startEvent = new ZygardeEvent.Assemble.New.Start(player, blockEntity, zygarde, blockEntity.position, cube, count, cores)))) {
                        int cellsToRemove;
                        count = startEvent.cells;
                        cores = startEvent.cores;
                        if (count >= 100 && cores >= 2) {
                            zygarde.setForm("fifty_percent");
                            zygarde.setAbility(AbilityRegistry.POWER_CONSTRUCT);
                            cellsToRemove = 100;
                        } else if (count >= 50 && cores >= 1) {
                            zygarde.setForm("fifty_percent");
                            zygarde.setAbility(AbilityRegistry.AURA_BREAK);
                            cellsToRemove = 50;
                        } else if (count >= 10 && cores >= 1) {
                            zygarde.setForm("ten_percent");
                            zygarde.setAbility(AbilityRegistry.AURA_BREAK);
                            cellsToRemove = 10;
                        } else {
                            blockEntity.reset();
                            return;
                        }
                        zygarde.setLevel(30);
                        StorageProxy.getPartyNow(blockEntity.uuid).add(zygarde);
                        ZygardeEvent.Assemble.New.End endEvent = new ZygardeEvent.Assemble.New.End(player, blockEntity, zygarde, blockEntity.position, cube, cellsToRemove, zygarde.getAbility() instanceof PowerConstruct ? 2 : 1);
                        Pixelmon.EVENT_BUS.post((Event)endEvent);
                        ZygardeCubeItem.setCellCount(cube, ZygardeCubeItem.getCellCount(cube) - endEvent.cells);
                        ZygardeCubeItem.setCoreCount(cube, ZygardeCubeItem.getCoreCount(cube) - endEvent.cores);
                    }
                }
                blockEntity.reset();
            }
        }
    }

    public static enum Mode {
        INACTIVE,
        ASSEMBLING,
        SEPARATING;

        private static final Mode[] VALUES;

        public static Mode fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

