/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokeStopEvent;
import com.pixelmonmod.pixelmon.api.util.LootClaim;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.world.generation.loot.LootTableRegistration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PokeStopTileEntity
extends BlockEntity
implements GeoBlockEntity {
    private boolean oneTimeUse = false;
    private ResourceLocation lootTable = LootTableRegistration.COMMON_POKESTOP;
    private Color color = new Color(101, 217, 253, 255);
    private Color cooldownColor = Color.RED;
    private float scale = 3.0f;
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    private final List<LootClaim> claimed = new ArrayList<LootClaim>();

    public PokeStopTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.POKESTOP.get(), blockPos, blockState);
    }

    public PokeStopTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("PokeStopOneTimeUse", this.oneTimeUse);
        tag.m_128359_("PokeStopLootTable", this.lootTable.toString());
        tag.m_128405_("PokeStopColorRed", this.color.getRed());
        tag.m_128405_("PokeStopColorGreen", this.color.getGreen());
        tag.m_128405_("PokeStopColorBlue", this.color.getBlue());
        tag.m_128405_("PokeStopColorAlpha", this.color.getAlpha());
        tag.m_128405_("PokeStopCooldownColorRed", this.cooldownColor.getRed());
        tag.m_128405_("PokeStopCooldownColorGreen", this.cooldownColor.getGreen());
        tag.m_128405_("PokeStopCooldownColorBlue", this.cooldownColor.getBlue());
        tag.m_128405_("PokeStopCooldownColorAlpha", this.cooldownColor.getAlpha());
        tag.m_128350_("PokeStopScale", this.scale);
        if (!this.claimed.isEmpty()) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.claimed.size(); ++i) {
                CompoundTag playerInfoTag = new CompoundTag();
                LootClaim playerClaim = this.claimed.get(i);
                if (this.canClaim(playerClaim.getPlayerID())) continue;
                playerInfoTag.m_128362_("Claimer", playerClaim.getPlayerID());
                playerInfoTag.m_128356_("PokeStopTimeClaimed", playerClaim.getTimeClaimed());
                list.add((Object)playerInfoTag);
            }
            tag.m_128365_("PokeStopClaimedPlayers", (Tag)list);
        }
    }

    public void m_142466_(CompoundTag tag) {
        this.oneTimeUse = tag.m_128471_("PokeStopOneTimeUse");
        this.lootTable = ResourceLocationHelper.of(tag.m_128461_("PokeStopLootTable"));
        this.color = new Color(tag.m_128451_("PokeStopColorRed"), tag.m_128451_("PokeStopColorGreen"), tag.m_128451_("PokeStopColorBlue"), tag.m_128451_("PokeStopColorAlpha"));
        this.cooldownColor = new Color(tag.m_128451_("PokeStopCooldownColorRed"), tag.m_128451_("PokeStopCooldownColorGreen"), tag.m_128451_("PokeStopCooldownColorBlue"), tag.m_128451_("PokeStopCooldownColorAlpha"));
        this.scale = tag.m_128457_("PokeStopScale");
        if (tag.m_128441_("PokeStopClaimedPlayers")) {
            ListTag claimedTag = tag.m_128437_("PokeStopClaimedPlayers", 10);
            for (Tag inbt : claimedTag) {
                CompoundTag nbt = (CompoundTag)inbt;
                this.claimed.add(new LootClaim(nbt.m_128342_("Claimer"), nbt.m_128454_("PokeStopTimeClaimed")));
            }
        }
        super.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public boolean canClaim(Player player) {
        LootClaim claim = this.getLootClaim(player.m_20148_());
        PokeStopEvent.CooldownCheck.PreCalculate cooldownCheckPreCalculate = new PokeStopEvent.CooldownCheck.PreCalculate(player, this, PixelmonConfigProxy.getSpawning().getPokeStop().getLootTime());
        if (Pixelmon.EVENT_BUS.post((Event)cooldownCheckPreCalculate)) {
            return false;
        }
        if (claim != null) {
            if (!this.oneTimeUse && (System.currentTimeMillis() - claim.getTimeClaimed()) / 1000L > cooldownCheckPreCalculate.getCooldownHours() * 3600L) {
                this.removeClaimer(player.m_20148_());
                return true;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean canClaim(UUID playerID) {
        LootClaim claim = this.getLootClaim(playerID);
        if (claim != null) {
            if (!this.oneTimeUse) {
                return (System.currentTimeMillis() - claim.getTimeClaimed()) / 1000L > (long)PixelmonConfigProxy.getSpawning().getPokeStop().getLootTime() * 3600L;
            }
            return false;
        }
        return true;
    }

    public LootClaim getLootClaim(Player player) {
        return this.getLootClaim(player.m_20148_());
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().equals(playerID)) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public void setOneTimeUse(boolean oneTimeUse) {
        this.oneTimeUse = oneTimeUse;
    }

    public boolean isOneTimeUse() {
        return this.oneTimeUse;
    }

    public boolean isUsableByPlayer(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) < 64.0;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public PokeStopTileEntity setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
        return this;
    }

    public float getScale() {
        return this.scale;
    }

    public PokeStopTileEntity setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public PokeStopTileEntity setColor(Color color) {
        this.color = color;
        return this;
    }

    public Color getCooldownColor() {
        return this.cooldownColor;
    }

    public PokeStopTileEntity setCooldownColor(Color cooldownColor) {
        this.cooldownColor = cooldownColor;
        return this;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<PokeStopTileEntity>(this, "animation.model.spinny", state -> {
            state.getController().setAnimation(RawAnimation.begin().then("animation.model.spinny", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

