/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.util.LootClaim;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.EnumPokegiftType;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PokeGiftTileEntity
extends BlockEntity {
    private EnumPokechestVisibility visibility = EnumPokechestVisibility.Visible;
    private UUID ownerID = null;
    private boolean chestOneTime = true;
    private boolean dropOneTime = true;
    private Pokemon pokemon = null;
    private List<PokemonSpecification> specialPixelmon = new ArrayList<PokemonSpecification>();
    private EnumPokegiftType type = EnumPokegiftType.GIFT;
    private List<LootClaim> claimed = new ArrayList<LootClaim>();

    public PokeGiftTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.POKE_GIFT.get(), blockPos, blockState);
    }

    public PokeGiftTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setOwner(UUID id) {
        this.ownerID = id;
    }

    public UUID getOwner() {
        return this.ownerID;
    }

    public void setType(EnumPokegiftType t) {
        this.type = t;
    }

    public EnumPokegiftType getGiftType() {
        return this.type;
    }

    public void m_183515_(CompoundTag compound) {
        ListTag list;
        super.m_183515_(compound);
        compound.m_128362_("Owner", this.ownerID == null ? Util.f_137441_ : this.ownerID);
        compound.m_128379_("chestOneTime", this.chestOneTime);
        compound.m_128379_("dropOneTime", this.dropOneTime);
        compound.m_128405_("type", this.type.ordinal());
        if (!this.claimed.isEmpty()) {
            list = new ListTag();
            for (int i = 0; i < this.claimed.size(); ++i) {
                CompoundTag playerInfoTag = new CompoundTag();
                LootClaim playerClaim = this.claimed.get(i);
                playerInfoTag.m_128362_("most", playerClaim.getPlayerID());
                playerInfoTag.m_128356_("timeClaimed", playerClaim.getTimeClaimed());
                list.add((Object)playerInfoTag);
            }
            compound.m_128365_("claimedPlayers", (Tag)list);
        }
        if (this.type == EnumPokegiftType.GIFT) {
            if (this.pokemon != null) {
                CompoundTag pokemon = new CompoundTag();
                this.pokemon.writeToNBT(pokemon);
                compound.m_128365_("pixelmon", (Tag)pokemon);
            }
        } else if (!this.specialPixelmon.isEmpty()) {
            list = new ListTag();
            for (PokemonSpecification p : this.specialPixelmon) {
                CompoundTag nbt = new CompoundTag();
                p.write(nbt);
                list.add((Object)nbt);
            }
            compound.m_128365_("specials", (Tag)list);
        }
    }

    public void m_142466_(CompoundTag tagger) {
        CompoundTag nbt;
        ListTag claimedTag;
        UUID uuid = tagger.m_128342_("Owner");
        this.ownerID = Objects.equals(Util.f_137441_, uuid) ? null : uuid;
        this.chestOneTime = tagger.m_128471_("chestOneTime");
        this.dropOneTime = tagger.m_128471_("dropOneTime");
        this.type = EnumPokegiftType.values()[tagger.m_128451_("type")];
        if (tagger.m_128441_("claimedPlayers")) {
            claimedTag = tagger.m_128437_("claimedPlayers", 10);
            for (Tag inbt : claimedTag) {
                nbt = (CompoundTag)inbt;
                this.claimed.add(new LootClaim(nbt.m_128342_("Claimer"), nbt.m_128454_("timeClaimed")));
            }
        }
        if (this.type == EnumPokegiftType.GIFT) {
            this.pokemon = tagger.m_128441_("pixelmon") ? PokemonFactory.create(tagger.m_128469_("pixelmon")) : null;
        } else if (tagger.m_128441_("specials")) {
            claimedTag = tagger.m_128437_("specials", 10);
            for (Tag inbt : claimedTag) {
                nbt = (CompoundTag)inbt;
                this.specialPixelmon.add(PokemonSpecificationProxy.fromNbt(nbt).get());
            }
        }
        super.m_142466_(tagger);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        this.m_183515_(compound);
        compound.m_128473_("claimedPlayers");
        compound.m_128473_("specials");
        compound.m_128473_("pixelmon");
        return compound;
    }

    public boolean canClaim(UUID playerID) {
        if (!this.dropOneTime) {
            return true;
        }
        LootClaim claim = this.getLootClaim(playerID);
        return claim == null;
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().toString().equals(playerID.toString())) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        if (this.dropOneTime) {
            this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
        }
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public boolean shouldBreakBlock() {
        return this.chestOneTime;
    }

    public void setChestOneTime(boolean val) {
        this.chestOneTime = val;
    }

    public boolean getChestMode() {
        return this.chestOneTime;
    }

    public void setDropOneTime(boolean val) {
        this.dropOneTime = val;
    }

    public boolean getDropMode() {
        return this.dropOneTime;
    }

    public boolean isUsableByPlayer(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) < 64.0;
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public void setPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
    }

    public List<PokemonSpecification> getSpecialPixelmon() {
        return this.specialPixelmon;
    }

    public void setAllSpecialPixelmon(List<PokemonSpecification> pixelmon) {
        this.specialPixelmon.clear();
        this.specialPixelmon.addAll(pixelmon);
    }

    public void setSpecialPixelmon(PokemonSpecification pixelmon) {
        this.specialPixelmon.add(pixelmon);
    }

    public EnumPokechestVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(EnumPokechestVisibility visible) {
        this.visibility = visible;
        this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
    }
}

